/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.google.common.util.concurrent.Futures;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexImplUtil;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IdIterator;
import com.intellij.util.indexing.IndexDataInitializer;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexVersion;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.IndexAccessValidator;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.storage.TransientFileContentIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.memory.InMemoryIndexStorage;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class StubIndexImpl
extends StubIndexEx {
    static final Logger LOG = Logger.getInstance(StubIndexImpl.class);
    private final Map<StubIndexKey<?, ?>, CachedValue<Map<KeyAndFileId<?>, StubIdList>>> myCachedStubIds = FactoryMap.createMap(k -> {
        UpdatableIndex<Integer, SerializedStubTree, FileContent> index2 = StubIndexImpl.getStubUpdatingIndex();
        ModificationTracker tracker2 = index2::getModificationStamp;
        return new CachedValueImpl(() -> new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{tracker2}));
    }, ConcurrentHashMap::new);
    private final StubProcessingHelper myStubProcessingHelper = new StubProcessingHelper();
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private final AtomicBoolean myForcedClean = new AtomicBoolean();
    private volatile CompletableFuture<AsyncState> myStateFuture;
    private volatile AsyncState myState;
    private volatile boolean myInitialized;

    public StubIndexImpl() {
        StubIndexExtension.EP_NAME.addExtensionPointListener(new ExtensionPointListener<StubIndexExtension<?, ?>>(){

            public void extensionRemoved(@NotNull StubIndexExtension<?, ?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ID.unloadId((ID)extension2.getKey());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/stubs/StubIndexImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private AsyncState getAsyncState() {
        AsyncState state = this.myState;
        if (state == null) {
            if (this.myStateFuture == null) {
                ((FileBasedIndexImpl)FileBasedIndex.getInstance()).waitUntilIndicesAreInitialized();
            }
            if (ProgressManager.getInstance().isInNonCancelableSection()) {
                try {
                    state = (AsyncState)Futures.getUnchecked(this.myStateFuture);
                }
                catch (Exception e) {
                    FileBasedIndexImpl.LOG.error((Throwable)e);
                }
            } else {
                state = ProgressIndicatorUtils.awaitWithCheckCanceled(this.myStateFuture);
            }
            this.myState = state;
        }
        return state;
    }

    @ApiStatus.Internal
    @TestOnly
    public void waitUntilStubIndexedInitialized() {
        this.getAsyncState();
    }

    public void initializationFailed(@NotNull Throwable error) {
        if (error == null) {
            StubIndexImpl.$$$reportNull$$$0(0);
        }
        this.myStateFuture = new CompletableFuture();
        this.myStateFuture.completeExceptionally(error);
    }

    @NotNull
    public static <K> FileBasedIndexExtension<K, Void> wrapStubIndexExtension(final StubIndexExtension<K, ?> extension2) {
        return new FileBasedIndexExtension<K, Void>(){

            @NotNull
            public ID<K, Void> getName() {
                StubIndexKey key;
                StubIndexKey stubIndexKey = key = extension2.getKey();
                if (stubIndexKey == null) {
                    2.$$$reportNull$$$0(0);
                }
                return stubIndexKey;
            }

            @NotNull
            public FileBasedIndex.InputFilter getInputFilter() {
                FileBasedIndex.InputFilter inputFilter = f -> {
                    throw new UnsupportedOperationException();
                };
                if (inputFilter == null) {
                    2.$$$reportNull$$$0(1);
                }
                return inputFilter;
            }

            public boolean dependsOnFileContent() {
                return true;
            }

            public boolean needsForwardIndexWhenSharing() {
                return false;
            }

            @NotNull
            public DataIndexer<K, Void, FileContent> getIndexer() {
                DataIndexer dataIndexer = i2 -> {
                    throw new AssertionError();
                };
                if (dataIndexer == null) {
                    2.$$$reportNull$$$0(2);
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<K> getKeyDescriptor() {
                KeyDescriptor keyDescriptor = extension2.getKeyDescriptor();
                if (keyDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                return keyDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    2.$$$reportNull$$$0(4);
                }
                return voidDataExternalizer;
            }

            public int getVersion() {
                return extension2.getVersion();
            }

            public boolean traceKeyHashToVirtualFileMapping() {
                return extension2 instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension2).traceKeyHashToVirtualFileMapping();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/stubs/StubIndexImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInputFilter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIndexer";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeyDescriptor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValueExternalizer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K> void registerIndexer(@NotNull StubIndexExtension<K, ?> extension2, boolean forceClean, @NotNull AsyncState state, @NotNull IndexVersionRegistrationSink registrationResultSink) throws IOException {
        if (extension2 == null) {
            StubIndexImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            StubIndexImpl.$$$reportNull$$$0(2);
        }
        if (registrationResultSink == null) {
            StubIndexImpl.$$$reportNull$$$0(3);
        }
        StubIndexKey indexKey = extension2.getKey();
        int version2 = extension2.getVersion();
        FileBasedIndexExtension<K, Void> wrappedExtension = StubIndexImpl.wrapStubIndexExtension(extension2);
        Path indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        IndexVersion.IndexVersionDiff versionDiff = forceClean ? new IndexVersion.IndexVersionDiff.InitialBuild(version2) : IndexVersion.versionDiffers(indexKey, version2);
        registrationResultSink.setIndexVersionDiff(indexKey, versionDiff);
        if (versionDiff != IndexVersion.IndexVersionDiff.UP_TO_DATE) {
            boolean needRebuild;
            Path versionFile = IndexInfrastructure.getVersionFile(indexKey);
            boolean versionFileExisted = Files.exists(versionFile, new LinkOption[0]);
            String[] children2 = indexRootDir.toFile().list();
            boolean indexRootHasChildren = children2 != null && children2.length > 0;
            boolean bl = needRebuild = !forceClean && (versionFileExisted || indexRootHasChildren);
            if (indexRootHasChildren) {
                FileUtil.deleteWithRenaming((File)indexRootDir.toFile());
            }
            IndexVersion.rewriteVersion(indexKey, version2);
            try {
                if (needRebuild) {
                    for (FileBasedIndexInfrastructureExtension ex : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                        ex.onStubIndexVersionChanged(indexKey);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = StubIndexImpl.getStubUpdatingIndex();
        ReadWriteLock lock2 = stubUpdatingIndex.getLock();
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                UpdatableIndex<Object, Object, FileContent> index2 = new TransientFileContentIndex<K, Void>(wrappedExtension, new StubIndexStorageLayout<K>(wrappedExtension, indexKey), lock2);
                for (FileBasedIndexInfrastructureExtension infrastructureExtension : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    UpdatableIndex<K, Void, FileContent> intermediateIndex = infrastructureExtension.combineIndex(wrappedExtension, index2);
                    if (intermediateIndex == null) continue;
                    index2 = intermediateIndex;
                }
                AsyncState needRebuild = state;
                synchronized (needRebuild) {
                    state.myIndices.put(indexKey, index2);
                    break;
                }
            }
            catch (IOException e) {
                registrationResultSink.setIndexVersionDiff(indexKey, new IndexVersion.IndexVersionDiff.CorruptedRebuild(version2));
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version2, indexRootDir, e);
                continue;
            }
            catch (RuntimeException e) {
                Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                if (cause == null) {
                    throw e;
                }
                StubIndexImpl.onExceptionInstantiatingIndex(indexKey, version2, indexRootDir, e);
            }
        }
    }

    private static <K> void onExceptionInstantiatingIndex(@NotNull StubIndexKey<K, ?> indexKey, int version2, @NotNull Path indexRootDir, @NotNull Exception e) throws IOException {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(4);
        }
        if (indexRootDir == null) {
            StubIndexImpl.$$$reportNull$$$0(5);
        }
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(6);
        }
        LOG.info((Throwable)e);
        FileUtil.deleteWithRenaming((File)indexRootDir.toFile());
        IndexVersion.rewriteVersion(indexKey, version2);
    }

    public long getIndexModificationStamp(@NotNull StubIndexKey<?, ?> indexId, @NotNull Project project) {
        UpdatableIndex<?, Void, FileContent> index2;
        if (indexId == null) {
            StubIndexImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(8);
        }
        if ((index2 = this.getAsyncState().myIndices.get(indexId)) != null) {
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, GlobalSearchScope.allScope((Project)project));
            return index2.getModificationStamp();
        }
        return -1L;
    }

    public void flush() throws StorageException {
        if (!this.myInitialized) {
            return;
        }
        for (UpdatableIndex<?, Void, FileContent> index2 : this.getAsyncState().myIndices.values()) {
            index2.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(9);
        }
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(10);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(11);
        }
        if (requiredClass == null) {
            StubIndexImpl.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            StubIndexImpl.$$$reportNull$$$0(13);
        }
        if (dumb = DumbService.isDumb((Project)project)) {
            if (LightEdit.owns((Project)project)) {
                return false;
            }
            accessType = FileBasedIndex.getInstance().getCurrentDumbModeAccessType();
            if (accessType == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
                throw new AssertionError((Object)"raw index data access is not available for StubIndex");
            }
        }
        if (!ModelBranchImpl.processModifiedFilesInScope(scope != null ? scope : GlobalSearchScope.everythingScope((Project)project), (Processor<? super VirtualFile>)(Processor)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processElements$3(com.intellij.psi.stubs.StubIndexKey java.lang.Object com.intellij.openapi.project.Project com.intellij.util.PairProcessor com.intellij.openapi.vfs.VirtualFile ), (Lcom/intellij/openapi/vfs/VirtualFile;)Z)(indexKey, key, (Project)project, (PairProcessor)(stubProcessor = (PairProcessor)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, lambda$processElements$2(com.intellij.openapi.project.Project com.intellij.util.Processor com.intellij.psi.search.GlobalSearchScope java.lang.Class com.intellij.openapi.vfs.VirtualFile com.intellij.psi.stubs.StubIdList ), (Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/stubs/StubIdList;)Z)((StubIndexImpl)this, (Project)project, processor, (GlobalSearchScope)scope, requiredClass))))) {
            return false;
        }
        singleFileInScope = StubIndexImpl.extractSingleFile(scope);
        if (singleFileInScope != null) {
            if (!(singleFileInScope instanceof VirtualFileWithId)) {
                return true;
            }
            FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, scope);
            fileStream /* !! */  = ObjectIterators.singleton((Object)singleFileInScope);
            shouldHaveKeys = false;
        } else {
            ids = this.getContainingIds(indexKey, key, project, idFilter, scope);
            if (ids == null) {
                return true;
            }
            accessibleFileFilter = ((FileBasedIndexEx)FileBasedIndex.getInstance()).getAccessibleFileIdFilter(project);
            idIterator = ids.iterator();
            fileStream /* !! */  = StubIndexImplUtil.mapIdIterator(idIterator, accessibleFileFilter);
            shouldHaveKeys = true;
        }
        try {
            block6: while (true) {
                if (fileStream /* !! */ .hasNext() == false) return true;
                file = (VirtualFile)fileStream /* !! */ .next();
                if (!StubIndexImpl.$assertionsDisabled && file == null) {
                    throw new AssertionError();
                }
                v0 = filesInScope = scope != null ? FileBasedIndexEx.filesInScopeWithBranches(scope, file) : Collections.singletonList(file);
                if (filesInScope.isEmpty()) continue;
                id = ((VirtualFileWithId)file).getId();
                list = ((Map)this.myCachedStubIds.get(indexKey).getValue()).computeIfAbsent(new KeyAndFileId<Key>(key, id), (Function<KeyAndFileId, StubIdList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processElements$4(com.intellij.psi.stubs.StubIndexKey java.lang.Object com.intellij.openapi.vfs.VirtualFile com.intellij.openapi.project.Project boolean com.intellij.psi.stubs.StubIndexImpl$KeyAndFileId ), (Lcom/intellij/psi/stubs/StubIndexImpl$KeyAndFileId;)Lcom/intellij/psi/stubs/StubIdList;)((StubIndexImpl)this, indexKey, key, (VirtualFile)file, (Project)project, (boolean)shouldHaveKeys));
                if (list == null) continue;
                var17_19 = filesInScope.iterator();
                do {
                    if (var17_19.hasNext()) ** break;
                    continue block6;
                } while (stubProcessor.process((Object)(eachFile = var17_19.next()), (Object)list));
                break;
            }
            var19_21 = false;
            return var19_21;
        }
        catch (RuntimeException e) {
            cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause == null) throw e;
            this.forceRebuild(cause);
            return true;
        }
        finally {
            this.wipeProblematicFileIdsForParticularKeyAndStubIndex(indexKey, key);
        }
    }

    private static <Key, Psi extends PsiElement> boolean processInMemoryStubs(StubIndexKey<Key, Psi> indexKey, Key key, Project project, PairProcessor<? super VirtualFile, ? super StubIdList> stubProcessor, VirtualFile file2) {
        Map data2 = FileBasedIndex.getInstance().getFileData(StubUpdatingIndex.INDEX_ID, file2, project);
        if (data2.size() == 1) {
            try {
                StubIdList list2 = ((SerializedStubTree)data2.values().iterator().next()).restoreIndexedStubs(indexKey, key);
                if (list2 != null) {
                    return stubProcessor.process((Object)file2, (Object)list2);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private <Key> UpdatableIndex<Key, Void, FileContent> getIndex(@NotNull StubIndexKey<Key, ?> indexKey) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(14);
        }
        return this.getAsyncState().myIndices.get(indexKey);
    }

    private <Key> void wipeProblematicFileIdsForParticularKeyAndStubIndex(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key key) {
        Set<VirtualFile> filesWithProblems;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(15);
        }
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(16);
        }
        if ((filesWithProblems = this.myStubProcessingHelper.takeAccumulatedFilesWithIndexProblems()) != null) {
            LOG.info("data for " + indexKey.getName() + " will be wiped for a some files because of internal stub processing error");
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).runCleanupAction(() -> {
                Lock writeLock = this.getIndex(indexKey).getLock().writeLock();
                boolean locked = writeLock.tryLock();
                if (!locked) {
                    return;
                }
                try {
                    for (VirtualFile file2 : filesWithProblems) {
                        this.updateIndex(indexKey, FileBasedIndex.getFileId((VirtualFile)file2), Collections.singleton(key), Collections.emptySet());
                    }
                }
                finally {
                    writeLock.unlock();
                }
            });
        }
    }

    public void forceRebuild(@NotNull Throwable e) {
        if (e == null) {
            StubIndexImpl.$$$reportNull$$$0(17);
        }
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    private static void requestRebuild() {
        FileBasedIndex.getInstance().requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(18);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(19);
        }
        HashSet allKeys = new HashSet();
        this.processAllKeys(indexKey, project, Processors.cancelableCollectProcessor(allKeys));
        HashSet hashSet = allKeys;
        if (hashSet == null) {
            StubIndexImpl.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Processor<? super K> processor2, @NotNull GlobalSearchScope scope2, @Nullable IdFilter idFilter) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(21);
        }
        if (processor2 == null) {
            StubIndexImpl.$$$reportNull$$$0(22);
        }
        if (scope2 == null) {
            StubIndexImpl.$$$reportNull$$$0(23);
        }
        UpdatableIndex index2 = this.getIndex(indexKey);
        FileBasedIndexEx fileBasedIndexEx = (FileBasedIndexEx)FileBasedIndex.getInstance();
        if (index2 == null || !fileBasedIndexEx.ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope2.getProject(), scope2, null)) {
            return true;
        }
        if (idFilter == null) {
            idFilter = fileBasedIndexEx.extractIdFilter(scope2, scope2.getProject());
        }
        try {
            @Nullable IdFilter finalIdFilter = idFilter;
            return (Boolean)this.myAccessValidator.validate(StubUpdatingIndex.INDEX_ID, () -> (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> index2.processAllKeys(processor2, scope2, finalIdFilter)));
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                this.forceRebuild(e);
            }
            throw e;
        }
        return true;
    }

    @NotNull
    public <Key> IdIterator getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable GlobalSearchScope scope2) {
        IntSet result2;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(24);
        }
        if (dataKey == null) {
            StubIndexImpl.$$$reportNull$$$0(25);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(26);
        }
        if ((result2 = this.getContainingIds(indexKey, dataKey, project, null, scope2)) == null) {
            IdIterator idIterator = IdIterator.EMPTY;
            if (idIterator == null) {
                StubIndexImpl.$$$reportNull$$$0(27);
            }
            return idIterator;
        }
        return new IdIterator(){
            final IntIterator iterator;
            {
                this.iterator = result2.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public int next() {
                return this.iterator.nextInt();
            }

            public int size() {
                return result2.size();
            }
        };
    }

    @NotNull
    public <Key> Set<VirtualFile> getContainingFiles(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        IntSet result2;
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(28);
        }
        if (dataKey == null) {
            StubIndexImpl.$$$reportNull$$$0(29);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(30);
        }
        if (scope2 == null) {
            StubIndexImpl.$$$reportNull$$$0(31);
        }
        CompactVirtualFileSet fileSet = new CompactVirtualFileSet((result2 = this.getContainingIds(indexKey, dataKey, project, null, scope2)) == null ? ArrayUtil.EMPTY_INT_ARRAY : result2.toIntArray());
        fileSet.freeze();
        CompactVirtualFileSet compactVirtualFileSet = fileSet;
        if (compactVirtualFileSet == null) {
            StubIndexImpl.$$$reportNull$$$0(32);
        }
        return compactVirtualFileSet;
    }

    @Nullable
    private <Key> IntSet getContainingIds(@NotNull StubIndexKey<Key, ?> indexKey, @NotNull Key dataKey, @NotNull Project project, @Nullable IdFilter idFilter, @Nullable GlobalSearchScope scope2) {
        if (indexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(33);
        }
        if (dataKey == null) {
            StubIndexImpl.$$$reportNull$$$0(34);
        }
        if (project == null) {
            StubIndexImpl.$$$reportNull$$$0(35);
        }
        FileBasedIndexEx fileBasedIndex = (FileBasedIndexEx)FileBasedIndex.getInstance();
        ID<Integer, SerializedStubTree> stubUpdatingIndexId = StubUpdatingIndex.INDEX_ID;
        UpdatableIndex<Key, Void, FileContent> index2 = this.getIndex(indexKey);
        if (index2 == null || !fileBasedIndex.ensureUpToDate(stubUpdatingIndexId, project, scope2, null)) {
            return null;
        }
        IdFilter finalIdFilter = idFilter != null ? idFilter : ((FileBasedIndexEx)FileBasedIndex.getInstance()).extractIdFilter(scope2, project);
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = fileBasedIndex.getIndex(stubUpdatingIndexId);
        try {
            IntLinkedOpenHashSet result2 = new IntLinkedOpenHashSet();
            this.myAccessValidator.validate(stubUpdatingIndexId, () -> this.lambda$getContainingIds$10(stubUpdatingIndex, index2, dataKey, finalIdFilter, (IntSet)result2));
            return result2;
        }
        catch (StorageException e) {
            this.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.forceRebuild(cause);
            }
            throw e;
        }
        return null;
    }

    void initializeStubIndexes() {
        assert (!this.myInitialized);
        if (this.myStateFuture == null) {
            FileBasedIndex.getInstance();
            this.myStateFuture = new CompletableFuture();
            Future<AsyncState> future2 = IndexDataInitializer.submitGenesisTask(new StubIndexInitialization());
            if (!IndexDataInitializer.ourDoAsyncIndicesInitialization) {
                try {
                    future2.get();
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
            }
        }
    }

    public void dispose() {
        try {
            for (UpdatableIndex<?, Void, FileContent> index2 : this.getAsyncState().myIndices.values()) {
                index2.dispose();
            }
        }
        finally {
            this.clearState();
        }
    }

    private void clearState() {
        StubIndexKeyDescriptorCache.INSTANCE.clear();
        ((SerializationManagerImpl)SerializationManagerEx.getInstanceEx()).dropSerializerData();
        this.myCachedStubIds.clear();
        this.myStateFuture = null;
        this.myState = null;
        this.myInitialized = false;
        LOG.info("StubIndexExtension-s were unloaded");
    }

    void setDataBufferingEnabled(boolean enabled) {
        AsyncState state = (AsyncState)ProgressManager.getInstance().computeInNonCancelableSection(this::getAsyncState);
        for (UpdatableIndex<?, Void, FileContent> index2 : state.myIndices.values()) {
            index2.setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupMemoryStorage() {
        UpdatableIndex<Integer, SerializedStubTree, FileContent> stubUpdatingIndex = StubIndexImpl.getStubUpdatingIndex();
        stubUpdatingIndex.getLock().writeLock().lock();
        try {
            for (UpdatableIndex<?, Void, FileContent> index2 : this.getAsyncState().myIndices.values()) {
                index2.cleanupMemoryStorage();
            }
        }
        finally {
            stubUpdatingIndex.getLock().writeLock().unlock();
        }
    }

    void clearAllIndices() {
        if (!this.myInitialized) {
            this.myForcedClean.set(true);
            return;
        }
        for (UpdatableIndex<?, Void, FileContent> index2 : this.getAsyncState().myIndices.values()) {
            try {
                index2.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    <K> void removeTransientDataForFile(@NotNull StubIndexKey<K, ?> key, int inputId, Map<K, StubIdList> keys2) {
        if (key == null) {
            StubIndexImpl.$$$reportNull$$$0(36);
        }
        UpdatableIndex<K, Void, FileContent> index2 = this.getIndex(key);
        index2.removeTransientDataForKeys(inputId, (InputDataDiffBuilder<K, Void>)new MapInputDataDiffBuilder(inputId, keys2));
    }

    public <K> void updateIndex(@NotNull StubIndexKey<K, ?> stubIndexKey, final int fileId, final @NotNull Set<? extends K> oldKeys, final @NotNull Set<? extends K> newKeys) {
        if (stubIndexKey == null) {
            StubIndexImpl.$$$reportNull$$$0(37);
        }
        if (oldKeys == null) {
            StubIndexImpl.$$$reportNull$$$0(38);
        }
        if (newKeys == null) {
            StubIndexImpl.$$$reportNull$$$0(39);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                UpdatableIndex index2;
                if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
                    LOG.info("stub index '" + stubIndexKey + "' update: " + fileId + " old = " + Arrays.toString(oldKeys.toArray()) + " new  = " + Arrays.toString(newKeys.toArray()) + " updated_id = " + System.identityHashCode(newKeys));
                }
                if ((index2 = this.getIndex(stubIndexKey)) == null) {
                    return;
                }
                index2.updateWithMap(new AbstractUpdateData<K, Void>(fileId){

                    protected boolean iterateKeys(@NotNull KeyValueUpdateProcessor<? super K, ? super Void> addProcessor, @NotNull KeyValueUpdateProcessor<? super K, ? super Void> updateProcessor, @NotNull RemovedKeyProcessor<? super K> removeProcessor) throws StorageException {
                        if (addProcessor == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (updateProcessor == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        if (removeProcessor == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        boolean modified = false;
                        for (Object oldKey : oldKeys) {
                            if (newKeys.contains(oldKey)) continue;
                            removeProcessor.process(oldKey, fileId);
                            if (modified) continue;
                            modified = true;
                        }
                        for (Object oldKey : newKeys) {
                            if (oldKeys.contains(oldKey)) continue;
                            addProcessor.process(oldKey, null, fileId);
                            if (modified) continue;
                            modified = true;
                        }
                        if (FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE) {
                            LOG.info("keys iteration finished updated_id = " + System.identityHashCode(newKeys) + "; modified = " + modified);
                        }
                        return modified;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "addProcessor";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "updateProcessor";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "removeProcessor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/psi/stubs/StubIndexImpl$5";
                        objectArray[2] = "iterateKeys";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
                StubIndexImpl.requestRebuild();
            }
        });
    }

    static UpdatableIndex<Integer, SerializedStubTree, FileContent> getStubUpdatingIndex() {
        return ((FileBasedIndexEx)FileBasedIndex.getInstance()).getIndex(StubUpdatingIndex.INDEX_ID);
    }

    @Nullable
    private static VirtualFile extractSingleFile(@Nullable GlobalSearchScope scope2) {
        if (!(scope2 instanceof Iterable)) {
            return null;
        }
        Iterable scopeAsFileIterable = (Iterable)scope2;
        VirtualFile result2 = null;
        for (VirtualFile file2 : scopeAsFileIterable) {
            if (result2 == null) {
                result2 = (VirtualFile)ObjectUtils.notNull((Object)file2, (Object)NullVirtualFile.INSTANCE);
                continue;
            }
            return null;
        }
        return result2;
    }

    @TestOnly
    public boolean areAllProblemsProcessedInTheCurrentThread() {
        return this.myStubProcessingHelper.areAllProblemsProcessedInTheCurrentThread();
    }

    private /* synthetic */ Boolean lambda$getContainingIds$10(UpdatableIndex stubUpdatingIndex, UpdatableIndex index2, Object dataKey, final IdFilter finalIdFilter, final IntSet result2) throws StorageException {
        return (Boolean)FileBasedIndexImpl.disableUpToDateCheckIn(() -> (Boolean)ConcurrencyUtil.withLock((Lock)stubUpdatingIndex.getLock().readLock(), () -> index2.getData(dataKey).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Void>(){

            public boolean perform(int id2, Void value2) {
                if (finalIdFilter == null || finalIdFilter.containsFileId(id2)) {
                    result2.add(id2);
                }
                return true;
            }
        })));
    }

    private /* synthetic */ StubIdList lambda$processElements$4(StubIndexKey indexKey, Object key, VirtualFile file2, Project project, boolean shouldHaveKeys, KeyAndFileId __) {
        return this.myStubProcessingHelper.retrieveStubIdList(indexKey, key, file2, project, shouldHaveKeys);
    }

    private static /* synthetic */ boolean lambda$processElements$3(StubIndexKey indexKey, Object key, Project project, PairProcessor stubProcessor, VirtualFile file2) {
        return StubIndexImpl.processInMemoryStubs(indexKey, key, project, (PairProcessor<? super VirtualFile, ? super StubIdList>)stubProcessor, file2);
    }

    private /* synthetic */ boolean lambda$processElements$2(Project project, Processor processor2, GlobalSearchScope scope2, Class requiredClass, VirtualFile file2, StubIdList list2) {
        return this.myStubProcessingHelper.processStubsInFile(project, file2, list2, processor2, scope2, requiredClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 27: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 27: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrationResultSink";
                break;
            }
            case 4: 
            case 9: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexRootDir";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 26: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 16: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 25: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexKey";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeys";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubIndexImpl";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingIds";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initializationFailed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onExceptionInstantiatingIndex";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "wipeProblematicFileIdsForParticularKeyAndStubIndex";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forceRebuild";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 20: 
            case 27: 
            case 32: {
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getContainingIds";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFiles";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 27: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class KeyAndFileId<K> {
        @NotNull
        private final K key;
        private final int fileId;

        private KeyAndFileId(@NotNull K key, int fileId) {
            if (key == null) {
                KeyAndFileId.$$$reportNull$$$0(0);
            }
            this.key = key;
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyAndFileId key1 = (KeyAndFileId)o;
            return this.fileId == key1.fileId && Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.fileId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/stubs/StubIndexImpl$KeyAndFileId", "<init>"));
        }
    }

    private final class StubIndexInitialization
    extends IndexDataInitializer<AsyncState> {
        private final AsyncState state = new AsyncState();
        private final IndexVersionRegistrationSink indicesRegistrationSink = new IndexVersionRegistrationSink();

        private StubIndexInitialization() {
        }

        @Override
        @NotNull
        protected AsyncState finish() {
            this.indicesRegistrationSink.logChangedAndFullyBuiltIndices(LOG, "Following stub indices will be updated:", "Following stub indices will be built:");
            if (this.indicesRegistrationSink.hasChangedIndexes()) {
                Throwable e = new Throwable(this.indicesRegistrationSink.changedIndices());
                AppUIExecutor.onWriteThread((ModalityState)ModalityState.NON_MODAL).later().submit(() -> StubIndexImpl.this.forceRebuild(e));
            }
            StubIndexImpl.this.myInitialized = true;
            StubIndexImpl.this.myStateFuture.complete(this.state);
            AsyncState asyncState = this.state;
            if (asyncState == null) {
                StubIndexInitialization.$$$reportNull$$$0(0);
            }
            return asyncState;
        }

        @Override
        @NotNull
        protected Collection<ThrowableRunnable<?>> prepareTasks() {
            StubIndexExtension extension2;
            Iterator extensionsIterator = IndexInfrastructure.hasIndices() ? StubIndexExtension.EP_NAME.getIterable().iterator() : Collections.emptyIterator();
            boolean forceClean = Boolean.TRUE.booleanValue() == StubIndexImpl.this.myForcedClean.getAndSet(false);
            ArrayList tasks = new ArrayList();
            while (extensionsIterator.hasNext() && (extension2 = (StubIndexExtension)extensionsIterator.next()) != null) {
                extension2.getKey();
                tasks.add(() -> StubIndexImpl.registerIndexer(extension2, forceClean, this.state, this.indicesRegistrationSink));
            }
            ArrayList arrayList = tasks;
            if (arrayList == null) {
                StubIndexInitialization.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected String getInitializationFinishedMessage(AsyncState initializationResult) {
            String string = "Initialized stub indexes: " + initializationResult.myIndices.keySet() + ".";
            if (string == null) {
                StubIndexInitialization.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/psi/stubs/StubIndexImpl$StubIndexInitialization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "finish";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareTasks";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInitializationFinishedMessage";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class StubIndexStorageLayout<K>
    implements VfsAwareIndexStorageLayout<K, Void> {
        private final FileBasedIndexExtension<K, Void> myWrappedExtension;
        private final StubIndexKey<K, ?> myIndexKey;

        private StubIndexStorageLayout(FileBasedIndexExtension<K, Void> wrappedExtension, StubIndexKey<K, ?> indexKey) {
            this.myWrappedExtension = wrappedExtension;
            this.myIndexKey = indexKey;
        }

        @NotNull
        public IndexStorage<K, Void> openIndexStorage() throws IOException {
            if (FileBasedIndex.USE_IN_MEMORY_INDEX) {
                return new InMemoryIndexStorage(this.myWrappedExtension.getKeyDescriptor());
            }
            Path storageFile = IndexInfrastructure.getStorageFile(this.myIndexKey);
            try {
                return new VfsAwareMapIndexStorage(storageFile, this.myWrappedExtension.getKeyDescriptor(), this.myWrappedExtension.getValueExternalizer(), this.myWrappedExtension.getCacheSize(), this.myWrappedExtension.keyIsUniqueForIndexedFile(), this.myWrappedExtension.traceKeyHashToVirtualFileMapping(), this.myWrappedExtension.enableWal());
            }
            catch (IOException e) {
                IOUtil.deleteAllFilesStartingWith((Path)storageFile);
                throw e;
            }
        }

        @Override
        public void clearIndexData() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class AsyncState {
        private final Map<StubIndexKey<?, ?>, UpdatableIndex<?, Void, FileContent>> myIndices = CollectionFactory.createSmallMemoryFootprintMap();

        private AsyncState() {
        }
    }
}

