/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.io.SelfDiagnosing;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StubSerializerEnumerator
implements Flushable,
Closeable {
    private static final Logger LOG = Logger.getInstance(StubSerializerEnumerator.class);
    private final DataEnumeratorEx<String> myNameStorage;
    private final Int2ObjectMap<String> myIdToName;
    private final Object2IntMap<String> myNameToId;
    private final Map<String, Supplier<ObjectStubSerializer<?, ? extends Stub>>> myNameToLazySerializer;
    private final ConcurrentIntObjectMap<ObjectStubSerializer<?, ? extends Stub>> myIdToSerializer;
    private final Map<ObjectStubSerializer<?, ? extends Stub>, Integer> mySerializerToId;
    private final boolean myUnmodifiable;

    StubSerializerEnumerator(@NotNull DataEnumeratorEx<String> nameStorage, boolean unmodifiable) {
        if (nameStorage == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(0);
        }
        this.myIdToName = new Int2ObjectOpenHashMap();
        this.myNameToId = new Object2IntOpenHashMap();
        this.myNameToLazySerializer = CollectionFactory.createSmallMemoryFootprintMap();
        this.myIdToSerializer = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.mySerializerToId = new ConcurrentHashMap();
        this.myNameStorage = nameStorage;
        this.myUnmodifiable = unmodifiable;
    }

    void dropRegisteredSerializers() {
        this.myIdToName.clear();
        this.myNameToId.clear();
        this.myNameToLazySerializer.clear();
        this.myIdToSerializer.clear();
        this.mySerializerToId.clear();
    }

    @NotNull
    ObjectStubSerializer<?, Stub> getClassById(@NotNull MissingSerializerReporter reporter, int id2) throws SerializerNotFoundException {
        ObjectStubSerializer<?, ? extends Stub> serializer2;
        if (reporter == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(1);
        }
        if ((serializer2 = (ObjectStubSerializer<?, ? extends Stub>)this.myIdToSerializer.get(id2)) == null) {
            serializer2 = this.instantiateSerializer(id2, reporter);
            this.myIdToSerializer.put(id2, serializer2);
        }
        ObjectStubSerializer<?, ? extends Stub> objectStubSerializer = serializer2;
        if (objectStubSerializer == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(2);
        }
        return objectStubSerializer;
    }

    int getClassId(@NotNull ObjectStubSerializer<?, ? extends Stub> serializer2) {
        Integer idValue;
        if (serializer2 == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(3);
        }
        if ((idValue = this.mySerializerToId.get(serializer2)) == null) {
            String name2 = serializer2.getExternalId();
            idValue = this.myNameToId.getInt((Object)name2);
            assert (idValue > 0) : "No ID found for serializer " + ObjectUtils.objectInfo(serializer2) + ", external id:" + name2 + (String)(serializer2 instanceof IElementType ? ", language:" + ((IElementType)serializer2).getLanguage() : "");
            this.mySerializerToId.put(serializer2, idValue);
        }
        return idValue;
    }

    void assignId(@NotNull Supplier<ObjectStubSerializer<?, ? extends Stub>> serializer2, String name2) throws IOException {
        int id2;
        Supplier<ObjectStubSerializer<?, Stub>> old;
        if (serializer2 == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(4);
        }
        if ((old = this.myNameToLazySerializer.put(name2, serializer2)) != null) {
            ObjectStubSerializer<?, Stub> computed;
            ObjectStubSerializer<?, Stub> existing = old.get();
            if (existing != (computed = serializer2.get())) {
                throw new AssertionError((Object)("ID: " + name2 + " is not unique, but found in both " + existing.getClass().getName() + " and " + computed.getClass().getName()));
            }
            return;
        }
        if (this.myUnmodifiable) {
            id2 = this.myNameStorage.tryEnumerate((Object)name2);
            if (id2 == 0) {
                LOG.debug("serialized " + name2 + " is ignored in unmodifiable stub serialization manager");
                return;
            }
        } else {
            id2 = this.myNameStorage.enumerate((Object)name2);
        }
        this.myIdToName.put(id2, (Object)name2);
        this.myNameToId.put((Object)name2, id2);
    }

    @Nullable
    String getSerializerName(int id2) {
        return (String)this.myIdToName.get(id2);
    }

    int getSerializerId(@NotNull String name2) {
        if (name2 == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(5);
        }
        return this.myNameToId.getInt((Object)name2);
    }

    @NotNull
    ObjectStubSerializer<?, ? extends Stub> getSerializer(@NotNull String name2) throws SerializerNotFoundException {
        if (name2 == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(6);
        }
        int id2 = this.myNameToId.getInt((Object)name2);
        ObjectStubSerializer<?, Stub> objectStubSerializer = this.getClassById((id1, name1, externalId) -> "Missed stub serializer for " + name2, id2);
        if (objectStubSerializer == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(7);
        }
        return objectStubSerializer;
    }

    @Nullable
    String getSerializerName(@NotNull ObjectStubSerializer<?, ? extends Stub> serializer2) {
        if (serializer2 == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(8);
        }
        return (String)this.myIdToName.get(this.getClassId(serializer2));
    }

    @NotNull
    private ObjectStubSerializer<?, ? extends Stub> instantiateSerializer(int id2, @NotNull MissingSerializerReporter reporter) throws SerializerNotFoundException {
        ObjectStubSerializer<?, ? extends Stub> serializer2;
        String name2;
        if (reporter == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(9);
        }
        Supplier<ObjectStubSerializer<?, Stub>> lazy = (name2 = (String)this.myIdToName.get(id2)) == null ? null : this.myNameToLazySerializer.get(name2);
        ObjectStubSerializer<?, ? extends Stub> objectStubSerializer = serializer2 = lazy == null ? null : lazy.get();
        if (serializer2 == null) {
            throw this.reportMissingSerializer(id2, name2, reporter);
        }
        ObjectStubSerializer<?, ? extends Stub> objectStubSerializer2 = serializer2;
        if (objectStubSerializer2 == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(10);
        }
        return objectStubSerializer2;
    }

    private SerializerNotFoundException reportMissingSerializer(int id2, @Nullable String name2, @NotNull MissingSerializerReporter reporter) {
        if (reporter == null) {
            StubSerializerEnumerator.$$$reportNull$$$0(11);
        }
        String externalId = null;
        Throwable storageException = null;
        try {
            externalId = (String)this.myNameStorage.valueOf(id2);
        }
        catch (Throwable e) {
            LOG.info(e);
            storageException = e;
        }
        SerializerNotFoundException exception = new SerializerNotFoundException(reporter.report(id2, name2, externalId));
        StubIndex.getInstance().forceRebuild(storageException != null ? storageException : exception);
        return exception;
    }

    @Override
    public void flush() throws IOException {
        if (this.myNameStorage instanceof Forceable && ((Forceable)this.myNameStorage).isDirty()) {
            ((Forceable)this.myNameStorage).force();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.myNameStorage instanceof Closeable) {
            ((Closeable)this.myNameStorage).close();
        }
    }

    @ApiStatus.Internal
    Map<String, Integer> dump() {
        assert (this.myUnmodifiable);
        assert (this.myNameStorage instanceof PersistentStringEnumerator);
        try {
            Collection stubNames = ((PersistentStringEnumerator)this.myNameStorage).getAllDataObjects(null);
            HashMap<String, Integer> dump = new HashMap<String, Integer>();
            for (String name2 : stubNames) {
                dump.put(name2, this.myNameStorage.tryEnumerate((Object)name2));
            }
            return dump;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return Collections.emptyMap();
        }
    }

    public void tryDiagnose() {
        if (this.myNameStorage instanceof SelfDiagnosing) {
            ((SelfDiagnosing)this.myNameStorage).diagnose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorage";
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubSerializerEnumerator";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubSerializerEnumerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassById";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassById";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClassId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSerializerId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSerializer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSerializerName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "instantiateSerializer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportMissingSerializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface MissingSerializerReporter {
        @NotNull
        public String report(int var1, @Nullable String var2, @Nullable String var3);
    }
}

