/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CallerChooserBase<M extends PsiElement>
extends DialogWrapper {
    private final M myMethod;
    private final Alarm myAlarm = new Alarm();
    private MemberNodeBase<M> myRoot;
    protected final Project myProject;
    private Tree myTree;
    private final Consumer<? super Set<M>> myCallback;
    private TreeSelectionListener myTreeSelectionListener;
    private Editor myCallerEditor;
    private Editor myCalleeEditor;
    private final boolean myInitDone;
    private final String myFileName;
    private final Collection<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();

    protected MemberNodeBase<M> createTreeNodeFor(M method2, HashSet<M> called, Runnable cancelCallback) {
        throw new UnsupportedOperationException();
    }

    protected abstract M[] findDeepestSuperMethods(M var1);

    @NlsContexts.Label
    protected String getEmptyCalleeText() {
        return "";
    }

    @NlsContexts.Label
    protected String getEmptyCallerText() {
        return "";
    }

    public CallerChooserBase(M method2, Project project, @NlsContexts.DialogTitle String title2, Tree previousTree, @NlsSafe String fileName, Consumer<? super Set<M>> callback2) {
        super(true);
        this.myMethod = method2;
        this.myProject = project;
        this.myTree = previousTree;
        this.myFileName = fileName;
        this.myCallback = callback2;
        this.setTitle(title2);
        this.init();
        this.myInitDone = true;
    }

    public Tree getTree() {
        return this.myTree;
    }

    protected JComponent createCenterPanel() {
        Splitter splitter2 = new Splitter(false, 0.6f);
        JPanel result2 = new JPanel(new BorderLayout());
        if (this.myTree == null) {
            this.myTree = this.createTree();
        } else {
            CheckedTreeNode root2 = (CheckedTreeNode)this.myTree.getModel().getRoot();
            this.myRoot = (MemberNodeBase)((Object)root2.getFirstChild());
        }
        this.myTreeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path2 = e.getPath();
                if (path2 != null) {
                    MemberNodeBase node2 = (MemberNodeBase)((Object)path2.getLastPathComponent());
                    CallerChooserBase.this.myAlarm.cancelAllRequests();
                    CallerChooserBase.this.myAlarm.addRequest(() -> CallerChooserBase.this.updateEditorTexts(node2), 300);
                }
            }
        };
        this.myTree.getSelectionModel().addTreeSelectionListener(this.myTreeSelectionListener);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        splitter2.setFirstComponent((JComponent)scrollPane);
        JComponent callSitesViewer = this.createCallSitesViewer();
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            selectionPath = new TreePath(this.myRoot.getPath());
            this.myTree.getSelectionModel().addSelectionPath(selectionPath);
        }
        MemberNodeBase node2 = (MemberNodeBase)((Object)selectionPath.getLastPathComponent());
        this.updateEditorTexts(node2);
        splitter2.setSecondComponent(callSitesViewer);
        result2.add((Component)splitter2);
        return result2;
    }

    private void updateEditorTexts(MemberNodeBase<M> node2) {
        PsiElement callee;
        MemberNodeBase<M> parentNode = this.getCalleeNode(node2);
        MemberNodeBase<M> callerNode = this.getCallerNode(node2);
        String callerText = node2 != this.myRoot ? this.getText(callerNode.getMember()) : this.getEmptyCallerText();
        Document callerDocument = this.myCallerEditor.getDocument();
        String calleeText = node2 != this.myRoot ? this.getText(parentNode.getMember()) : this.getEmptyCalleeText();
        Document calleeDocument = this.myCalleeEditor.getDocument();
        ApplicationManager.getApplication().runWriteAction(() -> {
            callerDocument.setText((CharSequence)callerText);
            calleeDocument.setText((CharSequence)calleeText);
        });
        M caller = callerNode.getMember();
        PsiElement psiElement = callee = parentNode != null ? parentNode.getElementToSearch() : null;
        if (caller != null && caller.isPhysical() && callee != null) {
            HighlightManager highlighter = HighlightManager.getInstance((Project)this.myProject);
            for (RangeHighlighter r : this.myHighlighters) {
                highlighter.removeSegmentHighlighter(this.myCallerEditor, r);
            }
            this.myHighlighters.clear();
            int start2 = this.getStartOffset(caller);
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.myProject);
            for (PsiElement element2 : this.findElementsToHighlight(caller, callee)) {
                TextRange textRange = element2.getTextRange();
                textRange = injectedLanguageManager.injectedToHost(element2, textRange);
                highlighter.addRangeHighlight(this.myCallerEditor, textRange.getStartOffset() - start2, textRange.getEndOffset() - start2, EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES, false, this.myHighlighters);
            }
        }
    }

    protected MemberNodeBase<M> getCalleeNode(MemberNodeBase<M> node2) {
        return (MemberNodeBase)((Object)node2.getParent());
    }

    protected MemberNodeBase<M> getCallerNode(MemberNodeBase<M> node2) {
        return node2;
    }

    protected Collection<PsiElement> findElementsToHighlight(M caller, PsiElement callee) {
        Query references = ReferencesSearch.search((PsiElement)callee, (SearchScope)new LocalSearchScope(caller), (boolean)false);
        return ContainerUtil.mapNotNull((Iterable)references, psiReference -> psiReference.getElement());
    }

    public void dispose() {
        if (this.myTree != null) {
            this.myTree.removeTreeSelectionListener(this.myTreeSelectionListener);
            EditorFactory.getInstance().releaseEditor(this.myCallerEditor);
            EditorFactory.getInstance().releaseEditor(this.myCalleeEditor);
        }
        super.dispose();
    }

    private String getText(M method2) {
        TextRange textRange;
        Document document;
        if (method2 == null) {
            return "";
        }
        PsiFile file2 = method2.getContainingFile();
        Document document2 = document = file2 != null ? PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2) : null;
        if (document != null && (textRange = method2.getTextRange()) != null) {
            int start2 = document.getLineStartOffset(document.getLineNumber(textRange.getStartOffset()));
            int end = document.getLineEndOffset(document.getLineNumber(textRange.getEndOffset()));
            return document.getText().substring(start2, end);
        }
        return "";
    }

    private int getStartOffset(@NotNull M method2) {
        if (method2 == null) {
            CallerChooserBase.$$$reportNull$$$0(0);
        }
        PsiFile file2 = method2.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
        return document.getLineStartOffset(document.getLineNumber(method2.getTextRange().getStartOffset()));
    }

    private JComponent createCallSitesViewer() {
        Splitter splitter2 = new Splitter(true);
        this.myCallerEditor = this.createEditor();
        this.myCalleeEditor = this.createEditor();
        JComponent callerComponent = this.myCallerEditor.getComponent();
        callerComponent.setBorder((Border)IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"caller.chooser.caller.method"), (boolean)false));
        splitter2.setFirstComponent(callerComponent);
        JComponent calleeComponent = this.myCalleeEditor.getComponent();
        calleeComponent.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.getCalleeEditorTitle(), (boolean)false));
        splitter2.setSecondComponent(calleeComponent);
        splitter2.setBorder((Border)IdeBorderFactory.createRoundedBorder());
        return splitter2;
    }

    @NotNull
    @Nls
    protected String getCalleeEditorTitle() {
        String string = RefactoringBundle.message((String)"caller.chooser.callee.method");
        if (string == null) {
            CallerChooserBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Editor editor2 = editorFactory.createViewer(document, this.myProject);
        ((EditorEx)editor2).setHighlighter(HighlighterFactory.createHighlighter((Project)this.myProject, (String)this.myFileName));
        return editor2;
    }

    private Tree createTree() {
        Runnable cancelCallback = () -> {
            if (!this.myInitDone) {
                throw new ProcessCanceledException();
            }
            this.close(1);
        };
        MemberNodeBase<Object> root2 = this.createTreeNodeFor(null, new HashSet(), cancelCallback);
        this.myRoot = this.createTreeNodeFor(this.myMethod, new HashSet(), cancelCallback);
        root2.add((MutableTreeNode)((Object)this.myRoot));
        CheckboxTree.CheckboxTreeCellRenderer cellRenderer = new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
                if (value2 instanceof MemberNodeBase) {
                    ((MemberNodeBase)((Object)value2)).customizeRenderer(this.getTextRenderer());
                }
            }
        };
        CheckboxTree tree = new CheckboxTree(cellRenderer, root2, new CheckboxTreeBase.CheckPolicy(false, true, true, false));
        tree.getSelectionModel().setSelectionMode(1);
        tree.getSelectionModel().setSelectionPath(new TreePath(this.myRoot.getPath()));
        return tree;
    }

    protected M getTopMember() {
        return this.myMethod;
    }

    private void getSelectedMethods(Set<? super M> methods) {
        MemberNodeBase<M> node2 = this.myRoot;
        this.getSelectedMethodsInner(node2, methods);
        methods.remove(node2.getMember());
    }

    private void getSelectedMethodsInner(MemberNodeBase<? extends M> node2, Set<? super M> allMethods) {
        if (node2.isChecked()) {
            PsiElement[] superMethods;
            M method2 = node2.getMember();
            PsiElement[] psiElementArray = superMethods = method2 == this.myMethod ? null : this.findDeepestSuperMethods((PsiElement)method2);
            if (superMethods == null || superMethods.length == 0) {
                allMethods.add(method2);
            } else {
                allMethods.addAll(Arrays.asList(superMethods));
            }
            Enumeration children2 = node2.children();
            while (children2.hasMoreElements()) {
                this.getSelectedMethodsInner((MemberNodeBase)((Object)children2.nextElement()), allMethods);
            }
        }
    }

    protected Set<MemberNodeBase<M>> getSelectedNodes() {
        LinkedHashSet<MemberNodeBase<M>> nodes = new LinkedHashSet<MemberNodeBase<M>>();
        this.collectSelectedNodes(this.myRoot, nodes);
        return nodes;
    }

    private void collectSelectedNodes(MemberNodeBase<M> node2, Set<? super MemberNodeBase<M>> nodes) {
        if (node2.isChecked()) {
            nodes.add(node2);
            Enumeration children2 = node2.children();
            while (children2.hasMoreElements()) {
                this.collectSelectedNodes((MemberNodeBase)((Object)children2.nextElement()), nodes);
            }
        }
    }

    protected void doOKAction() {
        HashSet selectedMethods = new HashSet();
        this.getSelectedMethods(selectedMethods);
        this.myCallback.consume(selectedMethods);
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "caller.chooser.dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/CallerChooserBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/CallerChooserBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalleeEditorTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

