/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ProjectDisposeAwareDocumentListener;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.NewIdentifierWatcher;
import com.intellij.refactoring.suggested.SuggestedRefactoringSignatureWatcher;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupportKt;
import com.intellij.refactoring.suggested.TextRangeUtilsKt;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003'()B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020\u001c2\b\b\u0002\u0010!\u001a\u00020\fJ \u0010\"\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010#\u001a\u00020\u001cJ\u0016\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0018R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "watcher", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSignatureWatcher;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/refactoring/suggested/SuggestedRefactoringSignatureWatcher;Lcom/intellij/openapi/Disposable;)V", "editingState", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeListener$SignatureEditingState;", "isFirstChangeInsideCommand", "", "newIdentifierWatcher", "Lcom/intellij/refactoring/suggested/NewIdentifierWatcher;", "psiDocumentManager", "Lcom/intellij/psi/PsiDocumentManager;", "kotlin.jvm.PlatformType", "createEditingState", "document", "Lcom/intellij/openapi/editor/Document;", "declaration", "Lcom/intellij/psi/PsiElement;", "signatureRange", "Lcom/intellij/openapi/util/TextRange;", "refactoringSupport", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "processBeforeFirstChangeWithPsiAndDocumentInSync", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "changeRange", "reset", "withNewIdentifiers", "shouldSuppressRefactoring", "suppressForCurrentDeclaration", "undoToState", "state", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "MyDocumentListener", "MyPsiTreeChangeListener", "SignatureEditingState", "intellij.platform.lang.impl"})
public final class SuggestedRefactoringChangeListener {
    private final PsiDocumentManager psiDocumentManager;
    private final NewIdentifierWatcher newIdentifierWatcher;
    private SignatureEditingState editingState;
    private boolean isFirstChangeInsideCommand;
    private final Project project;
    private final SuggestedRefactoringSignatureWatcher watcher;

    public final void reset(boolean withNewIdentifiers) {
        if (this.editingState != null) {
            SignatureEditingState signatureEditingState = this.editingState;
            Intrinsics.checkNotNull((Object)signatureEditingState);
            signatureEditingState.getSignatureRangeMarker().dispose();
            SignatureEditingState signatureEditingState2 = this.editingState;
            Intrinsics.checkNotNull((Object)signatureEditingState2);
            RangeMarker rangeMarker = signatureEditingState2.getImportRangeMarker();
            if (rangeMarker != null) {
                rangeMarker.dispose();
            }
            SignatureEditingState signatureEditingState3 = this.editingState;
            Intrinsics.checkNotNull((Object)signatureEditingState3);
            if (!signatureEditingState3.isRefactoringSuppressed()) {
                this.watcher.reset();
            }
            this.editingState = null;
        }
        if (withNewIdentifiers) {
            this.newIdentifierWatcher.reset();
        }
    }

    public static /* synthetic */ void reset$default(SuggestedRefactoringChangeListener suggestedRefactoringChangeListener, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        suggestedRefactoringChangeListener.reset(bl);
    }

    public final void undoToState(@NotNull SuggestedRefactoringState state, @NotNull TextRange signatureRange) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)signatureRange, (String)"signatureRange");
        PsiFile psiFile2 = psiFile = state.getDeclaration().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"psiFile");
        Document document = PsiDocumentManager.getInstance((Project)psiFile2.getProject()).getDocument(psiFile);
        Intrinsics.checkNotNull((Object)document);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026t).getDocument(psiFile)!!");
        Document document2 = document;
        this.editingState = this.createEditingState(document2, state.getDeclaration(), signatureRange, state.getRefactoringSupport());
    }

    public final void suppressForCurrentDeclaration() {
        if (this.editingState != null) {
            SignatureEditingState signatureEditingState = this.editingState;
            Intrinsics.checkNotNull((Object)signatureEditingState);
            if (!signatureEditingState.isRefactoringSuppressed()) {
                SignatureEditingState signatureEditingState2 = this.editingState;
                Intrinsics.checkNotNull((Object)signatureEditingState2);
                this.editingState = SignatureEditingState.copy$default(signatureEditingState2, null, null, true, 3, null);
                this.watcher.reset();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processBeforeFirstChangeWithPsiAndDocumentInSync(PsiFile psiFile, Document document, TextRange changeRange, SuggestedRefactoringSupport refactoringSupport) {
        void templateManager;
        if (this.editingState != null) {
            return;
        }
        Stream stream = EditorFactory.getInstance().editors(document, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"EditorFactory.getInstanc\u2026ditors(document, project)");
        Stream editors2 = stream;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        if (editors2.anyMatch(new Predicate(this, (Ref.ObjectRef)templateManager){
            final /* synthetic */ SuggestedRefactoringChangeListener this$0;
            final /* synthetic */ Ref.ObjectRef $templateManager;

            public final boolean test(Editor it) {
                if ((TemplateManager)this.$templateManager.element == null) {
                    this.$templateManager.element = TemplateManager.getInstance(SuggestedRefactoringChangeListener.access$getProject$p(this.this$0));
                }
                TemplateManager templateManager = (TemplateManager)this.$templateManager.element;
                Intrinsics.checkNotNull((Object)templateManager);
                return templateManager.getActiveTemplate(it) != null;
            }
            {
                this.this$0 = suggestedRefactoringChangeListener;
                this.$templateManager = objectRef;
            }
        })) {
            return;
        }
        if ((TemplateManager)templateManager.element == null) {
            return;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)undoManager, (String)"UndoManager.getInstance(project)");
        if (undoManager.isUndoInProgress()) {
            return;
        }
        Function1<Integer, PsiElement> $fun$declarationByOffsetInSignature$2 = new Function1<Integer, PsiElement>(refactoringSupport, psiFile){
            final /* synthetic */ SuggestedRefactoringSupport $refactoringSupport;
            final /* synthetic */ PsiFile $psiFile;

            @Nullable
            public final PsiElement invoke(int offset) {
                PsiElement psiElement = SuggestedRefactoringSupportKt.declarationByOffset((SuggestedRefactoringSupport)this.$refactoringSupport, (PsiFile)this.$psiFile, (int)offset);
                if (psiElement == null) {
                    return null;
                }
                PsiElement declaration = psiElement;
                TextRange textRange = this.$refactoringSupport.signatureRange(declaration);
                if (textRange == null) {
                    return null;
                }
                TextRange signatureRange = textRange;
                PsiElement psiElement2 = declaration;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement2;
                boolean bl3 = false;
                return signatureRange.contains(offset) ? psiElement2 : null;
            }
            {
                this.$refactoringSupport = suggestedRefactoringSupport;
                this.$psiFile = psiFile;
                super(1);
            }
        };
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        TextRange truncatedChangeRange = TextRangeUtilsKt.stripWhitespace((TextRange)changeRange, (CharSequence)charSequence);
        int offset = truncatedChangeRange.getStartOffset();
        PsiElement declaration = $fun$declarationByOffsetInSignature$2.invoke(offset);
        if (declaration == null && changeRange.isEmpty()) {
            TextRange textRange = new TextRange(offset, offset);
            CharSequence charSequence2 = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"document.charsSequence");
            TextRange whitespaceRange = TextRangeUtilsKt.extendWithWhitespace((TextRange)textRange, (CharSequence)charSequence2);
            PsiElement leftDeclaration = whitespaceRange.getStartOffset() > 0 ? $fun$declarationByOffsetInSignature$2.invoke(whitespaceRange.getStartOffset() - 1) : null;
            PsiElement rightDeclaration = whitespaceRange.getEndOffset() > offset ? $fun$declarationByOffsetInSignature$2.invoke(whitespaceRange.getEndOffset()) : null;
            PsiElement psiElement = leftDeclaration;
            if (psiElement == null) {
                psiElement = declaration = rightDeclaration;
            }
        }
        if (declaration == null) {
            return;
        }
        if (refactoringSupport.hasSyntaxError(declaration)) {
            return;
        }
        TextRange textRange = refactoringSupport.signatureRange(declaration);
        if (textRange == null) {
            return;
        }
        TextRange signatureRange = textRange;
        TextRange textRange2 = signatureRange.union(truncatedChangeRange);
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"signatureRange.union(truncatedChangeRange)");
        TextRange extendedSignatureRange = textRange2;
        SignatureEditingState signatureEditingState = this.editingState = this.createEditingState(document, declaration, extendedSignatureRange, refactoringSupport);
        Intrinsics.checkNotNull((Object)signatureEditingState);
        if (!signatureEditingState.isRefactoringSuppressed()) {
            this.watcher.editingStarted(declaration, refactoringSupport);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final SignatureEditingState createEditingState(Document document, PsiElement declaration, TextRange signatureRange, SuggestedRefactoringSupport refactoringSupport) {
        var6_5 = document.createRangeMarker(signatureRange);
        var7_6 = false;
        var8_9 = false;
        $this$apply = var6_5;
        $i$a$-apply-SuggestedRefactoringChangeListener$createEditingState$signatureRangeMarker$1 = false;
        $this$apply.setGreedyToLeft(true);
        $this$apply.setGreedyToRight(true);
        v0 = var6_5;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"document.createRangeMark\u2026reedyToRight = true\n    }");
        signatureRangeMarker = v0;
        v1 = declaration.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"declaration.containingFile");
        v2 = refactoringSupport.importsRange(v1);
        if (v2 == null) ** GOTO lbl-1000
        var7_7 = v2;
        var8_9 = false;
        var9_11 = false;
        it = var7_7;
        $i$a$-let-SuggestedRefactoringChangeListener$createEditingState$importRangeMarker$1 = false;
        v2 = document.createRangeMarker(it);
        if (v2 != null) {
            var7_7 = v2;
            var8_9 = false;
            var9_11 = false;
            $this$apply = var7_7;
            $i$a$-apply-SuggestedRefactoringChangeListener$createEditingState$importRangeMarker$2 = false;
            $this$apply.setGreedyToLeft(true);
            $this$apply.setGreedyToRight(true);
            v3 = var7_7;
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        importRangeMarker = v3;
        refactoringSuppressed = this.shouldSuppressRefactoring(declaration, document, refactoringSupport);
        return new SignatureEditingState(signatureRangeMarker, (RangeMarker)importRangeMarker, refactoringSuppressed);
    }

    private final boolean shouldSuppressRefactoring(PsiElement declaration, Document document, SuggestedRefactoringSupport refactoringSupport) {
        List<TextRange> ranges;
        int index2;
        TextRange nameRange;
        if (Intrinsics.areEqual((Object)this.newIdentifierWatcher.getLastDocument(), (Object)document) && (nameRange = refactoringSupport.nameRange(declaration)) != null && (index2 = (ranges = this.newIdentifierWatcher.lastNewIdentifierRanges()).lastIndexOf(nameRange)) >= 0) {
            boolean bl;
            block4: {
                TextRange textRange = refactoringSupport.signatureRange(declaration);
                Intrinsics.checkNotNull((Object)textRange);
                TextRange signatureRange = textRange;
                Iterable $this$all$iv = CollectionsKt.drop((Iterable)ranges, (int)(index2 + 1));
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        TextRange it = (TextRange)element$iv;
                        boolean bl2 = false;
                        if (signatureRange.contains(it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    public SuggestedRefactoringChangeListener(@NotNull Project project, @NotNull SuggestedRefactoringSignatureWatcher watcher, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.watcher = watcher;
        this.psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        this.newIdentifierWatcher = new NewIdentifierWatcher(5);
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(ProjectDisposeAwareDocumentListener.create(this.project, new MyDocumentListener()), parentDisposable);
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener(), parentDisposable);
        this.project.getMessageBus().connect(parentDisposable).subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void commandStarted(@NotNull CommandEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                isFirstChangeInsideCommand = true;
            }
        });
    }

    public static final /* synthetic */ void access$setEditingState$p(SuggestedRefactoringChangeListener $this, SignatureEditingState signatureEditingState) {
        $this.editingState = signatureEditingState;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeListener$SignatureEditingState;", "", "signatureRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "importRangeMarker", "isRefactoringSuppressed", "", "(Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/openapi/editor/RangeMarker;Z)V", "getImportRangeMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "()Z", "getSignatureRangeMarker", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    private static final class SignatureEditingState {
        @NotNull
        private final RangeMarker signatureRangeMarker;
        @Nullable
        private final RangeMarker importRangeMarker;
        private final boolean isRefactoringSuppressed;

        @NotNull
        public final RangeMarker getSignatureRangeMarker() {
            return this.signatureRangeMarker;
        }

        @Nullable
        public final RangeMarker getImportRangeMarker() {
            return this.importRangeMarker;
        }

        public final boolean isRefactoringSuppressed() {
            return this.isRefactoringSuppressed;
        }

        public SignatureEditingState(@NotNull RangeMarker signatureRangeMarker, @Nullable RangeMarker importRangeMarker, boolean isRefactoringSuppressed) {
            Intrinsics.checkNotNullParameter((Object)signatureRangeMarker, (String)"signatureRangeMarker");
            this.signatureRangeMarker = signatureRangeMarker;
            this.importRangeMarker = importRangeMarker;
            this.isRefactoringSuppressed = isRefactoringSuppressed;
        }

        @NotNull
        public final RangeMarker component1() {
            return this.signatureRangeMarker;
        }

        @Nullable
        public final RangeMarker component2() {
            return this.importRangeMarker;
        }

        public final boolean component3() {
            return this.isRefactoringSuppressed;
        }

        @NotNull
        public final SignatureEditingState copy(@NotNull RangeMarker signatureRangeMarker, @Nullable RangeMarker importRangeMarker, boolean isRefactoringSuppressed) {
            Intrinsics.checkNotNullParameter((Object)signatureRangeMarker, (String)"signatureRangeMarker");
            return new SignatureEditingState(signatureRangeMarker, importRangeMarker, isRefactoringSuppressed);
        }

        public static /* synthetic */ SignatureEditingState copy$default(SignatureEditingState signatureEditingState, RangeMarker rangeMarker, RangeMarker rangeMarker2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                rangeMarker = signatureEditingState.signatureRangeMarker;
            }
            if ((n & 2) != 0) {
                rangeMarker2 = signatureEditingState.importRangeMarker;
            }
            if ((n & 4) != 0) {
                bl = signatureEditingState.isRefactoringSuppressed;
            }
            return signatureEditingState.copy(rangeMarker, rangeMarker2, bl);
        }

        @NotNull
        public String toString() {
            return "SignatureEditingState(signatureRangeMarker=" + this.signatureRangeMarker + ", importRangeMarker=" + this.importRangeMarker + ", isRefactoringSuppressed=" + this.isRefactoringSuppressed + ")";
        }

        public int hashCode() {
            RangeMarker rangeMarker = this.signatureRangeMarker;
            RangeMarker rangeMarker2 = this.importRangeMarker;
            int n = ((rangeMarker != null ? rangeMarker.hashCode() : 0) * 31 + (rangeMarker2 != null ? rangeMarker2.hashCode() : 0)) * 31;
            int n2 = this.isRefactoringSuppressed ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SignatureEditingState)) break block3;
                    SignatureEditingState signatureEditingState = (SignatureEditingState)object;
                    if (!Intrinsics.areEqual((Object)this.signatureRangeMarker, (Object)signatureEditingState.signatureRangeMarker) || !Intrinsics.areEqual((Object)this.importRangeMarker, (Object)signatureEditingState.importRangeMarker) || this.isRefactoringSuppressed != signatureEditingState.isRefactoringSuppressed) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeListener$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "(Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeListener;)V", "isActionOnAllCommittedScheduled", "", "beforeDocumentChange", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "performWhenAllCommitted", "shouldAbortSignatureEditing", "shouldIgnoreFile", "file", "Lcom/intellij/psi/PsiFile;", "intellij.platform.lang.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        private boolean isActionOnAllCommittedScheduled;

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
            Document document2 = document;
            PsiFile psiFile = SuggestedRefactoringChangeListener.this.psiDocumentManager.getCachedPsiFile(document2);
            if (psiFile == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiDocumentManager.getCa\u2026iFile(document) ?: return");
            PsiFile psiFile2 = psiFile;
            if (this.shouldIgnoreFile(psiFile2)) {
                return;
            }
            boolean firstChangeInsideCommand = SuggestedRefactoringChangeListener.this.isFirstChangeInsideCommand;
            SuggestedRefactoringChangeListener.this.isFirstChangeInsideCommand = false;
            Language language2 = psiFile2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"psiFile.language");
            SuggestedRefactoringSupport suggestedRefactoringSupport = SuggestedRefactoringSupport.Companion.forLanguage(language2);
            if (suggestedRefactoringSupport == null) {
                return;
            }
            SuggestedRefactoringSupport refactoringSupport = suggestedRefactoringSupport;
            if (this.shouldAbortSignatureEditing(event)) {
                SuggestedRefactoringChangeListener.reset$default(SuggestedRefactoringChangeListener.this, false, 1, null);
            }
            if (firstChangeInsideCommand && SuggestedRefactoringChangeListener.this.psiDocumentManager.isCommitted(document2) && !SuggestedRefactoringChangeListener.this.psiDocumentManager.isDocumentBlockedByPsi(document2)) {
                SuggestedRefactoringChangeListener.this.processBeforeFirstChangeWithPsiAndDocumentInSync(psiFile2, document2, UtilsKt.getOldRange((DocumentEvent)event), refactoringSupport);
            }
        }

        private final boolean shouldIgnoreFile(PsiFile file2) {
            return !file2.isPhysical() || file2 instanceof PsiBinaryFile || file2 instanceof PsiCodeFragment;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldAbortSignatureEditing(DocumentEvent event) {
            SignatureEditingState signatureEditingState = SuggestedRefactoringChangeListener.this.editingState;
            if (signatureEditingState == null) return false;
            SignatureEditingState state = signatureEditingState;
            if (!state.getSignatureRangeMarker().isValid()) {
                return true;
            }
            if (Intrinsics.areEqual((Object)state.getSignatureRangeMarker().getDocument(), (Object)event.getDocument()) ^ true) {
                return true;
            }
            if (state.getImportRangeMarker() != null && !state.getImportRangeMarker().isValid()) {
                return true;
            }
            TextRange textRange = UtilsKt.getRange((RangeMarker)state.getSignatureRangeMarker());
            Intrinsics.checkNotNull((Object)textRange);
            TextRange signatureRange = textRange;
            RangeMarker rangeMarker = state.getImportRangeMarker();
            TextRange importRange = rangeMarker != null ? UtilsKt.getRange((RangeMarker)rangeMarker) : null;
            if (signatureRange.contains(UtilsKt.getOldRange((DocumentEvent)event))) return false;
            if (importRange != null) {
                if (importRange.contains(UtilsKt.getOldRange((DocumentEvent)event))) return false;
            }
            CharSequence charSequence = event.getOldFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"event.oldFragment");
            CharSequence charSequence2 = charSequence;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            CharSequence charSequence3 = event.getNewFragment();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"event.newFragment");
            charSequence2 = charSequence3;
            bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence2)) return false;
            return true;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getOldLength() == 0 && event.getNewLength() == 0) {
                return;
            }
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
            Document document2 = document;
            PsiFile psiFile = SuggestedRefactoringChangeListener.this.psiDocumentManager.getCachedPsiFile(document2);
            if (psiFile == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiDocumentManager.getCa\u2026iFile(document) ?: return");
            PsiFile psiFile2 = psiFile;
            if (this.shouldIgnoreFile(psiFile2)) {
                return;
            }
            NewIdentifierWatcher newIdentifierWatcher = SuggestedRefactoringChangeListener.this.newIdentifierWatcher;
            Language language2 = psiFile2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"psiFile.language");
            newIdentifierWatcher.documentChanged(event, language2);
            SignatureEditingState signatureEditingState = SuggestedRefactoringChangeListener.this.editingState;
            if (signatureEditingState == null) {
                return;
            }
            SignatureEditingState editingState = signatureEditingState;
            RangeMarker signatureRangeMarker = editingState.getSignatureRangeMarker();
            if (!signatureRangeMarker.isValid() || editingState.getImportRangeMarker() != null && !editingState.getImportRangeMarker().isValid()) {
                SuggestedRefactoringChangeListener.reset$default(SuggestedRefactoringChangeListener.this, false, 1, null);
                return;
            }
            if (!this.isActionOnAllCommittedScheduled) {
                this.isActionOnAllCommittedScheduled = true;
                Function0 function0 = (Function0)new Function0<Unit>(this){

                    public final void invoke() {
                        MyDocumentListener.access$performWhenAllCommitted((MyDocumentListener)this.receiver);
                    }
                };
                SuggestedRefactoringChangeListener.this.psiDocumentManager.performWhenAllCommitted(new Runnable(function0){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ void run() {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                    }
                });
            }
        }

        private final void performWhenAllCommitted() {
            TextRange signatureRange;
            TextRange textRange;
            PsiElement declaration;
            this.isActionOnAllCommittedScheduled = false;
            SignatureEditingState signatureEditingState = SuggestedRefactoringChangeListener.this.editingState;
            if (signatureEditingState == null) {
                return;
            }
            SignatureEditingState editingState = signatureEditingState;
            TextRange watchedRange = UtilsKt.getRange((RangeMarker)editingState.getSignatureRangeMarker());
            if (watchedRange == null) {
                SuggestedRefactoringChangeListener.reset$default(SuggestedRefactoringChangeListener.this, false, 1, null);
                return;
            }
            Document document = editingState.getSignatureRangeMarker().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editingState.signatureRangeMarker.document");
            Document document2 = document;
            PsiFile psiFile = SuggestedRefactoringChangeListener.this.psiDocumentManager.getPsiFile(document2);
            if (psiFile == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiDocumentManager.getPsiFile(document) ?: return");
            PsiFile psiFile2 = psiFile;
            Language language2 = psiFile2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"psiFile.language");
            SuggestedRefactoringSupport suggestedRefactoringSupport = SuggestedRefactoringSupport.Companion.forLanguage(language2);
            if (suggestedRefactoringSupport == null) {
                return;
            }
            SuggestedRefactoringSupport refactoringSupport = suggestedRefactoringSupport;
            CharSequence charSequence = document2.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
            CharSequence chars = charSequence;
            TextRange strippedWatchedRange = TextRangeUtilsKt.stripWhitespace((TextRange)watchedRange, (CharSequence)chars);
            PsiElement psiElement = declaration = SuggestedRefactoringSupportKt.declarationByOffset((SuggestedRefactoringSupport)refactoringSupport, (PsiFile)psiFile2, (int)strippedWatchedRange.getStartOffset());
            if (psiElement != null) {
                PsiElement psiElement2 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement2;
                boolean bl3 = false;
                textRange = refactoringSupport.signatureRange(it);
            } else {
                textRange = signatureRange = null;
            }
            if (declaration == null || signatureRange == null || Intrinsics.areEqual((Object)strippedWatchedRange, (Object)TextRangeUtilsKt.stripWhitespace(signatureRange, (CharSequence)chars)) ^ true) {
                CharSequence charSequence2 = document2.getCharsSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"document.charsSequence");
                TextRange watchedRangeExtended = TextRangeUtilsKt.extendWithWhitespace((TextRange)watchedRange, (CharSequence)charSequence2);
                TextRange textRange2 = signatureRange;
                if (textRange2 == null || (textRange2 = textRange2.union(watchedRangeExtended)) == null) {
                    textRange2 = watchedRangeExtended;
                }
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"signatureRange?.union(wa\u2026) ?: watchedRangeExtended");
                TextRange range2 = textRange2;
                if (PsiTreeUtilKt.hasErrorElementInRange((PsiFile)psiFile2, (TextRange)range2)) {
                    if (!editingState.isRefactoringSuppressed()) {
                        SuggestedRefactoringChangeListener.this.watcher.inconsistentState();
                    }
                } else {
                    SuggestedRefactoringChangeListener.reset$default(SuggestedRefactoringChangeListener.this, false, 1, null);
                }
                return;
            }
            if (!editingState.isRefactoringSuppressed()) {
                SuggestedRefactoringChangeListener.this.watcher.nextSignature(declaration, refactoringSupport);
            }
        }

        public static final /* synthetic */ void access$performWhenAllCommitted(MyDocumentListener $this) {
            $this.performWhenAllCommitted();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeListener$MyPsiTreeChangeListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "(Lcom/intellij/refactoring/suggested/SuggestedRefactoringChangeListener;)V", "beforeChildAddition", "", "event", "Lcom/intellij/psi/PsiTreeChangeEvent;", "beforeChildMovement", "beforeChildRemoval", "beforeChildReplacement", "beforeChildrenChange", "processBeforeEvent", "intellij.platform.lang.impl"})
    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processBeforeEvent(event);
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processBeforeEvent(event);
        }

        public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processBeforeEvent(event);
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processBeforeEvent(event);
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processBeforeEvent(event);
        }

        private final void processBeforeEvent(PsiTreeChangeEvent event) {
            if (SuggestedRefactoringChangeListener.this.project.isDisposed() || !SuggestedRefactoringChangeListener.this.isFirstChangeInsideCommand) {
                return;
            }
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"event.file ?: return");
            PsiFile psiFile2 = psiFile;
            Document document = SuggestedRefactoringChangeListener.this.psiDocumentManager.getCachedDocument(psiFile2);
            if (document == null) {
                SuggestedRefactoringChangeListener.this.isFirstChangeInsideCommand = false;
                return;
            }
            if (SuggestedRefactoringChangeListener.this.psiDocumentManager.isUncommited(document)) {
                return;
            }
            SuggestedRefactoringChangeListener.this.isFirstChangeInsideCommand = false;
            if (!(psiFile2 instanceof PsiFileImpl) || !((PsiFileImpl)psiFile2).isContentsLoaded()) {
                return;
            }
            Language language2 = ((PsiFileImpl)psiFile2).getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"psiFile.language");
            SuggestedRefactoringSupport suggestedRefactoringSupport = SuggestedRefactoringSupport.Companion.forLanguage(language2);
            if (suggestedRefactoringSupport == null) {
                return;
            }
            SuggestedRefactoringSupport refactoringSupport = suggestedRefactoringSupport;
            PsiTreeChangeEvent psiTreeChangeEvent = event;
            if (psiTreeChangeEvent == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.impl.PsiTreeChangeEventImpl");
            }
            PsiTreeChangeEventImpl cfr_ignored_0 = (PsiTreeChangeEventImpl)psiTreeChangeEvent;
            TextRange textRange = TextRange.from((int)((PsiTreeChangeEventImpl)event).getOffset(), (int)((PsiTreeChangeEventImpl)event).getOldLength());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.from(event.offset, event.oldLength)");
            TextRange changeRange = textRange;
            SuggestedRefactoringChangeListener.this.processBeforeFirstChangeWithPsiAndDocumentInSync(psiFile2, document, changeRange, refactoringSupport);
        }
    }
}

