/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.refactoring.suggested.SuggestedChangeSignatureData;
import com.intellij.refactoring.suggested.SuggestedRefactoringData;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.refactoring.suggested.SuggestedRenameData;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringFeatureUsage;", "", "()V", "POPUP_CANCELED", "", "POPUP_SHOWN", "REFACTORING_PERFORMED", "REFACTORING_SUGGESTED", "featureUsageGroup", "lastFeatureUsageIdLogged", "", "Ljava/lang/Integer;", "logEvent", "", "eventIdSuffix", "refactoringData", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringData;", "state", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "actionPlace", "refactoringSuggested", "intellij.platform.lang.impl"})
public final class SuggestedRefactoringFeatureUsage {
    private static final String featureUsageGroup = "suggested.refactorings";
    private static Integer lastFeatureUsageIdLogged;
    private static final String REFACTORING_SUGGESTED = "suggested";
    @NotNull
    public static final String POPUP_SHOWN = "popup.shown";
    @NotNull
    public static final String POPUP_CANCELED = "popup.canceled";
    @NotNull
    public static final String REFACTORING_PERFORMED = "performed";
    @NotNull
    public static final SuggestedRefactoringFeatureUsage INSTANCE;

    public final void logEvent(@NotNull String eventIdSuffix, @NotNull SuggestedRefactoringData refactoringData, @NotNull SuggestedRefactoringState state, @Nullable String actionPlace) {
        String string;
        Intrinsics.checkNotNullParameter((Object)eventIdSuffix, (String)"eventIdSuffix");
        Intrinsics.checkNotNullParameter((Object)refactoringData, (String)"refactoringData");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FeatureUsageData featureUsageData = new FeatureUsageData();
        boolean bl = false;
        boolean bl2 = false;
        FeatureUsageData $this$apply = featureUsageData;
        boolean bl3 = false;
        $this$apply.addPlace(actionPlace);
        $this$apply.addData("id", state.getFeatureUsageId());
        $this$apply.addLanguage(refactoringData.getDeclaration().getLanguage());
        String string2 = refactoringData.getDeclaration().getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"refactoringData.declaration.javaClass.name");
        $this$apply.addData("declaration_type", string2);
        FeatureUsageData featureUsageData2 = featureUsageData;
        SuggestedRefactoringData suggestedRefactoringData = refactoringData;
        if (suggestedRefactoringData instanceof SuggestedRenameData) {
            string = "rename.";
        } else if (suggestedRefactoringData instanceof SuggestedChangeSignatureData) {
            string = "changeSignature.";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String eventIdPrefix = string;
        String eventId = eventIdPrefix + eventIdSuffix;
        FUCounterUsageLogger.getInstance().logEvent(refactoringData.getDeclaration().getProject(), featureUsageGroup, eventId, featureUsageData2);
    }

    public final void refactoringSuggested(@NotNull SuggestedRefactoringData refactoringData, @NotNull SuggestedRefactoringState state) {
        Intrinsics.checkNotNullParameter((Object)refactoringData, (String)"refactoringData");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Integer n = lastFeatureUsageIdLogged;
        if (n == null || state.getFeatureUsageId() != n.intValue()) {
            lastFeatureUsageIdLogged = state.getFeatureUsageId();
            this.logEvent(REFACTORING_SUGGESTED, refactoringData, state, null);
        }
    }

    private SuggestedRefactoringFeatureUsage() {
    }

    static {
        SuggestedRefactoringFeatureUsage suggestedRefactoringFeatureUsage;
        INSTANCE = suggestedRefactoringFeatureUsage = new SuggestedRefactoringFeatureUsage();
    }
}

