/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JRadioButton;

public class RadioUpDownListener
extends KeyAdapter {
    private final JRadioButton[] myRadioButtons;

    public RadioUpDownListener(JRadioButton ... radioButtons) {
        this.myRadioButtons = radioButtons;
        for (JRadioButton radioButton2 : radioButtons) {
            radioButton2.addKeyListener(this);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int selected2 = this.getSelected();
        if (selected2 != -1) {
            if (e.getKeyCode() == 38) {
                this.up(selected2, selected2);
                e.consume();
            } else if (e.getKeyCode() == 40) {
                this.down(selected2, selected2);
                e.consume();
            }
        }
    }

    private void down(int selected2, int stop2) {
        int newIdx = selected2 + 1;
        if (newIdx > this.myRadioButtons.length - 1) {
            newIdx = 0;
        }
        if (!RadioUpDownListener.click(this.myRadioButtons[newIdx]) && stop2 != newIdx) {
            this.down(newIdx, selected2);
        }
    }

    private void up(int selected2, int stop2) {
        int newIdx = selected2 - 1;
        if (newIdx < 0) {
            newIdx = this.myRadioButtons.length - 1;
        }
        if (!RadioUpDownListener.click(this.myRadioButtons[newIdx]) && stop2 != newIdx) {
            this.up(newIdx, selected2);
        }
    }

    private int getSelected() {
        for (int i2 = 0; i2 < this.myRadioButtons.length; ++i2) {
            if (!this.myRadioButtons[i2].isSelected()) continue;
            return i2;
        }
        return -1;
    }

    private static boolean click(JRadioButton button4) {
        if (button4.isEnabled() && button4.isVisible()) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)button4, true));
            button4.doClick();
            return true;
        }
        return false;
    }
}

