/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsCantBeLoaded;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

final class CredentialsManagerImpl
extends CredentialsManager {
    CredentialsManagerImpl() {
    }

    public List<CredentialsType<?>> getAllTypes() {
        return CredentialsType.EP_NAME.getExtensionList();
    }

    public void loadCredentials(String interpreterPath, @Nullable Element element2, RemoteSdkAdditionalData data2) {
        for (CredentialsType type : CredentialsType.EP_NAME.getExtensionList()) {
            if (!type.hasPrefix(interpreterPath)) continue;
            Object credentials2 = type.createCredentials();
            try {
                type.getHandler(credentials2).load(element2);
            }
            catch (CredentialsCantBeLoaded e) {
                Logger.getInstance(CredentialsManagerImpl.class).warn((Throwable)e);
                continue;
            }
            data2.setCredentials(type.getCredentialsKey(), credentials2);
            return;
        }
        UnknownCredentialsHolder credentials3 = (UnknownCredentialsHolder)CredentialsType.UNKNOWN.createCredentials();
        credentials3.setSdkId(interpreterPath);
        credentials3.load(element2);
        data2.setCredentials(CredentialsType.UNKNOWN_CREDENTIALS, (Object)credentials3);
    }
}

