/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.remoteDev.RemoteDevUtilBundle;
import com.intellij.remoteDev.downloader.CodeWithMeClientDownloader;
import com.intellij.remoteDev.downloader.CodeWithMeGuestLauncher;
import com.intellij.remoteDev.downloader.ThinClientSessionInfoFetcher;
import com.intellij.remoteDev.util.UrlUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.UriUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\u0012J:\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0006\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/remoteDev/downloader/CodeWithMeGuestLauncher;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "alreadyDownloading", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "", "downloadCompatibleClientAndLaunch", "", "project", "Lcom/intellij/openapi/project/Project;", "url", "product", "onDone", "Lkotlin/Function1;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "runDownloadedClient", "lifetime", "pathToClient", "Ljava/nio/file/Path;", "pathToJre", "urlForThinClient", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class CodeWithMeGuestLauncher {
    private static final Logger LOG;
    private static final ConcurrentHashMap.KeySetView<String, Boolean> alreadyDownloading;
    @NotNull
    public static final CodeWithMeGuestLauncher INSTANCE;

    public final void downloadCompatibleClientAndLaunch(@Nullable Project project, @NotNull String url, @NlsContexts.DialogTitle @NotNull String product, @NotNull Function1<? super Lifetime, Unit> onDone2) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter(onDone2, (String)"onDone");
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            ApplicationKt.getApplication().invokeLater(new Runnable(project, url, product, onDone2){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $url;
                final /* synthetic */ String $product;
                final /* synthetic */ Function1 $onDone;

                public final void run() {
                    CodeWithMeGuestLauncher.INSTANCE.downloadCompatibleClientAndLaunch(this.$project, this.$url, this.$product, (Function1<? super Lifetime, Unit>)this.$onDone);
                }
                {
                    this.$project = project;
                    this.$url = string;
                    this.$product = string2;
                    this.$onDone = function1;
                }
            }, ModalityState.any());
            return;
        }
        URI uRI = UrlUtil.INSTANCE.parseOrShowError(url, product);
        if (uRI == null) {
            return;
        }
        URI uri = uRI;
        if (!alreadyDownloading.add(url)) {
            LOG.info("Already downloading a client for " + url);
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(uri, url, project, product, onDone2, project, RemoteDevUtilBundle.INSTANCE.message("launcher.title", new Object[0]), true){
            private Lifetime clientLifetime;
            final /* synthetic */ URI $uri;
            final /* synthetic */ String $url;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $product;
            final /* synthetic */ Function1 $onDone;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run(@NotNull ProgressIndicator progressIndicator) {
                Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
                try {
                    block18: {
                        block17: {
                            v0 = this.$uri.getScheme();
                            if (v0 == null) break block17;
                            var3_2 = v0;
                            switch (var3_2.hashCode()) {
                                case 114657: {
                                    if (!var3_2.equals("tcp")) ** break;
                                    ** GOTO lbl19
                                }
                                case 3213448: {
                                    if (!var3_2.equals("http")) ** break;
                                    break;
                                }
                                case 99617003: {
                                    if (!var3_2.equals("https")) ** break;
                                    break;
                                }
                                case 3186636: {
                                    if (!var3_2.equals("gwws")) ** break;
lbl19:
                                    // 2 sources

                                    v1 = UriUtilKt.getFragmentParameters(this.$uri).get("cb");
                                    if (v1 == null) {
                                        var5_3 = "there is no client build in url";
                                        var6_6 = false;
                                        throw (Throwable)new IllegalStateException(var5_3.toString());
                                    }
                                    clientBuild = v1;
                                    v2 = UriUtilKt.getFragmentParameters(this.$uri).get("jb");
                                    if (v2 == null) {
                                        var6_7 = "there is no jre build in url";
                                        var7_11 = false;
                                        throw (Throwable)new IllegalStateException(var6_7.toString());
                                    }
                                    jreBuild = v2;
                                    unattendedMode = UriUtilKt.getFragmentParameters(this.$uri).get("jt") != null;
                                    v3 = CodeWithMeClientDownloader.INSTANCE.createSessionInfo(clientBuild, jreBuild, unattendedMode);
                                    break block18;
                                }
                            }
                            progressIndicator.setText(RemoteDevUtilBundle.INSTANCE.message("launcher.get.client.info", new Object[0]));
                            v3 = ThinClientSessionInfoFetcher.INSTANCE.getSessionUrl(this.$uri);
                            break block18;
                        }
                        var4_10 = "scheme '" + this.$uri.getScheme() + " is not supported'";
                        var5_5 = false;
                        throw (Throwable)new IllegalStateException(var4_10.toString());
                    }
                    sessionInfo = v3;
                    pair = CodeWithMeClientDownloader.INSTANCE.downloadClientAndJdk(sessionInfo, progressIndicator);
                    if (pair == null) {
                        return;
                    }
                    v4 = this.$project;
                    if (v4 == null || (v4 = LifetimeDisposableExKt.createLifetime((Disposable)v4)) == null) {
                        v4 = Lifetime.Companion.getEternal();
                    }
                    this.clientLifetime = CodeWithMeGuestLauncher.INSTANCE.runDownloadedClient((Lifetime)v4, (Path)pair.getFirst(), (Path)pair.getSecond(), this.$url, this.$product, progressIndicator);
                }
                catch (Throwable t) {
                    CodeWithMeGuestLauncher.access$getLOG$p(CodeWithMeGuestLauncher.INSTANCE).warn(t);
                    ApplicationKt.getApplication().invokeLater(new Runnable(this, t){
                        final /* synthetic */ downloadCompatibleClientAndLaunch.2 this$0;
                        final /* synthetic */ Throwable $t;

                        public final void run() {
                            Object[] objectArray = new Object[1];
                            String string = this.$t.getMessage();
                            if (string == null) {
                                string = "Unknown";
                            }
                            objectArray[0] = string;
                            Messages.showErrorDialog((String)RemoteDevUtilBundle.INSTANCE.message("error.url.issue", objectArray), (String)this.this$0.$product);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$t = throwable;
                        }
                    }, ModalityState.any());
                }
                finally {
                    CodeWithMeGuestLauncher.access$getAlreadyDownloading$p(CodeWithMeGuestLauncher.INSTANCE).remove(this.$url);
                }
            }

            public void onSuccess() {
                this.$onDone.invoke((Object)this.clientLifetime);
            }

            public void onCancel() {
            }
            {
                this.$uri = $captured_local_variable$0;
                this.$url = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$product = $captured_local_variable$3;
                this.$onDone = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
                this.clientLifetime = Lifetime.Companion.getTerminated();
            }
        });
    }

    @NotNull
    public final Lifetime runDownloadedClient(@NotNull Lifetime lifetime, @NotNull Path pathToClient, @NotNull Path pathToJre, @NotNull String urlForThinClient, @NlsContexts.DialogTitle @NotNull String product, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)pathToClient, (String)"pathToClient");
        Intrinsics.checkNotNullParameter((Object)pathToJre, (String)"pathToJre");
        Intrinsics.checkNotNullParameter((Object)urlForThinClient, (String)"urlForThinClient");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        try {
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText(RemoteDevUtilBundle.INSTANCE.message("launcher.launch.client", new Object[0]));
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2(((Object)pathToClient).toString());
            }
            Lifetime thinClientLifetime = CodeWithMeClientDownloader.INSTANCE.runCwmGuestProcessFromDownload(lifetime, urlForThinClient, pathToClient, pathToJre);
            Thread.sleep(3000L);
            return thinClientLifetime;
        }
        catch (Throwable t) {
            Logger.getInstance(this.getClass()).warn(t);
            ApplicationKt.getApplication().invokeLater(new Runnable(t, product){
                final /* synthetic */ Throwable $t;
                final /* synthetic */ String $product;

                public final void run() {
                    Object[] objectArray = new Object[1];
                    String string = this.$t.getMessage();
                    if (string == null) {
                        string = "Unknown";
                    }
                    objectArray[0] = string;
                    Messages.showErrorDialog((String)RemoteDevUtilBundle.INSTANCE.message("error.guest.run.issue", objectArray), (String)this.$product);
                }
                {
                    this.$t = throwable;
                    this.$product = string;
                }
            });
            return Lifetime.Companion.getTerminated();
        }
    }

    private CodeWithMeGuestLauncher() {
    }

    static {
        CodeWithMeGuestLauncher codeWithMeGuestLauncher;
        INSTANCE = codeWithMeGuestLauncher = new CodeWithMeGuestLauncher();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CodeWithMeGuestLauncher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        alreadyDownloading = ConcurrentHashMap.newKeySet();
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getAlreadyDownloading$p(CodeWithMeGuestLauncher $this) {
        CodeWithMeGuestLauncher codeWithMeGuestLauncher = $this;
        return alreadyDownloading;
    }

    public static final /* synthetic */ Logger access$getLOG$p(CodeWithMeGuestLauncher $this) {
        CodeWithMeGuestLauncher codeWithMeGuestLauncher = $this;
        return LOG;
    }
}

