/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remoteDev.downloader.JetBrainsClientDownloaderConfigurationProvider;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.intellij.util.io.PathKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020:J\u0010\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u0004H\u0016J\u000e\u0010C\u001a\u00020\u00112\u0006\u0010D\u001a\u00020\u0004J\u001e\u0010E\u001a\u00020\u00112\u0006\u0010;\u001a\u00020<2\u0006\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\bR\u001c\u0010#\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010\bR\u001c\u0010&\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0006\"\u0004\b(\u0010\bR\u001a\u0010)\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001d\"\u0004\b*\u0010\u001fR\u001a\u0010+\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\f\"\u0004\b-\u0010\u000eR\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u00020\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001d\"\u0004\b2\u0010\u001fR\u001c\u00103\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108\u00a8\u0006H"}, d2={"Lcom/intellij/remoteDev/downloader/TestJetBrainsClientDownloaderConfigurationProvider;", "Lcom/intellij/remoteDev/downloader/JetBrainsClientDownloaderConfigurationProvider;", "()V", "clientCachesDir", "Ljava/nio/file/Path;", "getClientCachesDir", "()Ljava/nio/file/Path;", "setClientCachesDir", "(Ljava/nio/file/Path;)V", "clientDownloadLocation", "Ljava/net/URI;", "getClientDownloadLocation", "()Ljava/net/URI;", "setClientDownloadLocation", "(Ljava/net/URI;)V", "clientLaunched", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getClientLaunched", "()Lcom/jetbrains/rd/util/reactive/Signal;", "debugPort", "", "getDebugPort", "()I", "setDebugPort", "(I)V", "debugSuspendOnStart", "", "getDebugSuspendOnStart", "()Z", "setDebugSuspendOnStart", "(Z)V", "guestConfigFolder", "getGuestConfigFolder", "setGuestConfigFolder", "guestLogFolder", "getGuestLogFolder", "setGuestLogFolder", "guestSystemFolder", "getGuestSystemFolder", "setGuestSystemFolder", "isDebugEnabled", "setDebugEnabled", "jreDownloadLocation", "getJreDownloadLocation", "setJreDownloadLocation", "tarGzServer", "Lcom/sun/net/httpserver/HttpServer;", "verifySignature", "getVerifySignature", "setVerifySignature", "x11DisplayForClient", "", "getX11DisplayForClient", "()Ljava/lang/String;", "setX11DisplayForClient", "(Ljava/lang/String;)V", "mockClientDownloadsServer", "Ljava/net/InetSocketAddress;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "ipv4Address", "modifyClientCommandLine", "clientCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "patchVmOptions", "vmOptionsFile", "serveFile", "file", "startServerAndServeClient", "clientDistribution", "clientJdkBuildTxt", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class TestJetBrainsClientDownloaderConfigurationProvider
implements JetBrainsClientDownloaderConfigurationProvider {
    @Nullable
    private String x11DisplayForClient;
    @Nullable
    private Path guestConfigFolder;
    @Nullable
    private Path guestSystemFolder;
    @Nullable
    private Path guestLogFolder;
    private boolean isDebugEnabled;
    private boolean debugSuspendOnStart;
    private int debugPort = -1;
    @NotNull
    private URI clientDownloadLocation = new URI("https://cache-redirector.jetbrains.com/download.jetbrains.com/idea/code-with-me/");
    @NotNull
    private URI jreDownloadLocation = new URI("https://cache-redirector.jetbrains.com/download.jetbrains.com/idea/jbr/");
    @NotNull
    private Path clientCachesDir;
    private boolean verifySignature;
    @NotNull
    private final Signal<Unit> clientLaunched;
    private HttpServer tarGzServer;

    @Nullable
    public final String getX11DisplayForClient() {
        return this.x11DisplayForClient;
    }

    public final void setX11DisplayForClient(@Nullable String string) {
        this.x11DisplayForClient = string;
    }

    @Nullable
    public final Path getGuestConfigFolder() {
        return this.guestConfigFolder;
    }

    public final void setGuestConfigFolder(@Nullable Path path2) {
        this.guestConfigFolder = path2;
    }

    @Nullable
    public final Path getGuestSystemFolder() {
        return this.guestSystemFolder;
    }

    public final void setGuestSystemFolder(@Nullable Path path2) {
        this.guestSystemFolder = path2;
    }

    @Nullable
    public final Path getGuestLogFolder() {
        return this.guestLogFolder;
    }

    public final void setGuestLogFolder(@Nullable Path path2) {
        this.guestLogFolder = path2;
    }

    public final boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public final void setDebugEnabled(boolean bl) {
        this.isDebugEnabled = bl;
    }

    public final boolean getDebugSuspendOnStart() {
        return this.debugSuspendOnStart;
    }

    public final void setDebugSuspendOnStart(boolean bl) {
        this.debugSuspendOnStart = bl;
    }

    public final int getDebugPort() {
        return this.debugPort;
    }

    public final void setDebugPort(int n) {
        this.debugPort = n;
    }

    @Override
    public void modifyClientCommandLine(@NotNull GeneralCommandLine clientCommandLine) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)clientCommandLine, (String)"clientCommandLine");
            String string = this.x11DisplayForClient;
            if (string == null) break block1;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            boolean bl4 = SystemInfo.isLinux;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string3 = "X11 display property makes sense only on Linux";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.info("Setting env var DISPLAY for Guest process=" + it);
            Map map2 = clientCommandLine.getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"clientCommandLine.environment");
            map2.put("DISPLAY", it);
        }
    }

    @Override
    @NotNull
    public URI getClientDownloadLocation() {
        return this.clientDownloadLocation;
    }

    public void setClientDownloadLocation(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<set-?>");
        this.clientDownloadLocation = uRI;
    }

    @Override
    @NotNull
    public URI getJreDownloadLocation() {
        return this.jreDownloadLocation;
    }

    public void setJreDownloadLocation(@NotNull URI uRI) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<set-?>");
        this.jreDownloadLocation = uRI;
    }

    @Override
    @NotNull
    public Path getClientCachesDir() {
        return this.clientCachesDir;
    }

    public void setClientCachesDir(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"<set-?>");
        this.clientCachesDir = path2;
    }

    @Override
    public boolean getVerifySignature() {
        return this.verifySignature;
    }

    public void setVerifySignature(boolean bl) {
        this.verifySignature = bl;
    }

    @Override
    @NotNull
    public Signal<Unit> getClientLaunched() {
        return this.clientLaunched;
    }

    @Override
    public void patchVmOptions(@NotNull Path vmOptionsFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)vmOptionsFile, (String)"vmOptionsFile");
        TestJetBrainsClientDownloaderConfigurationProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        logger.info("Patching " + vmOptionsFile);
        List traceCategories = CollectionsKt.listOf((Object[])new String[]{"#com.jetbrains.rdserver.joinLinks", "#com.jetbrains.rd.platform.codeWithMe.network"});
        TestJetBrainsClientDownloaderConfigurationProvider testJetBrainsClientDownloaderConfigurationProvider = this;
        boolean bl = false;
        boolean bl2 = false;
        TestJetBrainsClientDownloaderConfigurationProvider $this$run22 = testJetBrainsClientDownloaderConfigurationProvider;
        boolean bl32 = false;
        if ($this$run22.isDebugEnabled) {
            String suspendOnStart = $this$run22.debugSuspendOnStart ? "y" : "n";
            string = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspendOnStart + ",address=" + $this$run22.debugPort;
        } else {
            string = "";
        }
        String debugOptions = string;
        Object[] objectArray = new String[17];
        objectArray[0] = "-Djb.consents.confirmation.enabled=false";
        objectArray[1] = "-Djb.privacy.policy.text=\"<!--999.999-->\"";
        objectArray[2] = "-Didea.initially.ask.config=force-not";
        objectArray[3] = "-Dfus.internal.test.mode=true";
        objectArray[4] = "-Didea.suppress.statistics.report=true";
        objectArray[5] = "-Drsch.send.usage.stat=false";
        objectArray[6] = "-Duse.linux.keychain=false";
        objectArray[7] = "-Dide.show.tips.on.startup.default.value=false";
        objectArray[8] = "-Didea.is.internal=true";
        objectArray[9] = "-DcodeWithMe.memory.only.certificate=true";
        objectArray[10] = "-Dide.slow.operations.assertion=false";
        objectArray[11] = "-Deap.login.enabled=false";
        StringBuilder stringBuilder = new StringBuilder().append("-Didea.config.path=");
        Path path2 = this.guestConfigFolder;
        Intrinsics.checkNotNull((Object)path2);
        Path path3 = path2;
        bl2 = false;
        objectArray[12] = stringBuilder.append(((Object)path3.toAbsolutePath()).toString()).toString();
        StringBuilder stringBuilder2 = new StringBuilder().append("-Didea.system.path=");
        Path path4 = this.guestSystemFolder;
        Intrinsics.checkNotNull((Object)path4);
        path3 = path4;
        bl2 = false;
        objectArray[13] = stringBuilder2.append(((Object)path3.toAbsolutePath()).toString()).toString();
        StringBuilder stringBuilder3 = new StringBuilder().append("-Didea.log.path=");
        Path path5 = this.guestLogFolder;
        Intrinsics.checkNotNull((Object)path5);
        path3 = path5;
        bl2 = false;
        objectArray[14] = stringBuilder3.append(((Object)path3.toAbsolutePath()).toString()).toString();
        objectArray[15] = "-Didea.log.trace.categories=" + CollectionsKt.joinToString$default((Iterable)traceCategories, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        objectArray[16] = debugOptions;
        String testVmOptions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", (CharSequence)"\n", null, (int)0, null, null, (int)60, null);
        boolean bl4 = PathKt.isFile((Path)vmOptionsFile) && PathKt.exists((Path)vmOptionsFile);
        bl2 = false;
        boolean $this$run22 = false;
        $this$run22 = false;
        bl32 = false;
        if (!bl4) {
            boolean bl5 = false;
            String bl32 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(bl32.toString());
        }
        String originalContent = PathsKt.readText((Path)vmOptionsFile, (Charset)Charsets.UTF_8);
        TestJetBrainsClientDownloaderConfigurationProvider $this$thisLogger$iv2 = this;
        boolean $i$f$thisLogger2 = false;
        Logger logger2 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        logger2.info("Original .vmoptions=\n" + originalContent);
        String patchedContent = originalContent + testVmOptions;
        TestJetBrainsClientDownloaderConfigurationProvider $this$thisLogger$iv3 = this;
        boolean $i$f$thisLogger3 = false;
        Logger logger3 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"Logger.getInstance(T::class.java)");
        logger3.info("Patched .vmoptions=" + patchedContent);
        PathsKt.writeText$default((Path)vmOptionsFile, (CharSequence)patchedContent, null, (OpenOption[])new OpenOption[0], (int)2, null);
        $this$thisLogger$iv3 = this;
        $i$f$thisLogger3 = false;
        Logger logger4 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"Logger.getInstance(T::class.java)");
        logger4.info("Patched " + vmOptionsFile + " successfully");
    }

    @NotNull
    public final InetSocketAddress mockClientDownloadsServer(@NotNull Lifetime lifetime, @NotNull InetSocketAddress ipv4Address) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)ipv4Address, (String)"ipv4Address");
        boolean bl = this.tarGzServer == null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        TestJetBrainsClientDownloaderConfigurationProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        logger.info("Initializing HTTP server to download distributions as if from outer world");
        HttpServer server = HttpServer.create(ipv4Address, 0);
        TestJetBrainsClientDownloaderConfigurationProvider $this$thisLogger$iv2 = this;
        boolean $i$f$thisLogger2 = false;
        Logger logger2 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        StringBuilder stringBuilder = new StringBuilder().append("HTTP server is bound to ");
        HttpServer httpServer = server;
        Intrinsics.checkNotNullExpressionValue((Object)httpServer, (String)"server");
        logger2.info(stringBuilder.append(httpServer.getAddress()).toString());
        server.createContext("/");
        $this$thisLogger$iv2 = this;
        $i$f$thisLogger2 = false;
        Logger logger3 = Logger.getInstance(TestJetBrainsClientDownloaderConfigurationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"Logger.getInstance(T::class.java)");
        logger3.info("Starting http server at " + server.getAddress());
        this.setClientDownloadLocation(new URI("http:/" + server.getAddress() + '/'));
        this.setVerifySignature(false);
        LifetimeExKt.onTerminationOrNow(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(this, server){
            final /* synthetic */ TestJetBrainsClientDownloaderConfigurationProvider this$0;
            final /* synthetic */ HttpServer $server;

            public final void invoke() {
                this.this$0.setClientDownloadLocation(new URI("INVALID"));
                this.this$0.setVerifySignature(true);
                TestJetBrainsClientDownloaderConfigurationProvider.access$setTarGzServer$p(this.this$0, null);
                this.$server.stop(10);
            }
            {
                this.this$0 = testJetBrainsClientDownloaderConfigurationProvider;
                this.$server = httpServer;
                super(0);
            }
        }));
        server.start();
        this.tarGzServer = server;
        InetSocketAddress inetSocketAddress = server.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"server.address");
        return inetSocketAddress;
    }

    public final void serveFile(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean bl = PathKt.exists((Path)file2);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = PathKt.isFile((Path)file2);
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        HttpServer server = this.tarGzServer;
        bl2 = server != null;
        bl3 = false;
        bl4 = false;
        bl4 = false;
        boolean bl7 = false;
        if (!bl2) {
            boolean bl8 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        server.createContext('/' + PathsKt.getName((Path)file2), new HttpHandler(file2){
            final /* synthetic */ Path $file;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void handle(HttpExchange httpExchange) {
                httpExchange.sendResponseHeaders(200, PathKt.size((Path)this.$file));
                HttpExchange httpExchange2 = httpExchange;
                Intrinsics.checkNotNullExpressionValue((Object)httpExchange2, (String)"httpExchange");
                Closeable closeable = httpExchange2.getResponseBody();
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    OutputStream responseBody = (OutputStream)closeable;
                    boolean bl3 = false;
                    Closeable closeable2 = PathKt.inputStream((Path)this.$file);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStream it = (InputStream)closeable2;
                        boolean bl6 = false;
                        OutputStream outputStream = responseBody;
                        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"responseBody");
                        ByteStreamsKt.copyTo((InputStream)it, (OutputStream)outputStream, (int)0x100000);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.$file = path2;
            }
        });
    }

    public final void startServerAndServeClient(@NotNull Lifetime lifetime, @NotNull Path clientDistribution, @NotNull Path clientJdkBuildTxt) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)clientDistribution, (String)"clientDistribution");
        Intrinsics.checkNotNullParameter((Object)clientJdkBuildTxt, (String)"clientJdkBuildTxt");
        boolean bl = StringsKt.endsWith$default((String)PathsKt.getName((Path)clientJdkBuildTxt), (String)".txt", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Do not mix-up client archive and client jdk build txt arguments";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.mockClientDownloadsServer(lifetime, new InetSocketAddress(Inet4Address.getLoopbackAddress(), 0));
        this.serveFile(clientDistribution);
        this.serveFile(clientJdkBuildTxt);
    }

    public TestJetBrainsClientDownloaderConfigurationProvider() {
        Path path2 = Files.createTempDirectory("", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Files.createTempDirectory(\"\")");
        this.clientCachesDir = path2;
        this.verifySignature = true;
        this.clientLaunched = new Signal();
    }

    public static final /* synthetic */ HttpServer access$getTarGzServer$p(TestJetBrainsClientDownloaderConfigurationProvider $this) {
        return $this.tarGzServer;
    }

    public static final /* synthetic */ void access$setTarGzServer$p(TestJetBrainsClientDownloaderConfigurationProvider $this, HttpServer httpServer) {
        $this.tarGzServer = httpServer;
    }
}

