/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerListConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String ID = "RemoteServers";
    private final RemoteServersManager myServersManager;
    private RemoteServer<?> myLastSelectedServer;
    @NlsSafe
    private final String myInitialSelectedName;
    private final List<ServerType<?>> myDisplayedServerTypes;
    private boolean isTreeInitialized;

    private RemoteServerListConfigurable(@NotNull RemoteServersManager manager2, @NotNull ServerType<?> type, @Nullable @NlsSafe String initialSelectedName) {
        if (manager2 == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(0);
        }
        if (type == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(1);
        }
        this(manager2, Collections.singletonList(type), initialSelectedName);
    }

    protected RemoteServerListConfigurable(@NotNull RemoteServersManager manager2, @NotNull List<ServerType<?>> displayedServerTypes, @Nullable String initialSelectedName) {
        if (manager2 == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(2);
        }
        if (displayedServerTypes == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(3);
        }
        this.myServersManager = manager2;
        this.myDisplayedServerTypes = displayedServerTypes;
        this.myToReInitWholePanel = true;
        this.myInitialSelectedName = initialSelectedName;
    }

    @NotNull
    public JComponent createComponent() {
        if (!this.isTreeInitialized) {
            this.initTree();
            this.isTreeInitialized = true;
        }
        JComponent jComponent = super.createComponent();
        if (jComponent == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @Nullable
    private ServerType<?> getSingleServerType() {
        List<ServerType<?>> serverTypes = this.getDisplayedServerTypes();
        return serverTypes.size() == 1 ? serverTypes.get(0) : null;
    }

    @NotNull
    public List<ServerType<?>> getDisplayedServerTypes() {
        List<Object> list2 = this.myDisplayedServerTypes != null ? this.myDisplayedServerTypes : Collections.emptyList();
        if (list2 == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    protected String getEmptySelectionString() {
        String typeNames = StringUtil.join(this.getDisplayedServerTypes(), ServerType::getPresentableName, (String)", ");
        if (typeNames.length() > 0) {
            return CloudBundle.message((String)"clouds.configure.empty.selection.string", (Object[])new Object[]{typeNames});
        }
        return null;
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type) {
        if (type == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(6);
        }
        return RemoteServerListConfigurable.createConfigurable(type, null);
    }

    public static RemoteServerListConfigurable createConfigurable(@NotNull ServerType<?> type, @Nullable String nameToSelect) {
        if (type == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(7);
        }
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), type, nameToSelect);
    }

    @Nls
    public String getDisplayName() {
        ServerType<?> singleServerType = this.getSingleServerType();
        return singleServerType == null ? CloudBundle.message((String)"configurable.display.name.clouds", (Object[])new Object[0]) : singleServerType.getPresentableName();
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        for (RemoteServer<?> server : this.getServers()) {
            this.addServerNode(server, false);
        }
        super.reset();
        if (this.myInitialSelectedName != null) {
            this.selectNodeInTree(this.myInitialSelectedName);
        }
    }

    @NotNull
    private List<? extends RemoteServer<?>> getServers() {
        List list2 = ContainerUtil.filter((Collection)this.myServersManager.getServers(), s -> this.myDisplayedServerTypes.contains(s.getType()));
        if (list2 == null) {
            RemoteServerListConfigurable.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private MasterDetailsComponent.MyNode addServerNode(RemoteServer<?> server, boolean isNew) {
        MasterDetailsComponent.MyNode node2 = new MasterDetailsComponent.MyNode((NamedConfigurable)new SingleRemoteServerConfigurable(server, this.TREE_UPDATER, isNew));
        this.addNode(node2, this.myRoot);
        return node2;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        return () -> Objects.requireNonNull(SpeedSearchSupply.getSupply((JComponent)this.myTree, (boolean)true)).findAndSelectElement(option2);
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, (Convertor<? super TreePath, String>)((Convertor)treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName()), true);
    }

    protected void processRemovedItems() {
        HashSet<RemoteServer> servers = new HashSet<RemoteServer>();
        for (NamedConfigurable<RemoteServer<?>> configurable2 : this.getConfiguredServers()) {
            servers.add((RemoteServer)configurable2.getEditableObject());
        }
        ArrayList toDelete = new ArrayList();
        for (RemoteServer<?> remoteServer : this.getServers()) {
            if (servers.contains(remoteServer)) continue;
            toDelete.add(remoteServer);
        }
        for (RemoteServer remoteServer : toDelete) {
            this.myServersManager.removeServer(remoteServer);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        HashSet servers = new HashSet(this.getServers());
        for (NamedConfigurable<RemoteServer<?>> configurable2 : this.getConfiguredServers()) {
            RemoteServer server = (RemoteServer)configurable2.getEditableObject();
            server.setName(configurable2.getDisplayName());
            if (servers.contains(server)) continue;
            this.myServersManager.addServer(server);
        }
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        ServerType<?> singleServerType = this.getSingleServerType();
        if (singleServerType == null) {
            actions2.add((AnAction)new AddRemoteServerGroup());
        } else {
            actions2.add((AnAction)new AddRemoteServerAction(singleServerType, IconUtil.getAddIcon()));
        }
        actions2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return actions2;
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    public String getHelpTopic() {
        ServerType<?> singleServerType;
        String result2 = super.getHelpTopic();
        if (result2 == null && (singleServerType = this.getSingleServerType()) != null) {
            result2 = singleServerType.getHelpTopic();
        }
        return result2 != null ? result2 : "reference.settings.clouds";
    }

    public void disposeUIResources() {
        Object selectedObject = this.getSelectedObject();
        this.myLastSelectedServer = selectedObject instanceof RemoteServer ? (RemoteServer)selectedObject : null;
        super.disposeUIResources();
    }

    @Nullable
    public RemoteServer<?> getLastSelectedServer() {
        return this.myLastSelectedServer;
    }

    protected void reInitWholePanelIfNeeded() {
        super.reInitWholePanelIfNeeded();
        if (this.myWholePanel.getBorder() == null) {
            this.myWholePanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        }
    }

    private List<NamedConfigurable<RemoteServer<?>>> getConfiguredServers() {
        ArrayList configurables = new ArrayList();
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2);
            configurables.add(node2.getConfigurable());
        }
        return configurables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayedServerTypes";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedServerTypes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class AddRemoteServerAction
    extends DumbAwareAction {
        private final ServerType<?> myServerType;

        private AddRemoteServerAction(ServerType<?> serverType, Icon icon2) {
            super(serverType.getPresentableName(), null, icon2);
            this.myServerType = serverType;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddRemoteServerAction.$$$reportNull$$$0(0);
            }
            String name2 = UniqueNameGenerator.generateUniqueName((String)this.myServerType.getPresentableName(), s -> {
                for (NamedConfigurable<RemoteServer<?>> configurable2 : RemoteServerListConfigurable.this.getConfiguredServers()) {
                    if (!configurable2.getDisplayName().equals(s)) continue;
                    return false;
                }
                return true;
            });
            MasterDetailsComponent.MyNode node2 = RemoteServerListConfigurable.this.addServerNode(RemoteServerListConfigurable.this.myServersManager.createServer(this.myServerType, name2), true);
            RemoteServerListConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable$AddRemoteServerAction", "actionPerformed"));
        }
    }

    private final class AddRemoteServerGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        private AddRemoteServerGroup() {
            super(CloudBundle.message((String)"group.action.AddRemoteServerGroup.text", (Object[])new Object[0]), "", IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)RemoteServerListConfigurable.this.myTree);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            List<ServerType<?>> serverTypes = RemoteServerListConfigurable.this.getDisplayedServerTypes();
            AnAction[] actions2 = new AnAction[serverTypes.size()];
            for (int i2 = 0; i2 < serverTypes.size(); ++i2) {
                actions2[i2] = new AddRemoteServerAction(serverTypes.get(i2), serverTypes.get(i2).getIcon());
            }
            if (actions2 == null) {
                AddRemoteServerGroup.$$$reportNull$$$0(0);
            }
            return actions2;
        }

        public ActionGroup getActionGroup() {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurable$AddRemoteServerGroup", "getChildren"));
        }
    }
}

