/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reporting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reporting.ReporterKt;
import com.intellij.reporting.StatsSender;
import com.intellij.reporting.StatsServerInfo;
import com.intellij.util.io.HttpRequests;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/reporting/StatsSender;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "infoUrl", "", "executeRequest", "", "info", "Lcom/intellij/reporting/StatsServerInfo;", "text", "compress", "", "requestServerUrl", "send", "intellij.platform.ide.impl"})
public final class StatsSender {
    private static final String infoUrl = "https://www.jetbrains.com/config/features-service-status.json";
    private static final Logger LOG;
    @NotNull
    public static final StatsSender INSTANCE;

    private final StatsServerInfo requestServerUrl() {
        try {
            StatsServerInfo info2 = (StatsServerInfo)ReporterKt.access$getGson$p().fromJson(HttpRequests.request((String)infoUrl).readString(), StatsServerInfo.class);
            if (info2.isServiceAlive()) {
                return info2;
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    public final boolean send(@NotNull String text2, boolean compress) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        StatsServerInfo statsServerInfo = this.requestServerUrl();
        if (statsServerInfo == null) {
            return false;
        }
        StatsServerInfo info2 = statsServerInfo;
        try {
            this.executeRequest(info2, text2, compress);
            return true;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static /* synthetic */ boolean send$default(StatsSender statsSender, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return statsSender.send(string, bl);
    }

    private final void executeRequest(StatsServerInfo info2, String text2, boolean compress) {
        if (compress) {
            byte[] data2 = ReporterKt.access$compressBase64Gzip(text2);
            HttpRequests.post((String)info2.urlForZipBase64Content, null).tuner((HttpRequests.ConnectionTuner)executeRequest.1.INSTANCE).write(data2);
            return;
        }
        HttpRequests.post((String)info2.url, (String)"text/html").write(text2);
    }

    private StatsSender() {
    }

    static {
        StatsSender statsSender;
        INSTANCE = statsSender = new StatsSender();
        Logger logger = Logger.getInstance(StatsSender.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(StatsSender::class.java)");
        LOG = logger;
    }
}

