/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.serviceContainer.ComponentManagerImpl;
import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0000\u001a\"\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007\u00a8\u0006\u0010"}, d2={"checkCanceledIfNotInClassInit", "", "isGettingServiceAllowedDuringPluginUnloading", "", "descriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "isLightService", "serviceClass", "Ljava/lang/Class;", "throwAlreadyDisposedError", "serviceDescription", "", "componentManager", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.serviceContainer"})
@ApiStatus.Internal
public final class ContainerUtilKt {
    public static final void checkCanceledIfNotInClassInit() {
        block4: {
            try {
                ProgressManager.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                boolean bl;
                block3: {
                    StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
                    StackTraceElement[] $this$any$iv = stackTraceElementArray;
                    boolean $i$f$any = false;
                    StackTraceElement[] stackTraceElementArray2 = $this$any$iv;
                    int n = stackTraceElementArray2.length;
                    for (int j = 0; j < n; ++j) {
                        StackTraceElement element$iv;
                        StackTraceElement it = element$iv = stackTraceElementArray2[j];
                        boolean bl2 = false;
                        StackTraceElement stackTraceElement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"it");
                        if (!Intrinsics.areEqual((Object)stackTraceElement.getMethodName(), (Object)"<clinit>")) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) break block4;
                throw (Throwable)e;
            }
        }
    }

    public static final boolean isGettingServiceAllowedDuringPluginUnloading(@NotNull PluginDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return descriptor2.isRequireRestart() || Intrinsics.areEqual((Object)descriptor2.getPluginId(), (Object)PluginManagerCore.CORE_ID) || Intrinsics.areEqual((Object)descriptor2.getPluginId(), (Object)PluginManagerCore.JAVA_PLUGIN_ID);
    }

    @ApiStatus.Internal
    public static final void throwAlreadyDisposedError(@NotNull String serviceDescription, @NotNull ComponentManagerImpl componentManager, @Nullable ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)serviceDescription, (String)"serviceDescription");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        AlreadyDisposedException error = new AlreadyDisposedException("Cannot create " + serviceDescription + " because container is already disposed (container=" + componentManager + ')');
        if (indicator2 == null) {
            throw (Throwable)error;
        }
        throw (Throwable)new ProcessCanceledException((Throwable)error);
    }

    public static final boolean isLightService(@NotNull Class<?> serviceClass) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        return Modifier.isFinal(serviceClass.getModifiers()) && serviceClass.isAnnotationPresent(Service.class);
    }
}

