/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceTreeBuilder;
import com.intellij.usages.UsageViewSettings;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SliceToTextFileExporter
implements ExporterToTextFile {
    private final SliceTreeBuilder myBuilder;
    @NotNull
    private final UsageViewSettings myUsageViewSettings;
    private final String myLineSeparator;

    public SliceToTextFileExporter(@NotNull SliceTreeBuilder builder2, @NotNull UsageViewSettings usageViewSettings) {
        if (builder2 == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(0);
        }
        if (usageViewSettings == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(1);
        }
        this.myLineSeparator = System.lineSeparator();
        this.myBuilder = builder2;
        this.myUsageViewSettings = usageViewSettings;
    }

    @NotNull
    public String getReportText() {
        StringBuilder buffer = new StringBuilder();
        this.appendChildren(buffer, this.myBuilder.getRootSliceNode(), "");
        String string = buffer.toString();
        if (string == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void appendNode(StringBuilder buffer, SliceNode node2, String indent) {
        buffer.append(indent).append(node2.getNodeText()).append(this.myLineSeparator);
        this.appendChildren(buffer, node2, indent + "    ");
    }

    private void appendChildren(StringBuilder buffer, SliceNode node2, String indent) {
        List<SliceNode> cachedChildren = node2.getCachedChildren();
        if (cachedChildren != null) {
            for (SliceNode child2 : cachedChildren) {
                this.appendNode(buffer, child2, indent);
            }
        } else {
            buffer.append(indent).append("...").append(this.myLineSeparator);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        String string = this.myUsageViewSettings.getExportFileName();
        if (string == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void exportedTo(@NotNull String filePath) {
        if (filePath == null) {
            SliceToTextFileExporter.$$$reportNull$$$0(4);
        }
        this.myUsageViewSettings.setExportFileName(filePath);
    }

    public boolean canExport() {
        return !this.myBuilder.analysisInProgress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceToTextFileExporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceToTextFileExporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exportedTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

