/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserDictionary
implements EditableDictionary {
    private final String name;
    @NotNull
    private final Set<String> words;

    public UserDictionary(@NotNull String name2) {
        if (name2 == null) {
            UserDictionary.$$$reportNull$$$0(0);
        }
        this.words = CollectionFactory.createSmallMemoryFootprintSet();
        this.name = name2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            UserDictionary.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        boolean contains2;
        if (word == null) {
            UserDictionary.$$$reportNull$$$0(2);
        }
        if (contains2 = this.words.contains(word)) {
            return true;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        Set<String> set2 = this.words;
        if (set2 == null) {
            UserDictionary.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @Override
    @NotNull
    public Set<String> getEditableWords() {
        Set<String> set2 = this.words;
        if (set2 == null) {
            UserDictionary.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @Override
    public void clear() {
        this.words.clear();
    }

    @Override
    public void addToDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.add(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        if (word == null) {
            return;
        }
        this.words.remove(word);
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.clear();
        this.addToDictionary(words);
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        if (words == null || words.isEmpty()) {
            return;
        }
        for (String word : words) {
            this.addToDictionary(word);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDictionary that = (UserDictionary)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @NonNls
    public String toString() {
        return "UserDictionary{name='" + this.name + "', words.count=" + this.words.size() + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/dictionary/UserDictionary";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/dictionary/UserDictionary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

