/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.async;

import ai.grazie.spell.lists.WordList;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.spellchecker.grazie.async.AsyncUtils;
import com.intellij.spellchecker.grazie.async.WordListLoader;
import com.intellij.spellchecker.grazie.dictionary.SimpleWordList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J(\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bJ*\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J*\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/spellchecker/grazie/async/WordListLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myIsLoadingList", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myListsToLoad", "", "Lkotlin/Pair;", "Lcom/intellij/spellchecker/dictionary/Loader;", "Lkotlin/Function2;", "", "Lai/grazie/spell/lists/WordList;", "", "doLoadWordListAsync", "loader", "consumer", "loadWordList", "loadWordListAsync", "queueWordListLoad", "readAll", "", "Companion", "intellij.spellchecker"})
public final class WordListLoader {
    private final AtomicBoolean myIsLoadingList;
    private final List<Pair<Loader, Function2<String, WordList, Unit>>> myListsToLoad;
    private final Project project;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final void loadWordList(@NotNull Loader loader, @NotNull Function2<? super String, ? super WordList, Unit> consumer2) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        if (AsyncUtils.INSTANCE.isNonAsyncMode()) {
            String string = loader.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loader.name");
            consumer2.invoke((Object)string, (Object)new SimpleWordList(this.readAll(loader)));
        } else {
            this.loadWordListAsync(loader, consumer2);
        }
    }

    private final void loadWordListAsync(Loader loader, Function2<? super String, ? super WordList, Unit> consumer2) {
        if (this.myIsLoadingList.compareAndSet(false, true)) {
            logger.debug("Loading " + loader.getName());
            this.doLoadWordListAsync(loader, consumer2);
        } else {
            this.queueWordListLoad(loader, consumer2);
        }
    }

    private final void doLoadWordListAsync(Loader loader, Function2<? super String, ? super WordList, Unit> consumer2) {
        if (this.project.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)this.project).runWhenProjectIsInitialized(new Runnable(this, loader, consumer2){
            final /* synthetic */ WordListLoader this$0;
            final /* synthetic */ Loader $loader;
            final /* synthetic */ Function2 $consumer;

            public final void run() {
                WordListLoader.access$getLogger$cp().debug("Loading " + this.$loader.getName());
                Application app2 = ApplicationManager.getApplication();
                app2.executeOnPooledThread(new Runnable(this, app2){
                    final /* synthetic */ doLoadWordListAsync.1 this$0;
                    final /* synthetic */ Application $app;

                    /*
                     * WARNING - void declaration
                     */
                    public final void run() {
                        Application application = this.$app;
                        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                        if (application.isDisposed()) {
                            return;
                        }
                        WordListLoader.access$getLogger$cp().debug(this.this$0.$loader.getName() + " loaded!");
                        Function2 function2 = this.this$0.$consumer;
                        String string = this.this$0.$loader.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loader.name");
                        function2.invoke((Object)string, (Object)new SimpleWordList(WordListLoader.access$readAll(this.this$0.this$0, this.this$0.$loader)));
                        while (true) {
                            void curLoader;
                            Object object = WordListLoader.access$getMyListsToLoad$p(this.this$0.this$0);
                            boolean bl = false;
                            if (!(!object.isEmpty())) break;
                            Application application2 = this.$app;
                            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"app");
                            if (application2.isDisposed()) {
                                return;
                            }
                            Pair pair = (Pair)WordListLoader.access$getMyListsToLoad$p(this.this$0.this$0).remove(0);
                            object = (Loader)pair.component1();
                            Function2 curConsumer = (Function2)pair.component2();
                            WordListLoader.access$getLogger$cp().debug(curLoader.getName() + " loaded!");
                            String string2 = curLoader.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"curLoader.name");
                            curConsumer.invoke((Object)string2, (Object)new SimpleWordList(WordListLoader.access$readAll(this.this$0.this$0, (Loader)curLoader)));
                        }
                        WordListLoader.access$getLogger$cp().debug("Loading finished, restarting daemon...");
                        WordListLoader.access$getMyIsLoadingList$p(this.this$0.this$0).set(false);
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                            final /* synthetic */ doLoadWordListAsync.1 this$0;

                            public final void run() {
                                Application application = this.this$0.$app;
                                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                                AsyncUtils.INSTANCE.restartInspection(application);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$app = application;
                    }
                });
            }
            {
                this.this$0 = wordListLoader;
                this.$loader = loader;
                this.$consumer = function2;
            }
        });
    }

    private final Set<String> readAll(Loader loader) {
        Set set2 = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"CollectionFactory.create\u2026oryFootprintSet<String>()");
        Set set3 = set2;
        loader.load(new Consumer(set3){
            final /* synthetic */ Set $set;

            public final void accept(String it) {
                this.$set.add(it);
            }
            {
                this.$set = set2;
            }
        });
        return set3;
    }

    private final void queueWordListLoad(Loader loader, Function2<? super String, ? super WordList, Unit> consumer2) {
        logger.debug("Queuing load for: " + loader.getName());
        this.myListsToLoad.add((Pair<Loader, Function2<String, WordList, Unit>>)TuplesKt.to((Object)loader, consumer2));
    }

    public WordListLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myIsLoadingList = new AtomicBoolean(false);
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ContainerUtil.createLockFreeCopyOnWriteList()");
        this.myListsToLoad = list2;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(WordListLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(WordListLoader::class.java)");
        WordListLoader.logger = logger;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Set access$readAll(WordListLoader $this, Loader loader) {
        return $this.readAll(loader);
    }

    public static final /* synthetic */ List access$getMyListsToLoad$p(WordListLoader $this) {
        return $this.myListsToLoad;
    }

    public static final /* synthetic */ AtomicBoolean access$getMyIsLoadingList$p(WordListLoader $this) {
        return $this.myIsLoadingList;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/spellchecker/grazie/async/WordListLoader$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

