/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.hunspell;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.hunspell.HunspellDictionary;
import com.intellij.spellchecker.ui.SpellCheckingNotifier;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u0012\u0010\u0007\u001a\f0\u0006\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionaryProvider;", "Lcom/intellij/spellchecker/dictionary/CustomDictionaryProvider;", "()V", "get", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "path", "", "getDictionaryType", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isApplicable", "", "Companion", "intellij.spellchecker"})
public final class HunspellDictionaryProvider
implements CustomDictionaryProvider {
    private static final Set<String> UNSUPPORTED_LANGUAGES;
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public Dictionary get(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            HunspellDictionary dict = new HunspellDictionary(path2, null, 2, null);
            if (CollectionsKt.contains((Iterable)UNSUPPORTED_LANGUAGES, (Object)dict.language())) {
                if (!HunspellDictionaryProvider.Companion.isHunspellPluginInstalled()) {
                    String string = SpellCheckerBundle.message("dictionary.unsupported.language.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpellCheckerBundle.messa\u2026upported.language.title\")");
                    String string2 = SpellCheckerBundle.message("dictionary.unsupported.language", path2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpellCheckerBundle.messa\u2026upported.language\", path)");
                    SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(string, string2);
                }
                return null;
            }
            return dict;
        }
        catch (FileNotFoundException e) {
            String string = SpellCheckerBundle.message("dictionary.not.found.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpellCheckerBundle.messa\u2026tionary.not.found.title\")");
            String string3 = SpellCheckerBundle.message("dictionary.not.found", path2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SpellCheckerBundle.messa\u2026tionary.not.found\", path)");
            SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(string, string3);
        }
        catch (ParseException e) {
            String string = SpellCheckerBundle.message("dictionary.unsupported.format.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpellCheckerBundle.messa\u2026nsupported.format.title\")");
            String string4 = SpellCheckerBundle.message("dictionary.unsupported.format", path2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"SpellCheckerBundle.messa\u2026nsupported.format\", path)");
            SpellCheckingNotifier.INSTANCE.showWarningNotificationBalloon(string, string4);
        }
        return null;
    }

    @Override
    public boolean isApplicable(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return !HunspellDictionaryProvider.Companion.isHunspellPluginInstalled() && HunspellDictionary.Companion.isHunspell(path2);
    }

    @Override
    @NotNull
    public String getDictionaryType() {
        String string = SpellCheckerBundle.message("hunspell.dictionary", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpellCheckerBundle.message(\"hunspell.dictionary\")");
        return string;
    }

    static {
        Companion = new Companion(null);
        UNSUPPORTED_LANGUAGES = SetsKt.setOf((Object)"hu_HU");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionaryProvider$Companion;", "", "()V", "UNSUPPORTED_LANGUAGES", "", "", "isHunspellPluginInstalled", "", "intellij.spellchecker"})
    public static final class Companion {
        private final boolean isHunspellPluginInstalled() {
            PluginId pluginId = PluginId.getId((String)"hunspell");
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginId.getId(\"hunspell\")");
            PluginId hunspellId = pluginId;
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin(hunspellId);
            return PluginManagerCore.isPluginInstalled(hunspellId) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

