/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.choice.ChoiceTitleIntentionAction;
import com.intellij.codeInsight.intention.choice.ChoiceVariantIntentionAction;
import com.intellij.codeInsight.intention.choice.DefaultIntentionActionWithChoice;
import com.intellij.codeInsight.intention.impl.config.LazyEditor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.spellchecker.quickfixes.ChangeTo;
import com.intellij.spellchecker.quickfixes.LazySuggestions;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0003\u0013\u0014\u0015B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R!\u0010\n\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00060\u00060\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo;", "Lcom/intellij/codeInsight/intention/choice/DefaultIntentionActionWithChoice;", "Lcom/intellij/spellchecker/quickfixes/LazySuggestions;", "typo", "", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTitle", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "getVariants", "", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "ChangeToTitleAction", "ChangeToVariantAction", "Companion", "intellij.spellchecker"})
public final class ChangeTo
extends LazySuggestions
implements DefaultIntentionActionWithChoice {
    private final SmartPsiElementPointer<PsiElement> pointer;
    private final TextRange range;
    @NotNull
    private static final Lazy fixName$delegate;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public ChoiceTitleIntentionAction getTitle() {
        return ChangeToTitleAction.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChoiceVariantIntentionAction> getVariants() {
        void $this$mapTo$iv$iv;
        int limit = Registry.intValue((String)"spellchecker.corrections.limit");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)limit);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ChangeToVariantAction changeToVariantAction = new ChangeToVariantAction((int)it);
            collection.add(changeToVariantAction);
        }
        return (List)destination$iv$iv;
    }

    public ChangeTo(@NotNull String typo, @NotNull PsiElement element2, @NotNull TextRange range2) {
        Intrinsics.checkNotNullParameter((Object)typo, (String)"typo");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        super(typo);
        this.range = range2;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)element2.getProject()).createSmartPsiElementPointer(element2, element2.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"SmartPointerManager.getI\u2026, element.containingFile)");
        this.pointer = smartPsiElementPointer;
    }

    static {
        Companion = new Companion(null);
        fixName$delegate = LazyKt.lazy((Function0)Companion.fixName.2.INSTANCE);
    }

    @NotNull
    public static final String getFixName() {
        return Companion.getFixName();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToTitleAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "intellij.spellchecker"})
    private static final class ChangeToTitleAction
    extends ChoiceTitleIntentionAction
    implements HighPriorityAction {
        @NotNull
        public static final ChangeToTitleAction INSTANCE;

        private ChangeToTitleAction() {
            super(Companion.getFixName(), Companion.getFixName());
        }

        static {
            ChangeToTitleAction changeToTitleAction;
            INSTANCE = changeToTitleAction = new ChangeToTitleAction();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$ChangeToVariantAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "index", "", "(Lcom/intellij/spellchecker/quickfixes/ChangeTo;I)V", "getIndex", "()I", "suggestion", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "getName", "getTooltipText", "isAvailable", "", "startInWriteAction", "intellij.spellchecker"})
    private final class ChangeToVariantAction
    extends ChoiceVariantIntentionAction
    implements HighPriorityAction {
        @NlsSafe
        private String suggestion;
        private final int index;

        @NotNull
        public String getName() {
            String string = this.suggestion;
            if (string == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public String getTooltipText() {
            String string = SpellCheckerBundle.message("change.to.tooltip", this.suggestion);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpellCheckerBundle.messa\u2026.to.tooltip\", suggestion)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return Companion.getFixName();
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            List<String> list2 = ChangeTo.this.getSuggestions(project);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSuggestions(project)");
            List<String> suggestions = list2;
            if (suggestions.size() <= this.getIndex()) {
                return false;
            }
            this.suggestion = suggestions.get(this.getIndex());
            return true;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            String string = this.suggestion;
            if (string == null) {
                return;
            }
            String suggestion = string;
            Editor editor3 = editor2;
            if (editor3 == null) {
                editor3 = new LazyEditor(file2);
            }
            Editor myEditor = editor3;
            PsiElement psiElement = ChangeTo.this.pointer.getElement();
            if (psiElement == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"pointer.element ?: return");
            PsiElement myElement = psiElement;
            TextRange textRange = ChangeTo.this.range.shiftRight(UtilsKt.getStartOffset((PsiElement)myElement));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range.shiftRight(myElement.startOffset)");
            TextRange myRange = textRange;
            String string2 = myEditor.getDocument().getText(myRange);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myEditor.document.getText(myRange)");
            String myText = string2;
            if (Intrinsics.areEqual((Object)myText, (Object)ChangeTo.this.typo) ^ true) {
                return;
            }
            UpdateHighlightersUtil.removeHighlightersWithExactRange(myEditor.getDocument(), project, (Segment)myRange);
            myEditor.getDocument().replaceString(myRange.getStartOffset(), myRange.getEndOffset(), (CharSequence)suggestion);
        }

        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            return (FileModifier)this;
        }

        public boolean startInWriteAction() {
            return true;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public ChangeToVariantAction(int index2) {
            this.index = index2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/spellchecker/quickfixes/ChangeTo$Companion;", "", "()V", "fixName", "", "getFixName$annotations", "getFixName", "()Ljava/lang/String;", "fixName$delegate", "Lkotlin/Lazy;", "intellij.spellchecker"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getFixName$annotations() {
        }

        @NotNull
        public final String getFixName() {
            Lazy lazy = fixName$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

