/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public abstract class EscapeSequenceTokenizer<T extends PsiElement>
extends Tokenizer<T> {
    private static final Key<int[]> ESCAPE_OFFSETS = Key.create((String)"escape.tokenizer.offsets");

    public static void processTextWithOffsets(PsiElement element2, TokenConsumer consumer2, StringBuilder unescapedText, int[] offsets2, int startOffset) {
        if (element2 != null) {
            element2.putUserData(ESCAPE_OFFSETS, (Object)offsets2);
        }
        String text2 = unescapedText.toString();
        consumer2.consumeToken(element2, text2, false, startOffset, TextRange.allOf((String)text2), PlainTextSplitter.getInstance());
        if (element2 != null) {
            element2.putUserData(ESCAPE_OFFSETS, null);
        }
    }

    @Override
    @NotNull
    public TextRange getHighlightingRange(PsiElement element2, int offset, TextRange range2) {
        int[] offsets2 = (int[])element2.getUserData(ESCAPE_OFFSETS);
        if (offsets2 != null) {
            int start2 = offsets2[range2.getStartOffset()];
            int end = offsets2[range2.getEndOffset()];
            return new TextRange(offset + start2, offset + end);
        }
        TextRange textRange = super.getHighlightingRange(element2, offset, range2);
        if (textRange == null) {
            EscapeSequenceTokenizer.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/EscapeSequenceTokenizer", "getHighlightingRange"));
    }
}

