/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolAction
extends AnAction
implements DumbAware {
    private final String myActionId;

    public ToolAction(@NotNull Tool tool) {
        if (tool == null) {
            ToolAction.$$$reportNull$$$0(0);
        }
        this.myActionId = tool.getActionId();
        this.getTemplatePresentation().setText(tool.getName(), false);
        this.getTemplatePresentation().setDescription(tool.getDescription());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ToolAction.$$$reportNull$$$0(1);
        }
        ToolAction.runTool(this.myActionId, e.getDataContext(), e, 0L, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Tool tool;
        if (e == null) {
            ToolAction.$$$reportNull$$$0(2);
        }
        if ((tool = ToolAction.findTool(this.myActionId)) != null) {
            e.getPresentation().setText(ToolRunProfile.expandMacrosInName(tool, e.getDataContext()), false);
        }
    }

    @Nullable
    private static Tool findTool(@NotNull String actionId) {
        if (actionId == null) {
            ToolAction.$$$reportNull$$$0(3);
        }
        for (Tool tool : ToolsProvider.getAllTools()) {
            if (!actionId.equals(tool.getActionId())) continue;
            return tool;
        }
        return null;
    }

    static void runTool(@NotNull String actionId, @NotNull DataContext context2) {
        if (actionId == null) {
            ToolAction.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            ToolAction.$$$reportNull$$$0(5);
        }
        ToolAction.runTool(actionId, context2, null, 0L, null);
    }

    /*
     * WARNING - void declaration
     */
    static void runTool(@NotNull String actionId, @NotNull DataContext context2, @Nullable AnActionEvent e, long executionId, @Nullable ProcessListener processListener2) {
        void processListener3;
        if (actionId == null) {
            ToolAction.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            ToolAction.$$$reportNull$$$0(7);
        }
        MacroManager.getInstance().cacheMacrosPreview(context2);
        Tool tool = ToolAction.findTool(actionId);
        if (tool != null) {
            tool.execute(e, ToolAction.getToolDataContext(context2), executionId, (ProcessListener)processListener3);
        } else {
            Tool.notifyCouldNotStart((ProcessListener)processListener3);
        }
    }

    @Nullable
    public String getTemplateText() {
        return ToolsBundle.message("action.text.external.tool", new Object[0]);
    }

    @NotNull
    public static DataContext getToolDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ToolAction.$$$reportNull$$$0(8);
        }
        if (dataContext instanceof SimpleDataContext) {
            DataContext dataContext2 = dataContext;
            if (dataContext2 == null) {
                ToolAction.$$$reportNull$$$0(9);
            }
            return dataContext2;
        }
        SimpleDataContext.Builder builder2 = SimpleDataContext.builder().addAll(dataContext, CommonDataKeys.PROJECT, PlatformCoreDataKeys.PROJECT_FILE_DIRECTORY, CommonDataKeys.EDITOR, CommonDataKeys.VIRTUAL_FILE, PlatformCoreDataKeys.MODULE, CommonDataKeys.PSI_FILE);
        VirtualFile virtualFile2 = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile2 == null) {
            Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            FileEditor editor2 = project == null ? null : FileEditorManager.getInstance((Project)project).getSelectedEditor();
            VirtualFile editorFile = editor2 == null ? null : editor2.getFile();
            builder2.add(CommonDataKeys.VIRTUAL_FILE, editorFile);
        }
        DataContext dataContext3 = builder2.build();
        if (dataContext3 == null) {
            ToolAction.$$$reportNull$$$0(10);
        }
        return dataContext3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ToolAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ToolAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTool";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getToolDataContext";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

