/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.NotificationBalloonRoundShadowBorderProvider;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J,\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0014J\u001c\u0010\u0015\u001a\u00060\nR\u00020\u00002\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u00000\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u001c\u001a\b\u0018\u00010\nR\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\tH\u0014J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0014J&\u0010&\u001a\u00020\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0014R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ui/ActionCenterBalloonLayout;", "Lcom/intellij/ui/BalloonLayoutImpl;", "parent", "Ljavax/swing/JRootPane;", "insets", "Ljava/awt/Insets;", "(Ljavax/swing/JRootPane;Ljava/awt/Insets;)V", "myCollapsedData", "Ljava/util/HashMap;", "Lcom/intellij/openapi/ui/popup/Balloon;", "Lcom/intellij/ui/ActionCenterBalloonLayout$CollapseInfo;", "add", "", "newBalloon", "layoutData", "", "addNewBalloon", "balloon", "callback", "Lkotlin/Function0;", "calculateSize", "createCollapsedData", "newLayoutData", "Lcom/intellij/ui/BalloonLayoutData;", "dispose", "doCollapse", "getCollapsedDataForExistBalloon", "Lcom/intellij/openapi/util/Pair;", "getCollapsedDataForNewBalloon", "getSize", "Ljava/awt/Dimension;", "preMerge", "Lcom/intellij/ui/BalloonLayoutData$MergeInfo;", "notification", "Lcom/intellij/notification/Notification;", "remove", "hide", "", "setBounds", "balloons", "", "startX", "", "startY", "CollapseInfo", "intellij.platform.ide.impl"})
public final class ActionCenterBalloonLayout
extends BalloonLayoutImpl {
    private final HashMap<Balloon, CollapseInfo> myCollapsedData;

    @Override
    public void dispose() {
        super.dispose();
        this.myCollapsedData.clear();
    }

    @Override
    public void add(@NotNull Balloon newBalloon, @Nullable Object layoutData) {
        Intrinsics.checkNotNullParameter((Object)newBalloon, (String)"newBalloon");
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (layoutData instanceof BalloonLayoutData) {
            if (((BalloonLayoutData)layoutData).collapseType == null) {
                throw (Throwable)new NullPointerException();
            }
            int size = this.myBalloons.size();
            for (Balloon balloon2 : this.myBalloons) {
                if (this.myLayoutData.get(balloon2) != null) continue;
                --size;
                break;
            }
            if (size < 3) {
                ActionCenterBalloonLayout.addNewBalloon$default(this, newBalloon, layoutData, null, 4, null);
            } else {
                this.doCollapse(newBalloon, (BalloonLayoutData)layoutData);
            }
        } else {
            for (Balloon balloon3 : this.myBalloons) {
                if (this.myLayoutData.get(balloon3) != null) continue;
                this.remove(balloon3);
                break;
            }
            ActionCenterBalloonLayout.addNewBalloon$default(this, newBalloon, null, null, 4, null);
        }
    }

    private final void addNewBalloon(Balloon balloon2, Object layoutData, Function0<Unit> callback2) {
        this.myBalloons.add(balloon2);
        if (layoutData instanceof BalloonLayoutData) {
            ((BalloonLayoutData)layoutData).closeAll = this.myCloseAll;
            ((BalloonLayoutData)layoutData).doLayout = this.myLayoutRunnable;
            Map map2 = this.myLayoutData;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"myLayoutData");
            map2.put(balloon2, layoutData);
        }
        Disposer.register((Disposable)((Disposable)balloon2), (Disposable)new Disposable(this, balloon2){
            final /* synthetic */ ActionCenterBalloonLayout this$0;
            final /* synthetic */ Balloon $balloon;

            public final void dispose() {
                this.this$0.remove(this.$balloon, false);
                this.this$0.queueRelayout();
            }
            {
                this.this$0 = actionCenterBalloonLayout;
                this.$balloon = balloon2;
            }
        });
        this.calculateSize();
        this.relayout();
        if (!balloon2.isDisposed()) {
            balloon2.show(this.myLayeredPane);
        }
        Function0<Unit> function0 = callback2;
        if (function0 != null) {
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
        this.fireRelayout();
    }

    static /* synthetic */ void addNewBalloon$default(ActionCenterBalloonLayout actionCenterBalloonLayout, Balloon balloon2, Object object, Function0 function0, int n, Object object2) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        actionCenterBalloonLayout.addNewBalloon(balloon2, object, (Function0<Unit>)function0);
    }

    private final void doCollapse(Balloon newBalloon, BalloonLayoutData newLayoutData) {
        CollapseInfo collapsedData = this.getCollapsedDataForNewBalloon(newLayoutData);
        if (collapsedData == null) {
            Pair<Balloon, CollapseInfo> p = this.getCollapsedDataForExistBalloon(newLayoutData);
            this.remove((Balloon)p.first);
            ((CollapseInfo)p.second).addBalloon();
            this.addNewBalloon(newBalloon, newLayoutData, (Function0<Unit>)((Function0)new Function0<Unit>(this, p){
                final /* synthetic */ ActionCenterBalloonLayout this$0;
                final /* synthetic */ Pair $p;

                public final void invoke() {
                    CollapseInfo collapseInfo = (CollapseInfo)this.$p.second;
                    JLayeredPane jLayeredPane = this.this$0.myLayeredPane;
                    Intrinsics.checkNotNullExpressionValue((Object)jLayeredPane, (String)"myLayeredPane");
                    collapseInfo.show(jLayeredPane);
                }
                {
                    this.this$0 = actionCenterBalloonLayout;
                    this.$p = pair;
                    super(0);
                }
            }));
        } else {
            collapsedData.addBalloon();
            newBalloon.hide();
            this.calculateSize();
            this.relayout();
            JLayeredPane jLayeredPane = this.myLayeredPane;
            Intrinsics.checkNotNullExpressionValue((Object)jLayeredPane, (String)"myLayeredPane");
            collapsedData.show(jLayeredPane);
            this.fireRelayout();
        }
    }

    private final CollapseInfo getCollapsedDataForNewBalloon(BalloonLayoutData newLayoutData) {
        for (Balloon balloon2 : this.myBalloons) {
            BalloonLayoutData balloonLayoutData = (BalloonLayoutData)this.myLayoutData.get(balloon2);
            if ((balloonLayoutData != null ? balloonLayoutData.collapseType : null) != newLayoutData.collapseType) continue;
            CollapseInfo collapseInfo = this.myCollapsedData.get(balloon2);
            if (collapseInfo == null) {
                Balloon balloon3 = balloon2;
                Intrinsics.checkNotNullExpressionValue((Object)balloon3, (String)"balloon");
                collapseInfo = this.createCollapsedData(balloon3, newLayoutData);
            }
            return collapseInfo;
        }
        return null;
    }

    private final Pair<Balloon, CollapseInfo> getCollapsedDataForExistBalloon(BalloonLayoutData newLayoutData) {
        List list2 = this.myBalloons;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myBalloons");
        for (Balloon balloon2 : CollectionsKt.reversed((Iterable)list2)) {
            BalloonLayoutData layoutData = (BalloonLayoutData)this.myLayoutData.get(balloon2);
            if (layoutData == null || layoutData.collapseType == newLayoutData.collapseType) continue;
            for (Balloon nextBalloon : this.myBalloons) {
                if (balloon2 == nextBalloon) continue;
                BalloonLayoutData balloonLayoutData = (BalloonLayoutData)this.myLayoutData.get(nextBalloon);
                if (layoutData.collapseType != (balloonLayoutData != null ? balloonLayoutData.collapseType : null)) continue;
                CollapseInfo collapseInfo = this.myCollapsedData.get(nextBalloon);
                if (collapseInfo == null) {
                    Balloon balloon3 = nextBalloon;
                    Intrinsics.checkNotNullExpressionValue((Object)balloon3, (String)"nextBalloon");
                    collapseInfo = this.createCollapsedData(balloon3, layoutData);
                }
                return new Pair((Object)balloon2, (Object)collapseInfo);
            }
        }
        throw (Throwable)new IllegalStateException();
    }

    private final CollapseInfo createCollapsedData(Balloon balloon2, BalloonLayoutData newLayoutData) {
        String string = IdeBundle.message((String)(newLayoutData.collapseType == BalloonLayoutData.Type.Timeline ? "notifications.collapse.balloon.title.timeline" : "notifications.collapse.balloon.title.suggestion"), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(if (ne\u2026alloon.title.suggestion\")");
        String titleEnd = string;
        CollapseInfo newCollapseInfo = new CollapseInfo(titleEnd);
        ((Map)this.myCollapsedData).put(balloon2, newCollapseInfo);
        Disposer.register((Disposable)((Disposable)balloon2), (Disposable)((Disposable)newCollapseInfo.getBalloon()));
        return newCollapseInfo;
    }

    @Override
    protected void remove(@NotNull Balloon balloon2, boolean hide2) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        this.myCollapsedData.remove(balloon2);
        super.remove(balloon2, hide2);
    }

    @Override
    @Nullable
    public BalloonLayoutData.MergeInfo preMerge(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        return null;
    }

    @Override
    protected void calculateSize() {
        super.calculateSize();
        for (Balloon balloon2 : this.myBalloons) {
            CollapseInfo collapseInfo = this.myCollapsedData.get(balloon2);
            if (collapseInfo == null) continue;
            collapseInfo.calculateSize();
        }
    }

    @Override
    @NotNull
    protected Dimension getSize(@NotNull Balloon balloon2) {
        Intrinsics.checkNotNullParameter((Object)balloon2, (String)"balloon");
        Dimension dimension = super.getSize(balloon2);
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getSize(balloon)");
        Dimension size = dimension;
        CollapseInfo info2 = this.myCollapsedData.get(balloon2);
        if (info2 != null) {
            size.height += info2.getHeight();
        }
        return size;
    }

    @Override
    protected void setBounds(@NotNull List<Balloon> balloons, int startX, int startY) {
        Intrinsics.checkNotNullParameter(balloons, (String)"balloons");
        int y = startY;
        for (Balloon balloon2 : balloons) {
            Rectangle bounds2 = new Rectangle(super.getSize(balloon2));
            CollapseInfo info2 = this.myCollapsedData.get(balloon2);
            if (info2 != null) {
                info2.getBalloon().setBounds(new Rectangle(startX - bounds2.width, y - info2.getFullHeight(), bounds2.width, info2.getFullHeight()));
                y -= info2.getHeight();
            }
            bounds2.setLocation(startX - bounds2.width, y -= bounds2.height);
            balloon2.setBounds(bounds2);
        }
    }

    public ActionCenterBalloonLayout(@NotNull JRootPane parent, @NotNull Insets insets) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        super(parent, insets);
        this.myCollapsedData = new HashMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006'"}, d2={"Lcom/intellij/ui/ActionCenterBalloonLayout$CollapseInfo;", "", "titleEnd", "", "(Lcom/intellij/ui/ActionCenterBalloonLayout;Ljava/lang/String;)V", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "getBalloon", "()Lcom/intellij/openapi/ui/popup/Balloon;", "collapsedBalloons", "", "getCollapsedBalloons", "()I", "setCollapsedBalloons", "(I)V", "doShow", "", "getDoShow", "()Z", "setDoShow", "(Z)V", "fullHeight", "getFullHeight", "setFullHeight", "height", "getHeight", "setHeight", "getTitleEnd", "()Ljava/lang/String;", "titleLabel", "Lcom/intellij/ui/components/labels/LinkLabel;", "getTitleLabel", "()Lcom/intellij/ui/components/labels/LinkLabel;", "addBalloon", "", "calculateSize", "show", "pane", "Ljavax/swing/JLayeredPane;", "intellij.platform.ide.impl"})
    private final class CollapseInfo {
        private int collapsedBalloons;
        @NotNull
        private final LinkLabel<Object> titleLabel;
        @NotNull
        private final Balloon balloon;
        private boolean doShow;
        private int height;
        private int fullHeight;
        @NotNull
        private final String titleEnd;

        public final int getCollapsedBalloons() {
            return this.collapsedBalloons;
        }

        public final void setCollapsedBalloons(int n) {
            this.collapsedBalloons = n;
        }

        @NotNull
        public final LinkLabel<Object> getTitleLabel() {
            return this.titleLabel;
        }

        @NotNull
        public final Balloon getBalloon() {
            return this.balloon;
        }

        public final boolean getDoShow() {
            return this.doShow;
        }

        public final void setDoShow(boolean bl) {
            this.doShow = bl;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public final int getFullHeight() {
            return this.fullHeight;
        }

        public final void setFullHeight(int n) {
            this.fullHeight = n;
        }

        public final void addBalloon() {
            int n = this.collapsedBalloons;
            this.collapsedBalloons = n + 1;
            this.titleLabel.setText(IdeBundle.message((String)"notifications.collapse.balloon.title", (Object[])new Object[]{this.collapsedBalloons, this.titleEnd}));
        }

        public final void show(@NotNull JLayeredPane pane2) {
            Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
            if (this.doShow) {
                this.doShow = false;
                this.balloon.show(pane2);
            }
        }

        public final void calculateSize() {
            Balloon balloon2 = this.balloon;
            if (balloon2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.BalloonImpl");
            }
            Insets insets = ((BalloonImpl)balloon2).getShadowBorderInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"(balloon as BalloonImpl).shadowBorderInsets");
            Insets insets2 = insets;
            this.fullHeight = ((BalloonImpl)this.balloon).getPreferredSize().height;
            this.height = this.fullHeight - JBUI.scale((int)7) - insets2.top - insets2.bottom;
        }

        @NotNull
        public final String getTitleEnd() {
            return this.titleEnd;
        }

        public CollapseInfo(String titleEnd) {
            Intrinsics.checkNotNullParameter((Object)titleEnd, (String)"titleEnd");
            this.titleEnd = titleEnd;
            this.doShow = true;
            this.titleLabel = (LinkLabel)new LinkLabel<Object>(){

                protected boolean isInClickableArea(@NotNull Point pt) {
                    Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
                    return true;
                }

                @NotNull
                protected Color getTextColor() {
                    JBColor jBColor = JBColor.namedColor((String)"infoPanelForeground", (Color)((Color)new JBColor(0x808080, 0x8C8C8C)));
                    Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"info\u2026olor(0x808080, 0x8C8C8C))");
                    return (Color)jBColor;
                }
            };
            this.titleLabel.setPaintUnderline(false);
            (this.titleLabel).setFont((Font)JBFont.medium());
            (this.titleLabel).setHorizontalAlignment(0);
            (this.titleLabel).setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)4, (int)0));
            (this.titleLabel).setIcon(null);
            this.titleLabel.setListener(new LinkListener(){

                public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                    block1: {
                        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.getTitleLabel()));
                        if (project == null) break block1;
                        ActionCenterBalloonLayout.this.closeAll();
                        ToolWindow toolWindow2 = ToolWindowManager.Companion.getInstance(project).getToolWindow("Notifications");
                        if (toolWindow2 != null) {
                            toolWindow2.show();
                        }
                    }
                }
            }, null);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(false);
            panel2.add((Component)this.titleLabel);
            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)panel2);
            Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"JBPopupFactory.getInstan\u2026eateBalloonBuilder(panel)");
            BalloonBuilder builder2 = balloonBuilder;
            builder2.setFillColor(NotificationsManagerImpl.FILL_COLOR).setCloseButtonEnabled(true).setShowCallout(false).setShadow(false).setAnimationCycle(0).setHideOnClickOutside(false).setHideOnAction(false).setHideOnKeyOutside(false).setHideOnFrameResize(false).setBorderColor(NotificationsManagerImpl.BORDER_COLOR).setBorderInsets((Insets)JBUI.emptyInsets());
            Balloon balloon2 = builder2.createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon2, (String)"builder.createBalloon()");
            this.balloon = balloon2;
            if (this.balloon instanceof BalloonImpl) {
                this.balloon.setAnimationEnabled(false);
                ((BalloonImpl)this.balloon).setZeroPositionInLayer(false);
                ((BalloonImpl)this.balloon).setShadowBorderProvider(new NotificationBalloonRoundShadowBorderProvider(NotificationsManagerImpl.FILL_COLOR, NotificationsManagerImpl.BORDER_COLOR));
                ((BalloonImpl)this.balloon).setActionProvider(new BalloonImpl.ActionProvider(){

                    @Override
                    @NotNull
                    public List<BalloonImpl.ActionButton> createActions() {
                        List<BalloonImpl.ActionButton> list2 = Collections.emptyList();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"Collections.emptyList()");
                        return list2;
                    }

                    @Override
                    public void layout(@NotNull Rectangle bounds2) {
                        Intrinsics.checkNotNullParameter((Object)bounds2, (String)"bounds");
                    }
                });
            }
        }
    }
}

