/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.DeferredIconRepaintScheduler;
import com.intellij.ui.IconDeferrerImpl;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeferredIconImpl<T>
extends JBScalableIcon
implements DeferredIcon,
RetrievableIcon,
IconWithToolTip,
CopyableIcon {
    private static final Logger LOG = Logger.getInstance(DeferredIconImpl.class);
    private static final int MIN_AUTO_UPDATE_MILLIS = 950;
    private static final DeferredIconRepaintScheduler ourRepaintScheduler = new DeferredIconRepaintScheduler();
    @NotNull
    private final Icon myDelegateIcon;
    @NotNull
    private volatile Icon myScaledDelegateIcon;
    private DeferredIconImpl<T> myScaledIconCache;
    private Function<? super T, ? extends Icon> myEvaluator;
    private volatile boolean myIsScheduled;
    final T myParam;
    private static final Icon EMPTY_ICON = EmptyIcon.create((int)16).withIconPreScaled(false);
    private final boolean myNeedReadAction;
    private boolean myDone;
    private final boolean myAutoUpdatable;
    private long myLastCalcTime;
    private long myLastTimeSpent;
    private static final ExecutorService ourIconCalculatingExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"IconCalculating Pool", (int)1);
    @Nullable
    private final BiConsumer<? super DeferredIcon, ? super Icon> myEvalListener;

    private DeferredIconImpl(@NotNull DeferredIconImpl<T> icon2) {
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(0);
        }
        super(icon2);
        this.myDelegateIcon = icon2.myDelegateIcon;
        this.myScaledDelegateIcon = icon2.myDelegateIcon;
        this.myScaledIconCache = null;
        this.myEvaluator = icon2.myEvaluator;
        this.myIsScheduled = icon2.myIsScheduled;
        this.myParam = icon2.myParam;
        this.myNeedReadAction = icon2.myNeedReadAction;
        this.myDone = icon2.myDone;
        this.myAutoUpdatable = icon2.myAutoUpdatable;
        this.myLastCalcTime = icon2.myLastCalcTime;
        this.myLastTimeSpent = icon2.myLastTimeSpent;
        this.myEvalListener = icon2.myEvalListener;
    }

    DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, boolean autoUpdatable, @NotNull Function<? super T, ? extends Icon> evaluator, @Nullable BiConsumer<? super DeferredIcon, ? super Icon> listener2) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(1);
        }
        this.myParam = param;
        this.myScaledDelegateIcon = this.myDelegateIcon = DeferredIconImpl.nonNull(baseIcon);
        this.myScaledIconCache = null;
        this.myEvaluator = evaluator;
        this.myNeedReadAction = needReadAction;
        this.myEvalListener = listener2;
        this.myAutoUpdatable = autoUpdatable;
        this.checkDelegationDepth();
    }

    public DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, @NotNull com.intellij.util.Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(2);
        }
        this(baseIcon, param, needReadAction, false, t -> (Icon)evaluator.fun(t), null);
    }

    @NotNull
    public DeferredIconImpl<T> copy() {
        return new DeferredIconImpl<T>(this);
    }

    @NotNull
    public DeferredIconImpl<T> scale(float scale) {
        if (this.getScale() == scale) {
            DeferredIconImpl deferredIconImpl = this;
            if (deferredIconImpl == null) {
                DeferredIconImpl.$$$reportNull$$$0(3);
            }
            return deferredIconImpl;
        }
        DeferredIconImpl<T> icon2 = this.myScaledIconCache;
        if (icon2 == null || icon2.getScale() != scale) {
            icon2 = new DeferredIconImpl<T>(this);
            icon2.setScale(ScaleType.OBJ_SCALE.of((double)scale));
            this.myScaledIconCache = icon2;
        }
        icon2.myScaledDelegateIcon = IconUtil.scale(icon2.myDelegateIcon, null, scale);
        DeferredIconImpl<T> deferredIconImpl = icon2;
        if (deferredIconImpl == null) {
            DeferredIconImpl.$$$reportNull$$$0(4);
        }
        return deferredIconImpl;
    }

    @NotNull
    public static <T> DeferredIcon withoutReadAction(Icon baseIcon, T param, @NotNull Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(5);
        }
        return new DeferredIconImpl<T>(baseIcon, param, false, false, evaluator, (BiConsumer<DeferredIcon, Icon>)null);
    }

    @Override
    @NotNull
    public Icon getBaseIcon() {
        Icon icon2 = this.myDelegateIcon;
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(6);
        }
        return icon2;
    }

    private void checkDelegationDepth() {
        int depth;
        DeferredIconImpl each = this;
        for (depth = 0; each.myScaledDelegateIcon instanceof DeferredIconImpl && depth < 50; ++depth) {
            each = (DeferredIconImpl)each.myScaledDelegateIcon;
        }
        if (depth >= 50) {
            LOG.error("Too deep deferred icon nesting");
        }
    }

    @NotNull
    private static Icon nonNull(@Nullable Icon icon2) {
        Icon icon3 = icon2 == null ? EMPTY_ICON : icon2;
        if (icon3 == null) {
            DeferredIconImpl.$$$reportNull$$$0(7);
        }
        return icon3;
    }

    @Override
    public void paintIcon(Component c, @NotNull Graphics g, int x, int y) {
        Icon scaledDelegateIcon;
        if (g == null) {
            DeferredIconImpl.$$$reportNull$$$0(8);
        }
        if (!((scaledDelegateIcon = this.myScaledDelegateIcon) instanceof DeferredIconImpl) || !(((DeferredIconImpl)scaledDelegateIcon).myScaledDelegateIcon instanceof DeferredIconImpl)) {
            scaledDelegateIcon.paintIcon(c, g, x, y);
        }
        if (this.isDone() || this.myIsScheduled || PowerSaveMode.isEnabled()) {
            return;
        }
        this.scheduleEvaluation(c, x, y);
    }

    @VisibleForTesting
    Future<?> scheduleEvaluation(Component c, int x, int y) {
        this.myIsScheduled = true;
        DeferredIconRepaintScheduler.RepaintRequest repaintRequest = ourRepaintScheduler.createRepaintRequest(c, x, y);
        return ourIconCalculatingExecutor.submit(() -> {
            Icon result2;
            int oldWidth = this.myScaledDelegateIcon.getIconWidth();
            Icon[] evaluated = new Icon[1];
            long startTime = System.currentTimeMillis();
            if (this.myNeedReadAction) {
                boolean result3 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    IconDeferrerImpl.evaluateDeferred(() -> {
                        evaluated[0] = this.evaluate();
                    });
                    if (this.myAutoUpdatable) {
                        this.myLastCalcTime = System.currentTimeMillis();
                        this.myLastTimeSpent = this.myLastCalcTime - startTime;
                    }
                });
                if (!result3) {
                    this.myIsScheduled = false;
                    return;
                }
            } else {
                IconDeferrerImpl.evaluateDeferred(() -> {
                    evaluated[0] = this.evaluate();
                });
                if (this.myAutoUpdatable) {
                    this.myLastCalcTime = System.currentTimeMillis();
                    this.myLastTimeSpent = this.myLastCalcTime - startTime;
                }
            }
            this.myScaledDelegateIcon = result2 = evaluated[0];
            this.checkDelegationDepth();
            boolean shouldRevalidate = Registry.is((String)"ide.tree.deferred.icon.invalidates.cache") && this.myScaledDelegateIcon.getIconWidth() != oldWidth;
            ApplicationManager.getApplication().invokeLater(() -> {
                this.setDone(result2);
                if (DeferredIconImpl.equalIcons(result2, this.myDelegateIcon)) {
                    return;
                }
                Component actualTarget = repaintRequest.getActualTarget();
                if (actualTarget == null) {
                    return;
                }
                if (shouldRevalidate && actualTarget instanceof JTree) {
                    TreeUtil.invalidateCacheAndRepaint((TreeUI)((JTree)actualTarget).getUI());
                }
                ourRepaintScheduler.scheduleRepaint(repaintRequest, this.getIconWidth(), this.getIconHeight());
            }, ModalityState.any());
        });
    }

    private void setDone(@NotNull Icon result2) {
        if (result2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(9);
        }
        if (this.myEvalListener != null) {
            this.myEvalListener.accept(this, result2);
        }
        this.myDone = true;
        if (!this.myAutoUpdatable) {
            this.myEvaluator = null;
        }
    }

    @NotNull
    public Icon retrieveIcon() {
        if (this.isDone()) {
            Icon icon2 = this.myScaledDelegateIcon;
            if (icon2 == null) {
                DeferredIconImpl.$$$reportNull$$$0(10);
            }
            return icon2;
        }
        AccessToken ignored = SlowOperations.allowSlowOperations((String)"rendering");
        Icon icon3 = this.evaluate();
        Icon icon4 = icon3;
        if (icon4 == null) {
            DeferredIconImpl.$$$reportNull$$$0(11);
        }
        return icon4;
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    public boolean isNeedReadAction() {
        return this.myNeedReadAction;
    }

    @Override
    @NotNull
    public Icon evaluate() {
        Icon result2;
        try {
            result2 = DeferredIconImpl.nonNull(this.myEvaluator.apply(this.myParam));
        }
        catch (IndexNotReadyException e) {
            result2 = EMPTY_ICON;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.checkDoesntReferenceThis(result2);
        }
        if (this.getScale() != 1.0f && result2 instanceof ScalableIcon) {
            result2 = ((ScalableIcon)result2).scale(this.getScale());
        }
        Icon icon2 = result2;
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(12);
        }
        return icon2;
    }

    private void checkDoesntReferenceThis(Icon icon2) {
        block4: {
            block5: {
                block3: {
                    if (icon2 == this) {
                        throw new IllegalStateException("Loop in icons delegation");
                    }
                    if (!(icon2 instanceof DeferredIconImpl)) break block3;
                    this.checkDoesntReferenceThis(((DeferredIconImpl)icon2).myScaledDelegateIcon);
                    break block4;
                }
                if (!(icon2 instanceof LayeredIcon)) break block5;
                for (Icon layer : ((LayeredIcon)icon2).getAllLayers()) {
                    this.checkDoesntReferenceThis(layer);
                }
                break block4;
            }
            if (!(icon2 instanceof RowIcon)) break block4;
            RowIcon rowIcon = (RowIcon)icon2;
            int count = rowIcon.getIconCount();
            for (int i2 = 0; i2 < count; ++i2) {
                this.checkDoesntReferenceThis(rowIcon.getIcon(i2));
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.myScaledDelegateIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.myScaledDelegateIcon.getIconHeight();
    }

    @Override
    public String getToolTip(boolean composite2) {
        if (this.myScaledDelegateIcon instanceof IconWithToolTip) {
            return ((IconWithToolTip)this.myScaledDelegateIcon).getToolTip(composite2);
        }
        return null;
    }

    public boolean isDone() {
        if (this.myAutoUpdatable && this.myDone && this.myLastCalcTime > 0L && System.currentTimeMillis() - this.myLastCalcTime > Math.max(950L, 10L * this.myLastTimeSpent)) {
            this.myDone = false;
            this.myIsScheduled = false;
        }
        return this.myDone;
    }

    public boolean equals(Object obj2) {
        return obj2 instanceof DeferredIconImpl && DeferredIconImpl.paramsEqual(this, (DeferredIconImpl)obj2);
    }

    public int hashCode() {
        return Objects.hash(this.myParam, this.myScaledDelegateIcon);
    }

    static boolean equalIcons(Icon icon1, Icon icon2) {
        if (icon1 instanceof DeferredIconImpl && icon2 instanceof DeferredIconImpl) {
            return DeferredIconImpl.paramsEqual((DeferredIconImpl)icon1, (DeferredIconImpl)icon2);
        }
        return Objects.equals(icon1, icon2);
    }

    private static boolean paramsEqual(@NotNull DeferredIconImpl<?> icon1, @NotNull DeferredIconImpl<?> icon2) {
        if (icon1 == null) {
            DeferredIconImpl.$$$reportNull$$$0(13);
        }
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(14);
        }
        return Comparing.equal(icon1.myParam, icon2.myParam) && DeferredIconImpl.equalIcons(icon1.myScaledDelegateIcon, icon2.myScaledDelegateIcon);
    }

    public String toString() {
        return "Deferred. Base=" + this.myScaledDelegateIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/DeferredIconImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/DeferredIconImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "nonNull";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withoutReadAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paintIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDone";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "paramsEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

