/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ProjectTopics;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EditorNotificationsImpl
extends EditorNotifications {
    public static final ProjectExtensionPointName<EditorNotifications.Provider<?>> EP_PROJECT = new ProjectExtensionPointName("com.intellij.editorNotificationProvider");
    private static final Key<Boolean> PENDING_UPDATE = Key.create((String)"pending.notification.update");
    @NotNull
    private final MergingUpdateQueue myUpdateMerger;
    @NotNull
    private final Project myProject;

    public EditorNotificationsImpl(@NotNull Project project) {
        if (project == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(0);
        }
        this.myUpdateMerger = new MergingUpdateQueue("EditorNotifications update merger", 100, true, null, (Disposable)project).usePassThroughInUnitTestMode();
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorNotificationsImpl.this.updateNotifications(file2);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                VirtualFile file2 = event.getNewFile();
                FileEditor editor2 = event.getNewEditor();
                if (file2 != null && editor2 != null && Boolean.TRUE.equals(editor2.getUserData(PENDING_UPDATE))) {
                    editor2.putUserData(PENDING_UPDATE, null);
                    EditorNotificationsImpl.this.updateEditor(file2, editor2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void exitDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/EditorNotificationsImpl$3", "rootsChanged"));
            }
        });
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (presentableLibraryName, oldRoots, newRoots, libraryNameForDebug) -> this.updateAllNotifications());
        EP_PROJECT.getPoint((AreaInstance)project).addExtensionPointListener(new ExtensionPointListener<EditorNotifications.Provider<?>>(){

            public void extensionAdded(@NotNull EditorNotifications.Provider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void extensionRemoved(@NotNull EditorNotifications.Provider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(3);
                }
                EditorNotificationsImpl.this.updateNotifications(extension2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, null);
    }

    public void updateNotifications(@NotNull EditorNotifications.Provider<?> provider2) {
        if (provider2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(1);
        }
        for (VirtualFile file2 : FileEditorManager.getInstance((Project)this.myProject).getOpenFilesWithRemotes()) {
            List<FileEditor> editors2 = this.getEditors(file2);
            for (FileEditor editor2 : editors2) {
                this.updateNotification(editor2, provider2, null);
            }
        }
    }

    public void updateNotifications(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(2);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            List editors2 = this.getEditors(file2);
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                editors2 = ContainerUtil.filter(editors2, fileEditor -> {
                    boolean visible = UIUtil.isShowing((Component)fileEditor.getComponent());
                    if (!visible) {
                        fileEditor.putUserData(PENDING_UPDATE, (Object)Boolean.TRUE);
                    }
                    return visible;
                });
            }
            for (FileEditor editor2 : editors2) {
                this.updateEditor(file2, editor2);
            }
        });
    }

    @NotNull
    private List<FileEditor> getEditors(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(3);
        }
        List list2 = ContainerUtil.filter((Object[])FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file2), editor2 -> !(editor2 instanceof TextEditor) || AsyncEditorLoader.isEditorLoaded(((TextEditor)editor2).getEditor()));
        if (list2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private void updateEditor(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(5);
        }
        if (fileEditor == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(6);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        for (EditorNotifications.Provider provider2 : DumbService.getDumbAwareExtensions((Project)this.myProject, EP_PROJECT)) {
            ReadAction.nonBlocking(() -> provider2.collectNotificationData(file2, fileEditor, this.myProject)).expireWith((Disposable)this.myProject).expireWhen(() -> !file2.isValid()).coalesceBy(new Object[]{this, provider2, file2}).finishOnUiThread(ModalityState.any(), supplier2 -> this.updateNotification(fileEditor, provider2, (JComponent)supplier2.get())).submit((Executor)NonUrgentExecutor.getInstance());
        }
    }

    private void updateNotification(@NotNull FileEditor editor2, @NotNull EditorNotifications.Provider<?> provider2, @Nullable JComponent component2) {
        Key key;
        JComponent old;
        if (editor2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(7);
        }
        if (provider2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(8);
        }
        if ((old = (JComponent)editor2.getUserData(key = provider2.getKey())) != null) {
            FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor2, old);
        }
        if (component2 != null) {
            if (component2 instanceof EditorNotificationPanel) {
                ((EditorNotificationPanel)component2).setProviderKey(key);
                ((EditorNotificationPanel)component2).setProject(this.myProject);
            }
            FeatureUsageData data2 = new FeatureUsageData().addData("key", key.toString()).addPluginInfo(PluginInfoDetectorKt.getPluginInfo(provider2.getClass()));
            FUCounterUsageLogger.getInstance().logEvent(this.myProject, "editor.notification.panel", "shown", data2);
            FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor2, component2);
        }
        editor2.putUserData(key, (Object)component2);
    }

    public void logNotificationActionInvocation(@Nullable Key<?> providerKey, @Nullable Class<?> runnableClass) {
        if (providerKey == null || runnableClass == null) {
            return;
        }
        FeatureUsageData data2 = new FeatureUsageData().addData("key", providerKey.toString()).addData("class_name", runnableClass.getName()).addPluginInfo(PluginInfoDetectorKt.getPluginInfo(runnableClass));
        FUCounterUsageLogger.getInstance().logEvent(this.myProject, "editor.notification.panel", "actionInvoked", data2);
    }

    public void updateAllNotifications() {
        if (this.myProject.isDefault()) {
            throw new UnsupportedOperationException("Editor notifications aren't supported for default project");
        }
        final FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        if (fileEditorManager == null) {
            throw new IllegalStateException("No FileEditorManager for " + this.myProject);
        }
        this.myUpdateMerger.queue(new Update("update"){

            public void run() {
                for (VirtualFile file2 : fileEditorManager.getOpenFilesWithRemotes()) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        });
    }

    @TestOnly
    public static void completeAsyncTasks() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorNotificationsImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateNotifications";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefactoringListenerProvider
    implements RefactoringElementListenerProvider {
        @Nullable
        public RefactoringElementListener getListener(final @NotNull PsiElement element2) {
            if (element2 == null) {
                RefactoringListenerProvider.$$$reportNull$$$0(0);
            }
            if (element2 instanceof PsiFile) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        VirtualFile vFile;
                        if (newElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (newElement instanceof PsiFile && (vFile = newElement.getContainingFile().getVirtualFile()) != null) {
                            EditorNotifications.getInstance((Project)element2.getProject()).updateNotifications(vFile);
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (oldQualifiedName == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        this.elementRenamedOrMoved(newElement);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl$RefactoringListenerProvider$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ui/EditorNotificationsImpl$RefactoringListenerProvider", "getListener"));
        }
    }
}

