/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.PluggableLafInfo;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.AbstractDelegatingToRootTraversalPolicy;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.LineSeparator;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTextField
extends NonOpaquePanel
implements EditorTextComponent,
DocumentListener,
DataProvider,
TextAccessor,
FocusListener,
MouseListener {
    public static final Key<Boolean> SUPPLEMENTARY_KEY = Key.create((String)"Supplementary");
    private static final Key<LineSeparator> LINE_SEPARATOR_KEY = Key.create((String)"ETF_LINE_SEPARATOR");
    private static final Key<Boolean> MANAGED_BY_FIELD = Key.create((String)"MANAGED_BY_FIELD");
    private Document myDocument;
    private final Project myProject;
    private FileType myFileType;
    private EditorEx myEditor;
    private Component myNextFocusable;
    private boolean myWholeTextSelected;
    private final List<DocumentListener> myDocumentListeners;
    private final List<FocusListener> myFocusListeners;
    private final List<MouseListener> myMouseListeners;
    private boolean myIsListenerInstalled;
    private boolean myIsViewer;
    private boolean myIsSupplementary;
    private boolean myInheritSwingFont;
    private Color myEnforcedBgColor;
    private boolean myOneLineMode;
    private boolean myShowPlaceholderWhenFocused;
    private boolean myEnsureWillComputePreferredSize;
    private Dimension myPassivePreferredSize;
    @Nls
    private CharSequence myHintText;
    private boolean myIsRendererWithSelection;
    private Color myRendererBg;
    private Color myRendererFg;
    private int myPreferredWidth;
    private int myCaretPosition;
    private final List<EditorSettingsProvider> mySettingsProviders;
    private Disposable myDisposable;
    private Disposable myManualDisposable;
    private boolean myInHierarchy;

    public EditorTextField() {
        this("");
    }

    public EditorTextField(@NotNull String text2) {
        if (text2 == null) {
            EditorTextField.$$$reportNull$$$0(0);
        }
        this(text2, null, (FileType)FileTypes.PLAIN_TEXT);
    }

    public EditorTextField(@NotNull String text2, Project project, FileType fileType) {
        if (text2 == null) {
            EditorTextField.$$$reportNull$$$0(1);
        }
        this(EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)text2)), project, fileType);
        LINE_SEPARATOR_KEY.set((UserDataHolder)this.myDocument, (Object)EditorTextField.detectLineSeparators(this.myDocument, text2));
    }

    public EditorTextField(Document document, Project project, FileType fileType) {
        this(document, project, fileType, false);
    }

    public EditorTextField(Project project, FileType fileType) {
        this((Document)null, project, fileType);
    }

    public EditorTextField(Document document, Project project, FileType fileType, boolean isViewer) {
        this(document, project, fileType, isViewer, true);
    }

    public EditorTextField(Document document, Project project, FileType fileType, boolean isViewer, boolean oneLineMode) {
        this.myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myInheritSwingFont = true;
        this.myPreferredWidth = -1;
        this.myCaretPosition = -1;
        this.mySettingsProviders = new ArrayList<EditorSettingsProvider>();
        this.myOneLineMode = oneLineMode;
        this.myIsViewer = isViewer;
        this.setDocument(document);
        this.myProject = project;
        this.myFileType = fileType;
        this.setLayout(new BorderLayout());
        this.enableEvents(8L);
        this.setFocusable(true);
        super.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorTextField.this.requestFocus();
            }
        });
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new Jdk7DelegatingToRootTraversalPolicy());
        this.setFont(UIManager.getFont("TextField.font"));
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L && e.getChanged().isShowing() && this.myEditor == null) {
                this.initEditor();
            }
        });
    }

    public void setDisposedWith(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            EditorTextField.$$$reportNull$$$0(2);
        }
        assert (this.myManualDisposable == null);
        Disposer.register((Disposable)disposable2, () -> {
            this.myManualDisposable = null;
            this.deInitEditor();
        });
        this.myManualDisposable = disposable2;
    }

    public void setSupplementary(boolean supplementary) {
        this.myIsSupplementary = supplementary;
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.putUserData(SUPPLEMENTARY_KEY, (Object)supplementary);
        }
    }

    public void setFontInheritedFromLAF(boolean b) {
        this.myInheritSwingFont = b;
        this.setDocument(this.myDocument);
    }

    public void setShowPlaceholderWhenFocused(boolean b) {
        this.myShowPlaceholderWhenFocused = b;
        EditorEx editor2 = this.getEditor(false);
        if (editor2 != null) {
            editor2.setShowPlaceholderWhenFocused(this.myShowPlaceholderWhenFocused);
        }
    }

    @Override
    @NotNull
    public String getText() {
        Document document = this.getDocument();
        String text2 = document.getText();
        LineSeparator separator2 = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)document);
        if (separator2 != null) {
            String string = StringUtil.convertLineSeparators((String)text2, (String)separator2.getSeparatorString());
            if (string == null) {
                EditorTextField.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            EditorTextField.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.myEnforcedBgColor = bg;
        EditorEx editor2 = this.getEditor(false);
        if (editor2 != null) {
            editor2.setBackgroundColor(bg);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            EditorTextField.$$$reportNull$$$0(5);
        }
        this.myDocumentListeners.add(listener2);
        this.installDocumentListener();
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            EditorTextField.$$$reportNull$$$0(6);
        }
        this.myDocumentListeners.remove(listener2);
        this.uninstallDocumentListener(false);
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorTextField.$$$reportNull$$$0(7);
        }
        for (DocumentListener documentListener2 : this.myDocumentListeners) {
            documentListener2.beforeDocumentChange(event);
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorTextField.$$$reportNull$$$0(8);
        }
        for (DocumentListener documentListener2 : this.myDocumentListeners) {
            documentListener2.documentChanged(event);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        if (this.myDocument == null) {
            this.myDocument = this.createDocument();
        }
        Document document = this.myDocument;
        if (document == null) {
            EditorTextField.$$$reportNull$$$0(9);
        }
        return document;
    }

    public void setDocument(Document document) {
        if (this.myDocument != null) {
            this.uninstallDocumentListener(true);
        }
        this.myDocument = document;
        this.installDocumentListener();
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            boolean isFocused = this.isFocusOwner();
            EditorEx newEditor = this.createEditor();
            this.releaseEditorNow();
            this.myEditor = newEditor;
            this.add(newEditor.getComponent(), "Center");
            this.validate();
            if (isFocused) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)newEditor.getContentComponent(), true));
            }
        }
    }

    private void installDocumentListener() {
        if (this.myDocument != null && !this.myDocumentListeners.isEmpty() && !this.myIsListenerInstalled) {
            this.myIsListenerInstalled = true;
            this.myDocument.addDocumentListener((DocumentListener)this);
        }
    }

    private void uninstallDocumentListener(boolean force) {
        if (this.myDocument != null && this.myIsListenerInstalled && (force || this.myDocumentListeners.isEmpty())) {
            this.myIsListenerInstalled = false;
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }

    @Override
    public void setText(@Nullable String text2) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            CaretModel caretModel;
            LineSeparator separator2 = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)this.myDocument);
            if (separator2 == null) {
                separator2 = EditorTextField.detectLineSeparators(this.myDocument, text2);
            }
            LINE_SEPARATOR_KEY.set((UserDataHolder)this.myDocument, (Object)separator2);
            this.myDocument.replaceString(0, this.myDocument.getTextLength(), (CharSequence)EditorTextField.normalize(text2, separator2));
            Editor editor2 = this.getEditor();
            if (editor2 != null && (caretModel = editor2.getCaretModel()).getOffset() >= this.myDocument.getTextLength()) {
                caretModel.moveToOffset(this.myDocument.getTextLength());
            }
        }), null, null, UndoConfirmationPolicy.DEFAULT, this.getDocument());
    }

    @NotNull
    private static String normalize(@Nullable String text2, @Nullable LineSeparator separator2) {
        if (text2 == null || separator2 == null) {
            String string = StringUtil.notNullize((String)text2);
            if (string == null) {
                EditorTextField.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = StringUtil.convertLineSeparators((String)text2);
        if (string == null) {
            EditorTextField.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private static LineSeparator detectLineSeparators(@Nullable Document document, @Nullable String text2) {
        boolean doNotNormalizeDetect;
        if (text2 == null) {
            return null;
        }
        boolean bl = doNotNormalizeDetect = document instanceof DocumentImpl && ((DocumentImpl)document).acceptsSlashR();
        if (doNotNormalizeDetect) {
            return null;
        }
        return StringUtil.detectSeparators((CharSequence)text2);
    }

    public void setPlaceholder(@Nls @Nullable CharSequence text2) {
        this.myHintText = text2;
        EditorEx editor2 = this.getEditor(false);
        if (editor2 != null) {
            editor2.setPlaceholder(text2);
        }
    }

    public void selectAll() {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            EditorTextField.doSelectAll(editor2);
        } else {
            this.myWholeTextSelected = true;
        }
    }

    private static void doSelectAll(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(12);
        }
        editor2.getCaretModel().removeSecondaryCarets();
        editor2.getCaretModel().getPrimaryCaret().setSelection(0, editor2.getDocument().getTextLength(), false);
    }

    public void removeSelection() {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.getSelectionModel().removeSelection();
        } else {
            this.myWholeTextSelected = false;
        }
    }

    public void setCaretPosition(int position) {
        Document document = this.getDocument();
        if (position > document.getTextLength() || position < 0) {
            throw new IllegalArgumentException("bad position: " + position);
        }
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.getCaretModel().moveToOffset(position);
        } else {
            this.myCaretPosition = position;
        }
    }

    public CaretModel getCaretModel() {
        EditorEx editor2 = this.getEditor(true);
        return editor2 == null ? null : editor2.getCaretModel();
    }

    public boolean isFocusOwner() {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            return IJSwingUtilities.hasFocus(editor2.getContentComponent());
        }
        return super.isFocusOwner();
    }

    protected void onEditorAdded(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(13);
        }
    }

    private EditorEx initEditor() {
        Disposable uiDisposable = (Disposable)PlatformDataKeys.UI_DISPOSABLE.getData(DataManager.getInstance().getDataContext((Component)((Object)this)));
        if (uiDisposable != null) {
            Disposer.register((Disposable)uiDisposable, this::releaseEditorNow);
        }
        this.myDisposable = Disposer.newDisposable((String)"ETF dispose");
        Disposer.register((Disposable)this.myDisposable, this::releaseEditorLater);
        if (this.myProject != null) {
            this.myProject.getMessageBus().connect(this.myDisposable).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (project == EditorTextField.this.myProject) {
                        EditorTextField.this.releaseEditorNow();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorTextField$2", "projectClosing"));
                }
            });
        }
        Disposer.register((Disposable)this.myDisposable, () -> {
            if (this.myDocument != null) {
                if (this.getProject() != null) {
                    ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).clearDocumentReferences(this.myDocument);
                }
                ((UndoManagerImpl)UndoManager.getGlobalInstance()).clearDocumentReferences(this.myDocument);
            }
        });
        if (this.myEditor != null) {
            this.releaseEditorLater();
        }
        boolean isFocused = this.isFocusOwner();
        EditorEx editor2 = this.initEditorInner();
        this.onEditorAdded(editor2);
        if (this.myNextFocusable != null) {
            editor2.getContentComponent().setNextFocusableComponent(this.myNextFocusable);
            this.myNextFocusable = null;
        }
        this.revalidate();
        if (isFocused) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> this.requestFocus());
        }
        return editor2;
    }

    private EditorEx initEditorInner() {
        String tooltip2;
        EditorEx editor2 = this.createEditor();
        editor2.getContentComponent().setEnabled(this.isEnabled());
        if (this.myCaretPosition >= 0) {
            editor2.getCaretModel().moveToOffset(this.myCaretPosition);
            editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        if (StringUtil.isNotEmpty((String)(tooltip2 = this.getToolTipText()))) {
            editor2.getContentComponent().setToolTipText(tooltip2);
        }
        this.myEditor = editor2;
        this.add(editor2.getComponent(), "Center");
        return editor2;
    }

    public void removeNotify() {
        this.myInHierarchy = false;
        super.removeNotify();
        if (this.myManualDisposable == null) {
            this.deInitEditor();
        }
    }

    private void deInitEditor() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private void releaseEditor(@NotNull Editor editor2) {
        PsiFile psiFile;
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(14);
        }
        if (this.myProject != null && !this.myProject.isDisposed() && this.myIsViewer && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor2.getDocument())) != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).setHighlightingEnabled(psiFile, true);
        }
        this.remove(editor2.getComponent());
        editor2.getContentComponent().removeFocusListener(this);
        editor2.getContentComponent().removeMouseListener(this);
        if (!editor2.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(editor2);
        }
    }

    private void releaseEditorNow() {
        EditorEx editor2 = this.myEditor;
        if (editor2 == null) {
            return;
        }
        this.myEditor = null;
        this.releaseEditor(editor2);
    }

    void releaseEditorLater() {
        EditorEx editor2 = this.myEditor;
        if (editor2 == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> this.releaseEditor(editor2), ModalityState.stateForComponent((Component)((Object)this)));
        this.myEditor = null;
    }

    public void setFont(Font font) {
        super.setFont(font);
        EditorEx editor2 = this.getEditor(false);
        if (editor2 != null) {
            this.setupEditorFont(editor2);
        }
    }

    protected boolean isOneLineMode() {
        return this.myOneLineMode;
    }

    private void initOneLineMode(EditorEx editor2) {
        boolean isOneLineMode = this.isOneLineMode();
        editor2.setOneLineMode(isOneLineMode);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme customGlobalScheme = colorsManager.getSchemeForCurrentUITheme();
        editor2.setColorsScheme(editor2.createBoundColorSchemeDelegate((EditorColorsScheme)(isOneLineMode ? customGlobalScheme : null)));
        EditorColorsScheme colorsScheme = editor2.getColorsScheme();
        editor2.getSettings().setCaretRowShown(false);
        editor2.getSettings().setDndEnabled(false);
        this.setupEditorFont(editor2);
        this.updateBorder(editor2);
        editor2.setBackgroundColor(this.getBackgroundColor(this.isEnabled(), colorsScheme));
    }

    public void setOneLineMode(boolean oneLineMode) {
        this.myOneLineMode = oneLineMode;
    }

    protected Document createDocument() {
        PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)this.myProject);
        long stamp = LocalTimeCounter.currentTime();
        PsiFile psiFile = factory2.createFileFromText("Dummy." + this.myFileType.getDefaultExtension(), this.myFileType, (CharSequence)"", stamp, true, false);
        return PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
    }

    @NotNull
    protected EditorEx createEditor() {
        PsiFile psiFile;
        Document document = this.getDocument();
        EditorFactory factory2 = EditorFactory.getInstance();
        EditorEx editor2 = (EditorEx)(this.myIsViewer ? factory2.createViewer(document, this.myProject) : factory2.createEditor(document, this.myProject));
        editor2.putUserData(MANAGED_BY_FIELD, Boolean.TRUE);
        EditorTextField.setupTextFieldEditor(editor2);
        editor2.setCaretEnabled(!this.myIsViewer);
        if (this.myProject != null && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor2.getDocument())) != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).setHighlightingEnabled(psiFile, !this.myIsViewer);
        }
        if (this.myProject != null) {
            EditorHighlighter highlighter;
            VirtualFile virtualFile2;
            EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
            VirtualFile virtualFile3 = virtualFile2 = this.myDocument == null ? null : FileDocumentManager.getInstance().getFile(this.myDocument);
            EditorHighlighter editorHighlighter = virtualFile2 != null ? highlighterFactory.createEditorHighlighter(this.myProject, virtualFile2) : (highlighter = this.myFileType != null ? highlighterFactory.createEditorHighlighter(this.myProject, this.myFileType) : null);
            if (highlighter != null) {
                editor2.setHighlighter(highlighter);
            }
        }
        editor2.getSettings().setCaretRowShown(false);
        editor2.setOneLineMode(this.myOneLineMode);
        editor2.getCaretModel().moveToOffset(document.getTextLength());
        if (!this.shouldHaveBorder()) {
            editor2.setBorder(null);
        }
        if (this.myIsViewer) {
            editor2.getSelectionModel().removeSelection();
        } else if (this.myWholeTextSelected) {
            EditorTextField.doSelectAll(editor2);
            this.myWholeTextSelected = false;
        }
        editor2.putUserData(SUPPLEMENTARY_KEY, this.myIsSupplementary);
        editor2.getContentComponent().setFocusCycleRoot(false);
        editor2.getContentComponent().addFocusListener(this);
        editor2.getContentComponent().addMouseListener(this);
        editor2.setPlaceholder(this.myHintText);
        editor2.setShowPlaceholderWhenFocused(this.myShowPlaceholderWhenFocused);
        this.initOneLineMode(editor2);
        if (this.myIsRendererWithSelection) {
            ((EditorImpl)editor2).setPaintSelection(true);
            editor2.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, this.myRendererBg);
            editor2.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, this.myRendererFg);
            editor2.getSelectionModel().setSelection(0, document.getTextLength());
            editor2.setBackgroundColor(this.myRendererBg);
        }
        for (EditorSettingsProvider provider2 : this.mySettingsProviders) {
            provider2.customizeSettings(editor2);
        }
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            EditorTextField.$$$reportNull$$$0(15);
        }
        return editorEx;
    }

    public static boolean managesEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(16);
        }
        return editor2.getUserData(MANAGED_BY_FIELD) == Boolean.TRUE;
    }

    public static void setupTextFieldEditor(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(17);
        }
        EditorSettings settings = editor2.getSettings();
        settings.setAdditionalLinesCount(0);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setRightMargin(-1);
        settings.setFoldingOutlineShown(false);
        settings.setLineNumbersShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        settings.setWheelFontChangeEnabled(false);
        settings.setAdditionalPageAtBottom(false);
        editor2.setHorizontalScrollbarVisible(false);
        editor2.setVerticalScrollbarVisible(false);
        settings.setLineCursorWidth(1);
    }

    protected void updateBorder(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(18);
        }
        if (editor2.isOneLineMode() && !Boolean.TRUE.equals(this.getClientProperty("JComboBox.isTableCellEditor")) && (SwingUtilities.getAncestorOfClass(JTable.class, (Component)((Object)this)) == null || Boolean.TRUE.equals(this.getClientProperty("JBListTable.isTableCellEditor")))) {
            Container parent = this.getParent();
            if (parent instanceof JTable || parent instanceof CellRendererPane) {
                return;
            }
            this.setupBorder(editor2);
        }
    }

    protected void setupBorder(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(19);
        }
        if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            LafManager lafManager = LafManager.getInstance();
            UIManager.LookAndFeelInfo lafInfo = lafManager.getCurrentLookAndFeel();
            if (lafInfo instanceof PluggableLafInfo) {
                editor2.setBorder(((PluggableLafInfo)lafInfo).createEditorTextFieldBorder(this, editor2));
            } else {
                editor2.setBorder(new DarculaEditorTextFieldBorder(this, editor2));
            }
        } else {
            editor2.setBorder(BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }
    }

    private void setupEditorFont(EditorEx editor2) {
        if (this.myInheritSwingFont) {
            ((EditorImpl)editor2).setUseEditorAntialiasing(false);
            editor2.getColorsScheme().setEditorFontName(this.getFont().getFontName());
            editor2.getColorsScheme().setEditorFontSize(this.getFont().getSize());
            return;
        }
        UISettings settings = UISettings.getInstance();
        if (settings.getPresentationMode()) {
            editor2.setFontSize(settings.getPresentationModeFontSize());
        }
    }

    protected boolean shouldHaveBorder() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            this.setFocusTraversalPolicyProvider(enabled);
            this.setViewerEnabled(enabled);
            this.resetEditor();
        }
    }

    protected void setViewerEnabled(boolean enabled) {
        this.myIsViewer = !enabled;
    }

    private void resetEditor() {
        EditorEx editor2 = this.myEditor;
        if (editor2 != null) {
            this.releaseEditor(editor2);
            this.initEditorInner();
            this.revalidate();
        }
    }

    public boolean isViewer() {
        return this.myIsViewer;
    }

    public void setViewer(boolean viewer) {
        if (this.myIsViewer != viewer) {
            this.myIsViewer = viewer;
            this.resetEditor();
        }
    }

    public Color getBackground() {
        Color color = this.getBackgroundColor(this.isEnabled(), EditorColorsUtil.getGlobalOrDefaultColorScheme());
        return color != null ? color : super.getBackground();
    }

    private Color getBackgroundColor(boolean enabled, EditorColorsScheme colorsScheme) {
        if (this.myEnforcedBgColor != null) {
            return this.myEnforcedBgColor;
        }
        if (ComponentUtil.getParentOfType(CellRendererPane.class, (Component)((Object)this)) != null && (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
            return this.getParent().getBackground();
        }
        if (StartupUiUtil.isUnderDarcula()) {
            return UIUtil.getTextFieldBackground();
        }
        return enabled ? colorsScheme.getDefaultBackground() : UIUtil.getInactiveTextFieldBackgroundColor();
    }

    protected void addImpl(Component comp, Object constraints2, int index2) {
        if (this.myEditor == null || comp != this.myEditor.getComponent()) assert (false) : "You are not allowed to add anything to EditorTextField";
        super.addImpl(comp, constraints2, index2);
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        EditorEx editor2 = this.getEditor(true);
        boolean toReleaseEditor = false;
        if (editor2 == null && this.myEnsureWillComputePreferredSize) {
            this.myEnsureWillComputePreferredSize = false;
            editor2 = this.initEditorInner();
            toReleaseEditor = true;
        }
        Object size = JBUI.size((int)100, (int)10);
        if (editor2 != null) {
            Dimension preferredSize = editor2.getComponent().getPreferredSize();
            JBInsets.addTo((Dimension)preferredSize, (Insets)this.getInsets());
            size = preferredSize;
        } else if (this.myPassivePreferredSize != null) {
            size = this.myPassivePreferredSize;
        }
        if (toReleaseEditor) {
            this.releaseEditorNow();
            this.myPassivePreferredSize = size;
        }
        if (this.myPreferredWidth != -1) {
            size.width = this.myPreferredWidth;
        }
        return size;
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        JBDimension size = JBUI.size((int)1, (int)10);
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            size.height = editor2.getLineHeight();
            if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
                size.height = Math.max(size.height, JBUIScale.scale((int)16));
            }
            JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
            JBInsets.addTo((Dimension)size, (Insets)editor2.getInsets());
        }
        return size;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.myPreferredWidth = preferredWidth;
    }

    public Component getNextFocusableComponent() {
        Editor editor2 = this.getEditor();
        if (editor2 == null && this.myNextFocusable == null) {
            return super.getNextFocusableComponent();
        }
        if (editor2 == null) {
            return this.myNextFocusable;
        }
        return editor2.getContentComponent().getNextFocusableComponent();
    }

    public void setNextFocusableComponent(Component aComponent) {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.getContentComponent().setNextFocusableComponent(aComponent);
            return;
        }
        this.myNextFocusable = aComponent;
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        EditorEx editor2 = this.getEditor(false);
        if (e.isConsumed() || editor2 != null && !editor2.processKeyTyped(e)) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return true;
    }

    public final void addNotify() {
        this.myInHierarchy = true;
        if (this.myManualDisposable == null && this.myEditor == null && !Registry.is((String)"editor.text.field.init.on.shown")) {
            this.initEditor();
        }
        super.addNotify();
    }

    @Nullable
    public EditorEx getEditor(boolean initializeIfSafe) {
        EditorEx editor2 = this.myEditor;
        if (editor2 == null && initializeIfSafe && (this.myInHierarchy || this.myManualDisposable != null)) {
            return this.initEditor();
        }
        return editor2;
    }

    public void requestFocus() {
        EditorEx editor2 = this.getEditor(true);
        if (editor2 != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                EditorEx e = this.getEditor(true);
                if (e != null) {
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)e.getContentComponent(), true);
                }
            });
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public boolean requestFocusInWindow() {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            boolean b = editor2.getContentComponent().requestFocusInWindow();
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return b;
        }
        return super.requestFocusInWindow();
    }

    @Nullable
    public Editor getEditor() {
        return this.getEditor(false);
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @NotNull
    public JComponent getFocusTarget() {
        Editor editor2 = this.getEditor();
        Object object = editor2 == null ? this : editor2.getContentComponent();
        if (object == null) {
            EditorTextField.$$$reportNull$$$0(20);
        }
        return object;
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.myFocusListeners.add(l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.myFocusListeners.remove(l);
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (FocusListener listener2 : this.myFocusListeners) {
            listener2.focusGained(e);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        for (FocusListener listener2 : this.myFocusListeners) {
            listener2.focusLost(e);
        }
    }

    public void addMouseListener(MouseListener l) {
        this.myMouseListeners.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.myMouseListeners.remove(l);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseReleased(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseExited(e);
        }
    }

    @Override
    public Object getData(@NotNull String dataId) {
        EditorEx editor2;
        if (dataId == null) {
            EditorTextField.$$$reportNull$$$0(21);
        }
        if ((editor2 = this.getEditor(false)) != null && editor2.isRendererMode()) {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return editor2.getCopyProvider();
            }
            return null;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return editor2;
        }
        return null;
    }

    public void setFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            EditorTextField.$$$reportNull$$$0(22);
        }
        this.setNewDocumentAndFileType(fileType, this.getDocument());
    }

    public void setNewDocumentAndFileType(@NotNull FileType fileType, Document document) {
        if (fileType == null) {
            EditorTextField.$$$reportNull$$$0(23);
        }
        this.myFileType = fileType;
        this.setDocument(document);
    }

    public void ensureWillComputePreferredSize() {
        this.myEnsureWillComputePreferredSize = true;
    }

    public void setAsRendererWithSelection(Color backgroundColor, Color foregroundColor) {
        this.myIsRendererWithSelection = true;
        this.myRendererBg = backgroundColor;
        this.myRendererFg = foregroundColor;
    }

    public void addSettingsProvider(@NotNull EditorSettingsProvider provider2) {
        if (provider2 == null) {
            EditorTextField.$$$reportNull$$$0(24);
        }
        this.mySettingsProviders.add(provider2);
    }

    public boolean removeSettingsProvider(@NotNull EditorSettingsProvider provider2) {
        if (provider2 == null) {
            EditorTextField.$$$reportNull$$$0(25);
        }
        return this.mySettingsProviders.remove(provider2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorTextField";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorTextField";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDisposedWith";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doSelectAll";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onEditorAdded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "releaseEditor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "managesEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupTextFieldEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateBorder";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupBorder";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setFileType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setNewDocumentAndFileType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsProvider";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeSettingsProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Jdk7DelegatingToRootTraversalPolicy
    extends AbstractDelegatingToRootTraversalPolicy {
        private boolean invokedFromBeforeOrAfter;

        private Jdk7DelegatingToRootTraversalPolicy() {
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.getDefaultComponent(aContainer);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.getDefaultComponent(aContainer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component after2;
            this.invokedFromBeforeOrAfter = true;
            try {
                after2 = super.getComponentAfter(aContainer, aComponent);
            }
            finally {
                this.invokedFromBeforeOrAfter = false;
            }
            return after2 != aComponent ? after2 : null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component before = super.getComponentBefore(aContainer, aComponent);
            return before != aComponent ? before : null;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            Editor editor2;
            if (this.invokedFromBeforeOrAfter) {
                return null;
            }
            Editor editor3 = editor2 = aContainer instanceof EditorTextField ? ((EditorTextField)((Object)aContainer)).getEditor() : null;
            if (editor2 != null) {
                return editor2.getContentComponent();
            }
            return aContainer;
        }
    }
}

