/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageTextField
extends EditorTextField {
    private final Language myLanguage;
    private final Project myProject;

    public LanguageTextField() {
        this(null, null, "");
    }

    public LanguageTextField(Language language2, @Nullable Project project, @NotNull String value2) {
        if (value2 == null) {
            LanguageTextField.$$$reportNull$$$0(0);
        }
        this(language2, project, value2, true);
    }

    public LanguageTextField(Language language2, @Nullable Project project, @NotNull String value2, boolean oneLineMode) {
        if (value2 == null) {
            LanguageTextField.$$$reportNull$$$0(1);
        }
        this(language2, project, value2, new SimpleDocumentCreator(), oneLineMode);
    }

    public LanguageTextField(@Nullable Language language2, @Nullable Project project, @NotNull String value2, @NotNull DocumentCreator documentCreator) {
        if (value2 == null) {
            LanguageTextField.$$$reportNull$$$0(2);
        }
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(3);
        }
        this(language2, project, value2, documentCreator, true);
    }

    public LanguageTextField(@Nullable Language language2, @Nullable Project project, @NotNull String value2, @NotNull DocumentCreator documentCreator, boolean oneLineMode) {
        if (value2 == null) {
            LanguageTextField.$$$reportNull$$$0(4);
        }
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(5);
        }
        super(documentCreator.createDocument(value2, language2, project), project, (FileType)(language2 != null ? language2.getAssociatedFileType() : StdFileTypes.PLAIN_TEXT), language2 == null, oneLineMode);
        this.myLanguage = language2;
        this.myProject = project;
        this.setEnabled(language2 != null);
    }

    public static Document createDocument(String value2, @Nullable Language language2, @Nullable Project project, @NotNull SimpleDocumentCreator documentCreator) {
        if (documentCreator == null) {
            LanguageTextField.$$$reportNull$$$0(6);
        }
        if (language2 != null) {
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)project);
            LanguageFileType fileType = language2.getAssociatedFileType();
            assert (fileType != null);
            long stamp = LocalTimeCounter.currentTime();
            PsiFile psiFile = factory2.createFileFromText("Dummy." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)value2, stamp, true, false);
            documentCreator.customizePsiFile(psiFile);
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            assert (document != null);
            return document;
        }
        return EditorFactory.getInstance().createDocument((CharSequence)value2);
    }

    @Override
    @NotNull
    protected EditorEx createEditor() {
        EditorEx ex = super.createEditor();
        if (this.myLanguage != null) {
            LanguageFileType fileType = this.myLanguage.getAssociatedFileType();
            ex.setHighlighter(HighlighterFactory.createHighlighter((Project)this.myProject, (FileType)fileType));
        }
        ex.setEmbeddedIntoDialogWrapper(true);
        EditorEx editorEx = ex;
        if (editorEx == null) {
            LanguageTextField.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentCreator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/LanguageTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/LanguageTextField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SimpleDocumentCreator
    implements DocumentCreator {
        @Override
        public Document createDocument(String value2, @Nullable Language language2, Project project) {
            return LanguageTextField.createDocument(value2, language2, project, this);
        }

        public void customizePsiFile(PsiFile file2) {
        }
    }

    public static interface DocumentCreator {
        public Document createDocument(String var1, @Nullable Language var2, Project var3);
    }
}

