/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class RasterizedImageDataLoader
implements ImageDataLoader {
    private final WeakReference<ClassLoader> classLoaderRef;
    private final long cacheKey;
    private final int imageFlags;
    private final String path;

    /*
     * WARNING - void declaration
     */
    RasterizedImageDataLoader(@NotNull String path2, @NotNull ClassLoader classLoader, long cacheKey, int n) {
        void imageFlags;
        if (path2 == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(0);
        }
        if (classLoader == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(1);
        }
        this.path = path2;
        this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        this.cacheKey = cacheKey;
        this.imageFlags = imageFlags;
    }

    @Nullable
    public Image loadImage(@NotNull List<? extends ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
        ClassLoader classLoader;
        if (filters == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(2);
        }
        if (scaleContext == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(3);
        }
        int flags = 1;
        if (isDark) {
            flags |= 4;
        }
        if ((classLoader = (ClassLoader)this.classLoaderRef.get()) == null) {
            return null;
        }
        return RasterizedImageDataLoader.loadRasterized(this.path, filters, classLoader, flags, scaleContext, this.cacheKey == 0L, this.cacheKey, this.imageFlags);
    }

    @Nullable
    public URL getURL() {
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        return classLoader == null ? null : classLoader.getResource(this.path);
    }

    @Nullable
    public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform) {
        if (originalPath == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(4);
        }
        if (transform == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(5);
        }
        ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
        Object pathWithLeadingSlash = originalPath.charAt(0) == '/' ? originalPath : "/" + originalPath;
        return classLoader == null ? null : IconLoader.createNewResolverIfNeeded((ClassLoader)classLoader, (String)pathWithLeadingSlash, (IconTransform)transform);
    }

    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(6);
        }
        return this.classLoaderRef.get() == classLoader;
    }

    public String toString() {
        return "RasterizedImageDataLoader(, classLoader=" + this.classLoaderRef.get() + ", path='" + this.path + "')";
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Image loadRasterized(@NotNull String path2, @NotNull List<? extends ImageFilter> filters, @NotNull ClassLoader classLoader, int flags, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded, long rasterizedCacheKey, int n) {
        float imageScale;
        Object effectivePath;
        void imageFlags;
        if (path2 == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(7);
        }
        if (filters == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(8);
        }
        if (classLoader == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(9);
        }
        if (scaleContext == null) {
            RasterizedImageDataLoader.$$$reportNull$$$0(10);
        }
        long loadingStart = StartUpMeasurer.getCurrentTimeIfEnabled();
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        int dotIndex = path2.lastIndexOf(46);
        String name2 = dotIndex < 0 ? path2 : path2.substring(0, dotIndex);
        float scale = ImageLoader.adjustScaleFactor(((flags & 1) == 1 ? 1 : 0) != 0, (float)pixScale);
        boolean isSvg = rasterizedCacheKey != 0L;
        boolean isDark = (flags & 4) == 4;
        boolean isRetina = JBUIScale.isHiDPI((double)pixScale);
        String ext = isSvg ? "svg" : (dotIndex < 0 || dotIndex == path2.length() - 1 ? "" : path2.substring(dotIndex + 1));
        boolean isEffectiveDark = isDark;
        if (isRetina && isDark && (imageFlags & 4) == 4) {
            effectivePath = name2 + "@2x_dark." + ext;
            imageScale = isSvg ? scale : 2.0f;
        } else if (isDark && (imageFlags & 2) == 2) {
            effectivePath = name2 + "_dark." + ext;
            imageScale = isSvg ? scale : 1.0f;
        } else {
            isEffectiveDark = false;
            if (isRetina && (imageFlags & 1) == 1) {
                effectivePath = name2 + "@2x." + ext;
                imageScale = isSvg ? scale : 2.0f;
            } else {
                effectivePath = path2;
                imageScale = isSvg ? scale : 1.0f;
            }
        }
        ImageLoader.Dimension2DDouble originalUserSize = new ImageLoader.Dimension2DDouble(0.0, 0.0);
        try {
            long start2 = StartUpMeasurer.getCurrentTimeIfEnabled();
            Image image = isSvg ? SVGLoader.loadFromClassResource(null, (ClassLoader)classLoader, (String)effectivePath, (long)rasterizedCacheKey, (float)imageScale, (boolean)isEffectiveDark, (ImageLoader.Dimension2DDouble)originalUserSize) : ImageLoader.loadPngFromClassResource((String)effectivePath, null, (ClassLoader)classLoader, (double)imageScale, (ImageLoader.Dimension2DDouble)originalUserSize);
            if (start2 != -1L) {
                IconLoadMeasurer.loadFromResources.end(start2);
            }
            if (loadingStart != -1L) {
                IconLoadMeasurer.addLoading((boolean)isSvg, (long)loadingStart);
            }
            if (image == null) {
                return null;
            }
            return ImageLoader.convertImage((Image)image, filters, (int)flags, (ScaleContext)scaleContext, (boolean)isUpScaleNeeded, (boolean)StartupUiUtil.isJreHiDPI((ScaleContext)scaleContext), (double)imageScale, (boolean)isSvg, (ImageLoader.Dimension2DDouble)originalUserSize);
        }
        catch (IOException e) {
            Logger.getInstance(ImageLoader.class).debug((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/RasterizedImageDataLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadImage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "patch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isMyClassLoader";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "loadRasterized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

