/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RenderingUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class TableCellState {
    private boolean mySelected;
    private Color myForeground;
    private Color myBackground;
    private Font myFont;
    private Border myCellBorder;

    public void collectState(JTable table, boolean isSelected, boolean hasFocus, int row2, int column2) {
        this.clear();
        this.mySelected = isSelected;
        this.myFont = table.getFont();
        this.myForeground = RenderingUtil.getForeground((JTable)table, (boolean)isSelected);
        this.myBackground = RenderingUtil.getBackground((JTable)table, (boolean)isSelected);
        this.myCellBorder = this.getBorder(isSelected, hasFocus);
    }

    @Nullable
    protected Border getBorder(boolean isSelected, boolean hasFocus) {
        if (hasFocus) {
            Border border;
            if (isSelected && (border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder")) != null) {
                return border;
            }
            return UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        return UIManager.getBorder("Table.cellNoFocusBorder");
    }

    public void updateRenderer(JComponent renderer2) {
        renderer2.setForeground(this.myForeground);
        renderer2.setBackground(this.myBackground);
        renderer2.setFont(this.myFont);
        renderer2.setBorder(this.myCellBorder);
    }

    protected void clear() {
        this.mySelected = false;
        this.myForeground = null;
        this.myBackground = null;
        this.myFont = null;
        this.myCellBorder = null;
    }

    public SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes2) {
        if (!this.mySelected) {
            return attributes2;
        }
        return new SimpleTextAttributes(attributes2.getStyle(), this.myForeground);
    }
}

