/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class TestTextFieldAction
extends DumbAwareAction {
    private JFrame frame;

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            TestTextFieldAction.$$$reportNull$$$0(0);
        }
        if (this.frame != null && this.frame.isVisible()) {
            this.frame.dispose();
            this.frame = null;
        } else {
            if (this.frame == null) {
                this.frame = new JFrame("Test Text Fields");
                this.frame.add(new View());
                this.frame.pack();
                this.frame.setLocationRelativeTo(null);
            }
            this.frame.setVisible(true);
            this.frame.toFront();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/components/TestTextFieldAction", "actionPerformed"));
    }

    private static final class View
    extends JPanel {
        private final JCheckBox columns = new JCheckBox("20 columns");
        private final JCheckBox opaque = new JCheckBox("Opaque");
        private final JCheckBox gradient = new JCheckBox("Gradient");
        private final JComboBox fill = new ComboBox((Object[])Fill.values());
        private final JPanel control = new JPanel((LayoutManager)new HorizontalLayout(5));
        private final JPanel center = new JPanel(new GridBagLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                if (g instanceof Graphics2D && gradient.isSelected()) {
                    Graphics2D g2d = (Graphics2D)g;
                    Rectangle bounds2 = new Rectangle(this.getWidth(), this.getHeight());
                    g2d.setPaint(new LinearGradientPaint(bounds2.x, bounds2.y, bounds2.width, bounds2.height, new float[]{0.0f, 1.0f}, new Color[]{JBColor.LIGHT_GRAY, JBColor.DARK_GRAY}));
                    g2d.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        private final List<JTextField> fields = Arrays.asList(new JBTextField(), new JBTextField(){
            {
                this.putClientProperty("JTextField.variant", "search");
            }
        }, new SearchTextField(false).getTextEditor(), new SearchTextField(true).getTextEditor(), new ExpandableTextField(), new ExtendableTextField(){
            {
                this.setExtensions(new ExtendableTextComponent.Extension[]{new ExtendableTextComponent.Extension(){

                    public Icon getIcon(boolean hovered2) {
                        return AllIcons.General.GearPlain;
                    }

                    public String getTooltip() {
                        return "Settings";
                    }

                    public boolean isIconBeforeText() {
                        return true;
                    }
                }, new ExtendableTextComponent.Extension(){

                    public Icon getIcon(boolean hovered2) {
                        return hovered2 ? AllIcons.General.ContextHelp : AllIcons.General.Locate;
                    }

                    public String getTooltip() {
                        return "Locate";
                    }

                    public boolean isIconBeforeText() {
                        return true;
                    }
                }, new ExtendableTextComponent.Extension(){
                    private final Icon icon = new AnimatedIcon.FS();

                    public Icon getIcon(boolean hovered2) {
                        return !hovered2 ? this.icon : AllIcons.Process.FS.Step_passive;
                    }

                    public String getTooltip() {
                        return "Refresh";
                    }
                }, new ExtendableTextComponent.Extension(){
                    private final Icon fading = new AnimatedIcon.Fading(AllIcons.Ide.FatalError);
                    private final Icon blinking = new AnimatedIcon.Blinking(AllIcons.Ide.FatalError);

                    public Icon getIcon(boolean hovered2) {
                        return hovered2 ? this.fading : this.blinking;
                    }
                }, new ExtendableTextComponent.Extension(){
                    private final TextIcon icon = new TextIcon("empty", null, null, 1);

                    public Icon getIcon(boolean hovered2) {
                        if (null == this.getActionOnClick()) {
                            this.icon.setFont(RelativeFont.SMALL.derive(this.getFont()));
                            this.icon.setBackground(this.getForeground());
                            this.icon.setForeground(this.getBackground());
                            return this.icon;
                        }
                        return hovered2 ? AllIcons.Actions.CloseHovered : AllIcons.Actions.Close;
                    }

                    public String getTooltip() {
                        return "Clear";
                    }

                    public Runnable getActionOnClick() {
                        return this.getText().isEmpty() ? null : () -> this.setText(null);
                    }
                }});
            }
        });

        private View() {
            super(new BorderLayout(10, 10));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add("North", this.control);
            this.add("Center", this.center);
            this.control.add(this.columns);
            this.columns.setSelected(true);
            this.columns.addChangeListener(event -> this.updateColumns());
            this.updateColumns();
            this.control.add(this.opaque);
            this.opaque.addChangeListener(event -> this.updateOpaque());
            this.updateOpaque();
            this.control.add(this.gradient);
            this.gradient.addChangeListener(event -> this.updateGradient());
            this.updateGradient();
            this.control.add(new JLabel("Fill:"));
            this.control.add(this.fill);
            this.fill.addItemListener(event -> this.updateFill());
            this.updateFill();
        }

        private void updateColumns() {
            int amount = this.columns.isSelected() ? 20 : 0;
            this.update((? super JTextField field) -> field.setColumns(amount));
        }

        private void updateOpaque() {
            boolean state = this.opaque.isSelected();
            this.update((? super JTextField field) -> field.setOpaque(state));
        }

        private void updateGradient() {
            this.update((? super JTextField field) -> {});
        }

        private void updateFill() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 10;
            gbc.fill = this.fill.getSelectedIndex();
            if (gbc.fill < 0) {
                gbc.fill = 0;
            }
            this.center.removeAll();
            this.update((? super JTextField field) -> this.center.add((Component)field, gbc));
        }

        private void update(Consumer<? super JTextField> consumer2) {
            this.fields.forEach(consumer2);
            this.center.revalidate();
            this.center.repaint();
        }
    }

    private static enum Fill {
        None,
        Both,
        Horizontal,
        Vertical;

    }
}

