/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.gridLayout.HorizontalGaps;
import com.intellij.ui.dsl.gridLayout.VerticalGaps;
import com.intellij.ui.dsl.gridLayout.impl.Cell;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c6\u0003J1\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\fH\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006,"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/LayoutCellData;", "", "cell", "Lcom/intellij/ui/dsl/gridLayout/impl/Cell;", "preferredSize", "Ljava/awt/Dimension;", "columnGaps", "Lcom/intellij/ui/dsl/gridLayout/HorizontalGaps;", "rowGaps", "Lcom/intellij/ui/dsl/gridLayout/VerticalGaps;", "(Lcom/intellij/ui/dsl/gridLayout/impl/Cell;Ljava/awt/Dimension;Lcom/intellij/ui/dsl/gridLayout/HorizontalGaps;Lcom/intellij/ui/dsl/gridLayout/VerticalGaps;)V", "baseline", "", "getBaseline", "()Ljava/lang/Integer;", "setBaseline", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getCell", "()Lcom/intellij/ui/dsl/gridLayout/impl/Cell;", "cellPaddedWidth", "getCellPaddedWidth", "()I", "getColumnGaps", "()Lcom/intellij/ui/dsl/gridLayout/HorizontalGaps;", "gapHeight", "getGapHeight", "gapWidth", "getGapWidth", "getPreferredSize", "()Ljava/awt/Dimension;", "getRowGaps", "()Lcom/intellij/ui/dsl/gridLayout/VerticalGaps;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
final class LayoutCellData {
    @Nullable
    private Integer baseline;
    @NotNull
    private final Cell cell;
    @NotNull
    private final Dimension preferredSize;
    @NotNull
    private final HorizontalGaps columnGaps;
    @NotNull
    private final VerticalGaps rowGaps;

    @Nullable
    public final Integer getBaseline() {
        return this.baseline;
    }

    public final void setBaseline(@Nullable Integer n) {
        this.baseline = n;
    }

    public final int getGapWidth() {
        return this.cell.getConstraints().getGaps().getWidth() + this.columnGaps.getWidth();
    }

    public final int getGapHeight() {
        return this.cell.getConstraints().getGaps().getHeight() + this.rowGaps.getHeight();
    }

    public final int getCellPaddedWidth() {
        return this.preferredSize.width + this.getGapWidth() - this.cell.getConstraints().getVisualPaddings().getWidth();
    }

    @NotNull
    public final Cell getCell() {
        return this.cell;
    }

    @NotNull
    public final Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @NotNull
    public final HorizontalGaps getColumnGaps() {
        return this.columnGaps;
    }

    @NotNull
    public final VerticalGaps getRowGaps() {
        return this.rowGaps;
    }

    public LayoutCellData(@NotNull Cell cell2, @NotNull Dimension preferredSize, @NotNull HorizontalGaps columnGaps, @NotNull VerticalGaps rowGaps) {
        Intrinsics.checkNotNullParameter((Object)cell2, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)columnGaps, (String)"columnGaps");
        Intrinsics.checkNotNullParameter((Object)rowGaps, (String)"rowGaps");
        this.cell = cell2;
        this.preferredSize = preferredSize;
        this.columnGaps = columnGaps;
        this.rowGaps = rowGaps;
    }

    @NotNull
    public final Cell component1() {
        return this.cell;
    }

    @NotNull
    public final Dimension component2() {
        return this.preferredSize;
    }

    @NotNull
    public final HorizontalGaps component3() {
        return this.columnGaps;
    }

    @NotNull
    public final VerticalGaps component4() {
        return this.rowGaps;
    }

    @NotNull
    public final LayoutCellData copy(@NotNull Cell cell2, @NotNull Dimension preferredSize, @NotNull HorizontalGaps columnGaps, @NotNull VerticalGaps rowGaps) {
        Intrinsics.checkNotNullParameter((Object)cell2, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)columnGaps, (String)"columnGaps");
        Intrinsics.checkNotNullParameter((Object)rowGaps, (String)"rowGaps");
        return new LayoutCellData(cell2, preferredSize, columnGaps, rowGaps);
    }

    public static /* synthetic */ LayoutCellData copy$default(LayoutCellData layoutCellData, Cell cell2, Dimension dimension, HorizontalGaps horizontalGaps, VerticalGaps verticalGaps, int n, Object object) {
        if ((n & 1) != 0) {
            cell2 = layoutCellData.cell;
        }
        if ((n & 2) != 0) {
            dimension = layoutCellData.preferredSize;
        }
        if ((n & 4) != 0) {
            horizontalGaps = layoutCellData.columnGaps;
        }
        if ((n & 8) != 0) {
            verticalGaps = layoutCellData.rowGaps;
        }
        return layoutCellData.copy(cell2, dimension, horizontalGaps, verticalGaps);
    }

    @NotNull
    public String toString() {
        return "LayoutCellData(cell=" + this.cell + ", preferredSize=" + this.preferredSize + ", columnGaps=" + this.columnGaps + ", rowGaps=" + this.rowGaps + ")";
    }

    public int hashCode() {
        Cell cell2 = this.cell;
        Dimension dimension = this.preferredSize;
        HorizontalGaps horizontalGaps = this.columnGaps;
        VerticalGaps verticalGaps = this.rowGaps;
        return (((cell2 != null ? cell2.hashCode() : 0) * 31 + (dimension != null ? ((Object)dimension).hashCode() : 0)) * 31 + (horizontalGaps != null ? ((Object)horizontalGaps).hashCode() : 0)) * 31 + (verticalGaps != null ? ((Object)verticalGaps).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LayoutCellData)) break block3;
                LayoutCellData layoutCellData = (LayoutCellData)object;
                if (!Intrinsics.areEqual((Object)this.cell, (Object)layoutCellData.cell) || !Intrinsics.areEqual((Object)this.preferredSize, (Object)layoutCellData.preferredSize) || !Intrinsics.areEqual((Object)this.columnGaps, (Object)layoutCellData.columnGaps) || !Intrinsics.areEqual((Object)this.rowGaps, (Object)layoutCellData.rowGaps)) break block3;
            }
            return true;
        }
        return false;
    }
}

