/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.util.FieldAccessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.VolatileImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@ApiStatus.Experimental
public class HwFacadeHelper {
    public static final Color TRANSPARENT_COLOR = new Color(1, 1, 1, 0);
    @NotNull
    private final JComponent myTarget;
    private JWindow myHwFacade;
    private ComponentAdapter myOwnerListener;
    private ComponentAdapter myTargetListener;
    private VolatileImage myBackBuffer;
    @NotNull
    Consumer<? super JBCefBrowser> myOnBrowserMoveResizeCallback;

    public static HwFacadeHelper create(@NotNull JComponent target2) {
        if (target2 == null) {
            HwFacadeHelper.$$$reportNull$$$0(0);
        }
        return JBCefApp.isSupported() ? new HwFacadeHelper(target2) : new HwFacadeHelper(target2){

            @Override
            public void addNotify() {
            }

            @Override
            public void show() {
            }

            @Override
            public void removeNotify() {
            }

            @Override
            public void hide() {
            }

            @Override
            public void paint(@NotNull Graphics g, @NotNull Consumer<? super Graphics> targetPaint) {
                if (g == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (targetPaint == null) {
                    1.$$$reportNull$$$0(1);
                }
                targetPaint.accept(g);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "g";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetPaint";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/jcef/HwFacadeHelper$1";
                objectArray[2] = "paint";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private HwFacadeHelper(@NotNull JComponent target2) {
        if (target2 == null) {
            HwFacadeHelper.$$$reportNull$$$0(1);
        }
        this.myOnBrowserMoveResizeCallback = browser2 -> {
            if (!this.isActive()) {
                this.activateIfNeeded(Collections.singletonList(browser2.getCefBrowser()));
            }
        };
        this.myTarget = target2;
    }

    private boolean isActive() {
        return this.myHwFacade != null;
    }

    private static boolean isCefAppActive() {
        return JCEFAccessor.getCefApp() != null;
    }

    private void onShowing() {
        if (!HwFacadeHelper.isCefAppActive()) {
            return;
        }
        assert (this.myHwFacade == null);
        assert (this.myTarget.isVisible());
        this.myTargetListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (HwFacadeHelper.this.isActive()) {
                    HwFacadeHelper.this.myHwFacade.setSize(HwFacadeHelper.this.myTarget.getSize());
                } else {
                    HwFacadeHelper.this.activateIfNeeded(JCEFAccessor.getHwBrowsers());
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (HwFacadeHelper.this.isActive()) {
                    if (HwFacadeHelper.this.myHwFacade.isVisible()) {
                        HwFacadeHelper.this.myHwFacade.setLocation(HwFacadeHelper.this.myTarget.getLocationOnScreen());
                    }
                } else {
                    HwFacadeHelper.this.activateIfNeeded(JCEFAccessor.getHwBrowsers());
                }
            }
        };
        this.myTarget.addComponentListener(this.myTargetListener);
        this.activateIfNeeded(JCEFAccessor.getHwBrowsers());
    }

    private void activateIfNeeded(@NotNull List<CefBrowser> browsers) {
        if (browsers == null) {
            HwFacadeHelper.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isLinux || !HwFacadeHelper.isCefAppActive() || !this.myTarget.isShowing()) {
            return;
        }
        Rectangle targetBounds = new Rectangle(this.myTarget.getLocationOnScreen(), this.myTarget.getSize());
        boolean overlaps = false;
        for (CefBrowser browser2 : browsers) {
            Component browserComp = browser2.getUIComponent();
            if (browserComp == null || !browserComp.isVisible() || !browserComp.isShowing() || SwingUtilities.isDescendingFrom(browserComp, this.myTarget) || !new Rectangle(browserComp.getLocationOnScreen(), browserComp.getSize()).intersects(targetBounds)) continue;
            overlaps = true;
            break;
        }
        if (overlaps) {
            Window owner = SwingUtilities.getWindowAncestor(this.myTarget);
            this.myOwnerListener = new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (HwFacadeHelper.this.myTarget.isVisible()) {
                        HwFacadeHelper.this.myHwFacade.setLocation(HwFacadeHelper.this.myTarget.getLocationOnScreen());
                    }
                }
            };
            owner.addComponentListener(this.myOwnerListener);
            this.myHwFacade = new JWindow(owner);
            this.myHwFacade.add(new JPanel(){
                {
                    this.setBackground(TRANSPARENT_COLOR);
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (HwFacadeHelper.this.myBackBuffer != null) {
                        g.drawImage(HwFacadeHelper.this.myBackBuffer, 0, 0, null);
                    }
                }
            });
            JdkEx.setIgnoreMouseEvents(this.myHwFacade, true);
            this.myHwFacade.setBounds(targetBounds);
            this.myHwFacade.setFocusableWindowState(false);
            this.myHwFacade.setBackground(TRANSPARENT_COLOR);
            this.myHwFacade.setVisible(true);
        }
    }

    public void addNotify() {
        if (this.myTarget.isVisible()) {
            this.onShowing();
        }
        if (!SystemInfo.isLinux) {
            JBCefBrowser.addOnBrowserMoveResizeCallback(this.myOnBrowserMoveResizeCallback);
        }
    }

    public void show() {
        if (!HwFacadeHelper.isCefAppActive()) {
            return;
        }
        if (AWTAccessor.getComponentAccessor().getPeer(this.myTarget) != null) {
            if (this.isActive()) {
                this.myHwFacade.setVisible(true);
            } else {
                this.onShowing();
            }
        }
    }

    public void removeNotify() {
        if (this.isActive()) {
            this.myHwFacade.dispose();
            this.myHwFacade = null;
            this.myBackBuffer = null;
            this.myTarget.removeComponentListener(this.myTargetListener);
            Window owner = SwingUtilities.getWindowAncestor(this.myTarget);
            assert (owner != null);
            owner.removeComponentListener(this.myOwnerListener);
        }
        if (!SystemInfo.isLinux) {
            JBCefBrowser.removeOnBrowserMoveResizeCallback(this.myOnBrowserMoveResizeCallback);
        }
    }

    public void hide() {
        if (this.isActive()) {
            this.myHwFacade.setVisible(false);
        }
    }

    public void paint(@NotNull Graphics g, @NotNull Consumer<? super Graphics> targetPaint) {
        if (g == null) {
            HwFacadeHelper.$$$reportNull$$$0(3);
        }
        if (targetPaint == null) {
            HwFacadeHelper.$$$reportNull$$$0(4);
        }
        if (this.isActive()) {
            Dimension size = this.myTarget.getSize();
            if (this.myBackBuffer == null || this.myBackBuffer.getWidth() != size.width || this.myBackBuffer.getHeight() != size.height) {
                this.myBackBuffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleVolatileImage(size.width, size.height, 3);
            }
            Graphics2D bbGraphics = (Graphics2D)this.myBackBuffer.getGraphics();
            bbGraphics.setBackground(TRANSPARENT_COLOR);
            bbGraphics.clearRect(0, 0, size.width, size.height);
            targetPaint.accept(bbGraphics);
            this.myHwFacade.repaint();
        } else {
            targetPaint.accept(g);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browsers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPaint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/HwFacadeHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "activateIfNeeded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JCEFAccessor {
        private static FieldAccessor<CefApp, HashSet<CefClient>> clientsField;
        private static FieldAccessor<CefClient, HashMap<Integer, CefBrowser>> browsersField;
        private static CefApp ourCefApp;

        private JCEFAccessor() {
        }

        @Nullable
        public static CefApp getCefApp() {
            if (ourCefApp == null && CefApp.getState() != CefApp.CefAppState.NONE) {
                ourCefApp = CefApp.getInstance();
                clientsField = new FieldAccessor(CefApp.class, "clients_");
                browsersField = new FieldAccessor(CefClient.class, "browser_");
            }
            return ourCefApp;
        }

        @NotNull
        public static List<CefBrowser> getHwBrowsers() {
            LinkedList<CefBrowser> list2 = new LinkedList<CefBrowser>();
            if (JCEFAccessor.getCefApp() == null || !clientsField.isAvailable() || !browsersField.isAvailable()) {
                LinkedList<CefBrowser> linkedList = list2;
                if (linkedList == null) {
                    JCEFAccessor.$$$reportNull$$$0(0);
                }
                return linkedList;
            }
            Set clients = (Set)clientsField.get((Object)ourCefApp);
            if (clients == null) {
                LinkedList<CefBrowser> linkedList = list2;
                if (linkedList == null) {
                    JCEFAccessor.$$$reportNull$$$0(1);
                }
                return linkedList;
            }
            for (CefClient client2 : clients) {
                HashMap browsers = (HashMap)browsersField.get((Object)client2);
                if (browsers == null) {
                    LinkedList<CefBrowser> linkedList = list2;
                    if (linkedList == null) {
                        JCEFAccessor.$$$reportNull$$$0(2);
                    }
                    return linkedList;
                }
                for (CefBrowser browser2 : browsers.values()) {
                    JBCefBrowser jbCefBrowser = JBCefBrowserBase.getJBCefBrowser((CefBrowser)browser2);
                    if (jbCefBrowser == null || jbCefBrowser.isOffScreenRendering()) continue;
                    list2.add(browser2);
                }
            }
            LinkedList<CefBrowser> linkedList = list2;
            if (linkedList == null) {
                JCEFAccessor.$$$reportNull$$$0(3);
            }
            return linkedList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/jcef/HwFacadeHelper$JCEFAccessor", "getHwBrowsers"));
        }
    }
}

