/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.Application;
import com.apple.eawt.FullScreenAdapter;
import com.apple.eawt.FullScreenListener;
import com.apple.eawt.FullScreenUtilities;
import com.apple.eawt.event.FullScreenEvent;
import com.intellij.ide.ActiveWindowsWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.IdeFrameDecorator;
import com.intellij.ui.mac.MacWinTabsHandler;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Native;
import com.sun.jna.platform.mac.CoreFoundation;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.EventListener;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class MacMainFrameDecorator
extends IdeFrameDecorator {
    public static final String FULL_SCREEN = "Idea.Is.In.FullScreen.Mode.Now";
    private static Method toggleFullScreenMethod;
    private final EventDispatcher<FSListener> myDispatcher;
    private final MacWinTabsHandler myTabsHandler;
    private boolean myInFullScreen;

    public MacMainFrameDecorator(final @NotNull JFrame frame, final @NotNull Disposable parentDisposable) {
        JRootPane rootPane;
        if (frame == null) {
            MacMainFrameDecorator.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            MacMainFrameDecorator.$$$reportNull$$$0(1);
        }
        super(frame);
        this.myDispatcher = EventDispatcher.create(FSListener.class);
        this.myTabsHandler = new MacWinTabsHandler(frame, parentDisposable);
        if (toggleFullScreenMethod != null) {
            FullScreenUtilities.setWindowCanFullScreen((Window)frame, (boolean)true);
            FullScreenUtilities.addFullScreenListenerTo((Window)frame, (FullScreenListener)new FullScreenListener(){

                public void windowEnteringFullScreen(FullScreenEvent event) {
                    ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowEnteringFullScreen(event);
                }

                public void windowEnteredFullScreen(FullScreenEvent event) {
                    ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowEnteredFullScreen(event);
                }

                public void windowExitingFullScreen(FullScreenEvent event) {
                    ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowExitingFullScreen(event);
                }

                public void windowExitedFullScreen(FullScreenEvent event) {
                    ((FSListener)MacMainFrameDecorator.this.myDispatcher.getMulticaster()).windowExitedFullScreen(event);
                }
            });
            this.myDispatcher.addListener((EventListener)new FSAdapter(){

                public void windowEnteringFullScreen(FullScreenEvent event) {
                    JRootPane rootPane = MacMainFrameDecorator.this.myFrame.getRootPane();
                    if (rootPane != null && rootPane.getBorder() != null && Registry.is((String)"ide.mac.transparentTitleBarAppearance")) {
                        rootPane.setBorder(null);
                    }
                    MacMainFrameDecorator.this.myTabsHandler.enteringFullScreen();
                }

                public void windowEnteredFullScreen(FullScreenEvent event) {
                    JRootPane rootPane = MacMainFrameDecorator.this.myFrame.getRootPane();
                    if (rootPane != null) {
                        rootPane.putClientProperty(MacMainFrameDecorator.FULL_SCREEN, Boolean.TRUE);
                    }
                    MacMainFrameDecorator.this.enterFullScreen();
                    MacMainFrameDecorator.this.myFrame.validate();
                }

                public void windowExitedFullScreen(FullScreenEvent event) {
                    JRootPane rootPane = MacMainFrameDecorator.this.myFrame.getRootPane();
                    if (Registry.is((String)"ide.mac.transparentTitleBarAppearance")) {
                        UIUtil.setCustomTitleBar((Window)MacMainFrameDecorator.this.myFrame, (JRootPane)rootPane, runnable2 -> {
                            if (!Disposer.isDisposed((Disposable)parentDisposable)) {
                                Disposer.register((Disposable)parentDisposable, () -> runnable2.run());
                            }
                        });
                    }
                    MacMainFrameDecorator.this.exitFullScreen();
                    ActiveWindowsWatcher.addActiveWindow(MacMainFrameDecorator.this.myFrame);
                    MacMainFrameDecorator.this.myFrame.validate();
                }
            });
        }
        if ((rootPane = this.myFrame.getRootPane()) != null && Registry.is((String)"ide.mac.transparentTitleBarAppearance")) {
            IdeGlassPane glassPane = (IdeGlassPane)this.myFrame.getRootPane().getGlassPane();
            glassPane.addMousePreprocessor((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getY() <= UIUtil.getTransparentTitleBarHeight((JRootPane)rootPane)) {
                        CoreFoundation.CFStringRef apple_global_domain;
                        CoreFoundation.CFStringRef appleActionOnDoubleClick = CoreFoundation.CFStringRef.createCFString((String)"AppleActionOnDoubleClick");
                        CoreFoundation.CFStringRef res2 = MyCoreFoundation.INSTANCE.CFPreferencesCopyAppValue(appleActionOnDoubleClick, apple_global_domain = CoreFoundation.CFStringRef.createCFString((String)"Apple Global Domain"));
                        if (res2 != null && !res2.stringValue().equals("Maximize")) {
                            if (frame.getExtendedState() == 1) {
                                frame.setExtendedState(0);
                            } else {
                                frame.setExtendedState(1);
                            }
                        } else if (frame.getExtendedState() == 6) {
                            frame.setExtendedState(0);
                        } else {
                            frame.setExtendedState(6);
                        }
                        apple_global_domain.release();
                        appleActionOnDoubleClick.release();
                        if (res2 != null) {
                            res2.release();
                        }
                    }
                    super.mouseClicked(e);
                }
            }, parentDisposable);
        }
    }

    private void enterFullScreen() {
        this.myInFullScreen = true;
        this.storeFullScreenStateIfNeeded();
        this.myTabsHandler.enterFullScreen();
    }

    private void exitFullScreen() {
        this.myInFullScreen = false;
        this.storeFullScreenStateIfNeeded();
        JRootPane rootPane = this.myFrame.getRootPane();
        if (rootPane != null) {
            rootPane.putClientProperty(FULL_SCREEN, null);
        }
        this.myTabsHandler.exitFullScreen();
    }

    private void storeFullScreenStateIfNeeded() {
        this.myFrame.doLayout();
    }

    @Override
    public void frameInit() {
        this.myTabsHandler.frameInit();
    }

    @Override
    public void frameShow() {
        this.myTabsHandler.frameShow();
    }

    @Override
    public void setProject() {
        this.myTabsHandler.setProject();
    }

    @Override
    public boolean isInFullScreen() {
        return this.myInFullScreen;
    }

    @Override
    @NotNull
    public Promise<Boolean> toggleFullScreen(boolean state) {
        final AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myInFullScreen == state) {
                promise.setResult((Object)state);
            } else if (toggleFullScreenMethod == null) {
                promise.setResult(null);
            } else {
                this.myDispatcher.addListener((EventListener)new FSAdapter(){

                    public void windowExitedFullScreen(FullScreenEvent event) {
                        promise.setResult((Object)false);
                        MacMainFrameDecorator.this.myDispatcher.removeListener((EventListener)this);
                    }

                    public void windowEnteredFullScreen(FullScreenEvent event) {
                        promise.setResult((Object)true);
                        MacMainFrameDecorator.this.myDispatcher.removeListener((EventListener)this);
                    }
                });
                this.invokeAppMethod(toggleFullScreenMethod);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            MacMainFrameDecorator.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    private void invokeAppMethod(Method method2) {
        try {
            method2.invoke((Object)Application.getApplication(), this.myFrame);
        }
        catch (Exception e) {
            Logger.getInstance(MacMainFrameDecorator.class).warn((Throwable)e);
        }
    }

    static {
        try {
            Class.forName("com.apple.eawt.FullScreenUtilities");
            toggleFullScreenMethod = Application.class.getMethod("requestToggleFullScreen", Window.class);
        }
        catch (Exception e) {
            Logger.getInstance(MacMainFrameDecorator.class).warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/MacMainFrameDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/MacMainFrameDecorator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toggleFullScreen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FSAdapter
    extends FullScreenAdapter
    implements FSListener {
        private FSAdapter() {
        }
    }

    private static interface FSListener
    extends FullScreenListener,
    EventListener {
    }

    static interface MyCoreFoundation
    extends CoreFoundation {
        public static final MyCoreFoundation INSTANCE = (MyCoreFoundation)Native.load((String)"CoreFoundation", MyCoreFoundation.class);

        public CoreFoundation.CFStringRef CFPreferencesCopyAppValue(CoreFoundation.CFStringRef var1, CoreFoundation.CFStringRef var2);
    }
}

