/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PathChooserDialogHelper;
import com.intellij.ui.UIBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.OwnerOptional;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacPathChooserDialog
implements PathChooserDialog,
FileChooserDialog {
    private FileDialog myFileDialog;
    private final FileChooserDescriptor myFileChooserDescriptor;
    private final WeakReference<Component> myParent;
    private final Project myProject;
    @NlsContexts.DialogTitle
    private final String myTitle;
    private VirtualFile[] virtualFiles;
    private final PathChooserDialogHelper myHelper;

    public MacPathChooserDialog(@NotNull FileChooserDescriptor descriptor2, Component parent, Project project) {
        if (descriptor2 == null) {
            MacPathChooserDialog.$$$reportNull$$$0(0);
        }
        this.myFileChooserDescriptor = descriptor2;
        this.myParent = new WeakReference<Component>(parent);
        this.myProject = project;
        this.myTitle = MacPathChooserDialog.getChooserTitle(descriptor2);
        this.myHelper = new PathChooserDialogHelper(descriptor2);
        String key = "awt.file.dialog.enable.filter";
        System.setProperty(key, Boolean.toString(Registry.is((String)key, (boolean)true)));
        Consumer dialogConsumer = owner -> {
            this.myFileDialog = new FileDialog((Dialog)owner, this.myTitle, 0);
        };
        Consumer frameConsumer = owner -> {
            this.myFileDialog = new FileDialog((Frame)owner, this.myTitle, 0);
        };
        OwnerOptional.fromComponent(parent).ifDialog((Consumer<? super Dialog>)dialogConsumer).ifFrame((Consumer<? super Frame>)frameConsumer).ifNull((Consumer<? super Frame>)frameConsumer);
    }

    @NlsContexts.DialogTitle
    private static String getChooserTitle(FileChooserDescriptor descriptor2) {
        String title2 = descriptor2.getTitle();
        return title2 != null ? title2 : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void choose(@Nullable VirtualFile toSelect2, @NotNull Consumer<? super List<VirtualFile>> callback2) {
        boolean appStarted2;
        if (callback2 == null) {
            MacPathChooserDialog.$$$reportNull$$$0(1);
        }
        if (toSelect2 != null && toSelect2.getParent() != null) {
            String directoryName;
            String fileName = null;
            if (toSelect2.isDirectory()) {
                directoryName = toSelect2.getCanonicalPath();
            } else {
                directoryName = toSelect2.getParent().getCanonicalPath();
                fileName = toSelect2.getPath();
            }
            this.myFileDialog.setDirectory(directoryName);
            this.myFileDialog.setFile(fileName);
        }
        this.myFileDialog.setFilenameFilter(FileChooser.safeInvokeFilter((dir, name2) -> this.myFileChooserDescriptor.isFileSelectable(PathChooserDialogHelper.fileToCoreLocalVirtualFile(dir, name2)), (boolean)false));
        this.myFileDialog.setMultipleMode(this.myFileChooserDescriptor.isChooseMultiple());
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean bl = appStarted2 = commandProcessor != null;
        if (appStarted2) {
            commandProcessor.enterModal();
            LaterInvocator.enterModal(this.myFileDialog);
        }
        Component parent = (Component)this.myParent.get();
        Component previousFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        try {
            this.myFileDialog.setVisible(true);
        }
        finally {
            if (appStarted2) {
                commandProcessor.leaveModal();
                LaterInvocator.leaveModal(this.myFileDialog);
                if (previousFocusOwner != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> previousFocusOwner.requestFocus());
                }
            }
        }
        Object[] files2 = this.myFileDialog.getFiles();
        List<VirtualFile> virtualFileList = this.myHelper.getChosenFiles((File[])files2);
        this.virtualFiles = virtualFileList.toArray(VirtualFile.EMPTY_ARRAY);
        if (!virtualFileList.isEmpty()) {
            try {
                if (virtualFileList.size() == 1) {
                    this.myFileChooserDescriptor.isFileSelectable(virtualFileList.get(0));
                }
                this.myFileChooserDescriptor.validateSelectedFiles(this.virtualFiles);
            }
            catch (Exception e) {
                if (parent == null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.myTitle);
                } else {
                    Messages.showErrorDialog((Component)parent, (String)e.getMessage(), (String)this.myTitle);
                }
                return;
            }
            if (!ArrayUtil.isEmpty((Object[])files2)) {
                callback2.consume(virtualFileList);
                return;
            }
        }
        if (callback2 instanceof FileChooser.FileChooserConsumer) {
            ((FileChooser.FileChooserConsumer)callback2).cancelled();
        }
    }

    @NotNull
    private static FileDialog createFileDialogWithoutOwner(String title2, int load2) {
        return new FileDialog((Frame)null, title2, load2);
    }

    public VirtualFile @NotNull [] choose(@Nullable VirtualFile toSelect2, @Nullable Project project) {
        this.choose(toSelect2, (Consumer<? super List<VirtualFile>>)((Consumer)files2 -> {}));
        if (this.virtualFiles == null) {
            MacPathChooserDialog.$$$reportNull$$$0(2);
        }
        return this.virtualFiles;
    }

    public VirtualFile @NotNull [] choose(@Nullable Project project, VirtualFile ... toSelect2) {
        if (toSelect2 == null) {
            MacPathChooserDialog.$$$reportNull$$$0(3);
        }
        VirtualFile[] virtualFileArray = this.choose(toSelect2.length > 0 ? toSelect2[0] : null, project);
        if (virtualFileArray == null) {
            MacPathChooserDialog.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/MacPathChooserDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/MacPathChooserDialog";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "choose";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

