/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.StatsCounters;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

class ActionGroupTouchBar
extends TouchBar {
    private static final boolean DISABLE_ASYNC_UPDATE = Boolean.getBoolean("touchbar.actions.disable.async.update");
    private static final boolean USE_CACHED_PRESENTATIONS = Boolean.getBoolean("touchbar.actions.use.cached.presentations");
    private static final int DELAY_FOR_CACHED_PRESENTATIONS_MS = Integer.getInteger("touchbar.actions.delay.for.cached.presentations", 750);
    private static final long DELAY_FOR_CACHED_PRESENTATIONS_NS = (long)DELAY_FOR_CACHED_PRESENTATIONS_MS * 1000000L;
    private static final Logger LOG = Logger.getInstance(ActionGroupTouchBar.class);
    private static final boolean IS_AUTOCLOSE_DISABLED = Boolean.getBoolean("touchbar.autoclose.disable");
    @NotNull
    private final ActionGroup myActionGroup;
    @NotNull
    private final PresentationFactory myFactory;
    @Nullable
    private final Collection<AnAction> myAutoCloseActions;
    @Nullable
    private final Customizer myCustomizer;
    @NotNull
    private final Updater myUpdateTimer;
    private CancellablePromise<List<AnAction>> myLastUpdate;
    private long myLastUpdateNs;
    private long myStartShowNs;
    @NotNull
    private final Map<AnAction, TBItemAnActionButton> myActionButtonPool;
    @NotNull
    private final Map<Integer, TBItemGroup> myGroupPool;
    private static final String ourSmallSeparatorText = "type.small";
    private static final String ourLargeSeparatorText = "type.large";
    private static final String ourFlexibleSeparatorText = "type.flexible";

    ActionGroupTouchBar(@NotNull String touchbarName, @NotNull ActionGroup actionGroup2, @Nullable Customizer customizations) {
        if (touchbarName == null) {
            ActionGroupTouchBar.$$$reportNull$$$0(0);
        }
        if (actionGroup2 == null) {
            ActionGroupTouchBar.$$$reportNull$$$0(1);
        }
        super(touchbarName, customizations != null ? customizations.getCrossEscInfo() : null, false);
        this.myFactory = new PresentationFactory();
        this.myUpdateTimer = new Updater();
        this.myLastUpdateNs = 0L;
        this.myStartShowNs = 0L;
        this.myActionButtonPool = new HashMap<AnAction, TBItemAnActionButton>();
        this.myGroupPool = new HashMap<Integer, TBItemGroup>();
        this.myActionGroup = actionGroup2;
        if (!IS_AUTOCLOSE_DISABLED && customizations != null && customizations.getAutoCloseActionIds() != null) {
            ActionManager actionManager = ActionManager.getInstance();
            ArrayList<AnAction> autoCloseActions = new ArrayList<AnAction>();
            for (String actId : customizations.getAutoCloseActionIds()) {
                AnAction act;
                if (actId == null || actId.isEmpty() || (act = actionManager.getAction(actId)) == null) continue;
                autoCloseActions.add(act);
            }
            ActionGroupTouchBar.validateAutoCloseActions(this.myActionGroup, autoCloseActions);
            if (LOG.isDebugEnabled() && !autoCloseActions.isEmpty()) {
                LOG.debug("initialized auto-closable touchbar '" + this.myName + "', auto-close actions: " + Arrays.toString(autoCloseActions.toArray()));
            }
            this.myAutoCloseActions = autoCloseActions.isEmpty() ? null : autoCloseActions;
        } else {
            this.myAutoCloseActions = null;
        }
        this.myCustomizer = customizations;
    }

    boolean updateAutoCloseAndCheck() {
        if (IS_AUTOCLOSE_DISABLED || this.myAutoCloseActions == null || this.myAutoCloseActions.isEmpty()) {
            return false;
        }
        if (this.myUpdateTimer.isRunning()) {
            return false;
        }
        long startTimeMs = System.currentTimeMillis();
        AnAction result2 = (AnAction)ProgressIndicatorUtils.withTimeout(50L, () -> this.updateAutoCloseAndCheckImpl());
        long spentTimeMs = System.currentTimeMillis() - startTimeMs;
        if (spentTimeMs > 10L) {
            LOG.debug("updateAutoCloseAndCheckImpl spent %d ms", new Object[]{spentTimeMs});
        }
        return result2 != null;
    }

    AnAction updateAutoCloseAndCheckImpl() {
        Application app2 = ApplicationManager.getApplication();
        if (app2 == null || app2.isDisposed() || this.myAutoCloseActions == null) {
            return null;
        }
        for (AnAction action2 : this.myAutoCloseActions) {
            boolean result2;
            ProgressManager.checkCanceled();
            Presentation presentation2 = this.myFactory.getPresentation(action2);
            presentation2.setEnabledAndVisible(true);
            @NotNull DataContext dataContext = DataManager.getInstance().getDataContext(Helpers.getCurrentFocusComponent());
            AnActionEvent event = new AnActionEvent(null, dataContext, "TouchBarGeneral", presentation2, ActionManager.getInstance(), 0, false, true);
            event.setInjectedContext(action2.isInInjectedContext());
            try {
                result2 = !ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)event, (boolean)false);
            }
            catch (Throwable exc) {
                continue;
            }
            if (!result2 || presentation2.isEnabledAndVisible()) continue;
            return action2;
        }
        return null;
    }

    synchronized void startUpdateTimer() {
        if (this.myUpdateTimer.isRunning()) {
            return;
        }
        this.myStartShowNs = System.nanoTime();
        this.myUpdateTimer.start();
    }

    synchronized void stopUpdateTimer() {
        this.myUpdateTimer.stop();
        if (this.myLastUpdate != null) {
            this.myLastUpdate.cancel();
            this.myLastUpdate = null;
        }
    }

    @Override
    synchronized void release() {
        super.release();
        long startNs = this.myStats != null ? System.nanoTime() : 0L;
        this.myActionButtonPool.forEach((act, item) -> item.releaseNativePeer());
        this.myActionButtonPool.clear();
        this.myGroupPool.forEach((n, item) -> item.releaseNativePeer());
        this.myGroupPool.clear();
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.touchbarReleaseDurationNs, System.nanoTime() - startNs);
        }
        this.myUpdateTimer.stop();
    }

    private void _rebuildButtons(@NotNull List<AnAction> actions2) {
        if (actions2 == null) {
            ActionGroupTouchBar.$$$reportNull$$$0(2);
        }
        this.softClear();
        ArrayList<AnAction> principal = null;
        TBItemGroup principalGroup = null;
        if (this.myCustomizer != null) {
            this.myCustomizer.prepare(this.myActionGroup);
            for (AnAction action2 : actions2) {
                if (!this.myCustomizer.isPrincipalGroupAction(action2)) continue;
                if (principal == null) {
                    principal = new ArrayList<AnAction>();
                }
                principal.add(action2);
            }
            if (principal != null && (principalGroup = this.myGroupPool.remove(principal.size())) == null) {
                principalGroup = new TBItemGroup(this.myItems.toString(), this.myItemListener, principal);
            }
        }
        int separatorCounter = 0;
        for (AnAction action3 : actions2) {
            int principalIndex;
            if (action3 instanceof Separator) {
                Separator sep = (Separator)action3;
                int increment = 1;
                if (sep.getText() != null) {
                    if (sep.getText().equals(ourSmallSeparatorText)) {
                        this.addSpacing(false);
                        continue;
                    }
                    if (sep.getText().equals(ourLargeSeparatorText)) {
                        this.addSpacing(true);
                        continue;
                    }
                    if (!sep.getText().equals(ourFlexibleSeparatorText)) continue;
                    this.addFlexibleSpacing();
                    continue;
                }
                separatorCounter += increment;
                continue;
            }
            if (separatorCounter > 0) {
                if (separatorCounter == 1) {
                    this.addSpacing(false);
                } else if (separatorCounter == 2) {
                    this.addSpacing(true);
                } else {
                    this.addFlexibleSpacing();
                }
                separatorCounter = 0;
            }
            TBItemAnActionButton butt = null;
            if (principal != null && (principalIndex = principal.indexOf(action3)) >= 0) {
                if (principalIndex == 0) {
                    this.addItem(principalGroup);
                    this.setPrincipal(principalGroup);
                }
                butt = principalGroup.getItem(principalIndex);
                butt.setAnAction(action3);
            }
            if (butt == null) {
                butt = this.createActionButton(action3);
                this.addItem(butt);
            }
            @NotNull Presentation presentation2 = this.myFactory.getPresentation(action3);
            butt.myIsVisible = presentation2.isVisible();
            if (!butt.myIsVisible) continue;
            long startNs = butt.myActionStats != null ? System.nanoTime() : 0L;
            butt.setDisabled(!presentation2.isEnabled());
            boolean isSelected = false;
            if (butt.getAnAction() instanceof Toggleable) {
                isSelected = Toggleable.isSelected((Presentation)presentation2);
                butt.myUpdateOptions |= 2;
            }
            butt.setSelected(isSelected);
            if (this.myCustomizer == null || !this.myCustomizer.applyCustomizations(butt, presentation2)) {
                butt.setIconFromPresentation(presentation2);
                boolean hideText = butt.myOriginIcon != null;
                String text2 = hideText ? null : presentation2.getText();
                butt.setText(text2);
            }
            if (butt.myActionStats != null) {
                butt.myActionStats.updateViewNs += System.nanoTime() - startNs;
            }
            butt.updateLater(false);
        }
        this.selectVisibleItemsToShow();
    }

    private AnAction _checkAutoClose(@NotNull List<AnAction> actions2) {
        if (actions2 == null) {
            ActionGroupTouchBar.$$$reportNull$$$0(3);
        }
        if (IS_AUTOCLOSE_DISABLED || this.myAutoCloseActions == null || this.myAutoCloseActions.isEmpty() || actions2.isEmpty()) {
            return null;
        }
        for (AnAction autocloseAction : this.myAutoCloseActions) {
            if (!actions2.contains(autocloseAction)) {
                return autocloseAction;
            }
            @NotNull Presentation presentation2 = this.myFactory.getPresentation(autocloseAction);
            if (presentation2.isVisible() && presentation2.isEnabled()) continue;
            return autocloseAction;
        }
        return null;
    }

    private void _applyPresentationChanges(List<AnAction> actions2) {
        long startNs = System.nanoTime();
        if (actions2 == null) {
            return;
        }
        AnAction autoCloseReason = this._checkAutoClose(actions2);
        if (autoCloseReason != null) {
            LOG.debug("touchbar '%s' was auto-closed because of: %s | %s", new Object[]{this.myName, autoCloseReason.getTemplateText(), autoCloseReason});
            this._closeSelf();
        }
        this._rebuildButtons(actions2);
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.applyPresentationChangesDurationNs, System.nanoTime() - startNs);
        }
    }

    @Override
    @NotNull
    TBItemAnActionButton createActionButton(@NotNull AnAction action2) {
        TBItemAnActionButton cached;
        if (action2 == null) {
            ActionGroupTouchBar.$$$reportNull$$$0(4);
        }
        if ((cached = this.myActionButtonPool.remove(action2)) != null) {
            cached.setAnAction(action2);
            TBItemAnActionButton tBItemAnActionButton = cached;
            if (tBItemAnActionButton == null) {
                ActionGroupTouchBar.$$$reportNull$$$0(5);
            }
            return tBItemAnActionButton;
        }
        Iterator<Map.Entry<AnAction, TBItemAnActionButton>> it = this.myActionButtonPool.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<AnAction, TBItemAnActionButton> entry2 = it.next();
            TBItemAnActionButton butt = entry2.getValue();
            if (!Objects.equals(action2.getTemplateText(), butt.getAnAction().getTemplateText())) continue;
            it.remove();
            butt.setAnAction(action2);
            TBItemAnActionButton tBItemAnActionButton = butt;
            if (tBItemAnActionButton == null) {
                ActionGroupTouchBar.$$$reportNull$$$0(6);
            }
            return tBItemAnActionButton;
        }
        TBItemAnActionButton tBItemAnActionButton = super.createActionButton(action2);
        if (tBItemAnActionButton == null) {
            ActionGroupTouchBar.$$$reportNull$$$0(7);
        }
        return tBItemAnActionButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void softClear() {
        if (this.myActionButtonPool.size() > 20) {
            ActionGroupTouchBar actionGroupTouchBar = this;
            synchronized (actionGroupTouchBar) {
                this.myActionButtonPool.forEach((act, item) -> item.releaseNativePeer());
                this.myActionButtonPool.clear();
            }
        }
        this.myItems.softClear(this.myActionButtonPool, this.myGroupPool);
    }

    void updateActionItems() {
        if (!this.myUpdateTimer.isRunning()) {
            return;
        }
        long timeNs = System.nanoTime();
        long elapsedFromStartShowNs = timeNs - this.myStartShowNs;
        this.myLastUpdateNs = timeNs;
        if (USE_CACHED_PRESENTATIONS && elapsedFromStartShowNs < DELAY_FOR_CACHED_PRESENTATIONS_NS) {
            if (this.myStats != null) {
                this.myStats.incrementCounter(StatsCounters.forceUseCached);
            }
            Timer t = new Timer(DELAY_FOR_CACHED_PRESENTATIONS_MS, e -> {
                if (System.nanoTime() - this.myLastUpdateNs > DELAY_FOR_CACHED_PRESENTATIONS_NS) {
                    if (this.myStats != null) {
                        this.myStats.incrementCounter(StatsCounters.forceCachedDelayedUpdateCount);
                    }
                    this.updateActionItems();
                }
            });
            t.setRepeats(false);
            t.start();
            return;
        }
        if (this.myCustomizer != null) {
            this.myCustomizer.onBeforeActionsExpand(this.myActionGroup);
        }
        DataContext dataContext = Utils.wrapDataContext(DataManager.getInstance().getDataContext(Helpers.getCurrentFocusComponent()));
        if (!DISABLE_ASYNC_UPDATE && Utils.isAsyncDataContext(dataContext)) {
            if (this.myLastUpdate != null) {
                this.myLastUpdate.cancel();
            }
            this.myLastUpdate = Utils.expandActionGroupAsync(LaterInvocator.isInModalContext(), this.myActionGroup, this.myFactory, dataContext, "TouchBarGeneral");
            this.myLastUpdate.onSuccess(actions2 -> this._applyPresentationChanges((List<AnAction>)actions2)).onProcessed(__ -> {
                this.myLastUpdate = null;
            });
        } else {
            List<AnAction> actions3 = Utils.expandActionGroupWithTimeout(LaterInvocator.isInModalContext(), this.myActionGroup, this.myFactory, dataContext, "TouchBarGeneral", Registry.intValue((String)"actionSystem.update.touchbar.timeout.ms"));
            this._applyPresentationChanges(actions3);
        }
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.totalUpdateDurationNs, System.nanoTime() - timeNs);
        }
    }

    private static void validateAutoCloseActions(@NotNull ActionGroup actionGroup2, @NotNull Collection<AnAction> autoCloseActions) {
        if (actionGroup2 == null) {
            ActionGroupTouchBar.$$$reportNull$$$0(8);
        }
        if (autoCloseActions == null) {
            ActionGroupTouchBar.$$$reportNull$$$0(9);
        }
        ArrayList<AnAction> actionsFromGroup = new ArrayList<AnAction>();
        Helpers.collectLeafActions(actionGroup2, actionsFromGroup);
        if (!actionsFromGroup.containsAll(autoCloseActions)) {
            autoCloseActions.removeIf(a -> !actionsFromGroup.contains(a));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touchbarName";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/ActionGroupTouchBar";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoCloseActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/ActionGroupTouchBar";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_rebuildButtons";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "_checkAutoClose";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createActionButton";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateAutoCloseActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Updater {
        @Nullable
        private TimerListener myTimerImpl;

        private Updater() {
        }

        void start() {
            if (this.myTimerImpl != null) {
                this.stop();
            }
            this.myTimerImpl = new TimerListener(){

                public ModalityState getModalityState() {
                    return ModalityState.current();
                }

                public void run() {
                    ActionGroupTouchBar.this.updateActionItems();
                }
            };
            ActionManager.getInstance().addTimerListener(this.myTimerImpl);
        }

        void stop() {
            if (this.myTimerImpl == null) {
                return;
            }
            ActionManager.getInstance().removeTimerListener(this.myTimerImpl);
            this.myTimerImpl = null;
        }

        boolean isRunning() {
            return this.myTimerImpl != null;
        }
    }
}

