/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.Helpers;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.mac.touchbar.TouchbarActionCustomizations;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CtxDialogs {
    private static final Logger LOG = Logger.getInstance(CtxDialogs.class);
    private static final int BUTTON_MIN_WIDTH_DLG = 107;
    private static final int BUTTON_BORDER = 16;
    private static final int BUTTON_IMAGE_MARGIN = 2;

    CtxDialogs() {
    }

    @Nullable
    static Disposable showWindowActions(final @NotNull Component contentPane) {
        if (contentPane == null) {
            CtxDialogs.$$$reportNull$$$0(0);
        }
        final DefaultActionGroup actions2 = new DefaultActionGroup();
        List<AnAction> actionList = CtxDialogs.findAllTouchbarActions(contentPane);
        if (actionList != null) {
            actions2.addAll(actionList);
        }
        if (LOG.isDebugEnabled()) {
            if (actionList == null || actionList.isEmpty()) {
                LOG.debug("window '%s' hasn't any touchbar actions", new Object[]{contentPane});
            } else {
                ArrayList<AnAction> leaves = new ArrayList<AnAction>();
                Helpers.collectLeafActions((ActionGroup)actions2, leaves);
                LOG.debug("show actions of window '%s' (count=%d):", new Object[]{contentPane, leaves.size()});
                for (AnAction act : leaves) {
                    LOG.debug("\t'%s' | id=%s | %s", new Object[]{act.getTemplateText(), Helpers.getActionId(act), act});
                }
            }
        }
        ModalityStateEx ms = LaterInvocator.getCurrentModalityState();
        TouchBar.CrossEscInfo crossEscInfo = CtxDialogs.isCrossEscGroup((ActionGroup)actions2) ? new TouchBar.CrossEscInfo(true, false) : null;
        Customizer customizer = new Customizer(crossEscInfo, null){
            @NotNull
            private final WeakReference<Component> myRoot;
            {
                super(crossEscInfo, autoCloseActionIds);
                this.myRoot = new WeakReference<Component>(contentPane);
            }

            @Override
            void onBeforeActionsExpand(@NotNull ActionGroup actionGroup2) {
                if (actionGroup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                List<AnAction> allActs = CtxDialogs.findAllTouchbarActions((Component)this.myRoot.get());
                actions2.removeAll();
                if (allActs != null) {
                    actions2.addAll(allActs);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/ui/mac/touchbar/CtxDialogs$1", "onBeforeActionsExpand"));
            }
        };
        customizer.addBaseCustomizations((pc, button4, presentation2) -> {
            button4.setModality(ms);
            boolean isDefault = false;
            TouchbarActionCustomizations ac = TouchbarActionCustomizations.getCustomizations((AnAction)button4.getAnAction());
            if (ac != null) {
                isDefault = ac.isDefault();
                if (!isDefault && ac.getComponent() instanceof JButton) {
                    JButton jb = (JButton)ac.getComponent();
                    isDefault = jb.getAction() != null ? jb.getAction().getValue("DefaultAction") != null : jb.isDefaultButton();
                }
                button4.setComponent(ac.getComponent());
                button4.setText(ac.isShowText() ? presentation2.getText() : null);
                button4.setIcon(ac.isShowImage() ? presentation2.getIcon() : null);
                if (ac.getComponent() instanceof JButton) {
                    button4.setLayout(107, 32768, 2, 16);
                }
            } else {
                TouchbarActionCustomizations parentAc = pc == null ? null : pc.getCustomizations();
                button4.setIconAndTextFromPresentation(presentation2, parentAc);
                button4.setComponent(parentAc == null ? null : parentAc.getComponent());
            }
            if (isDefault) {
                button4.setColored();
            }
        });
        TouchBarsManager.registerAndShow(contentPane, (ActionGroup)actions2, customizer);
        return () -> {
            LOG.debug("hide actions of window '%s'", new Object[]{contentPane});
            TouchBarsManager.unregister(contentPane);
        };
    }

    @Nullable
    private static List<AnAction> findAllTouchbarActions(@NotNull Component root2) {
        if (root2 == null) {
            CtxDialogs.$$$reportNull$$$0(1);
        }
        ArrayList<ActionGroup> result2 = null;
        JBIterable iter2 = ((JBTreeTraverser)UIUtil.uiTraverser((Component)root2).expandAndFilter(c -> c.isVisible())).traverse();
        for (Component component2 : iter2) {
            ActionGroup group2;
            if (!(component2 instanceof JComponent) || (group2 = Touchbar.getActions((JComponent)((JComponent)component2))) == null) continue;
            if (result2 == null) {
                result2 = new ArrayList<ActionGroup>();
            }
            result2.add(group2);
        }
        return result2;
    }

    private static boolean isCrossEscGroup(@NotNull ActionGroup group2) {
        if (group2 == null) {
            CtxDialogs.$$$reportNull$$$0(2);
        }
        for (AnAction child2 : group2.getChildren(null)) {
            TouchbarActionCustomizations customizations = TouchbarActionCustomizations.getCustomizations((AnAction)child2);
            if (customizations != null && customizations.isCrossEsc()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxDialogs";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showWindowActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findAllTouchbarActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCrossEscGroup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

