/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MessageMultilineInputDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TestDialogManager;
import com.intellij.openapi.ui.messages.AlertMessagesManager;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.ui.messages.TwoStepConfirmationDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.MessageException;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.mac.MacMessages;
import com.intellij.ui.messages.ChooseDialog;
import com.intellij.ui.messages.InputDialogWithCheckbox;
import com.intellij.ui.messages.MoreInfoMessageDialog;
import com.intellij.ui.messages.PasswordInputDialog;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesServiceImpl
implements MessagesService {
    private static final Logger LOG = Logger.getInstance(MessagesServiceImpl.class);

    public int showMessageDialog(@Nullable Project project, @Nullable Component parentComponent, String message2, @Nls(capitalization=Nls.Capitalization.Title) String title2, String @NotNull [] options2, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DoNotAskOption doNotAskOption, boolean alwaysUseIdeaUI, @Nullable String helpId) {
        if (options2 == null) {
            MessagesServiceImpl.$$$reportNull$$$0(0);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestImplementation().show(message2);
        }
        if (AlertMessagesManager.isEnabled()) {
            return AlertMessagesManager.instance().showMessageDialog(project, parentComponent, message2, title2, options2, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, helpId);
        }
        try {
            if (Messages.canShowMacSheetPanel() && !alwaysUseIdeaUI) {
                WindowManager windowManager;
                Object object = windowManager = LoadingState.COMPONENTS_REGISTERED.isOccurred() ? WindowManager.getInstance() : null;
                if (windowManager != null) {
                    Window parentWindow = windowManager.suggestParentWindow(project);
                    return MacMessages.getInstance().showMessageDialog(title2, message2, options2, parentWindow, defaultOptionIndex, focusedOptionIndex, doNotAskOption, icon2, null);
                }
            }
        }
        catch (MessageException windowManager) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MessageDialog dialog2 = new MessageDialog(project, parentComponent, message2, title2, options2, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, false, helpId);
        dialog2.show();
        return dialog2.getExitCode();
    }

    public int showMoreInfoMessageDialog(Project project, String message2, String title2, @NlsContexts.DetailedDescription String moreInfo, String[] options2, int defaultOptionIndex, int focusedOptionIndex, Icon icon2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestImplementation().show(message2);
        }
        try {
            if (Messages.canShowMacSheetPanel() && moreInfo == null) {
                return MacMessages.getInstance().showMessageDialog(title2, message2, options2, WindowManager.getInstance().suggestParentWindow(project), defaultOptionIndex, focusedOptionIndex, null, icon2, null);
            }
        }
        catch (MessageException messageException) {
        }
        catch (Exception reportThis) {
            LOG.error((Throwable)reportThis);
        }
        MoreInfoMessageDialog dialog2 = new MoreInfoMessageDialog(project, message2, title2, moreInfo, options2, defaultOptionIndex, focusedOptionIndex, icon2);
        dialog2.show();
        return dialog2.getExitCode();
    }

    public int showTwoStepConfirmationDialog(String message2, String title2, String[] options2, String checkboxText, boolean checked, int defaultOptionIndex, int focusedOptionIndex, Icon icon2, PairFunction<? super Integer, ? super JCheckBox, Integer> exitFunc) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestImplementation().show(message2);
        }
        TwoStepConfirmationDialog dialog2 = new TwoStepConfirmationDialog(message2, title2, options2, checkboxText, checked, defaultOptionIndex, focusedOptionIndex, icon2, exitFunc);
        dialog2.show();
        return dialog2.getExitCode();
    }

    public String showPasswordDialog(Project project, String message2, String title2, Icon icon2, InputValidator validator2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show(message2, validator2);
        }
        PasswordInputDialog dialog2 = project != null ? new PasswordInputDialog(project, message2, title2, icon2, validator2) : new PasswordInputDialog(message2, title2, icon2, validator2);
        dialog2.show();
        return dialog2.getInputString();
    }

    public char[] showPasswordDialog(@NotNull Component parentComponent, String message2, String title2, Icon icon2, @Nullable InputValidator validator2) {
        if (parentComponent == null) {
            MessagesServiceImpl.$$$reportNull$$$0(1);
        }
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show(message2, validator2).toCharArray();
        }
        PasswordInputDialog dialog2 = new PasswordInputDialog(parentComponent, message2, title2, icon2, validator2);
        dialog2.show();
        return dialog2.getExitCode() == 0 ? CredentialPromptDialog.getTrimmedChars(dialog2.getTextField()) : null;
    }

    public String showInputDialog(@Nullable Project project, Component parentComponent, String message2, String title2, @Nullable Icon icon2, @Nullable String initialValue, @Nullable InputValidator validator2, @Nullable TextRange selection, @Nullable @NlsContexts.DetailedDescription String comment) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show(message2, validator2);
        }
        Messages.InputDialog dialog2 = new Messages.InputDialog(project, message2, title2, icon2, initialValue, validator2, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0, comment);
        JTextComponent field = dialog2.getTextField();
        if (selection != null) {
            field.select(selection.getStartOffset(), selection.getEndOffset());
            field.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, true);
        }
        dialog2.show();
        return dialog2.getInputString();
    }

    public String showMultilineInputDialog(Project project, String message2, String title2, String initialValue, Icon icon2, @Nullable InputValidator validator2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show(message2, validator2);
        }
        MessageMultilineInputDialog dialog2 = new MessageMultilineInputDialog(project, message2, title2, icon2, initialValue, validator2, new String[]{Messages.getOkButton(), Messages.getCancelButton()}, 0);
        dialog2.show();
        return dialog2.getInputString();
    }

    public @NotNull Pair<@Nullable String, Boolean> showInputDialogWithCheckBox(String message2, String title2, String checkboxText, boolean checked, boolean checkboxEnabled, Icon icon2, String initialValue, InputValidator validator2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return new Pair((Object)TestDialogManager.getTestInputImplementation().show(message2), (Object)checked);
        }
        InputDialogWithCheckbox dialog2 = new InputDialogWithCheckbox(message2, title2, checkboxText, checked, checkboxEnabled, icon2, initialValue, validator2);
        dialog2.show();
        Pair pair = Pair.create((Object)dialog2.getInputString(), (Object)dialog2.isChecked());
        if (pair == null) {
            MessagesServiceImpl.$$$reportNull$$$0(2);
        }
        return pair;
    }

    public String showEditableChooseDialog(String message2, String title2, Icon icon2, String[] values2, @NlsSafe String initialValue, InputValidator validator2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestInputImplementation().show(message2, validator2);
        }
        ChooseDialog dialog2 = new ChooseDialog(message2, title2, icon2, values2, initialValue);
        dialog2.setValidator(validator2);
        dialog2.getComboBox().setEditable(true);
        dialog2.getComboBox().getEditor().setItem(initialValue);
        dialog2.getComboBox().setSelectedItem(initialValue);
        dialog2.show();
        return dialog2.getInputString();
    }

    public int showChooseDialog(@Nullable Project project, @Nullable Component parentComponent, String message2, String title2, String[] values2, String initialValue, @Nullable Icon icon2) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            return TestDialogManager.getTestImplementation().show(message2);
        }
        ChooseDialog dialog2 = new ChooseDialog(project, parentComponent, message2, title2, icon2, values2, initialValue);
        dialog2.show();
        return dialog2.getSelectedIndex();
    }

    public void showTextAreaDialog(JTextField textField2, String title2, String dimensionServiceKey, Function<? super String, ? extends List<String>> parser, Function<? super List<String>, String> lineJoiner) {
        if (Messages.isApplicationInUnitTestOrHeadless()) {
            TestDialogManager.getTestImplementation().show(title2);
            return;
        }
        JTextArea textArea2 = new JTextArea(10, 50);
        UIUtil.addUndoRedoActions((JTextComponent)textArea2);
        textArea2.setWrapStyleWord(true);
        textArea2.setLineWrap(true);
        List lines2 = (List)parser.fun((Object)textField2.getText());
        textArea2.setText(StringUtil.join((Collection)lines2, (String)"\n"));
        InsertPathAction.copyFromTo((JTextComponent)textField2, (JTextComponent)textArea2);
        DialogBuilder builder2 = new DialogBuilder((Component)textField2);
        builder2.setDimensionServiceKey(dimensionServiceKey);
        builder2.setCenterPanel((JComponent)ScrollPaneFactory.createScrollPane((Component)textArea2));
        builder2.setPreferredFocusComponent((JComponent)textArea2);
        String rawText = title2;
        if (StringUtil.endsWithChar((CharSequence)rawText, (char)':')) {
            rawText = rawText.substring(0, rawText.length() - 1);
        }
        builder2.setTitle(rawText);
        builder2.addOkAction();
        builder2.addCancelAction();
        builder2.setOkOperation(() -> {
            textField2.setText((String)lineJoiner.fun(Arrays.asList(StringUtil.splitByLines((String)textArea2.getText()))));
            builder2.getDialogWrapper().close(0);
        });
        builder2.show();
    }

    public boolean isAlertEnabled() {
        return AlertMessagesManager.isEnabled();
    }

    public void showErrorDialog(@Nullable Project project, @Nullable @NlsContexts.DialogMessage String message2, @NotNull @NlsContexts.DialogTitle String title2) {
        if (title2 == null) {
            MessagesServiceImpl.$$$reportNull$$$0(3);
        }
        Messages.showErrorDialog((Project)project, (String)message2, (String)title2);
    }

    public void showInfoMessage(@NotNull Component component2, @NotNull @NlsContexts.DialogMessage String message2, @NotNull @NlsContexts.DialogTitle String title2) {
        if (component2 == null) {
            MessagesServiceImpl.$$$reportNull$$$0(4);
        }
        if (message2 == null) {
            MessagesServiceImpl.$$$reportNull$$$0(5);
        }
        if (title2 == null) {
            MessagesServiceImpl.$$$reportNull$$$0(6);
        }
        Messages.showInfoMessage((Component)component2, (String)message2, (String)title2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/messages/MessagesServiceImpl";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/messages/MessagesServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "showInputDialogWithCheckBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showMessageDialog";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showPasswordDialog";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showInfoMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

