/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.popup.ActionStepBuilder;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ui.StatusText;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionPopupStep
implements ListPopupStepEx<PopupFactoryImpl.ActionItem>,
MnemonicNavigationFilter<PopupFactoryImpl.ActionItem>,
SpeedSearchFilter<PopupFactoryImpl.ActionItem> {
    private static final Logger LOG = Logger.getInstance(ActionPopupStep.class);
    private final List<PopupFactoryImpl.ActionItem> myItems;
    private final @NlsContexts.PopupTitle @Nullable String myTitle;
    private final Supplier<? extends DataContext> myContext;
    private final String myActionPlace;
    private final boolean myEnableMnemonics;
    private final PresentationFactory myPresentationFactory;
    private final int myDefaultOptionIndex;
    private final boolean myAutoSelectionEnabled;
    private final boolean myShowDisabledActions;
    private Runnable myFinalRunnable;
    private final Condition<? super AnAction> myPreselectActionCondition;

    public ActionPopupStep(@NotNull List<PopupFactoryImpl.ActionItem> items, @NlsContexts.PopupTitle @Nullable String title2, @NotNull Supplier<? extends DataContext> context2, @Nullable String actionPlace, boolean enableMnemonics, @Nullable Condition<? super AnAction> preselectActionCondition, boolean autoSelection, boolean showDisabledActions, @Nullable PresentationFactory presentationFactory) {
        if (items == null) {
            ActionPopupStep.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            ActionPopupStep.$$$reportNull$$$0(1);
        }
        this.myItems = items;
        this.myTitle = title2;
        this.myContext = context2;
        this.myActionPlace = ActionPlaces.getPopupPlace((String)actionPlace);
        this.myEnableMnemonics = enableMnemonics;
        this.myPresentationFactory = presentationFactory;
        this.myDefaultOptionIndex = ActionPopupStep.getDefaultOptionIndexFromSelectCondition(preselectActionCondition, items);
        this.myPreselectActionCondition = preselectActionCondition;
        this.myAutoSelectionEnabled = autoSelection;
        this.myShowDisabledActions = showDisabledActions;
        if (actionPlace != null && !ActionPlaces.isPopupPlace((String)actionPlace)) {
            LOG.error("ActionPlaces.isPopupPlace(" + actionPlace + ")==false. Use ActionPlaces.getPopupPlace.");
        }
    }

    private static int getDefaultOptionIndexFromSelectCondition(@Nullable Condition<? super AnAction> preselectActionCondition, @NotNull List<? extends PopupFactoryImpl.ActionItem> items) {
        if (items == null) {
            ActionPopupStep.$$$reportNull$$$0(2);
        }
        int defaultOptionIndex = 0;
        if (preselectActionCondition != null) {
            for (int i2 = 0; i2 < items.size(); ++i2) {
                AnAction action2 = items.get(i2).getAction();
                if (!preselectActionCondition.value((Object)action2)) continue;
                defaultOptionIndex = i2;
                break;
            }
        }
        return defaultOptionIndex;
    }

    @NotNull
    public static ListPopupStep<PopupFactoryImpl.ActionItem> createActionsStep(@NotNull ActionGroup actionGroup2, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, @NlsContexts.PopupTitle @Nullable String title2, boolean honorActionMnemonics, boolean autoSelectionEnabled, Supplier<? extends DataContext> contextSupplier, @Nullable String actionPlace, Condition<? super AnAction> preselectCondition, int defaultOptionIndex, @Nullable PresentationFactory presentationFactory) {
        if (actionGroup2 == null) {
            ActionPopupStep.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ActionPopupStep.$$$reportNull$$$0(4);
        }
        List<PopupFactoryImpl.ActionItem> items = ActionPopupStep.createActionItems(actionGroup2, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace, presentationFactory);
        boolean enableMnemonics = showNumbers || honorActionMnemonics && items.stream().anyMatch(actionItem -> actionItem.getAction().getTemplatePresentation().getMnemonic() != 0);
        return new ActionPopupStep(items, title2, contextSupplier, actionPlace, enableMnemonics, (Condition<? super AnAction>)(preselectCondition != null ? preselectCondition : action2 -> defaultOptionIndex >= 0 && defaultOptionIndex < items.size() && ((PopupFactoryImpl.ActionItem)items.get(defaultOptionIndex)).getAction().equals(action2)), autoSelectionEnabled, showDisabledActions, presentationFactory);
    }

    @NotNull
    public static List<PopupFactoryImpl.ActionItem> createActionItems(@NotNull ActionGroup actionGroup2, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory) {
        if (actionGroup2 == null) {
            ActionPopupStep.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            ActionPopupStep.$$$reportNull$$$0(6);
        }
        if (actionPlace != null && !ActionPlaces.isPopupPlace((String)actionPlace)) {
            LOG.error("ActionPlaces.isPopupPlace(" + actionPlace + ")==false. Use ActionPlaces.getPopupPlace.");
            actionPlace = ActionPlaces.getPopupPlace((String)actionPlace);
        }
        DataContext wrappedContext = Utils.wrapDataContext(dataContext);
        ActionStepBuilder builder2 = new ActionStepBuilder(wrappedContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace, presentationFactory);
        builder2.buildGroup(actionGroup2);
        List<PopupFactoryImpl.ActionItem> list2 = builder2.getItems();
        if (list2 == null) {
            ActionPopupStep.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PopupFactoryImpl.ActionItem> getValues() {
        List<PopupFactoryImpl.ActionItem> list2 = this.myItems;
        if (list2 == null) {
            ActionPopupStep.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public boolean isSelectable(PopupFactoryImpl.ActionItem value2) {
        return value2.isEnabled();
    }

    @Override
    public int getMnemonicPos(PopupFactoryImpl.ActionItem value2) {
        String text2 = this.getTextFor(value2);
        int i2 = text2.indexOf(27);
        if (i2 < 0) {
            i2 = text2.indexOf(38);
        }
        if (i2 < 0) {
            i2 = text2.indexOf(95);
        }
        return i2;
    }

    @Override
    @Nullable
    public String getMnemonicString(PopupFactoryImpl.ActionItem value2) {
        if (value2.digitMnemonicsEnabled()) {
            Character res2 = value2.getMnemonicChar();
            return res2 != null ? res2.toString() : null;
        }
        return MnemonicNavigationFilter.super.getMnemonicString(value2);
    }

    public Icon getIconFor(PopupFactoryImpl.ActionItem aValue) {
        return aValue.getIcon(false);
    }

    public Icon getSelectedIconFor(PopupFactoryImpl.ActionItem value2) {
        return value2.getIcon(true);
    }

    @Override
    @NotNull
    public String getTextFor(PopupFactoryImpl.ActionItem value2) {
        String string = value2.getText();
        if (string == null) {
            ActionPopupStep.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public String getTooltipTextFor(PopupFactoryImpl.ActionItem value2) {
        return value2.getTooltip();
    }

    public void setEmptyText(@NotNull StatusText emptyText) {
        if (emptyText == null) {
            ActionPopupStep.$$$reportNull$$$0(10);
        }
    }

    @Nullable
    public String getValueFor(PopupFactoryImpl.ActionItem item) {
        return item.getValue();
    }

    public ListSeparator getSeparatorAbove(PopupFactoryImpl.ActionItem value2) {
        return value2.isPrependWithSeparator() ? new ListSeparator(value2.getSeparatorText()) : null;
    }

    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public PopupStep<?> onChosen(PopupFactoryImpl.ActionItem actionChoice, boolean finalChoice) {
        return this.onChosen(actionChoice, finalChoice, 0);
    }

    public PopupStep<?> onChosen(PopupFactoryImpl.ActionItem actionChoice, boolean finalChoice, int eventModifiers) {
        if (!actionChoice.isEnabled()) {
            return FINAL_CHOICE;
        }
        AnAction action2 = actionChoice.getAction();
        DataContext dataContext = this.myContext.get();
        if (!(!(action2 instanceof ActionGroup) || finalChoice && ((ActionGroup)action2).canBePerformed(dataContext))) {
            return ActionPopupStep.createActionsStep((ActionGroup)action2, dataContext, this.myEnableMnemonics, true, this.myShowDisabledActions, null, false, false, this.myContext, this.myActionPlace, this.myPreselectActionCondition, -1, this.myPresentationFactory);
        }
        this.myFinalRunnable = () -> this.performAction(action2, eventModifiers);
        return FINAL_CHOICE;
    }

    public boolean isFinal(PopupFactoryImpl.ActionItem value2) {
        if (!value2.isEnabled()) {
            return true;
        }
        AnAction action2 = value2.getAction();
        DataContext dataContext = this.myContext.get();
        return !(action2 instanceof ActionGroup) || ((ActionGroup)action2).canBePerformed(dataContext);
    }

    public void performAction(@NotNull AnAction action2, int modifiers) {
        if (action2 == null) {
            ActionPopupStep.$$$reportNull$$$0(11);
        }
        this.performAction(action2, modifiers, null);
    }

    public void performAction(@NotNull AnAction action2, int modifiers, InputEvent inputEvent) {
        if (action2 == null) {
            ActionPopupStep.$$$reportNull$$$0(12);
        }
        DataContext dataContext = this.myContext.get();
        AnActionEvent event = new AnActionEvent(inputEvent, dataContext, this.myActionPlace, action2.getTemplatePresentation().clone(), ActionManager.getInstance(), modifiers);
        event.setInjectedContext(action2.isInInjectedContext());
        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false)) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)event);
        }
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    public boolean hasSubstep(PopupFactoryImpl.ActionItem selectedValue) {
        return selectedValue != null && selectedValue.isEnabled() && selectedValue.getAction() instanceof ActionGroup;
    }

    public void canceled() {
    }

    public boolean isMnemonicsNavigationEnabled() {
        return this.myEnableMnemonics;
    }

    public MnemonicNavigationFilter<PopupFactoryImpl.ActionItem> getMnemonicNavigationFilter() {
        return this;
    }

    @Override
    public String getIndexedString(PopupFactoryImpl.ActionItem value2) {
        return this.getTextFor(value2);
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return this.myAutoSelectionEnabled;
    }

    public SpeedSearchFilter<PopupFactoryImpl.ActionItem> getSpeedSearchFilter() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/ActionPopupStep";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/ActionPopupStep";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOptionIndexFromSelectCondition";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createActionsStep";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createActionItems";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

