/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakList;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StackingPopupDispatcherImpl
extends StackingPopupDispatcher
implements AWTEventListener,
KeyEventDispatcher {
    private final Stack<JBPopup> myStack = new Stack();
    private final Collection<JBPopup> myPersistentPopups = new WeakList();
    private final Collection<JBPopup> myAllPopups = new WeakList();

    private StackingPopupDispatcherImpl() {
    }

    public void onPopupShown(JBPopup popup2, boolean inStack) {
        if (inStack) {
            this.myStack.push((Object)popup2);
            if (ApplicationManager.getApplication() != null) {
                IdeEventQueue.getInstance().getPopupManager().push((IdePopupEventDispatcher)StackingPopupDispatcherImpl.getInstance());
            }
        } else if (popup2.isPersistent()) {
            this.myPersistentPopups.add(popup2);
        }
        this.myAllPopups.add(popup2);
    }

    public void onPopupHidden(JBPopup popup2) {
        boolean wasInStack = this.myStack.remove((Object)popup2);
        this.myPersistentPopups.remove(popup2);
        if (wasInStack && this.myStack.isEmpty() && ApplicationManager.getApplication() != null) {
            IdeEventQueue.getInstance().getPopupManager().remove((IdePopupEventDispatcher)this);
        }
        this.myAllPopups.remove(popup2);
    }

    public void hidePersistentPopups() {
        for (JBPopup each : this.myPersistentPopups) {
            if (!each.isNativePopup()) continue;
            each.setUiVisible(false);
        }
    }

    public void restorePersistentPopups() {
        for (JBPopup each : this.myPersistentPopups) {
            if (!each.isNativePopup()) continue;
            each.setUiVisible(true);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.dispatchMouseEvent(event);
    }

    private boolean dispatchMouseEvent(AWTEvent event) {
        if (event.getID() != 501) {
            return false;
        }
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.findPopup();
        MouseEvent mouseEvent = (MouseEvent)event;
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        while (true) {
            if (popup2 != null && !popup2.isDisposed()) {
                Window window = ComponentUtil.getWindow((Component)mouseEvent.getComponent());
                if (window != null && window != popup2.getPopupWindow() && SwingUtilities.isDescendingFrom(window, popup2.getPopupWindow())) {
                    return false;
                }
                JComponent content2 = popup2.getContent();
                if (!content2.isShowing()) {
                    popup2.cancel();
                    return false;
                }
                Rectangle bounds2 = new Rectangle(content2.getLocationOnScreen(), content2.getSize());
                if (bounds2.contains(point) || !popup2.isCancelOnClickOutside()) {
                    return false;
                }
                if (!popup2.canClose()) {
                    return false;
                }
                if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                    return false;
                }
                popup2.cancel(mouseEvent);
            }
            if (this.myStack.isEmpty()) {
                return false;
            }
            popup2 = (AbstractPopup)this.myStack.peek();
            if (popup2 != null && !popup2.isDisposed()) continue;
            this.myStack.pop();
        }
    }

    @ApiStatus.Internal
    @Nullable
    public JBPopup findPopup() {
        while (!this.myStack.isEmpty()) {
            AbstractPopup each = (AbstractPopup)this.myStack.peek();
            if (each != null && !each.isDisposed()) {
                return each;
            }
            this.myStack.pop();
        }
        return null;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        JBPopup popup2;
        boolean closeRequest = AbstractPopup.isCloseRequest(e);
        JBPopup jBPopup = popup2 = closeRequest ? this.findPopup() : this.getFocusedPopup();
        if (popup2 == null) {
            return false;
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window instanceof Dialog && ((Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(popup2.getContent(), window)) {
            return false;
        }
        return popup2.dispatchKeyEvent(e);
    }

    @Nullable
    public Component getComponent() {
        return this.myStack.isEmpty() || ((JBPopup)this.myStack.peek()).isDisposed() ? null : ((JBPopup)this.myStack.peek()).getContent();
    }

    @NotNull
    public Stream<JBPopup> getPopupStream() {
        Stream stream = this.myStack.stream();
        if (stream == null) {
            StackingPopupDispatcherImpl.$$$reportNull$$$0(0);
        }
        return stream;
    }

    public boolean dispatch(AWTEvent event) {
        if (event instanceof KeyEvent) {
            return this.dispatchKeyEvent((KeyEvent)event);
        }
        return event instanceof MouseEvent && this.dispatchMouseEvent(event);
    }

    public boolean requestFocus() {
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.myStack.peek();
        return popup2.requestFocus();
    }

    public boolean close() {
        int next;
        if (!this.closeActivePopup()) {
            return false;
        }
        int size = this.myStack.size();
        while (this.closeActivePopup() && size != (next = this.myStack.size())) {
            size = next;
        }
        return true;
    }

    public void setRestoreFocusSilently() {
        if (this.myStack.isEmpty()) {
            return;
        }
        for (JBPopup each : this.myAllPopups) {
            if (!(each instanceof AbstractPopup)) continue;
            ((AbstractPopup)each).setOk(true);
        }
    }

    public boolean closeActivePopup() {
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.myStack.peek();
        if (popup2 != null && popup2.isVisible() && popup2.isCancelOnWindowDeactivation() && popup2.canClose()) {
            popup2.cancel();
            return !popup2.isVisible();
        }
        return false;
    }

    public boolean isPopupFocused() {
        return this.getFocusedPopup() != null;
    }

    @Nullable
    public JBPopup getFocusedPopup() {
        for (JBPopup each : this.myAllPopups) {
            if (each == null || !each.isFocused()) continue;
            return each;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/StackingPopupDispatcherImpl", "getPopupStream"));
    }
}

