/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.ui.win.JumpTask;
import com.intellij.ui.win.WinShellIntegration;
import com.intellij.util.PathUtil;
import com.intellij.util.system.CpuArch;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;

public final class WinDockDelegate
implements SystemDock.Delegate {
    private final @NotNull Future<@Nullable WinShellIntegration> wsiFuture;
    private static final Logger LOG = Logger.getInstance(WinDockDelegate.class);
    @Nullable
    private static final WinDockDelegate instance;

    @Nullable
    public static WinDockDelegate getInstance() {
        return instance;
    }

    @Override
    public void updateRecentProjectsMenu() {
        Throwable stackTraceHolder = new Throwable("Asynchronously launched from here");
        ForkJoinPool.commonPool().execute(() -> {
            try {
                WinShellIntegration wsi = this.wsiFuture.get(30L, TimeUnit.SECONDS);
                if (wsi == null) {
                    return;
                }
                List<AnAction> recentProjectActions = RecentProjectListActionProvider.getInstance().getActions(false);
                @NotNull JumpTask @NotNull [] jumpTasks = WinDockDelegate.convertToJumpTasks(recentProjectActions);
                wsi.postShellTask(ctx -> {
                    if (jumpTasks == null) {
                        WinDockDelegate.$$$reportNull$$$0(4);
                    }
                    ctx.clearRecentTasksList();
                    ctx.setRecentTasksList(jumpTasks);
                }).get();
            }
            catch (InterruptedException e) {
                e.addSuppressed(stackTraceHolder);
                LOG.warn((Throwable)e);
            }
            catch (Throwable e) {
                e.addSuppressed(stackTraceHolder);
                LOG.error(e);
            }
        });
    }

    private WinDockDelegate(@NotNull Future<@Nullable WinShellIntegration> wsiFuture) {
        if (wsiFuture == null) {
            WinDockDelegate.$$$reportNull$$$0(0);
        }
        this.wsiFuture = wsiFuture;
    }

    @NotNull
    private static @NotNull JumpTask @NotNull [] convertToJumpTasks(@NotNull List<AnAction> actions2) {
        if (actions2 == null) {
            WinDockDelegate.$$$reportNull$$$0(1);
        }
        String launcherFileName = ApplicationNamesInfo.getInstance().getScriptName() + (CpuArch.isIntel64() ? "64" : "") + ".exe";
        String launcherPath = Paths.get(PathManager.getBinPath(), launcherFileName).toString();
        @NotNull JumpTask @NotNull [] result2 = new JumpTask[actions2.size()];
        int i2 = 0;
        for (AnAction action2 : actions2) {
            Object taskTooltip;
            String taskTitle;
            if (!(action2 instanceof ReopenProjectAction)) {
                LOG.debug("Failed to convert an action \"" + action2 + "\" to Jump Task: the action is not ReopenProjectAction");
                continue;
            }
            ReopenProjectAction reopenProjectAction = (ReopenProjectAction)action2;
            @SystemIndependent String projectPath = reopenProjectAction.getProjectPath();
            @SystemDependent String projectPathSystem = PathUtil.toSystemDependentName((String)projectPath);
            if (Strings.isEmptyOrSpaces((CharSequence)projectPathSystem)) {
                LOG.debug("Failed to convert a ReopenProjectAction \"" + reopenProjectAction + "\" to Jump Task: path to the project is empty (\"" + projectPathSystem + "\")");
                continue;
            }
            String presentationText = reopenProjectAction.getTemplatePresentation().getText();
            if (!Strings.isEmptyOrSpaces((CharSequence)presentationText)) {
                taskTitle = presentationText;
                taskTooltip = presentationText + " (" + projectPathSystem + ")";
            } else {
                String projectName = reopenProjectAction.getProjectNameToDisplay();
                if (!Strings.isEmptyOrSpaces((CharSequence)projectName)) {
                    taskTitle = projectName;
                    taskTooltip = projectName + " (" + projectPathSystem + ")";
                } else {
                    taskTitle = projectPathSystem;
                    taskTooltip = projectPathSystem;
                }
            }
            String taskArgs = "\"" + projectPathSystem + "\"";
            result2[i2++] = new JumpTask(taskTitle, launcherPath, taskArgs, (String)taskTooltip);
        }
        if (i2 < result2.length) {
            JumpTask[] jumpTaskArray = Arrays.copyOf(result2, i2);
            if (jumpTaskArray == null) {
                WinDockDelegate.$$$reportNull$$$0(2);
            }
            return jumpTaskArray;
        }
        if (result2 == null) {
            WinDockDelegate.$$$reportNull$$$0(3);
        }
        return result2;
    }

    static {
        Throwable stackTraceHolder = new Throwable("Asynchronously launched from here");
        @NotNull Future wsiFuture = ForkJoinPool.commonPool().submit(() -> {
            try {
                if (!Registry.is((String)"windows.jumplist")) {
                    return null;
                }
                return WinShellIntegration.getInstance();
            }
            catch (Throwable err) {
                err.addSuppressed(stackTraceHolder);
                LOG.error("Failed to initialize com.intellij.ui.win.WinShellIntegration instance", err);
                return null;
            }
        });
        instance = new WinDockDelegate(wsiFuture);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsiFuture";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/win/WinDockDelegate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jumpTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/win/WinDockDelegate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToJumpTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "convertToJumpTasks";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateRecentProjectsMenu$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

