/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Deprecated(forRemoval=true)
@ApiStatus.ScheduledForRemoval(inVersion="2022.1")
public final class JdkBundle {
    private static final String BUNDLED_JDK_DIR_NAME = "jbr";
    private final File myLocation;
    private final JdkVersionDetector.JdkVersionInfo myVersionInfo;
    private final boolean myBoot;
    private final boolean myBundled;
    private final boolean myJdk;

    private JdkBundle(File location, JdkVersionDetector.JdkVersionInfo versionInfo, boolean boot, boolean bundled, boolean jdk) {
        this.myLocation = location;
        this.myVersionInfo = versionInfo;
        this.myBoot = boot;
        this.myBundled = bundled;
        this.myJdk = jdk;
    }

    @NotNull
    public File getLocation() {
        File file2 = this.myLocation;
        if (file2 == null) {
            JdkBundle.$$$reportNull$$$0(0);
        }
        return file2;
    }

    @NotNull
    public JavaVersion getBundleVersion() {
        JavaVersion javaVersion = this.myVersionInfo.version;
        if (javaVersion == null) {
            JdkBundle.$$$reportNull$$$0(1);
        }
        return javaVersion;
    }

    @NotNull
    public Bitness getBitness() {
        Bitness bitness = this.myVersionInfo.bitness;
        if (bitness == null) {
            JdkBundle.$$$reportNull$$$0(2);
        }
        return bitness;
    }

    public boolean isBoot() {
        return this.myBoot;
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public boolean isJdk() {
        return this.myJdk;
    }

    @NotNull
    public File getHome() {
        File file2 = this.getVMExecutable().getParentFile().getParentFile();
        if (file2 == null) {
            JdkBundle.$$$reportNull$$$0(3);
        }
        return file2;
    }

    @NotNull
    public File getVMExecutable() {
        File javaPath;
        File contents;
        File home2 = this.myLocation;
        if (SystemInfo.isMac && (contents = new File(home2, "Contents/Home")).isDirectory()) {
            home2 = contents;
        }
        if (!(javaPath = new File(home2, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java")).isFile()) {
            javaPath = new File(home2, SystemInfo.isWindows ? "jre\\bin\\java.exe" : "jre/bin/java");
        }
        File file2 = javaPath;
        if (file2 == null) {
            JdkBundle.$$$reportNull$$$0(4);
        }
        return file2;
    }

    public boolean isOperational() {
        if (this.myBoot) {
            return true;
        }
        File javaPath = this.getVMExecutable();
        if (SystemInfo.isUnix && !javaPath.canExecute()) {
            return false;
        }
        try {
            ProcessOutput output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{javaPath.getPath(), "-version"}));
            return output2.getExitCode() == 0;
        }
        catch (ExecutionException e) {
            Logger.getInstance(JdkBundle.class).debug((Throwable)e);
            return false;
        }
    }

    @NotNull
    public static JdkBundle createBoot() {
        File home2 = new File(SystemProperties.getJavaHome());
        JdkBundle bundle = JdkBundle.createBundle(home2, true);
        assert (bundle != null) : home2;
        JdkBundle jdkBundle = bundle;
        if (jdkBundle == null) {
            JdkBundle.$$$reportNull$$$0(5);
        }
        return jdkBundle;
    }

    @Nullable
    public static JdkBundle createBundled() {
        return JdkBundle.createBundle(new File(PathManager.getHomePath(), BUNDLED_JDK_DIR_NAME), false);
    }

    @Nullable
    public static JdkBundle createBundle(@NotNull File bundleHome) {
        if (bundleHome == null) {
            JdkBundle.$$$reportNull$$$0(6);
        }
        return JdkBundle.createBundle(bundleHome, false);
    }

    private static JdkBundle createBundle(File bundleHome, boolean boot) {
        JdkVersionDetector.JdkVersionInfo versionInfo;
        File jdk;
        if ("jre".equals(bundleHome.getName()) && new File(jdk = bundleHome.getParentFile(), "lib").isDirectory()) {
            bundleHome = jdk;
        }
        File actualHome = bundleHome;
        if (SystemInfo.isMac) {
            if (actualHome.getName().equals("Home") && actualHome.getParentFile().getName().equals("Contents")) {
                bundleHome = actualHome.getParentFile().getParentFile();
            } else {
                File contents = new File(bundleHome, "Contents/Home");
                if (contents.isDirectory()) {
                    actualHome = contents;
                }
            }
        }
        if ((versionInfo = boot ? new JdkVersionDetector.JdkVersionInfo(JavaVersion.current(), SystemInfo.is64Bit ? Bitness.x64 : Bitness.x32, null) : JdkVersionDetector.getInstance().detectJdkVersionInfo(actualHome.getPath())) != null) {
            boolean bundled = PathManager.isUnderHomeDirectory((String)bundleHome.getPath());
            boolean jdk2 = JdkUtil.checkForJdk((Path)actualHome.toPath());
            return new JdkBundle(bundleHome, versionInfo, boot, bundled, jdk2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JdkBundle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBitness";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHome";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVMExecutable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createBoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JdkBundle";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBundle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

