/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeIndexingInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.EntityIndexingService;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.RootChangesLogger;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootsChangeListener;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

class EntityIndexingServiceImpl
implements EntityIndexingService {
    private static final Logger LOG = Logger.getInstance(EntityIndexingServiceImpl.class);
    private static final RootChangesLogger ROOT_CHANGES_LOGGER = new RootChangesLogger();

    EntityIndexingServiceImpl() {
    }

    @Override
    public void indexChanges(@NotNull Project project, @NotNull List<? extends RootsChangeIndexingInfo> changes) {
        if (project == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(1);
        }
        if (!(FileBasedIndex.getInstance() instanceof FileBasedIndexImpl)) {
            return;
        }
        if (changes.isEmpty()) {
            EntityIndexingServiceImpl.runFullReindex(project, "Project roots have changed");
        }
        if (Registry.is((String)"indexing.full.rescan.on.workspace.model.changes")) {
            EntityIndexingServiceImpl.runFullReindex(project, "Reindex requested by project root model changes (full rescanning forced by registry key)");
            return;
        }
        for (RootsChangeIndexingInfo rootsChangeIndexingInfo : changes) {
            if (rootsChangeIndexingInfo != RootsChangeIndexingInfo.TOTAL_REINDEX) continue;
            EntityIndexingServiceImpl.runFullReindex(project, "Reindex requested by project root model changes");
            return;
        }
        SmartList builders = new SmartList();
        WorkspaceEntityStorage workspaceEntityStorage = WorkspaceModel.getInstance(project).getEntityStorage().getCurrent();
        for (RootsChangeIndexingInfo rootsChangeIndexingInfo : changes) {
            if (rootsChangeIndexingInfo == RootsChangeIndexingInfo.NO_INDEXING_NEEDED) continue;
            if (rootsChangeIndexingInfo instanceof ProjectRootsChangeListener.WorkspaceEventIndexingInfo) {
                builders.addAll(EntityIndexingServiceImpl.getBuildersOnWorkspaceChange(project, ((ProjectRootsChangeListener.WorkspaceEventIndexingInfo)rootsChangeIndexingInfo).getEvents()));
                continue;
            }
            LOG.warn("Unexpected change " + rootsChangeIndexingInfo.getClass() + " " + rootsChangeIndexingInfo + ", full reindex requested");
            EntityIndexingServiceImpl.runFullReindex(project, "Reindex on unexpected change in EntityIndexingServiceImpl");
            return;
        }
        if (!builders.isEmpty()) {
            List<IndexableFilesIterator> mergedIterators = IndexableIteratorBuilders.INSTANCE.instantiateBuilders((List<? extends IndexableEntityProvider.IndexableIteratorBuilder>)builders, project, workspaceEntityStorage);
            List list2 = ContainerUtil.map(mergedIterators, it -> it.getDebugName());
            LOG.debug("Accumulated iterators: " + list2);
            int maxNamesToLog = 10;
            String reasonMessage = "changes in: " + list2.stream().limit(maxNamesToLog).map(n -> StringUtil.wrapWithDoubleQuote((String)n)).collect(Collectors.joining(", "));
            if (list2.size() > maxNamesToLog) {
                reasonMessage = reasonMessage + " and " + (list2.size() - maxNamesToLog) + " iterators more";
            }
            EntityIndexingServiceImpl.logRootChanges(project, false);
            new UnindexedFilesUpdater(project, mergedIterators, reasonMessage).queue(project);
        }
    }

    private static void runFullReindex(@NotNull Project project, @NotNull @NonNls String reason) {
        if (project == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(2);
        }
        if (reason == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(3);
        }
        EntityIndexingServiceImpl.logRootChanges(project, true);
        new UnindexedFilesUpdater(project, reason).queue(project);
    }

    private static void logRootChanges(@NotNull Project project, boolean isFullReindex) {
        if (project == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (LOG.isDebugEnabled()) {
                String message2 = isFullReindex ? "Project roots of " + project.getName() + " have changed" : "Project roots of " + project.getName() + " will be partially reindexed";
                LOG.debug(message2, new Throwable());
            }
        } else {
            ROOT_CHANGES_LOGGER.info(project, isFullReindex);
        }
    }

    @TestOnly
    @NotNull
    static List<IndexableFilesIterator> getIterators(@NotNull Project project, @NotNull Collection<EntityChange<?>> events) {
        if (project == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(5);
        }
        if (events == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(6);
        }
        WorkspaceEntityStorage entityStorage = WorkspaceModel.getInstance(project).getEntityStorage().getCurrent();
        List<IndexableEntityProvider.IndexableIteratorBuilder> result2 = EntityIndexingServiceImpl.getBuildersOnWorkspaceChange(project, events);
        List<IndexableFilesIterator> list2 = IndexableIteratorBuilders.INSTANCE.instantiateBuilders(result2, project, entityStorage);
        if (list2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private static List<IndexableEntityProvider.IndexableIteratorBuilder> getBuildersOnWorkspaceChange(@NotNull Project project, @NotNull Collection<EntityChange<?>> event) {
        if (project == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(8);
        }
        if (event == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(9);
        }
        SmartList builders = new SmartList();
        for (EntityChange<?> change : event) {
            Object entity;
            if (change instanceof EntityChange.Added) {
                entity = ((EntityChange.Added)change).getEntity();
                EntityIndexingServiceImpl.collectIteratorBuildersOnAdd(entity, project, (Collection<IndexableEntityProvider.IndexableIteratorBuilder>)builders);
                continue;
            }
            if (change instanceof EntityChange.Replaced) {
                Object newEntity2 = ((EntityChange.Replaced)change).getNewEntity();
                Object oldEntity = ((EntityChange.Replaced)change).getOldEntity();
                EntityIndexingServiceImpl.collectIteratorBuildersOnReplace(oldEntity, newEntity2, project, (Collection<IndexableEntityProvider.IndexableIteratorBuilder>)builders);
                continue;
            }
            if (change instanceof EntityChange.Removed) {
                entity = ((EntityChange.Removed)change).getEntity();
                EntityIndexingServiceImpl.collectIteratorBuildersOnRemove(entity, project, (Collection<IndexableEntityProvider.IndexableIteratorBuilder>)builders);
                continue;
            }
            LOG.error("Unexpected change " + change.getClass() + " " + change);
        }
        SmartList smartList = builders;
        if (smartList == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static <E extends WorkspaceEntity> void collectIteratorBuildersOnAdd(@NotNull E entity, @NotNull Project project, @NotNull Collection<IndexableEntityProvider.IndexableIteratorBuilder> builders) {
        if (entity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(11);
        }
        if (project == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(12);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(13);
        }
        Class<?> entityClass = entity.getClass();
        for (IndexableEntityProvider provider2 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
            if (entityClass != provider2.getEntityClass()) continue;
            builders.addAll(provider2.getAddedEntityIteratorBuilders(entity, project));
        }
    }

    private static <E extends WorkspaceEntity> void collectIteratorBuildersOnReplace(@NotNull E oldEntity, @NotNull E newEntity2, @NotNull Project project, @NotNull Collection<IndexableEntityProvider.IndexableIteratorBuilder> builders) {
        if (oldEntity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(14);
        }
        if (newEntity2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(15);
        }
        if (project == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(16);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(17);
        }
        Class<?> entityClass = oldEntity.getClass();
        for (IndexableEntityProvider provider2 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
            if (entityClass != provider2.getEntityClass()) continue;
            builders.addAll(provider2.getReplacedEntityIteratorBuilders(oldEntity, newEntity2));
        }
        if (oldEntity instanceof ModuleEntity) {
            ModuleEntity oldModule = (ModuleEntity)oldEntity;
            ModuleEntity newModule = (ModuleEntity)newEntity2;
            for (IndexableEntityProvider provider3 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
                if (!(provider3 instanceof IndexableEntityProvider.ModuleEntityDependent)) continue;
                builders.addAll(((IndexableEntityProvider.ModuleEntityDependent)provider3).getReplacedModuleEntityIteratorBuilder(oldModule, newModule, project));
            }
        }
    }

    private static <E extends WorkspaceEntity> void collectIteratorBuildersOnRemove(@NotNull E entity, @NotNull Project project, @NotNull Collection<IndexableEntityProvider.IndexableIteratorBuilder> builders) {
        if (entity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(18);
        }
        if (project == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(19);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(20);
        }
        Class<?> entityClass = entity.getClass();
        for (IndexableEntityProvider provider2 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
            if (entityClass != provider2.getEntityClass()) continue;
            builders.addAll(provider2.getRemovedEntityIteratorBuilders(entity, project));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/EntityIndexingServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldEntity";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/EntityIndexingServiceImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterators";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildersOnWorkspaceChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "indexChanges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runFullReindex";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logRootChanges";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIterators";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBuildersOnWorkspaceChange";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectIteratorBuildersOnAdd";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectIteratorBuildersOnReplace";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectIteratorBuildersOnRemove";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

