/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.intellij.AppTopics;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartFMap;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.gist.GistManager;
import com.intellij.util.indexing.AuthenticContent;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DocumentContent;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexFileTypeListener;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtensionUpdatableIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.GlobalIndexFilter;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexDataInitializer;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexUpToDateCheckIn;
import com.intellij.util.indexing.IndexVersion;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableFilesFilter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexedFileWrapper;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.ProjectFilesCondition;
import com.intellij.util.indexing.PsiContent;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.StaleIndexesChecker;
import com.intellij.util.indexing.StorageBufferingHandler;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UnindexedFilesUpdaterListener;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateTask;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.events.ChangedFilesCollector;
import com.intellij.util.indexing.events.DeletedVirtualFileStub;
import com.intellij.util.indexing.events.VfsEventsMerger;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayout;
import com.intellij.util.indexing.impl.storage.TransientFileContentIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.projectFilter.FileAddStatus;
import com.intellij.util.indexing.projectFilter.IncrementalProjectIndexableFilesFilterHolder;
import com.intellij.util.indexing.projectFilter.ProjectIndexableFilesFilterHolder;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.snapshot.SnapshotHashEnumeratorService;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingException;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.SimpleMessageBusConnection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class FileBasedIndexImpl
extends FileBasedIndexEx {
    private static final ThreadLocal<VirtualFile> ourIndexedFile = new ThreadLocal();
    private static final ThreadLocal<VirtualFile> ourFileToBeIndexed = new ThreadLocal();
    @ApiStatus.Internal
    public static final Logger LOG = Logger.getInstance(FileBasedIndexImpl.class);
    private final boolean myTraceIndexUpdates;
    private volatile RegisteredIndexes myRegisteredIndexes;
    @Nullable
    private volatile String myShutdownReason;
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
    private final ProjectIndexableFilesFilterHolder myIndexableFilesFilterHolder;
    private final NotNullLazyValue<ChangedFilesCollector> myChangedFilesCollector = NotNullLazyValue.createValue(() -> (ChangedFilesCollector)AsyncEventSupport.EP_NAME.findExtensionOrFail(ChangedFilesCollector.class));
    private final List<Pair<IndexableFileSet, Project>> myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
    private final SimpleMessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final Set<ID<?, ?>> myUpToDateIndicesForUnsavedOrTransactedDocuments = ContainerUtil.newConcurrentSet();
    private volatile SmartFMap<Document, PsiFile> myTransactionMap = SmartFMap.emptyMap();
    private final boolean myIsUnitTestMode;
    @Nullable
    private Runnable myShutDownTask;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    @Nullable
    private ScheduledFuture<?> myHealthCheckFuture;
    private final AtomicInteger myLocalModCount = new AtomicInteger();
    private final AtomicInteger myFilesModCount = new AtomicInteger();
    private final IntSet myStaleIds = new IntOpenHashSet();
    private final Lock myReadLock;
    public final Lock myWriteLock;
    private final UnindexedFilesUpdaterListener myUnindexedFilesUpdaterListener;
    private final ThreadLocal<Boolean> myReentrancyGuard = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Key<WeakReference<Pair<FileContentImpl, Long>>> ourFileContentKey = Key.create((String)"unsaved.document.index.content");
    private final StorageBufferingHandler myStorageBufferingHandler = new StorageBufferingHandler(){

        @Override
        @NotNull
        protected Stream<UpdatableIndex<?, ?, ?>> getIndexes() {
            IndexConfiguration state = FileBasedIndexImpl.this.getState();
            Stream<UpdatableIndex<?, ?, ?>> stream = state.getIndexIDs().stream().map(id2 -> FileBasedIndexImpl.this.getIndex(id2));
            if (stream == null) {
                6.$$$reportNull$$$0(0);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$6", "getIndexes"));
        }
    };
    private final VirtualFileUpdateTask myForceUpdateTask = new VirtualFileUpdateTask();
    public static final boolean DO_TRACE_STUB_INDEX_UPDATE = Boolean.getBoolean("idea.trace.stub.index.update");

    private IndexConfiguration getState() {
        return this.myRegisteredIndexes.getConfigurationState();
    }

    void dropRegisteredIndexes() {
        ScheduledFuture<?> flushingFuture = this.myFlushingFuture;
        LOG.assertTrue(flushingFuture == null || flushingFuture.isCancelled() || flushingFuture.isDone());
        LOG.assertTrue(this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty());
        LOG.assertTrue(this.myTransactionMap.isEmpty());
        this.myRegisteredIndexes = null;
    }

    public FileBasedIndexImpl() {
        ReentrantReadWriteLock lock2 = new ReentrantReadWriteLock();
        this.myReadLock = lock2.readLock();
        this.myWriteLock = lock2.writeLock();
        this.myFileDocumentManager = FileDocumentManager.getInstance();
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        SimpleMessageBusConnection connection = messageBus.simpleConnect();
        this.myUnindexedFilesUpdaterListener = (UnindexedFilesUpdaterListener)messageBus.syncPublisher(UnindexedFilesUpdaterListener.TOPIC);
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus((Object)doc, (Object)file2);
                FileBasedIndexImpl.this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
            }

            @Override
            public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus((Object)doc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "doc";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileBasedIndexFileTypeListener());
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.cleanupMemoryStorage(true);
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$2";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appWillBeClosed(boolean isRestart) {
                if (FileBasedIndexImpl.this.myRegisteredIndexes != null && !FileBasedIndexImpl.this.myRegisteredIndexes.areIndexesReady()) {
                    new Task.Modal(null, IndexingBundle.message((String)"indexes.preparing.to.shutdown.message", (Object[])new Object[0]), false){

                        public void run(@NotNull ProgressIndicator indicator2) {
                            if (indicator2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            FileBasedIndexImpl.this.myRegisteredIndexes.waitUntilAllIndicesAreInitialized();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexImpl$3$1", "run"));
                        }
                    }.queue();
                }
            }
        });
        this.myConnection = connection;
        FileBasedIndexExtension.EXTENSION_POINT_NAME.addExtensionPointListener(new ExtensionPointListener<FileBasedIndexExtension<?, ?>>(){

            public void extensionRemoved(@NotNull FileBasedIndexExtension<?, ?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                ID.unloadId((ID)extension2.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
        this.myIndexableFilesFilterHolder = new IncrementalProjectIndexableFilesFilterHolder();
        this.myTraceIndexUpdates = SystemProperties.getBooleanProperty((String)"trace.file.based.index.update", (boolean)false);
    }

    @ApiStatus.Internal
    public boolean doTraceStubUpdates() {
        return this.myTraceIndexUpdates;
    }

    boolean doTraceStubUpdates(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(0);
        }
        return this.myTraceIndexUpdates && indexId.equals(StubUpdatingIndex.INDEX_ID);
    }

    @ApiStatus.Internal
    boolean doTraceSharedIndexUpdates() {
        return this.myTraceIndexUpdates && SystemProperties.getBooleanProperty((String)"trace.shared.index.updates", (boolean)false);
    }

    void scheduleFullIndexesRescan(@NotNull Collection<ID<?, ?>> indexesToRebuild, @NotNull String reason) {
        if (indexesToRebuild == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(1);
        }
        if (reason == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(2);
        }
        IndexingFlag.cleanupProcessedFlag();
        this.doClearIndices(id2 -> indexesToRebuild.contains(id2));
        FileBasedIndexImpl.scheduleIndexRebuild(reason);
    }

    @VisibleForTesting
    void doClearIndices(@NotNull Predicate<? super ID<?, ?>> filter) {
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(3);
        }
        try {
            this.waitUntilIndicesAreInitialized();
        }
        catch (ProcessCanceledException e) {
            return;
        }
        IndexingStamp.flushCaches();
        ArrayList clearedIndexes = new ArrayList();
        ArrayList survivedIndexes = new ArrayList();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            if (filter.test(indexId)) {
                try {
                    this.clearIndex(indexId);
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                clearedIndexes.add(indexId);
                continue;
            }
            survivedIndexes.add(indexId);
        }
        LOG.info("indexes cleared: " + clearedIndexes.stream().map(id2 -> id2.getName()).collect(Collectors.joining(", ")) + "\nsurvived indexes: " + survivedIndexes.stream().map(id2 -> id2.getName()).collect(Collectors.joining(", ")));
    }

    public void registerProjectFileSets(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(4);
        }
        for (final IndexableFilesContributor extension2 : (IndexableFilesContributor[])IndexableFilesContributor.EP_NAME.getExtensions()) {
            final Predicate contributorsPredicate = extension2.getOwnFilePredicate(project);
            this.registerIndexableSet(new IndexableFileSet(){

                @Override
                public boolean isInSet(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return contributorsPredicate.test(file2);
                }

                public String toString() {
                    return "IndexableFileSet[" + extension2 + "]";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$5", "isInSet"));
                }
            }, project);
        }
    }

    public void removeProjectFileSets(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(5);
        }
        this.myIndexableSets.removeIf(p -> ((Project)p.second).equals(project));
    }

    boolean processChangedFiles(@NotNull Project project, @NotNull Processor<? super VirtualFile> processor2) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(7);
        }
        Iterator iterator2 = Iterators.concat(this.getChangedFilesCollector().getEventMerger().getChangedFiles().iterator(), this.getChangedFilesCollector().getFilesToUpdate().iterator());
        HashSet<VirtualFile> checkedFiles = new HashSet<VirtualFile>();
        Predicate<VirtualFile> filterPredicate = this.filesToBeIndexedForProjectCondition(project);
        while (iterator2.hasNext()) {
            VirtualFile virtualFile2 = (VirtualFile)iterator2.next();
            if (!filterPredicate.test(virtualFile2) || checkedFiles.contains(virtualFile2)) continue;
            checkedFiles.add(virtualFile2);
            if (processor2.process((Object)virtualFile2)) continue;
            return false;
        }
        return true;
    }

    public RegisteredIndexes getRegisteredIndexes() {
        return this.myRegisteredIndexes;
    }

    void setUpShutDownTask() {
        this.myShutDownTask = new MyShutDownTask();
        ShutDownTracker.getInstance().registerShutdownTask(this.myShutDownTask);
    }

    @ApiStatus.Internal
    public void resetSnapshotInputMappingStatistics() {
        for (ID<?, ?> id2 : this.getRegisteredIndexes().getState().getIndexIDs()) {
            UpdatableIndex<?, ?, FileContent> index2 = this.getIndex(id2);
            if (!(index2 instanceof VfsAwareMapReduceIndex)) continue;
            ((VfsAwareMapReduceIndex)index2).resetSnapshotInputMappingsStatistics();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public List<SnapshotInputMappingsStatistics> dumpSnapshotInputMappingStatistics() {
        List<SnapshotInputMappingsStatistics> list2 = this.getRegisteredIndexes().getState().getIndexIDs().stream().map(id2 -> {
            UpdatableIndex index2 = this.getIndex((ID)id2);
            if (index2 instanceof VfsAwareMapReduceIndex) {
                return ((VfsAwareMapReduceIndex)index2).dumpSnapshotInputMappingsStatistics();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStaleIds(@NotNull IntSet staleIds) {
        if (staleIds == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(9);
        }
        IntSet intSet = this.myStaleIds;
        synchronized (intSet) {
            this.myStaleIds.addAll((IntCollection)staleIds);
        }
    }

    void setUpHealthCheck() {
        this.myHealthCheckFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(ConcurrencyUtil.underThreadNameRunnable((String)"Index Healthcheck", () -> this.myIndexableFilesFilterHolder.runHealthCheck()), 5L, 5L, TimeUnit.MINUTES);
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file2, @Nullable FileType fileType) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(10);
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2, (FileType)fileType);
    }

    static boolean belongsToScope(@Nullable VirtualFile file2, @Nullable VirtualFile restrictedTo, @Nullable GlobalSearchScope filter) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return false;
        }
        return !(restrictedTo != null && !Comparing.equal((Object)file2, (Object)restrictedTo) || filter != null && restrictedTo == null && !filter.accept(file2));
    }

    public void requestReindex(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(11);
        }
        this.requestReindex(file2, true);
    }

    @ApiStatus.Internal
    public void requestReindex(@NotNull VirtualFile file2, boolean forceRebuild) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(12);
        }
        GistManager.getInstance().invalidateData(file2);
        ChangedFilesCollector changedFilesCollector = this.getChangedFilesCollector();
        if (forceRebuild) {
            file2.putUserData(IndexingDataKeys.REBUILD_REQUESTED, (Object)Boolean.TRUE);
        }
        changedFilesCollector.scheduleForIndexingRecursively(file2, true);
        if (this.myRegisteredIndexes.isInitialized()) {
            changedFilesCollector.ensureUpToDateAsync();
        }
    }

    public synchronized void loadIndexes() {
        if (this.myRegisteredIndexes == null) {
            LOG.assertTrue(this.myRegisteredIndexes == null);
            this.myStorageBufferingHandler.resetState();
            this.myRegisteredIndexes = new RegisteredIndexes(this.myFileDocumentManager, this);
            this.myShutdownReason = null;
        }
    }

    @Override
    public void waitUntilIndicesAreInitialized() {
        if (this.myRegisteredIndexes == null) {
            throw new ServiceNotReadyException();
        }
        this.myRegisteredIndexes.waitUntilIndicesAreInitialized();
    }

    static <K, V> void registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension2, @NotNull IndexConfiguration state, @NotNull IndexVersionRegistrationSink versionRegistrationStatusSink, @NotNull IntSet staleInputIdSink) throws Exception {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(13);
        }
        if (state == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(14);
        }
        if (versionRegistrationStatusSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(15);
        }
        if (staleInputIdSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(16);
        }
        ID name2 = extension2.getName();
        int version2 = FileBasedIndexImpl.getIndexExtensionVersion(extension2);
        Path versionFile = IndexInfrastructure.getVersionFile(name2);
        IndexVersion.IndexVersionDiff diff = IndexVersion.versionDiffers(name2, version2);
        versionRegistrationStatusSink.setIndexVersionDiff(name2, diff);
        if (diff != IndexVersion.IndexVersionDiff.UP_TO_DATE) {
            boolean versionFileExisted = Files.exists(versionFile, new LinkOption[0]);
            if (extension2.hasSnapshotMapping() && versionFileExisted) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name2).toFile());
            }
            Path rootDir = IndexInfrastructure.getIndexRootDir(name2);
            if (versionFileExisted) {
                FileUtil.deleteWithRenaming((File)rootDir.toFile());
            }
            IndexVersion.rewriteVersion(name2, version2);
            try {
                if (versionFileExisted) {
                    for (FileBasedIndexInfrastructureExtension ex : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                        ex.onFileBasedIndexVersionChanged(name2);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        FileBasedIndexImpl.initIndexStorage(extension2, version2, state, versionRegistrationStatusSink, staleInputIdSink);
    }

    private static <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension2, int version2, @NotNull IndexConfiguration state, @NotNull IndexVersionRegistrationSink registrationStatusSink, @NotNull IntSet staleInputIdSink) throws Exception {
        HashSet addedTypes;
        FileBasedIndex.InputFilter inputFilter;
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(17);
        }
        if (state == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(18);
        }
        if (registrationStatusSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(19);
        }
        if (staleInputIdSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(20);
        }
        ID name2 = extension2.getName();
        boolean contentHashesEnumeratorOk = true;
        try {
            inputFilter = extension2.getInputFilter();
            if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
                addedTypes = new HashSet();
                ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing(type -> {
                    if (type != null) {
                        addedTypes.add(type);
                    }
                });
            } else {
                addedTypes = null;
            }
            if (VfsAwareMapReduceIndex.hasSnapshotMapping(extension2)) {
                contentHashesEnumeratorOk = SnapshotHashEnumeratorService.getInstance().initialize();
            }
        }
        catch (Exception e) {
            state.registerIndexInitializationProblem(name2, e);
            throw e;
        }
        UpdatableIndex<K, V, FileContent> index2 = null;
        int attemptCount = 2;
        for (int attempt = 0; attempt < attemptCount; ++attempt) {
            try {
                VfsAwareIndexStorageLayout<K, V> layout = DefaultIndexStorageLayout.getLayout(extension2, contentHashesEnumeratorOk);
                index2 = FileBasedIndexImpl.createIndex(extension2, layout);
                for (FileBasedIndexInfrastructureExtension infrastructureExtension : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    UpdatableIndex<K, V, FileContent> intermediateIndex = infrastructureExtension.combineIndex(extension2, index2);
                    if (intermediateIndex == null) continue;
                    index2 = intermediateIndex;
                }
                state.registerIndex(name2, index2, FileBasedIndexImpl.composeInputFilter(inputFilter, file2 -> !GlobalIndexFilter.isExcludedFromIndexViaFilters(file2, name2)), version2 + GlobalIndexFilter.getFiltersVersion(name2), addedTypes);
                break;
            }
            catch (Exception e) {
                boolean lastAttempt = attempt == attemptCount - 1;
                try {
                    VfsAwareIndexStorageLayout<K, V> layout = DefaultIndexStorageLayout.getLayout(extension2, contentHashesEnumeratorOk);
                    layout.clearIndexData();
                }
                catch (Exception layoutEx) {
                    LOG.error((Throwable)layoutEx);
                }
                for (FileBasedIndexInfrastructureExtension ext : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    try {
                        ext.resetPersistentState(name2);
                    }
                    catch (Exception extEx) {
                        LOG.error((Throwable)extEx);
                    }
                }
                registrationStatusSink.setIndexVersionDiff(name2, new IndexVersion.IndexVersionDiff.CorruptedRebuild(version2));
                IndexVersion.rewriteVersion(name2, version2);
                if (lastAttempt) {
                    state.registerIndexInitializationProblem(name2, e);
                    if (extension2 instanceof CustomImplementationFileBasedIndexExtension) {
                        ((CustomImplementationFileBasedIndexExtension)extension2).handleInitializationError(e);
                    }
                    throw e;
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error((Throwable)e);
                    continue;
                }
                String message2 = "Attempt #" + attemptCount + " to initialize index has failed for " + extension2.getName();
                if (e instanceof CorruptedException) {
                    LOG.warn(message2 + " because storage corrupted");
                    continue;
                }
                LOG.warn(message2, (Throwable)e);
                continue;
            }
        }
        try {
            if (StubUpdatingIndex.INDEX_ID.equals((Object)extension2.getName()) && index2 != null) {
                staleInputIdSink.addAll((IntCollection)StaleIndexesChecker.checkIndexForStaleRecords(index2, true));
            }
        }
        catch (Exception e) {
            LOG.error("Exception while checking for stale records", (Throwable)e);
        }
    }

    @NotNull
    private static <K, V> UpdatableIndex<K, V, FileContent> createIndex(@NotNull FileBasedIndexExtension<K, V> extension2, @NotNull VfsAwareIndexStorageLayout<K, V> layout) throws StorageException, IOException {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(21);
        }
        if (layout == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(22);
        }
        if (extension2 instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex<K, V, FileContent> index2;
            UpdatableIndex<K, V, FileContent> updatableIndex = index2 = ((CustomImplementationFileBasedIndexExtension)extension2).createIndexImplementation(extension2, layout);
            if (updatableIndex == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(23);
            }
            return updatableIndex;
        }
        return new TransientFileContentIndex<K, V>(extension2, layout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void performShutdown(boolean keepConnection, @NotNull String reason) {
        if (reason == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(24);
        }
        this.myShutdownReason = keepConnection ? reason : null;
        RegisteredIndexes registeredIndexes = this.myRegisteredIndexes;
        if (registeredIndexes == null) return;
        if (!registeredIndexes.performShutdown()) {
            return;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> registeredIndexes.waitUntilAllIndicesAreInitialized());
        try {
            if (this.myShutDownTask != null) {
                ShutDownTracker.getInstance().unregisterShutdownTask(this.myShutDownTask);
            }
            if (this.myFlushingFuture != null) {
                this.myFlushingFuture.cancel(false);
                this.myFlushingFuture = null;
            }
            if (this.myHealthCheckFuture == null) return;
            this.myHealthCheckFuture.cancel(false);
            this.myHealthCheckFuture = null;
            return;
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                UpdatableIndex<Integer, SerializedStubTree, FileContent> index2;
                PersistentIndicesConfiguration.saveConfiguration();
                for (VirtualFile file2 : this.getChangedFilesCollector().getAllPossibleFilesToUpdate()) {
                    PingProgress.interactWithEdtProgress();
                    int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
                    try {
                        this.removeDataFromIndicesForFile(fileId, file2, "shutdown");
                    }
                    catch (Throwable throwable) {
                        LOG.error(throwable);
                    }
                }
                this.getChangedFilesCollector().clearFilesToUpdate();
                IndexingStamp.flushCaches();
                if (this.myIsUnitTestMode && (index2 = this.getState().getIndex(StubUpdatingIndex.INDEX_ID)) != null) {
                    StaleIndexesChecker.checkIndexForStaleRecords(index2, false);
                }
                IndexConfiguration state = this.getState();
                for (ID<?, ?> indexId : state.getIndexIDs()) {
                    PingProgress.interactWithEdtProgress();
                    try {
                        UpdatableIndex<?, ?, FileContent> index3 = this.getIndex(indexId);
                        if (!RebuildStatus.isOk(indexId)) {
                            index3.clear();
                        }
                        index3.dispose();
                    }
                    catch (Throwable throwable) {
                        LOG.info("Problem disposing " + indexId, throwable);
                    }
                }
                FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.shutdown());
                SnapshotHashEnumeratorService.getInstance().close();
                if (!keepConnection) {
                    this.myConnection.disconnect();
                }
            }
            catch (Throwable e) {
                LOG.error("Problems during index shutdown", e);
            }
            finally {
                IndexVersion.clearCachedIndexVersions();
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    public void removeDataFromIndicesForFile(int fileId, @NotNull VirtualFile file2, @NotNull String cause) {
        boolean isValid;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(25);
        }
        if (cause == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(26);
        }
        VfsEventsMerger.tryLog("REMOVE", file2, () -> "cause=" + cause);
        VirtualFile originalFile = file2 instanceof DeletedVirtualFileStub ? ((DeletedVirtualFileStub)file2).getOriginalFile() : file2;
        List<ID<?, ?>> states = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!states.isEmpty()) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.removeFileDataFromIndices(states, fileId, originalFile));
        }
        if (file2 instanceof VirtualFileSystemEntry && file2.isValid()) {
            IndexingFlag.cleanProcessingFlag(file2);
        }
        boolean bl = isValid = file2 instanceof DeletedVirtualFileStub ? ((DeletedVirtualFileStub)file2).getOriginalFile().isValid() : file2.isValid();
        if (!isValid) {
            this.getIndexableFilesFilterHolder().removeFile(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileDataFromIndices(@NotNull Collection<? extends ID<?, ?>> affectedIndices, int inputId, @Nullable VirtualFile file2) {
        if (affectedIndices == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(27);
        }
        assert (ProgressManager.getInstance().isInNonCancelableSection());
        try {
            this.removeTransientFileDataFromIndices(affectedIndices, inputId, file2);
            Throwable unexpectedError = null;
            for (ID<?, ?> indexId : affectedIndices) {
                try {
                    this.updateSingleIndex(indexId, null, inputId, null);
                }
                catch (Throwable e) {
                    LOG.info(e);
                    if (unexpectedError != null) continue;
                    unexpectedError = e;
                }
            }
            if (unexpectedError != null) {
                LOG.error(unexpectedError);
            }
        }
        finally {
            IndexingStamp.flushCache(inputId);
        }
    }

    private void removeTransientFileDataFromIndices(@NotNull Collection<? extends ID<?, ?>> indices, int inputId, @Nullable VirtualFile file2) {
        Document document;
        if (indices == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(28);
        }
        for (ID<?, ?> indexId : indices) {
            this.getIndex(indexId).removeTransientDataForFile(inputId);
        }
        Document document2 = document = file2 == null ? null : this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
        }
        this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount.get()) {
                return;
            }
            try {
                UpdatableIndex<?, ?, FileContent> index2 = state.getIndex(indexId);
                if (index2 == null) continue;
                index2.flush();
            }
            catch (Throwable e) {
                this.requestRebuild(indexId, e);
            }
        }
        SnapshotHashEnumeratorService.getInstance().flush();
    }

    public static <T, E extends Throwable> T disableUpToDateCheckIn(@NotNull ThrowableComputable<T, E> runnable2) throws E {
        if (runnable2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(29);
        }
        return IndexUpToDateCheckIn.disableUpToDateCheckIn(runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K> boolean ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedFile) {
        block19: {
            String shutdownReason;
            if (indexId == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(30);
            }
            if ((shutdownReason = this.myShutdownReason) != null) {
                LOG.info("FileBasedIndex is currently shutdown because: " + shutdownReason);
                return false;
            }
            ProgressManager.checkCanceled();
            SlowOperations.assertSlowOperationsAreAllowed();
            this.getChangedFilesCollector().ensureUpToDate();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            NoAccessDuringPsiEvents.checkCallContext(indexId);
            if (!this.needsFileContentLoading(indexId)) {
                return true;
            }
            if (filter == GlobalSearchScope.EMPTY_SCOPE || filter instanceof DelegatingGlobalSearchScope && ((DelegatingGlobalSearchScope)filter).unwrap() == GlobalSearchScope.EMPTY_SCOPE) {
                return false;
            }
            if (project == null) {
                LOG.warn("Please provide a GlobalSearchScope with specified project. Otherwise it might lead to performance problems!", (Throwable)new Exception());
            }
            if (project != null && project.isDefault()) {
                LOG.error("FileBasedIndex should not receive default project");
            }
            if (ActionUtil.isDumbMode((Project)project) && this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                FileBasedIndexImpl.handleDumbMode(project);
            }
            if (this.myReentrancyGuard.get().booleanValue()) {
                return true;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                block20: {
                    if (!IndexUpToDateCheckIn.isUpToDateCheckEnabled()) break block19;
                    try {
                        if (RebuildStatus.isOk(indexId)) break block20;
                        if (this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                            throw new ServiceNotReadyException();
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (RuntimeException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof StorageException || cause instanceof IOException) {
                            this.scheduleRebuild(indexId, e);
                            break block19;
                        }
                        throw e;
                    }
                }
                if (!ActionUtil.isDumbMode((Project)project) || this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                    this.forceUpdate(project, filter, restrictedFile);
                }
                if (!this.areUnsavedDocumentsIndexed(indexId)) {
                    this.indexUnsavedDocuments(indexId, project, filter, restrictedFile);
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
        return true;
    }

    private boolean areUnsavedDocumentsIndexed(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(31);
        }
        return this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId);
    }

    private static void handleDumbMode(@Nullable Project project) throws IndexNotReadyException {
        ProgressManager.checkCanceled();
        throw IndexNotReadyException.create(project == null ? null : DumbServiceImpl.getInstance(project).getDumbModeStartTrace());
    }

    @TestOnly
    public void cleanupForNextTest() {
        this.getChangedFilesCollector().ensureUpToDate();
        this.myTransactionMap = SmartFMap.emptyMap();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            UpdatableIndex<?, ?, FileContent> index2 = this.getIndex(indexId);
            index2.cleanupForNextTest();
        }
    }

    @ApiStatus.Internal
    public ChangedFilesCollector getChangedFilesCollector() {
        return (ChangedFilesCollector)this.myChangedFilesCollector.getValue();
    }

    public void incrementFilesModCount() {
        this.myFilesModCount.incrementAndGet();
    }

    public int getFilesModCount() {
        return this.myFilesModCount.get();
    }

    void filesUpdateStarted(Project project, boolean isFullUpdate) {
        if (isFullUpdate) {
            this.myIndexableFilesFilterHolder.entireProjectUpdateStarted(project);
        }
        this.ensureStaleIdsDeleted();
        this.getChangedFilesCollector().ensureUpToDate();
        this.incrementFilesModCount();
        this.fireUpdateStarted(project);
    }

    void fireUpdateStarted(Project project) {
        this.myUnindexedFilesUpdaterListener.updateStarted(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureStaleIdsDeleted() {
        this.loadIndexes();
        this.waitUntilIndicesAreInitialized();
        IntSet intSet = this.myStaleIds;
        synchronized (intSet) {
            if (this.myStaleIds.isEmpty()) {
                return;
            }
            try {
                StaleIndexesChecker.clearStaleIndexes(this.myStaleIds);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myStaleIds.clear();
            }
        }
    }

    void filesUpdateFinished(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(32);
        }
        this.myIndexableFilesFilterHolder.entireProjectUpdateFinished(project);
        this.incrementFilesModCount();
        this.fireUpdateFinished(project);
    }

    void fireUpdateFinished(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(33);
        }
        this.myUnindexedFilesUpdaterListener.updateFinished(project);
    }

    @Override
    @Nullable
    public IdFilter projectIndexableFiles(@Nullable Project project) {
        if (project == null || project.isDefault()) {
            return null;
        }
        return this.myIndexableFilesFilterHolder.getProjectIndexableFiles(project);
    }

    @NotNull
    public ProjectIndexableFilesFilterHolder getIndexableFilesFilterHolder() {
        ProjectIndexableFilesFilterHolder projectIndexableFilesFilterHolder = this.myIndexableFilesFilterHolder;
        if (projectIndexableFilesFilterHolder == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(34);
        }
        return projectIndexableFilesFilterHolder;
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (e == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(35);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e instanceof ProcessCanceledException) {
            return null;
        }
        if (e instanceof MapReduceIndexMappingException) {
            if (e.getCause() instanceof SnapshotInputMappingException) {
                return e.getCause();
            }
            return null;
        }
        if (e instanceof IndexOutOfBoundsException) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    private static void scheduleIndexRebuild(String reason) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            new UnindexedFilesUpdater(project, reason).queue(project);
        }
    }

    void clearIndicesIfNecessary() {
        this.waitUntilIndicesAreInitialized();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<StorageException>)((ThrowableRunnable)() -> this.getIndex(indexId).clear()));
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                this.requestRebuild(indexId);
            }
        }
    }

    void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(36);
        }
        this.advanceIndexVersion(indexId);
        this.getIndex(indexId).clear();
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexVersion.rewriteVersion(indexId, this.myRegisteredIndexes.getState().getIndexVersion(indexId));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        Set set2 = this.myTransactionMap.keySet();
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(37);
        }
        return set2;
    }

    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedFile) {
        List documentsToProcessForProject;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(38);
        }
        if (this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId)) {
            return;
        }
        HashSet<Document> documents = new HashSet<Document>();
        this.myFileDocumentManager.processUnsavedDocuments(document -> {
            documents.add((Document)document);
            return true;
        });
        documents.addAll(this.getTransactedDocuments());
        if (project != null) {
            Collections.addAll(documents, PsiDocumentManager.getInstance((Project)project).getUncommittedDocuments());
        }
        if (!documents.isEmpty() && !(documentsToProcessForProject = ContainerUtil.filter(documents, document -> FileBasedIndexImpl.belongsToScope(this.myFileDocumentManager.getFile(document), restrictedFile, filter))).isEmpty()) {
            UpdateTask<Document> task2 = this.myRegisteredIndexes.getUnsavedDataUpdateTask(indexId);
            assert (task2 != null) : "Task for unsaved data indexing was not initialized for index " + indexId;
            if (this.myStorageBufferingHandler.runUpdate(true, (Computable<Boolean>)((Computable)() -> task2.processAll(documentsToProcessForProject, project))) && documentsToProcessForProject.size() == documents.size() && !this.hasActiveTransactions()) {
                this.myUpToDateIndicesForUnsavedOrTransactedDocuments.add(indexId);
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    void indexUnsavedDocument(@NotNull Document document, @NotNull ID<?, ?> requestedIndexId, @NotNull Project project, @NotNull VirtualFile vFile) {
        PsiFile dominantContentFile;
        if (document == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(39);
        }
        if (requestedIndexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(40);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(41);
        }
        if (vFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(42);
        }
        DocumentContent content2 = (dominantContentFile = FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project)) != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
        long currentDocStamp = PsiDocumentManager.getInstance((Project)project).getLastCommittedStamp(document);
        long previousDocStamp = this.myLastIndexedDocStamps.get(document, requestedIndexId);
        if (previousDocStamp == currentDocStamp) {
            return;
        }
        CharSequence contentText = content2.getText();
        FileTypeManagerEx.getInstanceEx().freezeFileTypeTemporarilyIn(vFile, () -> {
            IndexedFileImpl indexedFile = new IndexedFileImpl(vFile, project);
            if (this.getAffectedIndexCandidates(indexedFile).contains(requestedIndexId) && this.acceptsInput(requestedIndexId, indexedFile)) {
                int inputId = FileBasedIndexImpl.getFileId((VirtualFile)vFile);
                if (!this.isTooLarge(vFile, Long.valueOf(contentText.length()))) {
                    FileContentImpl newFc;
                    WeakReference previousContentAndStampRef = (WeakReference)document.getUserData(ourFileContentKey);
                    Pair previousContentAndStamp = (Pair)SoftReference.dereference((Reference)previousContentAndStampRef);
                    if (previousContentAndStamp != null && currentDocStamp == (Long)previousContentAndStamp.getSecond()) {
                        newFc = (FileContentImpl)((Object)((Object)previousContentAndStamp.getFirst()));
                    } else {
                        newFc = (FileContentImpl)FileContentImpl.createByText(vFile, contentText, project);
                        document.putUserData(ourFileContentKey, new WeakReference<Pair>(Pair.create((Object)((Object)newFc), (Object)currentDocStamp)));
                    }
                    FileBasedIndexImpl.initFileContent(newFc, dominantContentFile);
                    newFc.ensureThreadSafeLighterAST();
                    if (content2 instanceof AuthenticContent) {
                        newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document));
                    }
                    FileBasedIndexImpl.markFileIndexed(vFile, (FileContent)newFc);
                    try {
                        Computable update2 = this.getIndex(requestedIndexId).mapInputAndPrepareUpdate(inputId, (Object)newFc);
                        ProgressManager.getInstance().executeNonCancelableSection(() -> ((Computable)update2).compute());
                    }
                    finally {
                        FileBasedIndexImpl.unmarkBeingIndexed();
                        FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                    }
                } else {
                    Computable update3 = this.getIndex(requestedIndexId).mapInputAndPrepareUpdate(inputId, null);
                    ProgressManager.getInstance().executeNonCancelableSection(() -> ((Computable)update3).compute());
                }
            }
            long previousState = this.myLastIndexedDocStamps.set(document, requestedIndexId, currentDocStamp);
            assert (previousState == previousDocStamp);
        });
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> getFileData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile2, @NotNull Project project) {
        if (id2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(43);
        }
        if (virtualFile2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(44);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(45);
        }
        if (ModelBranch.getFileBranch((VirtualFile)virtualFile2) != null) {
            return this.getInMemoryData(id2, virtualFile2, project);
        }
        Map<K, V> map2 = super.getFileData(id2, virtualFile2, project);
        if (map2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(46);
        }
        return map2;
    }

    @NotNull
    private <K, V> Map<K, V> getInMemoryData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile2, @NotNull Project project) {
        PsiFile psiFile;
        if (id2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(47);
        }
        if (virtualFile2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(48);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(49);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2)) != null) {
            Map indexValues = (Map)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> {
                try {
                    FileContentImpl fc = psiFile instanceof PsiBinaryFile ? (FileContentImpl)FileContentImpl.createByFile(virtualFile2, project) : (FileContentImpl)FileContentImpl.createByText(virtualFile2, psiFile.getViewProvider().getContents(), project);
                    FileBasedIndexImpl.initFileContent(fc, psiFile);
                    Map result2 = FactoryMap.create(key -> this.getIndex((ID)key).getExtension().getIndexer().map((Object)fc));
                    return CachedValueProvider.Result.createSingleDependency((Object)result2, (Object)psiFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            Map map2 = (Map)indexValues.get(id2);
            if (map2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(50);
            }
            return map2;
        }
        Map map3 = Collections.emptyMap();
        if (map3 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(51);
        }
        return map3;
    }

    @ApiStatus.Internal
    public void runCleanupAction(@NotNull Runnable cleanupAction) {
        if (cleanupAction == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(52);
        }
        Computable updateComputable = () -> {
            ProgressManager.getInstance().executeNonCancelableSection(cleanupAction);
            return true;
        };
        this.runUpdateForPersistentData((Computable<Boolean>)updateComputable);
        this.myStorageBufferingHandler.runUpdate(true, (Computable<Boolean>)updateComputable);
    }

    public void cleanupMemoryStorage(boolean skipContentDependentIndexes) {
        this.myLastIndexedDocStamps.clear();
        if (this.myRegisteredIndexes == null) {
            return;
        }
        IndexConfiguration state = this.myRegisteredIndexes.getState();
        if (state == null) {
            return;
        }
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            if (skipContentDependentIndexes && this.myRegisteredIndexes.isContentDependentIndex(indexId)) continue;
            UpdatableIndex<?, ?, FileContent> index2 = this.getIndex(indexId);
            index2.cleanupMemoryStorage();
        }
    }

    public void requestRebuild(@NotNull ID<?, ?> indexId, @NotNull Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(53);
        }
        if (throwable == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(54);
        }
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            IndexDataInitializer.submitGenesisTask(() -> {
                this.waitUntilIndicesAreInitialized();
                this.doRequestRebuild(indexId, throwable);
                return null;
            });
        } else {
            this.doRequestRebuild(indexId, throwable);
        }
    }

    private void doRequestRebuild(@NotNull ID<?, ?> indexId, Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(55);
        }
        IndexingFlag.cleanupProcessedFlag();
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            FileBasedIndexImpl.reportUnexpectedAsyncInitState();
        }
        if (RebuildStatus.requestRebuild(indexId)) {
            String message2 = "Rebuild requested for index " + indexId;
            Application app2 = ApplicationManager.getApplication();
            if (this.myIsUnitTestMode && app2.isReadAccessAllowed() && !app2.isDispatchThread()) {
                LOG.error(message2, throwable);
            } else {
                LOG.info(message2, throwable);
            }
            IndexingFlag.cleanupProcessedFlag();
            if (!this.myRegisteredIndexes.isInitialized()) {
                return;
            }
            this.advanceIndexVersion(indexId);
            Runnable rebuildRunnable = () -> FileBasedIndexImpl.scheduleIndexRebuild(message2);
            ((AppUIExecutor)AppUIExecutor.onWriteThread().later().expireWith((Disposable)app2)).submit(rebuildRunnable);
        }
    }

    private static void reportUnexpectedAsyncInitState() {
        LOG.error("Unexpected async indices initialization problem");
    }

    @Override
    @NotNull
    public <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        UpdatableIndex<K, V, FileContent> index2 = this.getState().getIndex(indexId);
        if (index2 == null) {
            Throwable initializationProblem = this.getState().getInitializationProblem(indexId);
            String message2 = "Index is not created for `" + indexId.getName() + "`";
            throw initializationProblem != null ? new IllegalStateException(message2, initializationProblem) : new IllegalStateException(message2);
        }
        UpdatableIndex<K, V, FileContent> updatableIndex = index2;
        if (updatableIndex == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(56);
        }
        return updatableIndex;
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(57);
        }
        if (!this.myRegisteredIndexes.isInitialized()) {
            this.waitUntilIndicesAreInitialized();
        }
        return this.getState().getInputFilter(indexId);
    }

    @NotNull
    Collection<VirtualFile> getFilesToUpdate(Project project) {
        List list2 = ContainerUtil.filter(this.getChangedFilesCollector().getAllFilesToUpdate(), this.filesToBeIndexedForProjectCondition(project)::test);
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(58);
        }
        return list2;
    }

    @NotNull
    private Predicate<VirtualFile> filesToBeIndexedForProjectCondition(Project project) {
        Predicate<VirtualFile> predicate2 = virtualFile2 -> {
            if (!virtualFile2.isValid()) {
                return true;
            }
            for (Pair<IndexableFileSet, Project> set2 : this.myIndexableSets) {
                Project proj = (Project)set2.second;
                if (proj != null && !proj.equals(project) || !((Boolean)ReadAction.compute(() -> ((IndexableFileSet)set2.first).isInSet((VirtualFile)virtualFile2))).booleanValue()) continue;
                return true;
            }
            return false;
        };
        if (predicate2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(59);
        }
        return predicate2;
    }

    public boolean isFileUpToDate(VirtualFile file2) {
        return file2 instanceof VirtualFileWithId && !this.getChangedFilesCollector().isScheduledForUpdate(file2);
    }

    private void processRefreshedFile(@Nullable Project project, @NotNull CachedFileContent fileContent) {
        if (fileContent == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(60);
        }
        VirtualFile file2 = fileContent.getVirtualFile();
        if (this.getChangedFilesCollector().isScheduledForUpdate(file2)) {
            this.indexFileContent(project, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public FileIndexingStatistics indexFileContent(@Nullable Project project, @NotNull CachedFileContent content2) {
        FileIndexingStatistics indexingStatistics;
        boolean setIndexedStatus;
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(61);
        }
        ProgressManager.checkCanceled();
        VirtualFile file2 = content2.getVirtualFile();
        int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
        boolean isValid = file2.isValid();
        if (file2.isValid() && content2.getTimeStamp() != file2.getTimeStamp()) {
            content2 = new CachedFileContent(file2);
        }
        if (!isValid || this.isTooLarge(file2)) {
            ProgressManager.checkCanceled();
            this.removeDataFromIndicesForFile(fileId, file2, "invalid_or_large_file");
            setIndexedStatus = true;
            indexingStatistics = new FileIndexingStatistics(file2.getFileType(), Collections.emptySet(), false, Collections.emptyMap(), Collections.emptyMap());
        } else {
            Pair<Boolean, FileIndexingStatistics> pair = this.doIndexFileContent(project, content2);
            setIndexedStatus = (Boolean)pair.first;
            indexingStatistics = (FileIndexingStatistics)pair.second;
        }
        if (setIndexedStatus) {
            IndexingFlag.setFileIndexed(file2);
        }
        VfsEventsMerger.tryLog("INDEX_UPDATED", file2, () -> " updated_indexes=" + indexingStatistics.getPerIndexerUpdateTimes().keySet() + " deleted_indexes=" + indexingStatistics.getPerIndexerDeleteTimes().keySet() + " valid=" + isValid);
        this.getChangedFilesCollector().removeFileIdFromFilesScheduledForUpdate(fileId);
        FileIndexingStatistics fileIndexingStatistics = indexingStatistics;
        FileIndexingStatistics fileIndexingStatistics2 = fileIndexingStatistics;
        if (fileIndexingStatistics2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(62);
        }
        return fileIndexingStatistics2;
        finally {
            IndexingStamp.flushCache(fileId);
        }
    }

    @NotNull
    private Pair<Boolean, FileIndexingStatistics> doIndexFileContent(@Nullable Project project, @NotNull CachedFileContent content2) {
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(63);
        }
        ProgressManager.checkCanceled();
        VirtualFile file2 = content2.getVirtualFile();
        Ref setIndexedStatus = Ref.create((Object)Boolean.TRUE);
        HashMap perIndexerUpdateTimes = new HashMap();
        HashMap perIndexerDeletionTimes = new HashMap();
        HashSet indexesProvidedByExtensions = new HashSet();
        Ref wasFullyIndexedByInfrastructureExtensions = Ref.create((Object)true);
        Ref fileTypeRef = Ref.create();
        int inputId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
        Project guessedProject = project != null ? project : this.myIndexableFilesFilterHolder.findProjectForFile(inputId);
        IndexedFileImpl indexedFile = new IndexedFileImpl(file2, guessedProject);
        FileTypeManagerEx.getInstanceEx().freezeFileTypeTemporarilyIn(file2, () -> {
            ProgressManager.checkCanceled();
            FileContentImpl fc = null;
            HashSet currentIndexedStates = new HashSet(IndexingStamp.getNontrivialFileIndexedStates(inputId));
            List<ID<?, ?>> affectedIndexCandidates = this.getAffectedIndexCandidates(indexedFile);
            int size = affectedIndexCandidates.size();
            for (int i2 = 0; i2 < size; ++i2) {
                boolean update2;
                ID<?, ?> iD;
                boolean acceptedAndRequired;
                ProgressManager.checkCanceled();
                if (fc == null) {
                    fc = (FileContentImpl)FileContentImpl.createByContent(file2, (NotNullComputable<byte[]>)((NotNullComputable)() -> FileBasedIndexImpl.getBytesOrNull(content2)), guessedProject);
                    fc.setSubstituteFileType(indexedFile.getFileType());
                    ProgressManager.checkCanceled();
                    fileTypeRef.set((Object)fc.getFileType());
                    ProgressManager.checkCanceled();
                }
                boolean bl = acceptedAndRequired = this.acceptsInput(iD = affectedIndexCandidates.get(i2), fc) && this.getIndexingState(fc, iD).updateRequired();
                if (acceptedAndRequired) {
                    boolean update3 = RebuildStatus.isOk(iD);
                    if (!update3) {
                        setIndexedStatus.set((Object)Boolean.FALSE);
                        currentIndexedStates.remove(iD);
                    }
                } else {
                    update2 = false;
                }
                if (!update2 && this.doTraceStubUpdates(iD)) {
                    String reason = acceptedAndRequired ? "index is required to rebuild, and indexing does not update such" : (this.acceptsInput(iD, fc) ? "update is not required" : "file is not accepted by index");
                    LOG.info("index " + iD + " should not be updated for " + fc.getFileName() + " because " + reason);
                }
                if (!update2) continue;
                ProgressManager.checkCanceled();
                SingleIndexUpdateStats updateStats = this.updateSingleIndex(iD, file2, inputId, (FileContent)fc);
                if (updateStats == null) {
                    setIndexedStatus.set((Object)Boolean.FALSE);
                } else {
                    perIndexerUpdateTimes.put(iD, updateStats.mapInputTime);
                    if (updateStats.indexWasProvidedByExtension) {
                        indexesProvidedByExtensions.add(iD);
                    } else {
                        if (this.doTraceSharedIndexUpdates()) {
                            LOG.info("shared index " + iD + " is not provided for file " + fc.getFileName());
                        }
                        wasFullyIndexedByInfrastructureExtensions.set((Object)false);
                    }
                }
                currentIndexedStates.remove(iD);
            }
            boolean shouldClearAllIndexedStates = fc == null;
            for (ID iD : currentIndexedStates) {
                ProgressManager.checkCanceled();
                if (!shouldClearAllIndexedStates && !this.getIndex(iD).getIndexingStateForFile(inputId, fc).updateRequired()) continue;
                ProgressManager.checkCanceled();
                SingleIndexUpdateStats updateStats = this.updateSingleIndex(iD, file2, inputId, null);
                if (updateStats == null) {
                    setIndexedStatus.set((Object)Boolean.FALSE);
                    continue;
                }
                perIndexerDeletionTimes.put(iD, updateStats.mapInputTime);
            }
            fileTypeRef.set((Object)(fc != null ? fc.getFileType() : file2.getFileType()));
            if (indexesProvidedByExtensions.isEmpty() && this.doTraceSharedIndexUpdates()) {
                LOG.info("no shared indexes were provided for file " + (fc != null ? fc.getFileName() : file2.getName()));
            }
        });
        file2.putUserData(IndexingDataKeys.REBUILD_REQUESTED, null);
        Pair pair = Pair.create((Object)((Boolean)setIndexedStatus.get()), (Object)new FileIndexingStatistics((FileType)fileTypeRef.get(), indexesProvidedByExtensions, !indexesProvidedByExtensions.isEmpty() && (Boolean)wasFullyIndexedByInfrastructureExtensions.get() != false, perIndexerUpdateTimes, perIndexerDeletionTimes));
        if (pair == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(64);
        }
        return pair;
    }

    private static byte @NotNull [] getBytesOrNull(@NotNull CachedFileContent content2) {
        byte[] byArray;
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(65);
        }
        try {
            byArray = content2.getBytes();
        }
        catch (IOException e) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(67);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(66);
        }
        return byArray;
    }

    @NotNull
    List<ID<?, ?>> getAffectedIndexCandidates(@NotNull IndexedFile indexedFile) {
        if (indexedFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(68);
        }
        if (indexedFile.getFile().isDirectory()) {
            List<ID<?, ?>> list2 = FileBasedIndexImpl.isProjectOrWorkspaceFile(indexedFile.getFile(), null) ? Collections.emptyList() : this.myRegisteredIndexes.getIndicesForDirectories();
            if (list2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(69);
            }
            return list2;
        }
        FileType fileType = indexedFile.getFileType();
        if (fileType instanceof SubstitutedFileType) {
            fileType = ((SubstitutedFileType)fileType).getFileType();
        }
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(indexedFile.getFile(), fileType)) {
            List<ID<?, ?>> list3 = Collections.emptyList();
            if (list3 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(70);
            }
            return list3;
        }
        List<ID<?, ?>> list4 = this.getState().getFileTypesForIndex(fileType);
        if (list4 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(71);
        }
        return list4;
    }

    private static void cleanFileContent(FileContentImpl fc, PsiFile psiFile) {
        if (fc == null) {
            return;
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
        fc.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(@NotNull FileContentImpl fc, PsiFile psiFile) {
        if (fc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(72);
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
            fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable(value="null in case index update is not necessary or the update has failed")
    @Nullable(value="null in case index update is not necessary or the update has failed") SingleIndexUpdateStats updateSingleIndex(@NotNull ID<?, ?> indexId, @Nullable VirtualFile file, int inputId, @Nullable FileContent currentFC) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean runUpdateForPersistentData(Computable<Boolean> storageUpdate) {
        return this.myStorageBufferingHandler.runUpdate(false, (Computable<Boolean>)((Computable)() -> (Boolean)ProgressManager.getInstance().computeInNonCancelableSection(() -> (Boolean)storageUpdate.compute())));
    }

    static void setIndexedState(UpdatableIndex<?, ?, FileContent> index2, @NotNull IndexedFile currentFC, int inputId, boolean indexWasProvided) {
        if (currentFC == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(74);
        }
        if (index2 instanceof FileBasedIndexInfrastructureExtensionUpdatableIndex) {
            ((FileBasedIndexInfrastructureExtensionUpdatableIndex)index2).setIndexedStateForFile(inputId, currentFC, indexWasProvided);
        } else {
            index2.setIndexedStateForFile(inputId, currentFC);
        }
    }

    public static void markFileIndexed(@Nullable VirtualFile file2, @Nullable FileContent fc) {
        if (fc != null && (ourIndexedFile.get() != null || ourFileToBeIndexed.get() != null)) {
            throw new AssertionError((Object)"Reentrant indexing");
        }
        ourIndexedFile.set(file2);
    }

    public static void unmarkBeingIndexed() {
        ourIndexedFile.remove();
    }

    public VirtualFile getFileBeingCurrentlyIndexed() {
        return ourIndexedFile.get();
    }

    private void forceUpdate(@Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedTo) {
        Collection<VirtualFile> allFilesToUpdate = this.getChangedFilesCollector().getAllFilesToUpdate();
        if (!allFilesToUpdate.isEmpty()) {
            boolean includeFilesFromOtherProjects = restrictedTo == null && project == null;
            List virtualFilesToBeUpdatedForProject = ContainerUtil.filter(allFilesToUpdate, (Condition)new ProjectFilesCondition(this.projectIndexableFiles(project), filter, restrictedTo, includeFilesFromOtherProjects));
            if (!virtualFilesToBeUpdatedForProject.isEmpty()) {
                this.myForceUpdateTask.processAll(virtualFilesToBeUpdatedForProject, project);
            }
        }
    }

    public boolean needsFileContentLoading(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(75);
        }
        return this.myRegisteredIndexes.isContentDependentIndex(indexId);
    }

    @NotNull
    public Set<Project> getContainingProjects(@NotNull VirtualFile file2) {
        Project project;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(76);
        }
        if ((project = ProjectCoreUtil.theOnlyOpenProject()) != null) {
            Set<Object> set2 = this.belongsToIndexableFiles(file2) ? Collections.singleton(project) : Collections.emptySet();
            if (set2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(77);
            }
            return set2;
        }
        Set projects = null;
        for (Pair<IndexableFileSet, Project> set3 : this.myIndexableSets) {
            if (projects != null && projects.contains(set3.second) || !((IndexableFileSet)set3.first).isInSet(file2)) continue;
            if (projects == null) {
                projects = new SmartHashSet();
            }
            projects.add((Project)set3.second);
        }
        Set set4 = ContainerUtil.notNullize(projects);
        if (set4 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(78);
        }
        return set4;
    }

    public boolean belongsToProjectIndexableFiles(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(79);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(80);
        }
        return ContainerUtil.find(this.myIndexableSets, pair -> ((Project)pair.second).equals(project) && ((IndexableFileSet)pair.first).isInSet(file2)) != null;
    }

    public boolean belongsToIndexableFiles(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(81);
        }
        return ContainerUtil.find(this.myIndexableSets, pair -> ((IndexableFileSet)pair.first).isInSet(file2)) != null;
    }

    public boolean containsIndexableSet(@NotNull IndexableFileSet set2, @NotNull Project project) {
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(82);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(83);
        }
        return ContainerUtil.find(this.myIndexableSets, pair -> pair.first == set2 && ((Project)pair.second).equals(project)) != null;
    }

    @ApiStatus.Internal
    public void dropNontrivialIndexedStates(int inputId) {
        for (ID<?, ?> id2 : IndexingStamp.getNontrivialFileIndexedStates(inputId)) {
            this.dropNontrivialIndexedStates(inputId, id2);
        }
    }

    @ApiStatus.Internal
    public void dropNontrivialIndexedStates(int inputId, ID<?, ?> indexId) {
        UpdatableIndex<?, ?, FileContent> index2 = this.getIndex(indexId);
        index2.invalidateIndexedStateForFile(inputId);
    }

    public void doTransientStateChangeForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(84);
        }
        this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null && this.myFileDocumentManager.isDocumentUnsaved(document)) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
            return;
        }
        Collection contentDependentIndexes = ContainerUtil.intersection(IndexingStamp.getNontrivialFileIndexedStates(fileId), this.myRegisteredIndexes.getRequiringContentIndices());
        this.removeTransientFileDataFromIndices(contentDependentIndexes, fileId, file2);
        for (ID candidate : contentDependentIndexes) {
            this.getIndex(candidate).invalidateIndexedStateForFile(fileId);
        }
        IndexingStamp.flushCache(fileId);
        this.getChangedFilesCollector().scheduleForUpdate(file2);
    }

    public void doInvalidateIndicesForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(85);
        }
        IndexingFlag.cleanProcessedFlagRecursively(file2);
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        this.removeTransientFileDataFromIndices(nontrivialFileIndexedStates, fileId, file2);
        for (ID<?, ?> indexId : nontrivialFileIndexedStates) {
            if (this.myRegisteredIndexes.isContentDependentIndex(indexId)) continue;
            this.updateSingleIndex(indexId, null, fileId, null);
        }
        if (!file2.isDirectory()) {
            this.getChangedFilesCollector().scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
        } else {
            this.getChangedFilesCollector().removeScheduledFileFromUpdate(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleFileForIndexing(int fileId, @NotNull VirtualFile file2, boolean contentChange) {
        List filters;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(86);
        }
        if (!(filters = IndexableFilesFilter.EP_NAME.getExtensionList()).isEmpty() && !ContainerUtil.exists((Iterable)filters, e -> e.shouldIndex(file2))) {
            return;
        }
        if (this.myIndexableFilesFilterHolder.addFileId(fileId, (Function0<? extends Set<? extends Project>>)((Function0)() -> this.getContainingProjects(file2))) == FileAddStatus.SKIPPED) {
            this.doInvalidateIndicesForFile(fileId, file2);
            return;
        }
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        this.removeTransientFileDataFromIndices(nontrivialFileIndexedStates, fileId, file2);
        boolean fileIsDirectory = file2.isDirectory();
        IndexedFileImpl indexedFile = new IndexedFileImpl(file2, this.myIndexableFilesFilterHolder.findProjectForFile(fileId));
        IndexedFileWrapper fileContent = null;
        for (ID iD : contentChange ? Collections.singleton(FileTypeIndex.NAME) : this.getContentLessIndexes(fileIsDirectory)) {
            if (!this.acceptsInput(iD, indexedFile)) continue;
            if (fileContent == null) {
                fileContent = new IndexedFileWrapper(indexedFile);
            }
            this.updateSingleIndex(iD, file2, fileId, fileContent);
        }
        if (!fileIsDirectory) {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.getChangedFilesCollector().scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
            } else {
                ourFileToBeIndexed.set(file2);
                try {
                    FileTypeManagerEx.getInstanceEx().freezeFileTypeTemporarilyIn(file2, () -> {
                        List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(indexedFile);
                        boolean scheduleForUpdate = false;
                        int size = candidates.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            ID<?, ?> indexId = candidates.get(i2);
                            if (!this.needsFileContentLoading(indexId) || !this.acceptsInput(indexId, indexedFile)) continue;
                            this.getIndex(indexId).invalidateIndexedStateForFile(fileId);
                            scheduleForUpdate = true;
                        }
                        if (scheduleForUpdate) {
                            IndexingStamp.flushCache(fileId);
                            this.getChangedFilesCollector().scheduleForUpdate(file2);
                        } else {
                            IndexingFlag.setFileIndexed(file2);
                        }
                    });
                }
                finally {
                    ourFileToBeIndexed.remove();
                }
            }
        } else {
            IndexingFlag.setFileIndexed(file2);
        }
    }

    @NotNull
    Collection<ID<?, ?>> getContentLessIndexes(boolean isDirectory) {
        Collection<ID<?, ?>> collection = isDirectory ? this.myRegisteredIndexes.getIndicesForDirectories() : this.myRegisteredIndexes.getNotRequiringContentIndices();
        if (collection == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(87);
        }
        return collection;
    }

    @NotNull
    public Collection<ID<?, ?>> getContentDependentIndexes() {
        Set<ID<?, ?>> set2 = this.myRegisteredIndexes.getRequiringContentIndices();
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(88);
        }
        return set2;
    }

    void clearUpToDateIndexesForUnsavedOrTransactedDocs() {
        if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
            this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
        }
    }

    FileIndexingState shouldIndexFile(@NotNull IndexedFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(89);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(90);
        }
        if (!this.acceptsInput(indexId, file2)) {
            return this.getIndexingState(file2, indexId) == FileIndexingState.NOT_INDEXED ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        }
        return this.getIndexingState(file2, indexId);
    }

    @NotNull
    FileIndexingState getIndexingState(@NotNull IndexedFile file2, @NotNull ID<?, ?> indexId) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(91);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(92);
        }
        if (FileBasedIndexImpl.isMock(virtualFile2 = file2.getFile())) {
            FileIndexingState fileIndexingState = FileIndexingState.NOT_INDEXED;
            if (fileIndexingState == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(93);
            }
            return fileIndexingState;
        }
        FileIndexingState fileIndexingState = this.getIndex(indexId).getIndexingStateForFile(((NewVirtualFile)virtualFile2).getId(), file2);
        if (fileIndexingState == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(94);
        }
        return fileIndexingState;
    }

    public static boolean isMock(VirtualFile file2) {
        return !(file2 instanceof NewVirtualFile);
    }

    public boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(95);
        }
        return this.isTooLarge(file2, null);
    }

    public boolean isTooLarge(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(96);
        }
        return FileBasedIndexImpl.isTooLarge(file2, contentSize, this.myRegisteredIndexes.getNoLimitCheckFileTypes());
    }

    @ApiStatus.Internal
    public static boolean isTooLarge(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize, @NotNull Set<FileType> noLimitFileTypes) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(97);
        }
        if (noLimitFileTypes == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(98);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2, contentSize)) {
            return !noLimitFileTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2, contentSize);
        }
        return false;
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set2, @NotNull Project project) {
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(99);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(100);
        }
        this.myIndexableSets.add((Pair<IndexableFileSet, Project>)Pair.create((Object)set2, (Object)project));
    }

    boolean acceptsInput(@NotNull ID<?, ?> indexId, @NotNull IndexedFile indexedFile) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(101);
        }
        if (indexedFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(102);
        }
        FileBasedIndex.InputFilter filter = this.getInputFilter(indexId);
        return FileBasedIndexImpl.acceptsInput(filter, indexedFile);
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set2) {
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(103);
        }
        if (!this.myIndexableSets.removeIf(p -> p.first == set2)) {
            return;
        }
        ChangedFilesCollector changedFilesCollector = this.getChangedFilesCollector();
        for (VirtualFile file2 : changedFilesCollector.getAllFilesToUpdate()) {
            int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
            if (!file2.isValid()) {
                this.removeDataFromIndicesForFile(fileId, file2, "invalid_file");
                changedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
                continue;
            }
            if (this.belongsToIndexableFiles(file2)) continue;
            if (ChangedFilesCollector.CLEAR_NON_INDEXABLE_FILE_DATA) {
                this.removeDataFromIndicesForFile(fileId, file2, "non_indexable_file");
            }
            changedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
        }
        IndexingStamp.flushCaches();
    }

    public VirtualFile findFileById(Project project, int id2) {
        return ManagingFS.getInstance().findFileById(id2);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project) {
        if (doc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(104);
        }
        if (project == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(105);
        }
        return PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(doc);
    }

    void setUpFlusher() {
        this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
            private int lastModCount;

            @Override
            public void run() {
                int currentModCount = FileBasedIndexImpl.this.myLocalModCount.get();
                if (this.lastModCount == currentModCount) {
                    FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                }
                this.lastModCount = currentModCount;
            }
        });
    }

    public void invalidateCaches() {
        CorruptionMarker.requestInvalidation();
    }

    public boolean isFileIndexedInCurrentSession(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(106);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(107);
        }
        if (!(file2.isValid() && file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed())) {
            return false;
        }
        int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
        return IndexingStamp.getNontrivialFileIndexedStates(fileId).contains(indexId);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public IntPredicate getAccessibleFileIdFilter(@Nullable Project project) {
        boolean dumb = ActionUtil.isDumbMode((Project)project);
        if (!dumb) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(108);
            }
            return intPredicate;
        }
        if (DumbServiceImpl.ALWAYS_SMART && project != null && UnindexedFilesUpdater.isIndexUpdateInProgress(project)) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(109);
            }
            return intPredicate;
        }
        DumbModeAccessType dumbModeAccessType = this.getCurrentDumbModeAccessType();
        if (dumbModeAccessType == null) {
            IntPredicate intPredicate = __ -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(110);
            }
            return intPredicate;
        }
        if (dumbModeAccessType == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(111);
            }
            return intPredicate;
        }
        assert (dumbModeAccessType == DumbModeAccessType.RELIABLE_DATA_ONLY);
        IntPredicate intPredicate = fileId -> !this.getChangedFilesCollector().containsFileId(fileId);
        if (intPredicate == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(112);
        }
        return intPredicate;
    }

    @Override
    @Nullable
    public IdFilter extractIdFilter(@Nullable GlobalSearchScope scope2, @Nullable Project project) {
        if (scope2 == null) {
            return this.projectIndexableFiles(project);
        }
        IdFilter filter = this.extractFileEnumeration(scope2);
        if (filter != null) {
            return filter;
        }
        return this.projectIndexableFiles((Project)ObjectUtils.chooseNotNull((Object)project, (Object)scope2.getProject()));
    }

    @ApiStatus.Internal
    public void flushIndexes() {
        for (ID<?, ?> id2 : this.getRegisteredIndexes().getState().getIndexIDs()) {
            try {
                this.getIndex(id2).flush();
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ApiStatus.Internal
    static <K, V> int getIndexExtensionVersion(@NotNull FileBasedIndexExtension<K, V> extension2) {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(113);
        }
        int version2 = extension2.getVersion();
        if (VfsAwareMapReduceIndex.hasSnapshotMapping(extension2)) {
            version2 += SnapshotInputMappings.getVersion();
        }
        return version2;
    }

    public static boolean acceptsInput(@NotNull FileBasedIndex.InputFilter filter, @NotNull IndexedFile indexedFile) {
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(114);
        }
        if (indexedFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(115);
        }
        if (filter instanceof FileBasedIndex.ProjectSpecificInputFilter) {
            if (indexedFile.getProject() == null) {
                Project project = ProjectUtil.guessProjectForFile((VirtualFile)indexedFile.getFile());
                ((IndexedFileImpl)indexedFile).setProject(project);
            }
            return ((FileBasedIndex.ProjectSpecificInputFilter)filter).acceptInput(indexedFile);
        }
        return filter.acceptInput(indexedFile.getFile());
    }

    @NotNull
    public static FileBasedIndex.InputFilter composeInputFilter(final @NotNull FileBasedIndex.InputFilter filter, final @NotNull Predicate<? super VirtualFile> condition) {
        if (filter == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(116);
        }
        if (condition == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(117);
        }
        Object object = filter instanceof FileBasedIndex.ProjectSpecificInputFilter ? new FileBasedIndex.ProjectSpecificInputFilter(){

            public boolean acceptInput(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                return ((FileBasedIndex.ProjectSpecificInputFilter)filter).acceptInput(file2) && condition.test(file2.getFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$8", "acceptInput"));
            }
        } : file2 -> filter.acceptInput(file2) && condition.test(file2);
        if (object == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(118);
        }
        return object;
    }

    @Nullable
    private IdFilter extractFileEnumeration(final @NotNull GlobalSearchScope scope2) {
        VirtualFileEnumeration hint;
        if (scope2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(119);
        }
        if ((hint = VirtualFileEnumeration.extract((GlobalSearchScope)scope2)) != null) {
            return new IdFilter(){

                public boolean containsFileId(int id2) {
                    return hint.contains(id2);
                }

                public String toString() {
                    return "IdFilter of " + scope2;
                }
            };
        }
        Project project = scope2.getProject();
        if (project == null) {
            return null;
        }
        return this.projectIndexableFiles(project);
    }

    private static /* synthetic */ void lambda$updateSingleIndex$29(FileContent currentFC, UpdatableIndex index2, int inputId, boolean indexWasProvided) throws RuntimeException {
        if (currentFC != null) {
            if (!FileBasedIndexImpl.isMock(currentFC.getFile())) {
                FileBasedIndexImpl.setIndexedState(index2, (IndexedFile)currentFC, inputId, indexWasProvided);
            }
        } else {
            index2.setUnindexedStateForFile(inputId);
        }
    }

    private /* synthetic */ Set lambda$updateSingleIndex$28(VirtualFile file2) {
        return this.getContainingProjects(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 23: 
            case 34: 
            case 37: 
            case 46: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 118: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 23: 
            case 34: 
            case 37: 
            case 46: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 118: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexesToRebuild";
                break;
            }
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 3: 
            case 114: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 32: 
            case 33: 
            case 41: 
            case 45: 
            case 49: 
            case 80: 
            case 83: 
            case 100: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 23: 
            case 34: 
            case 37: 
            case 46: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleIds";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 25: 
            case 76: 
            case 79: 
            case 81: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 95: 
            case 96: 
            case 97: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRegistrationStatusSink";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleInputIdSink";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrationStatusSink";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedIndices";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedIndexId";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupAction";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 61: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 68: 
            case 102: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fc";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFC";
                break;
            }
            case 82: 
            case 99: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noLimitFileTypes";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpSnapshotInputMappingStatistics";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndex";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableFilesFilterHolder";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransactedDocuments";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileData";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getInMemoryData";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToUpdate";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "filesToBeIndexedForProjectCondition";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFileContent";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "doIndexFileContent";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytesOrNull";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedIndexCandidates";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingProjects";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLessIndexes";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDependentIndexes";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingState";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleFileIdFilter";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "composeInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTraceStubUpdates";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFullIndexesRescan";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doClearIndices";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectFileSets";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectFileSets";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processChangedFiles";
                break;
            }
            case 8: 
            case 23: 
            case 34: 
            case 37: 
            case 46: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 118: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addStaleIds";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isProjectOrWorkspaceFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "requestReindex";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initIndexStorage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "performShutdown";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeDataFromIndicesForFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeFileDataFromIndices";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientFileDataFromIndices";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "disableUpToDateCheckIn";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "areUnsavedDocumentsIndexed";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "filesUpdateFinished";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fireUpdateFinished";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCauseToRebuildIndex";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "clearIndex";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocuments";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocument";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getInMemoryData";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "runCleanupAction";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "doRequestRebuild";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilter";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processRefreshedFile";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "indexFileContent";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "doIndexFileContent";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getBytesOrNull";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedIndexCandidates";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "initFileContent";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "updateSingleIndex";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedState";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "needsFileContentLoading";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getContainingProjects";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "belongsToProjectIndexableFiles";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "belongsToIndexableFiles";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "containsIndexableSet";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "doTransientStateChangeForFile";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "doInvalidateIndicesForFile";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFileForIndexing";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndexFile";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingState";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexableSet";
                break;
            }
            case 101: 
            case 102: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInput";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "removeIndexableSet";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "findLatestKnownPsiForUncomittedDocument";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isFileIndexedInCurrentSession";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getIndexExtensionVersion";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "composeInputFilter";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "extractFileEnumeration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 23: 
            case 34: 
            case 37: 
            case 46: 
            case 50: 
            case 51: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 77: 
            case 78: 
            case 87: 
            case 88: 
            case 93: 
            case 94: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 118: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class VirtualFileUpdateTask
    extends UpdateTask<VirtualFile> {
        private VirtualFileUpdateTask() {
        }

        @Override
        void doProcess(VirtualFile item, Project project) {
            FileBasedIndexImpl.this.processRefreshedFile(project, new CachedFileContent(item));
        }
    }

    private static final class SingleIndexUpdateStats {
        public final long mapInputTime;
        public final boolean indexWasProvidedByExtension;

        private SingleIndexUpdateStats(long mapInputTime, boolean indexWasProvidedByExtension) {
            this.mapInputTime = mapInputTime;
            this.indexWasProvidedByExtension = indexWasProvidedByExtension;
        }
    }

    static class MyShutDownTask
    implements Runnable {
        MyShutDownTask() {
        }

        @Override
        public void run() {
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            if (fileBasedIndex instanceof FileBasedIndexImpl) {
                ((FileBasedIndexImpl)fileBasedIndex).performShutdown(false, "IDE shutdown");
            }
        }
    }
}

