/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/IndexingFlag;", "", "()V", "cleanProcessedFlagRecursively", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "cleanProcessingFlag", "cleanupProcessedFlag", "setFileIndexed", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class IndexingFlag {
    @NotNull
    public static final IndexingFlag INSTANCE;

    @JvmStatic
    public static final void cleanupProcessedFlag() {
        VirtualFile[] roots2;
        ManagingFS managingFS = ManagingFS.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)managingFS, (String)"ManagingFS.getInstance()");
        VirtualFile[] virtualFileArray = roots2 = managingFS.getRoots();
        int n = virtualFileArray.length;
        for (int j = 0; j < n; ++j) {
            VirtualFile root2;
            VirtualFile virtualFile2 = root2 = virtualFileArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"root");
            IndexingFlag.cleanProcessedFlagRecursively(virtualFile2);
        }
    }

    @JvmStatic
    public static final void cleanProcessedFlagRecursively(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof VirtualFileSystemEntry)) {
            return;
        }
        IndexingFlag.cleanProcessingFlag(file2);
        if (file2.isDirectory()) {
            Iterator iterator2 = ((VirtualFileSystemEntry)file2).getCachedChildren().iterator();
            while (iterator2.hasNext()) {
                VirtualFile child2;
                VirtualFile virtualFile2 = child2 = (VirtualFile)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"child");
                IndexingFlag.cleanProcessedFlagRecursively(virtualFile2);
            }
        }
    }

    @JvmStatic
    public static final void cleanProcessingFlag(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof VirtualFileSystemEntry) {
            ((VirtualFileSystemEntry)file2).setFileIndexed(false);
        }
    }

    @JvmStatic
    public static final void setFileIndexed(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof VirtualFileSystemEntry) {
            ((VirtualFileSystemEntry)file2).setFileIndexed(true);
        }
    }

    private IndexingFlag() {
    }

    static {
        IndexingFlag indexingFlag;
        INSTANCE = indexingFlag = new IndexingFlag();
    }
}

