/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.actions.SynchronizeCurrentFileAction;
import com.intellij.ide.actions.cache.AsyncRecoveryResult;
import com.intellij.ide.actions.cache.CacheInconsistencyProblem;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR%\u0010\u000b\u001a\u00130\u0004\u00a2\u0006\u000e\b\f\u0012\n\b\r\u0012\u0006\b\n0\u000e8\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction;", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "()V", "actionKey", "", "getActionKey", "()Ljava/lang/String;", "performanceRate", "", "getPerformanceRate", "()I", "presentableName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getPresentableName", "performSync", "", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "project", "Lcom/intellij/openapi/project/Project;", "Event", "EventLog", "intellij.platform.lang.impl"})
public final class RefreshIndexableFilesAction
implements RecoveryAction {
    @Override
    public int getPerformanceRate() {
        return 9999;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = LangBundle.message((String)"refresh.indexable.files.recovery.action.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"refr\u2026es.recovery.action.name\")");
        return string;
    }

    @Override
    @NotNull
    public String getActionKey() {
        return "refresh";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CacheInconsistencyProblem> performSync(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Event $this$flatMapTo$iv$iv;
        Object actionDisposable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ManagingFS managingFS = ManagingFS.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)managingFS, (String)"ManagingFS.getInstance()");
        VirtualFile[] localRoots = managingFS.getLocalRoots();
        RefreshQueue.getInstance().refresh(false, true, null, Arrays.copyOf(localRoots, localRoots.length));
        EventLog eventLog = new EventLog();
        Disposable $this$use$iv = Disposer.newDisposable();
        boolean $i$f$use = false;
        try {
            actionDisposable = $this$use$iv;
            boolean bl = false;
            project.getMessageBus().connect(actionDisposable).subscribe(VirtualFileManager.VFS_CHANGES, (Object)eventLog);
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            if (fileBasedIndex == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
            }
            FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
            List<IndexableFilesIterator> list2 = fileBasedIndex2.getIndexableFilesProviders(project);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"fileBasedIndex.getIndexableFilesProviders(project)");
            Iterable $this$flatMap$iv = list2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                IndexableFilesIterator it = (IndexableFilesIterator)element$iv$iv;
                boolean bl2 = false;
                IndexableFilesIterator indexableFilesIterator = it;
                Intrinsics.checkNotNullExpressionValue((Object)indexableFilesIterator, (String)"it");
                Iterable list$iv$iv = indexableFilesIterator.getRootUrls();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List rootUrls = (List)destination$iv$iv;
            $i$f$flatMap = false;
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
            for (String rootUrl : rootUrls) {
                VirtualFile file2 = VirtualFileManager.getInstance().refreshAndFindFileByUrl(rootUrl);
                if (file2 == null) continue;
                files2.add(file2);
            }
            SynchronizeCurrentFileAction.synchronizeFiles((Collection<VirtualFile>)files2, project, false);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if ($this$use$iv != null) {
                Disposer.dispose((Disposable)$this$use$iv);
            }
        }
        Iterable $this$map$iv = eventLog.getLoggedEvents();
        boolean $i$f$map = false;
        actionDisposable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            $this$flatMapTo$iv$iv = (Event)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CacheInconsistencyProblem cacheInconsistencyProblem = it.toCacheInconsistencyProblem();
            collection.add(cacheInconsistencyProblem);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean canBeApplied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RecoveryAction.DefaultImpls.canBeApplied(this, project);
    }

    @Override
    @NotNull
    public CompletableFuture<AsyncRecoveryResult> perform(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RecoveryAction.DefaultImpls.perform(this, project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0004H\u0016J\u0018\u0010\f\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0004H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction$EventLog;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "()V", "loggedEvents", "", "Lcom/intellij/util/indexing/RefreshIndexableFilesAction$Event;", "getLoggedEvents", "()Ljava/util/List;", "after", "", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "logEvent", "event", "intellij.platform.lang.impl"})
    private static final class EventLog
    implements BulkFileListener {
        @NotNull
        private final List<Event> loggedEvents;

        @NotNull
        public final List<Event> getLoggedEvents() {
            return this.loggedEvents;
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFileCreateEvent) continue;
                this.logEvent(vFileEvent);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileCreateEvent)) continue;
                this.logEvent(vFileEvent);
            }
        }

        private final void logEvent(VFileEvent event) {
            block0: {
                VirtualFile virtualFile2 = event.getFile();
                if (virtualFile2 == null) break block0;
                VirtualFile virtualFile3 = virtualFile2;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile3;
                boolean bl3 = false;
                VirtualFile virtualFile4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
                String string = virtualFile4.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.url");
                this.loggedEvents.add(new Event(string));
            }
        }

        public EventLog() {
            boolean bl = false;
            this.loggedEvents = new ArrayList();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction$Event;", "", "affectedFileUrl", "", "(Ljava/lang/String;)V", "getAffectedFileUrl", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toCacheInconsistencyProblem", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "toString", "intellij.platform.lang.impl"})
    private static final class Event {
        @NotNull
        private final String affectedFileUrl;

        @NotNull
        public final CacheInconsistencyProblem toCacheInconsistencyProblem() {
            return new CacheInconsistencyProblem(this){
                final /* synthetic */ Event this$0;

                @NotNull
                public String getMessage() {
                    return "vfs event on " + this.this$0.getAffectedFileUrl();
                }
                {
                    this.this$0 = this$0;
                }
            };
        }

        @NotNull
        public final String getAffectedFileUrl() {
            return this.affectedFileUrl;
        }

        public Event(@NotNull String affectedFileUrl) {
            Intrinsics.checkNotNullParameter((Object)affectedFileUrl, (String)"affectedFileUrl");
            this.affectedFileUrl = affectedFileUrl;
        }

        @NotNull
        public final String component1() {
            return this.affectedFileUrl;
        }

        @NotNull
        public final Event copy(@NotNull String affectedFileUrl) {
            Intrinsics.checkNotNullParameter((Object)affectedFileUrl, (String)"affectedFileUrl");
            return new Event(affectedFileUrl);
        }

        public static /* synthetic */ Event copy$default(Event event, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = event.affectedFileUrl;
            }
            return event.copy(string);
        }

        @NotNull
        public String toString() {
            return "Event(affectedFileUrl=" + this.affectedFileUrl + ")";
        }

        public int hashCode() {
            String string = this.affectedFileUrl;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Event)) break block3;
                    Event event = (Event)object;
                    if (!Intrinsics.areEqual((Object)this.affectedFileUrl, (Object)event.affectedFileUrl)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

