/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.diagnostic.BiggestFileTypeContributor;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.IndexingTimes;
import com.intellij.util.indexing.diagnostic.LimitedPriorityQueue;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.ScanningStatistics;
import com.intellij.util.indexing.diagnostic.SnapshotInputMappingStats;
import com.intellij.util.indexing.diagnostic.StatsPerFileType;
import com.intellij.util.indexing.diagnostic.StatsPerIndexer;
import com.intellij.util.indexing.diagnostic.dto.JsonConverterKt;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\t\b\u0087\b\u0018\u0000 =2\u00020\u0001:\u0006<=>?@AB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020.J\u0014\u0010/\u001a\u00020*2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c2\u0003J)\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u00107\u001a\u00020\u00072\b\u00108\u001a\u0004\u0018\u000109H\u00d6\u0003J\t\u0010:\u001a\u00020\nH\u00d6\u0001J\t\u0010;\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0014j\b\u0012\u0004\u0012\u00020\u001a`\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR0\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"`#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R0\u0010&\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020'0!j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020'`#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "project", "Lcom/intellij/openapi/project/Project;", "indexingReason", "", "wasFullIndexing", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Z)V", "biggestContributorsPerFileTypeLimit", "", "getIndexingReason", "()Ljava/lang/String;", "indexingSessionId", "", "getIndexingSessionId", "()J", "getProject", "()Lcom/intellij/openapi/project/Project;", "providerStatistics", "Ljava/util/ArrayList;", "Lcom/intellij/util/indexing/diagnostic/dto/JsonFileProviderIndexStatistics;", "Lkotlin/collections/ArrayList;", "getProviderStatistics", "()Ljava/util/ArrayList;", "scanningStatistics", "Lcom/intellij/util/indexing/diagnostic/dto/JsonScanningStatistics;", "getScanningStatistics", "times", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "getTimes", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "totalStatsPerFileType", "Ljava/util/HashMap;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$StatsPerFileTypeImpl;", "Lkotlin/collections/HashMap;", "getTotalStatsPerFileType", "()Ljava/util/HashMap;", "totalStatsPerIndexer", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$StatsPerIndexerImpl;", "getTotalStatsPerIndexer", "addProviderStatistics", "", "statistics", "Lcom/intellij/util/indexing/diagnostic/IndexingJobStatistics;", "addScanningStatistics", "Lcom/intellij/util/indexing/diagnostic/ScanningStatistics;", "addSnapshotInputMappingStatistics", "snapshotInputMappingsStatistics", "", "Lcom/intellij/util/indexing/snapshot/SnapshotInputMappingsStatistics;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "BiggestFileTypeContributorImpl", "Companion", "IndexingTimesImpl", "SnapshotInputMappingStatsImpl", "StatsPerFileTypeImpl", "StatsPerIndexerImpl", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class ProjectIndexingHistoryImpl
implements ProjectIndexingHistory {
    private final long indexingSessionId;
    private final int biggestContributorsPerFileTypeLimit;
    @NotNull
    private final IndexingTimesImpl times;
    @NotNull
    private final ArrayList<JsonScanningStatistics> scanningStatistics;
    @NotNull
    private final ArrayList<JsonFileProviderIndexStatistics> providerStatistics;
    @NotNull
    private final HashMap<String, StatsPerFileTypeImpl> totalStatsPerFileType;
    @NotNull
    private final HashMap<String, StatsPerIndexerImpl> totalStatsPerIndexer;
    @NotNull
    private final Project project;
    @Nullable
    private final String indexingReason;
    private final boolean wasFullIndexing;
    @Deprecated
    @NotNull
    private static final AtomicLong indexingSessionIdSequencer;
    @NotNull
    private static final Companion Companion;

    @Override
    public long getIndexingSessionId() {
        return this.indexingSessionId;
    }

    @Override
    @NotNull
    public IndexingTimesImpl getTimes() {
        return this.times;
    }

    @NotNull
    public ArrayList<JsonScanningStatistics> getScanningStatistics() {
        return this.scanningStatistics;
    }

    @NotNull
    public ArrayList<JsonFileProviderIndexStatistics> getProviderStatistics() {
        return this.providerStatistics;
    }

    @NotNull
    public HashMap<String, StatsPerFileTypeImpl> getTotalStatsPerFileType() {
        return this.totalStatsPerFileType;
    }

    @NotNull
    public HashMap<String, StatsPerIndexerImpl> getTotalStatsPerIndexer() {
        return this.totalStatsPerIndexer;
    }

    public final void addScanningStatistics(@NotNull ScanningStatistics statistics) {
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        Collection collection = this.getScanningStatistics();
        JsonScanningStatistics jsonScanningStatistics = JsonConverterKt.toJsonStatistics(statistics);
        boolean bl = false;
        collection.add(jsonScanningStatistics);
    }

    /*
     * WARNING - void declaration
     */
    public final void addProviderStatistics(@NotNull IndexingJobStatistics statistics) {
        Object totalStats;
        Object answer$iv;
        Object value$iv;
        Object fileType;
        boolean $i$f$getOrPut;
        Map $this$getOrPut$iv22;
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        Map.Entry entry22 = this.getProviderStatistics();
        Iterator iterator2 = JsonConverterKt.toJsonStatistics(statistics);
        boolean bl = false;
        entry22.add(iterator2);
        Object object = statistics.getStatsPerFileType();
        boolean bl2 = false;
        iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2;
            Map.Entry entry3 = entry22 = (Map.Entry)iterator2.next();
            boolean bl3 = false;
            object = (String)entry3.getKey();
            entry3 = entry22;
            bl3 = false;
            IndexingJobStatistics.StatsPerFileType fileTypeStats = (IndexingJobStatistics.StatsPerFileType)entry3.getValue();
            $this$getOrPut$iv22 = this.getTotalStatsPerFileType();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv22.get(fileType);
            if (value$iv == null) {
                boolean bl4 = false;
                boolean bl5 = false;
                answer$iv = new StatsPerFileTypeImpl(0, 0L, 0L, 0L, new LimitedPriorityQueue<BiggestFileTypeContributorImpl>(this.biggestContributorsPerFileTypeLimit, new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        BiggestFileTypeContributorImpl it = (BiggestFileTypeContributorImpl)a;
                        boolean bl2 = false;
                        Comparable comparable = Long.valueOf(it.getProcessingTimeInAllThreads());
                        it = (BiggestFileTypeContributorImpl)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Comparable comparable3 = Long.valueOf(it.getProcessingTimeInAllThreads());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                    }
                }));
                $this$getOrPut$iv22.put(fileType, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Object object3 = totalStats = (StatsPerFileTypeImpl)object2;
            ((StatsPerFileTypeImpl)object3).setTotalNumberOfFiles(((StatsPerFileTypeImpl)object3).getTotalNumberOfFiles() + fileTypeStats.getNumberOfFiles());
            Object object4 = totalStats;
            ((StatsPerFileTypeImpl)object4).setTotalBytes(((StatsPerFileTypeImpl)object4).getTotalBytes() + fileTypeStats.getTotalBytes());
            Object object5 = totalStats;
            ((StatsPerFileTypeImpl)object5).setTotalProcessingTimeInAllThreads(((StatsPerFileTypeImpl)object5).getTotalProcessingTimeInAllThreads() + fileTypeStats.getProcessingTimeInAllThreads());
            Object object6 = totalStats;
            ((StatsPerFileTypeImpl)object6).setTotalContentLoadingTimeInAllThreads(((StatsPerFileTypeImpl)object6).getTotalContentLoadingTimeInAllThreads() + fileTypeStats.getContentLoadingTimeInAllThreads());
            ((StatsPerFileTypeImpl)totalStats).getBiggestFileTypeContributors().addElement(new BiggestFileTypeContributorImpl(statistics.getFileSetName(), fileTypeStats.getNumberOfFiles(), fileTypeStats.getTotalBytes(), fileTypeStats.getProcessingTimeInAllThreads()));
        }
        fileType = statistics.getStatsPerIndexer();
        boolean fileTypeStats = false;
        for (Map.Entry entry22 : fileType.entrySet()) {
            Object object7;
            void indexId;
            totalStats = entry22;
            boolean $this$getOrPut$iv22 = false;
            fileType = (String)totalStats.getKey();
            totalStats = entry22;
            $this$getOrPut$iv22 = false;
            IndexingJobStatistics.StatsPerIndexer stats = (IndexingJobStatistics.StatsPerIndexer)totalStats.getValue();
            $this$getOrPut$iv22 = this.getTotalStatsPerIndexer();
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv22.get(indexId);
            if (value$iv == null) {
                boolean bl6 = false;
                answer$iv = new StatsPerIndexerImpl(0, 0, 0L, 0L, new SnapshotInputMappingStatsImpl(0L, 0L));
                $this$getOrPut$iv22.put(indexId, answer$iv);
                object7 = answer$iv;
            } else {
                object7 = value$iv;
            }
            Object object8 = totalStats = (StatsPerIndexerImpl)object7;
            ((StatsPerIndexerImpl)object8).setTotalNumberOfFiles(((StatsPerIndexerImpl)object8).getTotalNumberOfFiles() + stats.getNumberOfFiles());
            Object object9 = totalStats;
            ((StatsPerIndexerImpl)object9).setTotalNumberOfFilesIndexedByExtensions(((StatsPerIndexerImpl)object9).getTotalNumberOfFilesIndexedByExtensions() + stats.getNumberOfFilesIndexedByExtensions());
            Object object10 = totalStats;
            ((StatsPerIndexerImpl)object10).setTotalBytes(((StatsPerIndexerImpl)object10).getTotalBytes() + stats.getTotalBytes());
            Object object11 = totalStats;
            ((StatsPerIndexerImpl)object11).setTotalIndexingTimeInAllThreads(((StatsPerIndexerImpl)object11).getTotalIndexingTimeInAllThreads() + stats.getIndexingTime());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addSnapshotInputMappingStatistics(@NotNull List<SnapshotInputMappingsStatistics> snapshotInputMappingsStatistics) {
        Intrinsics.checkNotNullParameter(snapshotInputMappingsStatistics, (String)"snapshotInputMappingsStatistics");
        for (SnapshotInputMappingsStatistics mappingsStatistic : snapshotInputMappingsStatistics) {
            Object object;
            String key$iv;
            void $this$getOrPut$iv;
            Map map2 = this.getTotalStatsPerIndexer();
            ID<?, ?> iD = mappingsStatistic.getIndexId();
            Intrinsics.checkNotNullExpressionValue(iD, (String)"mappingsStatistic.indexId");
            Intrinsics.checkNotNullExpressionValue((Object)iD.getName(), (String)"mappingsStatistic.indexId.name");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                StatsPerIndexerImpl answer$iv = new StatsPerIndexerImpl(0, 0, 0L, 0L, new SnapshotInputMappingStatsImpl(0L, 0L));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            StatsPerIndexerImpl totalStats = (StatsPerIndexerImpl)object;
            SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl = totalStats.getSnapshotInputMappingStats();
            snapshotInputMappingStatsImpl.setRequests(snapshotInputMappingStatsImpl.getRequests() + mappingsStatistic.getTotalRequests());
            SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl2 = totalStats.getSnapshotInputMappingStats();
            snapshotInputMappingStatsImpl2.setMisses(snapshotInputMappingStatsImpl2.getMisses() + mappingsStatistic.getTotalMisses());
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    public String getIndexingReason() {
        return this.indexingReason;
    }

    public ProjectIndexingHistoryImpl(@NotNull Project project, @Nullable String indexingReason, boolean wasFullIndexing) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.indexingReason = indexingReason;
        this.wasFullIndexing = wasFullIndexing;
        this.indexingSessionId = indexingSessionIdSequencer.getAndIncrement();
        this.biggestContributorsPerFileTypeLimit = 10;
        String string = this.getIndexingReason();
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.now(ZoneOffset.UTC)");
        this.times = new IndexingTimesImpl(string, this.wasFullIndexing, zonedDateTime, System.nanoTime(), null, null, null, null, null, null, null, false, 4080, null);
        boolean bl = false;
        this.scanningStatistics = new ArrayList();
        bl = false;
        this.providerStatistics = new ArrayList();
        bl = false;
        this.totalStatsPerFileType = new HashMap();
        bl = false;
        this.totalStatsPerIndexer = new HashMap();
    }

    static {
        Companion = new Companion(null);
        indexingSessionIdSequencer = new AtomicLong();
    }

    @NotNull
    public final Project component1() {
        return this.getProject();
    }

    @Nullable
    public final String component2() {
        return this.getIndexingReason();
    }

    private final boolean component3() {
        return this.wasFullIndexing;
    }

    @NotNull
    public final ProjectIndexingHistoryImpl copy(@NotNull Project project, @Nullable String indexingReason, boolean wasFullIndexing) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ProjectIndexingHistoryImpl(project, indexingReason, wasFullIndexing);
    }

    public static /* synthetic */ ProjectIndexingHistoryImpl copy$default(ProjectIndexingHistoryImpl projectIndexingHistoryImpl, Project project, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            project = projectIndexingHistoryImpl.getProject();
        }
        if ((n & 2) != 0) {
            string = projectIndexingHistoryImpl.getIndexingReason();
        }
        if ((n & 4) != 0) {
            bl = projectIndexingHistoryImpl.wasFullIndexing;
        }
        return projectIndexingHistoryImpl.copy(project, string, bl);
    }

    @NotNull
    public String toString() {
        return "ProjectIndexingHistoryImpl(project=" + this.getProject() + ", indexingReason=" + this.getIndexingReason() + ", wasFullIndexing=" + this.wasFullIndexing + ")";
    }

    public int hashCode() {
        Project project = this.getProject();
        String string = this.getIndexingReason();
        int n = ((project != null ? project.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
        int n2 = this.wasFullIndexing ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProjectIndexingHistoryImpl)) break block3;
                ProjectIndexingHistoryImpl projectIndexingHistoryImpl = (ProjectIndexingHistoryImpl)object;
                if (!Intrinsics.areEqual((Object)this.getProject(), (Object)projectIndexingHistoryImpl.getProject()) || !Intrinsics.areEqual((Object)this.getIndexingReason(), (Object)projectIndexingHistoryImpl.getIndexingReason()) || this.wasFullIndexing != projectIndexingHistoryImpl.wasFullIndexing) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\n\u0010\u0007\u001a\u00060\u0005j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0005j\u0002`\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\"\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J\r\u0010#\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\r\u0010$\u001a\u00060\u0005j\u0002`\bH\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JM\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\b\u0002\u0010\u0007\u001a\u00060\u0005j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0005j\u0002`\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\t\u001a\u00060\u0005j\u0002`\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010\u0007\u001a\u00060\u0005j\u0002`\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018\u00a8\u0006."}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$StatsPerFileTypeImpl;", "Lcom/intellij/util/indexing/diagnostic/StatsPerFileType;", "totalNumberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalProcessingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "totalContentLoadingTimeInAllThreads", "biggestFileTypeContributors", "Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$BiggestFileTypeContributorImpl;", "(IJJJLcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;)V", "biggestFileTypeContributorList", "", "Lcom/intellij/util/indexing/diagnostic/BiggestFileTypeContributor;", "getBiggestFileTypeContributorList", "()Ljava/util/List;", "getBiggestFileTypeContributors", "()Lcom/intellij/util/indexing/diagnostic/LimitedPriorityQueue;", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalContentLoadingTimeInAllThreads", "setTotalContentLoadingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "getTotalProcessingTimeInAllThreads", "setTotalProcessingTimeInAllThreads", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerFileTypeImpl
    implements StatsPerFileType {
        private int totalNumberOfFiles;
        private long totalBytes;
        private long totalProcessingTimeInAllThreads;
        private long totalContentLoadingTimeInAllThreads;
        @NotNull
        private final LimitedPriorityQueue<BiggestFileTypeContributorImpl> biggestFileTypeContributors;

        @Override
        @NotNull
        public List<BiggestFileTypeContributor> getBiggestFileTypeContributorList() {
            return this.biggestFileTypeContributors.getBiggestElements();
        }

        @Override
        public int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        public void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        @Override
        public long getTotalProcessingTimeInAllThreads() {
            return this.totalProcessingTimeInAllThreads;
        }

        public void setTotalProcessingTimeInAllThreads(long l) {
            this.totalProcessingTimeInAllThreads = l;
        }

        @Override
        public long getTotalContentLoadingTimeInAllThreads() {
            return this.totalContentLoadingTimeInAllThreads;
        }

        public void setTotalContentLoadingTimeInAllThreads(long l) {
            this.totalContentLoadingTimeInAllThreads = l;
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributorImpl> getBiggestFileTypeContributors() {
            return this.biggestFileTypeContributors;
        }

        public StatsPerFileTypeImpl(int totalNumberOfFiles, long totalBytes, long totalProcessingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributorImpl> biggestFileTypeContributors) {
            Intrinsics.checkNotNullParameter(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalBytes = totalBytes;
            this.totalProcessingTimeInAllThreads = totalProcessingTimeInAllThreads;
            this.totalContentLoadingTimeInAllThreads = totalContentLoadingTimeInAllThreads;
            this.biggestFileTypeContributors = biggestFileTypeContributors;
        }

        public final int component1() {
            return this.getTotalNumberOfFiles();
        }

        public final long component2() {
            return this.getTotalBytes();
        }

        public final long component3() {
            return this.getTotalProcessingTimeInAllThreads();
        }

        public final long component4() {
            return this.getTotalContentLoadingTimeInAllThreads();
        }

        @NotNull
        public final LimitedPriorityQueue<BiggestFileTypeContributorImpl> component5() {
            return this.biggestFileTypeContributors;
        }

        @NotNull
        public final StatsPerFileTypeImpl copy(int totalNumberOfFiles, long totalBytes, long totalProcessingTimeInAllThreads, long totalContentLoadingTimeInAllThreads, @NotNull LimitedPriorityQueue<BiggestFileTypeContributorImpl> biggestFileTypeContributors) {
            Intrinsics.checkNotNullParameter(biggestFileTypeContributors, (String)"biggestFileTypeContributors");
            return new StatsPerFileTypeImpl(totalNumberOfFiles, totalBytes, totalProcessingTimeInAllThreads, totalContentLoadingTimeInAllThreads, biggestFileTypeContributors);
        }

        public static /* synthetic */ StatsPerFileTypeImpl copy$default(StatsPerFileTypeImpl statsPerFileTypeImpl, int n, long l, long l2, long l3, LimitedPriorityQueue limitedPriorityQueue, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = statsPerFileTypeImpl.getTotalNumberOfFiles();
            }
            if ((n2 & 2) != 0) {
                l = statsPerFileTypeImpl.getTotalBytes();
            }
            if ((n2 & 4) != 0) {
                l2 = statsPerFileTypeImpl.getTotalProcessingTimeInAllThreads();
            }
            if ((n2 & 8) != 0) {
                l3 = statsPerFileTypeImpl.getTotalContentLoadingTimeInAllThreads();
            }
            if ((n2 & 0x10) != 0) {
                limitedPriorityQueue = statsPerFileTypeImpl.biggestFileTypeContributors;
            }
            return statsPerFileTypeImpl.copy(n, l, l2, l3, limitedPriorityQueue);
        }

        @NotNull
        public String toString() {
            return "StatsPerFileTypeImpl(totalNumberOfFiles=" + this.getTotalNumberOfFiles() + ", totalBytes=" + this.getTotalBytes() + ", totalProcessingTimeInAllThreads=" + this.getTotalProcessingTimeInAllThreads() + ", totalContentLoadingTimeInAllThreads=" + this.getTotalContentLoadingTimeInAllThreads() + ", biggestFileTypeContributors=" + this.biggestFileTypeContributors + ")";
        }

        public int hashCode() {
            LimitedPriorityQueue<BiggestFileTypeContributorImpl> limitedPriorityQueue = this.biggestFileTypeContributors;
            return (((Integer.hashCode(this.getTotalNumberOfFiles()) * 31 + Long.hashCode(this.getTotalBytes())) * 31 + Long.hashCode(this.getTotalProcessingTimeInAllThreads())) * 31 + Long.hashCode(this.getTotalContentLoadingTimeInAllThreads())) * 31 + (limitedPriorityQueue != null ? limitedPriorityQueue.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerFileTypeImpl)) break block3;
                    StatsPerFileTypeImpl statsPerFileTypeImpl = (StatsPerFileTypeImpl)object;
                    if (this.getTotalNumberOfFiles() != statsPerFileTypeImpl.getTotalNumberOfFiles() || this.getTotalBytes() != statsPerFileTypeImpl.getTotalBytes() || this.getTotalProcessingTimeInAllThreads() != statsPerFileTypeImpl.getTotalProcessingTimeInAllThreads() || this.getTotalContentLoadingTimeInAllThreads() != statsPerFileTypeImpl.getTotalContentLoadingTimeInAllThreads() || !Intrinsics.areEqual(this.biggestFileTypeContributors, statsPerFileTypeImpl.biggestFileTypeContributors)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\n\u0010\t\u001a\u00060\u0007j\u0002`\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u0015\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J\r\u0010\u0016\u001a\u00060\u0007j\u0002`\nH\u00c6\u0003J9\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\f\b\u0002\u0010\t\u001a\u00060\u0007j\u0002`\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\t\u001a\u00060\u0007j\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$BiggestFileTypeContributorImpl;", "Lcom/intellij/util/indexing/diagnostic/BiggestFileTypeContributor;", "providerName", "", "numberOfFiles", "", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "processingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "(Ljava/lang/String;IJJ)V", "getNumberOfFiles", "()I", "getProcessingTimeInAllThreads", "()J", "getProviderName", "()Ljava/lang/String;", "getTotalBytes", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.platform.lang.impl"})
    public static final class BiggestFileTypeContributorImpl
    implements BiggestFileTypeContributor {
        @NotNull
        private final String providerName;
        private final int numberOfFiles;
        private final long totalBytes;
        private final long processingTimeInAllThreads;

        @Override
        @NotNull
        public String getProviderName() {
            return this.providerName;
        }

        @Override
        public int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        @Override
        public long getProcessingTimeInAllThreads() {
            return this.processingTimeInAllThreads;
        }

        public BiggestFileTypeContributorImpl(@NotNull String providerName, int numberOfFiles, long totalBytes, long processingTimeInAllThreads) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.providerName = providerName;
            this.numberOfFiles = numberOfFiles;
            this.totalBytes = totalBytes;
            this.processingTimeInAllThreads = processingTimeInAllThreads;
        }

        @NotNull
        public final String component1() {
            return this.getProviderName();
        }

        public final int component2() {
            return this.getNumberOfFiles();
        }

        public final long component3() {
            return this.getTotalBytes();
        }

        public final long component4() {
            return this.getProcessingTimeInAllThreads();
        }

        @NotNull
        public final BiggestFileTypeContributorImpl copy(@NotNull String providerName, int numberOfFiles, long totalBytes, long processingTimeInAllThreads) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            return new BiggestFileTypeContributorImpl(providerName, numberOfFiles, totalBytes, processingTimeInAllThreads);
        }

        public static /* synthetic */ BiggestFileTypeContributorImpl copy$default(BiggestFileTypeContributorImpl biggestFileTypeContributorImpl, String string, int n, long l, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = biggestFileTypeContributorImpl.getProviderName();
            }
            if ((n2 & 2) != 0) {
                n = biggestFileTypeContributorImpl.getNumberOfFiles();
            }
            if ((n2 & 4) != 0) {
                l = biggestFileTypeContributorImpl.getTotalBytes();
            }
            if ((n2 & 8) != 0) {
                l2 = biggestFileTypeContributorImpl.getProcessingTimeInAllThreads();
            }
            return biggestFileTypeContributorImpl.copy(string, n, l, l2);
        }

        @NotNull
        public String toString() {
            return "BiggestFileTypeContributorImpl(providerName=" + this.getProviderName() + ", numberOfFiles=" + this.getNumberOfFiles() + ", totalBytes=" + this.getTotalBytes() + ", processingTimeInAllThreads=" + this.getProcessingTimeInAllThreads() + ")";
        }

        public int hashCode() {
            String string = this.getProviderName();
            return (((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.getNumberOfFiles())) * 31 + Long.hashCode(this.getTotalBytes())) * 31 + Long.hashCode(this.getProcessingTimeInAllThreads());
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BiggestFileTypeContributorImpl)) break block3;
                    BiggestFileTypeContributorImpl biggestFileTypeContributorImpl = (BiggestFileTypeContributorImpl)object;
                    if (!Intrinsics.areEqual((Object)this.getProviderName(), (Object)biggestFileTypeContributorImpl.getProviderName()) || this.getNumberOfFiles() != biggestFileTypeContributorImpl.getNumberOfFiles() || this.getTotalBytes() != biggestFileTypeContributorImpl.getTotalBytes() || this.getProcessingTimeInAllThreads() != biggestFileTypeContributorImpl.getProcessingTimeInAllThreads()) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001f\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0003J\r\u0010 \u001a\u00060\u0006j\u0002`\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c6\u0003JC\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\f\b\u0002\u0010\b\u001a\u00060\u0006j\u0002`\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\b\u001a\u00060\u0006j\u0002`\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$StatsPerIndexerImpl;", "Lcom/intellij/util/indexing/diagnostic/StatsPerIndexer;", "totalNumberOfFiles", "", "totalNumberOfFilesIndexedByExtensions", "totalBytes", "", "Lcom/intellij/util/indexing/diagnostic/BytesNumber;", "totalIndexingTimeInAllThreads", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "snapshotInputMappingStats", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;", "(IIJJLcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;)V", "getSnapshotInputMappingStats", "()Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;", "setSnapshotInputMappingStats", "(Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;)V", "getTotalBytes", "()J", "setTotalBytes", "(J)V", "getTotalIndexingTimeInAllThreads", "setTotalIndexingTimeInAllThreads", "getTotalNumberOfFiles", "()I", "setTotalNumberOfFiles", "(I)V", "getTotalNumberOfFilesIndexedByExtensions", "setTotalNumberOfFilesIndexedByExtensions", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class StatsPerIndexerImpl
    implements StatsPerIndexer {
        private int totalNumberOfFiles;
        private int totalNumberOfFilesIndexedByExtensions;
        private long totalBytes;
        private long totalIndexingTimeInAllThreads;
        @NotNull
        private SnapshotInputMappingStatsImpl snapshotInputMappingStats;

        @Override
        public int getTotalNumberOfFiles() {
            return this.totalNumberOfFiles;
        }

        public void setTotalNumberOfFiles(int n) {
            this.totalNumberOfFiles = n;
        }

        @Override
        public int getTotalNumberOfFilesIndexedByExtensions() {
            return this.totalNumberOfFilesIndexedByExtensions;
        }

        public void setTotalNumberOfFilesIndexedByExtensions(int n) {
            this.totalNumberOfFilesIndexedByExtensions = n;
        }

        @Override
        public long getTotalBytes() {
            return this.totalBytes;
        }

        public void setTotalBytes(long l) {
            this.totalBytes = l;
        }

        @Override
        public long getTotalIndexingTimeInAllThreads() {
            return this.totalIndexingTimeInAllThreads;
        }

        public void setTotalIndexingTimeInAllThreads(long l) {
            this.totalIndexingTimeInAllThreads = l;
        }

        @Override
        @NotNull
        public SnapshotInputMappingStatsImpl getSnapshotInputMappingStats() {
            return this.snapshotInputMappingStats;
        }

        public void setSnapshotInputMappingStats(@NotNull SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStatsImpl, (String)"<set-?>");
            this.snapshotInputMappingStats = snapshotInputMappingStatsImpl;
        }

        public StatsPerIndexerImpl(int totalNumberOfFiles, int totalNumberOfFilesIndexedByExtensions, long totalBytes, long totalIndexingTimeInAllThreads, @NotNull SnapshotInputMappingStatsImpl snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"snapshotInputMappingStats");
            this.totalNumberOfFiles = totalNumberOfFiles;
            this.totalNumberOfFilesIndexedByExtensions = totalNumberOfFilesIndexedByExtensions;
            this.totalBytes = totalBytes;
            this.totalIndexingTimeInAllThreads = totalIndexingTimeInAllThreads;
            this.snapshotInputMappingStats = snapshotInputMappingStats;
        }

        public final int component1() {
            return this.getTotalNumberOfFiles();
        }

        public final int component2() {
            return this.getTotalNumberOfFilesIndexedByExtensions();
        }

        public final long component3() {
            return this.getTotalBytes();
        }

        public final long component4() {
            return this.getTotalIndexingTimeInAllThreads();
        }

        @NotNull
        public final SnapshotInputMappingStatsImpl component5() {
            return this.getSnapshotInputMappingStats();
        }

        @NotNull
        public final StatsPerIndexerImpl copy(int totalNumberOfFiles, int totalNumberOfFilesIndexedByExtensions, long totalBytes, long totalIndexingTimeInAllThreads, @NotNull SnapshotInputMappingStatsImpl snapshotInputMappingStats) {
            Intrinsics.checkNotNullParameter((Object)snapshotInputMappingStats, (String)"snapshotInputMappingStats");
            return new StatsPerIndexerImpl(totalNumberOfFiles, totalNumberOfFilesIndexedByExtensions, totalBytes, totalIndexingTimeInAllThreads, snapshotInputMappingStats);
        }

        public static /* synthetic */ StatsPerIndexerImpl copy$default(StatsPerIndexerImpl statsPerIndexerImpl, int n, int n2, long l, long l2, SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = statsPerIndexerImpl.getTotalNumberOfFiles();
            }
            if ((n3 & 2) != 0) {
                n2 = statsPerIndexerImpl.getTotalNumberOfFilesIndexedByExtensions();
            }
            if ((n3 & 4) != 0) {
                l = statsPerIndexerImpl.getTotalBytes();
            }
            if ((n3 & 8) != 0) {
                l2 = statsPerIndexerImpl.getTotalIndexingTimeInAllThreads();
            }
            if ((n3 & 0x10) != 0) {
                snapshotInputMappingStatsImpl = statsPerIndexerImpl.getSnapshotInputMappingStats();
            }
            return statsPerIndexerImpl.copy(n, n2, l, l2, snapshotInputMappingStatsImpl);
        }

        @NotNull
        public String toString() {
            return "StatsPerIndexerImpl(totalNumberOfFiles=" + this.getTotalNumberOfFiles() + ", totalNumberOfFilesIndexedByExtensions=" + this.getTotalNumberOfFilesIndexedByExtensions() + ", totalBytes=" + this.getTotalBytes() + ", totalIndexingTimeInAllThreads=" + this.getTotalIndexingTimeInAllThreads() + ", snapshotInputMappingStats=" + this.getSnapshotInputMappingStats() + ")";
        }

        public int hashCode() {
            SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl = this.getSnapshotInputMappingStats();
            return (((Integer.hashCode(this.getTotalNumberOfFiles()) * 31 + Integer.hashCode(this.getTotalNumberOfFilesIndexedByExtensions())) * 31 + Long.hashCode(this.getTotalBytes())) * 31 + Long.hashCode(this.getTotalIndexingTimeInAllThreads())) * 31 + (snapshotInputMappingStatsImpl != null ? ((Object)snapshotInputMappingStatsImpl).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StatsPerIndexerImpl)) break block3;
                    StatsPerIndexerImpl statsPerIndexerImpl = (StatsPerIndexerImpl)object;
                    if (this.getTotalNumberOfFiles() != statsPerIndexerImpl.getTotalNumberOfFiles() || this.getTotalNumberOfFilesIndexedByExtensions() != statsPerIndexerImpl.getTotalNumberOfFilesIndexedByExtensions() || this.getTotalBytes() != statsPerIndexerImpl.getTotalBytes() || this.getTotalIndexingTimeInAllThreads() != statsPerIndexerImpl.getTotalIndexingTimeInAllThreads() || !Intrinsics.areEqual((Object)this.getSnapshotInputMappingStats(), (Object)statsPerIndexerImpl.getSnapshotInputMappingStats())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b4\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B{\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u00060\tj\u0002`\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\r\u0012\b\b\u0002\u0010\u0012\u001a\u00020\r\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0014J\u000b\u00103\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003J\t\u00105\u001a\u00020\rH\u00c6\u0003J\t\u00106\u001a\u00020\u0005H\u00c6\u0003J\t\u00107\u001a\u00020\u0005H\u00c6\u0003J\t\u00108\u001a\u00020\u0007H\u00c6\u0003J\r\u00109\u001a\u00060\tj\u0002`\nH\u00c6\u0003J\t\u0010:\u001a\u00020\u0007H\u00c6\u0003J\t\u0010;\u001a\u00020\rH\u00c6\u0003J\t\u0010<\u001a\u00020\rH\u00c6\u0003J\t\u0010=\u001a\u00020\rH\u00c6\u0003J\t\u0010>\u001a\u00020\rH\u00c6\u0003J\u0087\u0001\u0010?\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\f\b\u0002\u0010\b\u001a\u00060\tj\u0002`\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010@\u001a\u00020\u00052\b\u0010A\u001a\u0004\u0018\u00010BH\u00d6\u0003J\t\u0010C\u001a\u00020DH\u00d6\u0001J\t\u0010E\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u000e\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0010\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u000f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010\u0018R\u001a\u0010\u0011\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010\u0018R\u001a\u0010\u0012\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u001e\u0010\b\u001a\u00060\tj\u0002`\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\u000b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010*R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u0010\u0013\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010/\"\u0004\b1\u00102\u00a8\u0006F"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$IndexingTimesImpl;", "Lcom/intellij/util/indexing/diagnostic/IndexingTimes;", "indexingReason", "", "wasFullIndexing", "", "updatingStart", "Ljava/time/ZonedDateTime;", "totalUpdatingTime", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "updatingEnd", "indexingDuration", "Ljava/time/Duration;", "contentLoadingDuration", "pushPropertiesDuration", "indexExtensionsDuration", "scanFilesDuration", "suspendedDuration", "wasInterrupted", "(Ljava/lang/String;ZLjava/time/ZonedDateTime;JLjava/time/ZonedDateTime;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;Z)V", "getContentLoadingDuration", "()Ljava/time/Duration;", "setContentLoadingDuration", "(Ljava/time/Duration;)V", "getIndexExtensionsDuration", "setIndexExtensionsDuration", "getIndexingDuration", "setIndexingDuration", "getIndexingReason", "()Ljava/lang/String;", "getPushPropertiesDuration", "setPushPropertiesDuration", "getScanFilesDuration", "setScanFilesDuration", "getSuspendedDuration", "setSuspendedDuration", "getTotalUpdatingTime", "()J", "setTotalUpdatingTime", "(J)V", "getUpdatingEnd", "()Ljava/time/ZonedDateTime;", "setUpdatingEnd", "(Ljava/time/ZonedDateTime;)V", "getUpdatingStart", "getWasFullIndexing", "()Z", "getWasInterrupted", "setWasInterrupted", "(Z)V", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    public static final class IndexingTimesImpl
    implements IndexingTimes {
        @Nullable
        private final String indexingReason;
        private final boolean wasFullIndexing;
        @NotNull
        private final ZonedDateTime updatingStart;
        private long totalUpdatingTime;
        @NotNull
        private ZonedDateTime updatingEnd;
        @NotNull
        private Duration indexingDuration;
        @NotNull
        private Duration contentLoadingDuration;
        @NotNull
        private Duration pushPropertiesDuration;
        @NotNull
        private Duration indexExtensionsDuration;
        @NotNull
        private Duration scanFilesDuration;
        @NotNull
        private Duration suspendedDuration;
        private boolean wasInterrupted;

        @Override
        @Nullable
        public String getIndexingReason() {
            return this.indexingReason;
        }

        @Override
        public boolean getWasFullIndexing() {
            return this.wasFullIndexing;
        }

        @Override
        @NotNull
        public ZonedDateTime getUpdatingStart() {
            return this.updatingStart;
        }

        @Override
        public long getTotalUpdatingTime() {
            return this.totalUpdatingTime;
        }

        public void setTotalUpdatingTime(long l) {
            this.totalUpdatingTime = l;
        }

        @Override
        @NotNull
        public ZonedDateTime getUpdatingEnd() {
            return this.updatingEnd;
        }

        public void setUpdatingEnd(@NotNull ZonedDateTime zonedDateTime) {
            Intrinsics.checkNotNullParameter((Object)zonedDateTime, (String)"<set-?>");
            this.updatingEnd = zonedDateTime;
        }

        @Override
        @NotNull
        public Duration getIndexingDuration() {
            return this.indexingDuration;
        }

        public void setIndexingDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.indexingDuration = duration;
        }

        @Override
        @NotNull
        public Duration getContentLoadingDuration() {
            return this.contentLoadingDuration;
        }

        public void setContentLoadingDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.contentLoadingDuration = duration;
        }

        @Override
        @NotNull
        public Duration getPushPropertiesDuration() {
            return this.pushPropertiesDuration;
        }

        public void setPushPropertiesDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.pushPropertiesDuration = duration;
        }

        @Override
        @NotNull
        public Duration getIndexExtensionsDuration() {
            return this.indexExtensionsDuration;
        }

        public void setIndexExtensionsDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.indexExtensionsDuration = duration;
        }

        @Override
        @NotNull
        public Duration getScanFilesDuration() {
            return this.scanFilesDuration;
        }

        public void setScanFilesDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.scanFilesDuration = duration;
        }

        @Override
        @NotNull
        public Duration getSuspendedDuration() {
            return this.suspendedDuration;
        }

        public void setSuspendedDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.suspendedDuration = duration;
        }

        @Override
        public boolean getWasInterrupted() {
            return this.wasInterrupted;
        }

        public void setWasInterrupted(boolean bl) {
            this.wasInterrupted = bl;
        }

        public IndexingTimesImpl(@Nullable String indexingReason, boolean wasFullIndexing, @NotNull ZonedDateTime updatingStart, long totalUpdatingTime, @NotNull ZonedDateTime updatingEnd, @NotNull Duration indexingDuration, @NotNull Duration contentLoadingDuration, @NotNull Duration pushPropertiesDuration, @NotNull Duration indexExtensionsDuration, @NotNull Duration scanFilesDuration, @NotNull Duration suspendedDuration, boolean wasInterrupted) {
            Intrinsics.checkNotNullParameter((Object)updatingStart, (String)"updatingStart");
            Intrinsics.checkNotNullParameter((Object)updatingEnd, (String)"updatingEnd");
            Intrinsics.checkNotNullParameter((Object)indexingDuration, (String)"indexingDuration");
            Intrinsics.checkNotNullParameter((Object)contentLoadingDuration, (String)"contentLoadingDuration");
            Intrinsics.checkNotNullParameter((Object)pushPropertiesDuration, (String)"pushPropertiesDuration");
            Intrinsics.checkNotNullParameter((Object)indexExtensionsDuration, (String)"indexExtensionsDuration");
            Intrinsics.checkNotNullParameter((Object)scanFilesDuration, (String)"scanFilesDuration");
            Intrinsics.checkNotNullParameter((Object)suspendedDuration, (String)"suspendedDuration");
            this.indexingReason = indexingReason;
            this.wasFullIndexing = wasFullIndexing;
            this.updatingStart = updatingStart;
            this.totalUpdatingTime = totalUpdatingTime;
            this.updatingEnd = updatingEnd;
            this.indexingDuration = indexingDuration;
            this.contentLoadingDuration = contentLoadingDuration;
            this.pushPropertiesDuration = pushPropertiesDuration;
            this.indexExtensionsDuration = indexExtensionsDuration;
            this.scanFilesDuration = scanFilesDuration;
            this.suspendedDuration = suspendedDuration;
            this.wasInterrupted = wasInterrupted;
        }

        public /* synthetic */ IndexingTimesImpl(String string, boolean bl, ZonedDateTime zonedDateTime, long l, ZonedDateTime zonedDateTime2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, Duration duration6, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                zonedDateTime2 = zonedDateTime;
            }
            if ((n & 0x20) != 0) {
                Duration duration7 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration7, (String)"Duration.ZERO");
                duration = duration7;
            }
            if ((n & 0x40) != 0) {
                Duration duration8 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration8, (String)"Duration.ZERO");
                duration2 = duration8;
            }
            if ((n & 0x80) != 0) {
                Duration duration9 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration9, (String)"Duration.ZERO");
                duration3 = duration9;
            }
            if ((n & 0x100) != 0) {
                Duration duration10 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration10, (String)"Duration.ZERO");
                duration4 = duration10;
            }
            if ((n & 0x200) != 0) {
                Duration duration11 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration11, (String)"Duration.ZERO");
                duration5 = duration11;
            }
            if ((n & 0x400) != 0) {
                Duration duration12 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration12, (String)"Duration.ZERO");
                duration6 = duration12;
            }
            if ((n & 0x800) != 0) {
                bl2 = false;
            }
            this(string, bl, zonedDateTime, l, zonedDateTime2, duration, duration2, duration3, duration4, duration5, duration6, bl2);
        }

        @Nullable
        public final String component1() {
            return this.getIndexingReason();
        }

        public final boolean component2() {
            return this.getWasFullIndexing();
        }

        @NotNull
        public final ZonedDateTime component3() {
            return this.getUpdatingStart();
        }

        public final long component4() {
            return this.getTotalUpdatingTime();
        }

        @NotNull
        public final ZonedDateTime component5() {
            return this.getUpdatingEnd();
        }

        @NotNull
        public final Duration component6() {
            return this.getIndexingDuration();
        }

        @NotNull
        public final Duration component7() {
            return this.getContentLoadingDuration();
        }

        @NotNull
        public final Duration component8() {
            return this.getPushPropertiesDuration();
        }

        @NotNull
        public final Duration component9() {
            return this.getIndexExtensionsDuration();
        }

        @NotNull
        public final Duration component10() {
            return this.getScanFilesDuration();
        }

        @NotNull
        public final Duration component11() {
            return this.getSuspendedDuration();
        }

        public final boolean component12() {
            return this.getWasInterrupted();
        }

        @NotNull
        public final IndexingTimesImpl copy(@Nullable String indexingReason, boolean wasFullIndexing, @NotNull ZonedDateTime updatingStart, long totalUpdatingTime, @NotNull ZonedDateTime updatingEnd, @NotNull Duration indexingDuration, @NotNull Duration contentLoadingDuration, @NotNull Duration pushPropertiesDuration, @NotNull Duration indexExtensionsDuration, @NotNull Duration scanFilesDuration, @NotNull Duration suspendedDuration, boolean wasInterrupted) {
            Intrinsics.checkNotNullParameter((Object)updatingStart, (String)"updatingStart");
            Intrinsics.checkNotNullParameter((Object)updatingEnd, (String)"updatingEnd");
            Intrinsics.checkNotNullParameter((Object)indexingDuration, (String)"indexingDuration");
            Intrinsics.checkNotNullParameter((Object)contentLoadingDuration, (String)"contentLoadingDuration");
            Intrinsics.checkNotNullParameter((Object)pushPropertiesDuration, (String)"pushPropertiesDuration");
            Intrinsics.checkNotNullParameter((Object)indexExtensionsDuration, (String)"indexExtensionsDuration");
            Intrinsics.checkNotNullParameter((Object)scanFilesDuration, (String)"scanFilesDuration");
            Intrinsics.checkNotNullParameter((Object)suspendedDuration, (String)"suspendedDuration");
            return new IndexingTimesImpl(indexingReason, wasFullIndexing, updatingStart, totalUpdatingTime, updatingEnd, indexingDuration, contentLoadingDuration, pushPropertiesDuration, indexExtensionsDuration, scanFilesDuration, suspendedDuration, wasInterrupted);
        }

        public static /* synthetic */ IndexingTimesImpl copy$default(IndexingTimesImpl indexingTimesImpl, String string, boolean bl, ZonedDateTime zonedDateTime, long l, ZonedDateTime zonedDateTime2, Duration duration, Duration duration2, Duration duration3, Duration duration4, Duration duration5, Duration duration6, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = indexingTimesImpl.getIndexingReason();
            }
            if ((n & 2) != 0) {
                bl = indexingTimesImpl.getWasFullIndexing();
            }
            if ((n & 4) != 0) {
                zonedDateTime = indexingTimesImpl.getUpdatingStart();
            }
            if ((n & 8) != 0) {
                l = indexingTimesImpl.getTotalUpdatingTime();
            }
            if ((n & 0x10) != 0) {
                zonedDateTime2 = indexingTimesImpl.getUpdatingEnd();
            }
            if ((n & 0x20) != 0) {
                duration = indexingTimesImpl.getIndexingDuration();
            }
            if ((n & 0x40) != 0) {
                duration2 = indexingTimesImpl.getContentLoadingDuration();
            }
            if ((n & 0x80) != 0) {
                duration3 = indexingTimesImpl.getPushPropertiesDuration();
            }
            if ((n & 0x100) != 0) {
                duration4 = indexingTimesImpl.getIndexExtensionsDuration();
            }
            if ((n & 0x200) != 0) {
                duration5 = indexingTimesImpl.getScanFilesDuration();
            }
            if ((n & 0x400) != 0) {
                duration6 = indexingTimesImpl.getSuspendedDuration();
            }
            if ((n & 0x800) != 0) {
                bl2 = indexingTimesImpl.getWasInterrupted();
            }
            return indexingTimesImpl.copy(string, bl, zonedDateTime, l, zonedDateTime2, duration, duration2, duration3, duration4, duration5, duration6, bl2);
        }

        @NotNull
        public String toString() {
            return "IndexingTimesImpl(indexingReason=" + this.getIndexingReason() + ", wasFullIndexing=" + this.getWasFullIndexing() + ", updatingStart=" + this.getUpdatingStart() + ", totalUpdatingTime=" + this.getTotalUpdatingTime() + ", updatingEnd=" + this.getUpdatingEnd() + ", indexingDuration=" + this.getIndexingDuration() + ", contentLoadingDuration=" + this.getContentLoadingDuration() + ", pushPropertiesDuration=" + this.getPushPropertiesDuration() + ", indexExtensionsDuration=" + this.getIndexExtensionsDuration() + ", scanFilesDuration=" + this.getScanFilesDuration() + ", suspendedDuration=" + this.getSuspendedDuration() + ", wasInterrupted=" + this.getWasInterrupted() + ")";
        }

        public int hashCode() {
            String string = this.getIndexingReason();
            int n = (string != null ? string.hashCode() : 0) * 31;
            int n2 = this.getWasFullIndexing() ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            ZonedDateTime zonedDateTime = this.getUpdatingStart();
            ZonedDateTime zonedDateTime2 = this.getUpdatingEnd();
            Duration duration = this.getIndexingDuration();
            Duration duration2 = this.getContentLoadingDuration();
            Duration duration3 = this.getPushPropertiesDuration();
            Duration duration4 = this.getIndexExtensionsDuration();
            Duration duration5 = this.getScanFilesDuration();
            Duration duration6 = this.getSuspendedDuration();
            int n3 = ((((((((((n + n2) * 31 + (zonedDateTime != null ? ((Object)zonedDateTime).hashCode() : 0)) * 31 + Long.hashCode(this.getTotalUpdatingTime())) * 31 + (zonedDateTime2 != null ? ((Object)zonedDateTime2).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (duration2 != null ? ((Object)duration2).hashCode() : 0)) * 31 + (duration3 != null ? ((Object)duration3).hashCode() : 0)) * 31 + (duration4 != null ? ((Object)duration4).hashCode() : 0)) * 31 + (duration5 != null ? ((Object)duration5).hashCode() : 0)) * 31 + (duration6 != null ? ((Object)duration6).hashCode() : 0)) * 31;
            int n4 = this.getWasInterrupted() ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return n3 + n4;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexingTimesImpl)) break block3;
                    IndexingTimesImpl indexingTimesImpl = (IndexingTimesImpl)object;
                    if (!Intrinsics.areEqual((Object)this.getIndexingReason(), (Object)indexingTimesImpl.getIndexingReason()) || this.getWasFullIndexing() != indexingTimesImpl.getWasFullIndexing() || !Intrinsics.areEqual((Object)this.getUpdatingStart(), (Object)indexingTimesImpl.getUpdatingStart()) || this.getTotalUpdatingTime() != indexingTimesImpl.getTotalUpdatingTime() || !Intrinsics.areEqual((Object)this.getUpdatingEnd(), (Object)indexingTimesImpl.getUpdatingEnd()) || !Intrinsics.areEqual((Object)this.getIndexingDuration(), (Object)indexingTimesImpl.getIndexingDuration()) || !Intrinsics.areEqual((Object)this.getContentLoadingDuration(), (Object)indexingTimesImpl.getContentLoadingDuration()) || !Intrinsics.areEqual((Object)this.getPushPropertiesDuration(), (Object)indexingTimesImpl.getPushPropertiesDuration()) || !Intrinsics.areEqual((Object)this.getIndexExtensionsDuration(), (Object)indexingTimesImpl.getIndexExtensionsDuration()) || !Intrinsics.areEqual((Object)this.getScanFilesDuration(), (Object)indexingTimesImpl.getScanFilesDuration()) || !Intrinsics.areEqual((Object)this.getSuspendedDuration(), (Object)indexingTimesImpl.getSuspendedDuration()) || this.getWasInterrupted() != indexingTimesImpl.getWasInterrupted()) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$SnapshotInputMappingStatsImpl;", "Lcom/intellij/util/indexing/diagnostic/SnapshotInputMappingStats;", "requests", "", "misses", "(JJ)V", "hits", "getHits", "()J", "getMisses", "setMisses", "(J)V", "getRequests", "setRequests", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class SnapshotInputMappingStatsImpl
    implements SnapshotInputMappingStats {
        private long requests;
        private long misses;

        @Override
        public long getHits() {
            return this.getRequests() - this.getMisses();
        }

        @Override
        public long getRequests() {
            return this.requests;
        }

        public void setRequests(long l) {
            this.requests = l;
        }

        @Override
        public long getMisses() {
            return this.misses;
        }

        public void setMisses(long l) {
            this.misses = l;
        }

        public SnapshotInputMappingStatsImpl(long requests2, long misses) {
            this.requests = requests2;
            this.misses = misses;
        }

        public final long component1() {
            return this.getRequests();
        }

        public final long component2() {
            return this.getMisses();
        }

        @NotNull
        public final SnapshotInputMappingStatsImpl copy(long requests2, long misses) {
            return new SnapshotInputMappingStatsImpl(requests2, misses);
        }

        public static /* synthetic */ SnapshotInputMappingStatsImpl copy$default(SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = snapshotInputMappingStatsImpl.getRequests();
            }
            if ((n & 2) != 0) {
                l2 = snapshotInputMappingStatsImpl.getMisses();
            }
            return snapshotInputMappingStatsImpl.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "SnapshotInputMappingStatsImpl(requests=" + this.getRequests() + ", misses=" + this.getMisses() + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.getRequests()) * 31 + Long.hashCode(this.getMisses());
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SnapshotInputMappingStatsImpl)) break block3;
                    SnapshotInputMappingStatsImpl snapshotInputMappingStatsImpl = (SnapshotInputMappingStatsImpl)object;
                    if (this.getRequests() != snapshotInputMappingStatsImpl.getRequests() || this.getMisses() != snapshotInputMappingStatsImpl.getMisses()) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl$Companion;", "", "()V", "indexingSessionIdSequencer", "Ljava/util/concurrent/atomic/AtomicLong;", "getIndexingSessionIdSequencer", "()Ljava/util/concurrent/atomic/AtomicLong;", "intellij.platform.lang.impl"})
    private static final class Companion {
        @NotNull
        public final AtomicLong getIndexingSessionIdSequencer() {
            return indexingSessionIdSequencer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

