/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.projectFilter;

import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.projectFilter.FileAddStatus;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/projectFilter/IncrementalProjectIndexableFilesFilter;", "Lcom/intellij/util/indexing/IdFilter;", "()V", "fileIds", "Lcom/intellij/util/containers/ConcurrentBitSet;", "previousFileIds", "containsFileId", "", "fileId", "", "ensureFileIdPresent", "Lcom/intellij/util/indexing/projectFilter/FileAddStatus;", "add", "Lkotlin/Function0;", "getFilteringScopeType", "Lcom/intellij/util/indexing/IdFilter$FilterScopeType;", "memoizeAndResetFileIds", "", "removeFileId", "resetPreviousFileIds", "intellij.platform.lang.impl"})
public final class IncrementalProjectIndexableFilesFilter
extends IdFilter {
    private volatile ConcurrentBitSet fileIds;
    private ConcurrentBitSet previousFileIds;

    @NotNull
    public IdFilter.FilterScopeType getFilteringScopeType() {
        return IdFilter.FilterScopeType.PROJECT_AND_LIBRARIES;
    }

    public boolean containsFileId(int fileId) {
        return this.fileIds.get(fileId);
    }

    @NotNull
    public final FileAddStatus ensureFileIdPresent(int fileId, @NotNull Function0<Boolean> add2) {
        Intrinsics.checkNotNullParameter(add2, (String)"add");
        boolean bl = fileId > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ConcurrentBitSet _fileIds = this.fileIds;
        if (_fileIds.get(fileId)) {
            return FileAddStatus.PRESENT;
        }
        if (((Boolean)add2.invoke()).booleanValue()) {
            _fileIds.set(fileId);
            ConcurrentBitSet _previousFileIds = this.previousFileIds;
            return _previousFileIds == null || !_previousFileIds.get(fileId) ? FileAddStatus.ADDED : FileAddStatus.PRESENT;
        }
        return FileAddStatus.SKIPPED;
    }

    public final void removeFileId(int fileId) {
        boolean bl = fileId > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.fileIds.clear(fileId);
    }

    public final void memoizeAndResetFileIds() {
        this.previousFileIds = this.fileIds;
        ConcurrentBitSet concurrentBitSet = ConcurrentBitSet.create();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentBitSet, (String)"ConcurrentBitSet.create()");
        this.fileIds = concurrentBitSet;
    }

    public final void resetPreviousFileIds() {
        this.previousFileIds = null;
    }

    public IncrementalProjectIndexableFilesFilter() {
        ConcurrentBitSet concurrentBitSet = ConcurrentBitSet.create();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentBitSet, (String)"ConcurrentBitSet.create()");
        this.fileIds = concurrentBitSet;
    }
}

