/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.DefaultProjectIndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryBridgeIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.SdkIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0011\u001a\u00020\u0015J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0018\u001a\u00020\u0019J8\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/roots/IndexableEntityProviderMethods;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createIterators", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "module", "Lcom/intellij/openapi/module/Module;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryBridge;", "entity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "project", "Lcom/intellij/openapi/project/Project;", "root", "newRootsToIndex", "oldRootsToIndex", "findModuleForEntity", "intellij.platform.lang.impl"})
public final class IndexableEntityProviderMethods {
    private static final Logger LOG;
    @NotNull
    public static final IndexableEntityProviderMethods INSTANCE;

    @Nullable
    public final Module findModuleForEntity(@NotNull ModuleEntity entity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String moduleName = entity.getName();
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        if (module == null) {
            LOG.warn("Failed to find module " + moduleName);
        }
        return module;
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull ModuleEntity entity, @NotNull List<? extends VirtualFile> roots2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (roots2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Module module = this.findModuleForEntity(entity, project);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        return this.createIterators(module2, roots2);
    }

    @NotNull
    public final Set<IndexableFilesIterator> createIterators(@NotNull Module module, @NotNull List<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        return SetsKt.setOf((Object)new ModuleIndexableFilesIteratorImpl(module, roots2, true));
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull ModuleEntity entity, @NotNull List<? extends VirtualFile> newRootsToIndex, @NotNull List<? extends VirtualFile> oldRootsToIndex, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(newRootsToIndex, (String)"newRootsToIndex");
        Intrinsics.checkNotNullParameter(oldRootsToIndex, (String)"oldRootsToIndex");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List roots2 = new ArrayList(newRootsToIndex);
        roots2.removeAll((Collection)oldRootsToIndex);
        return this.createIterators(entity, roots2, project);
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull ModuleEntity entity, @Nullable VirtualFile root2, @NotNull Project project) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                object = root2;
                if (object == null) break block2;
                VirtualFile virtualFile2 = object;
                boolean bl = false;
                boolean bl2 = false;
                VirtualFile it = virtualFile2;
                boolean bl3 = false;
                object = INSTANCE.createIterators(entity, CollectionsKt.listOf((Object)root2), project);
                if (object != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull ModuleEntity entity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DefaultProjectIndexableFilesContributor.Companion.indexProjectBasedOnIndexableEntityProviders()) {
            boolean bl = false;
            List builders = new ArrayList();
            WorkspaceEntityStorage entityStorage = WorkspaceModel.Companion.getInstance(project).getEntityStorage().getCurrent();
            ExtensionPointName<IndexableEntityProvider<? extends WorkspaceEntity>> extensionPointName = IndexableEntityProvider.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"IndexableEntityProvider.EP_NAME");
            for (IndexableEntityProvider provider2 : extensionPointName.getExtensionList()) {
                if (!(provider2 instanceof IndexableEntityProvider.Existing)) continue;
                Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = ((IndexableEntityProvider.Existing)provider2).getIteratorBuildersForExistingModule(entity, entityStorage, project);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"provider.getIteratorBuil\u2026, entityStorage, project)");
                builders.addAll(collection);
            }
            return IndexableIteratorBuilders.INSTANCE.instantiateBuilders(builders, project, entityStorage);
        }
        Module module = this.findModuleForEntity(entity, project);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        return ModuleIndexableFilesIteratorImpl.Companion.getModuleIterators(module);
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull LibraryBridge library2) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        return this.createIterators((Library)library2, library2.getLibraryId());
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull Library library2, @NotNull LibraryId libraryId) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return CollectionsKt.listOf((Object)new LibraryBridgeIndexableFilesIteratorImpl(library2, libraryId));
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return CollectionsKt.listOf((Object)new SdkIndexableFilesIteratorImpl(sdk2));
    }

    private IndexableEntityProviderMethods() {
    }

    static {
        IndexableEntityProviderMethods indexableEntityProviderMethods;
        INSTANCE = indexableEntityProviderMethods = new IndexableEntityProviderMethods();
        IndexableEntityProviderMethods $this$thisLogger$iv = indexableEntityProviderMethods;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(IndexableEntityProviderMethods.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

