/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIterator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0016J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\b\u0010\u000f\u001a\u00020\bH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorBase;", "Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIterator;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/roots/libraries/Library;)V", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "getDebugName", "", "getIndexingProgressText", "getRootUrls", "", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRootsScanningProgressText", "iterateFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "intellij.platform.lang.impl"})
public abstract class LibraryIndexableFilesIteratorBase
implements LibraryIndexableFilesIterator {
    @NotNull
    private final Library library;

    @NotNull
    public String getDebugName() {
        return "Library " + this.library.getPresentableName();
    }

    @NotNull
    public String getIndexingProgressText() {
        String string = IndexingBundle.message((String)"indexable.files.provider.indexing.library.name", (Object[])new Object[]{this.library.getPresentableName()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026 library.presentableName)");
        return string;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        String libraryName = this.library.getName();
        CharSequence charSequence = libraryName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = IndexingBundle.message((String)"indexable.files.provider.scanning.library.name", (Object[])new Object[]{libraryName});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026brary.name\", libraryName)");
            return string;
        }
        String string = IndexingBundle.message((String)"indexable.files.provider.scanning.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IndexingBundle.message(\"\u2026additional.dependencies\")");
        return string;
    }

    public boolean iterateFiles(@NotNull Project project, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        List<VirtualFile> roots2 = this.getRoots();
        return IndexableFilesIterationMethods.iterateRoots$default(IndexableFilesIterationMethods.INSTANCE, project, roots2, fileIterator, fileFilter, false, 16, null);
    }

    @NotNull
    public final List<VirtualFile> getRoots() {
        boolean $i$f$runReadAction = false;
        return (List)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ LibraryIndexableFilesIteratorBase this$0;
            {
                this.this$0 = libraryIndexableFilesIteratorBase;
            }

            public final T compute() {
                List list2;
                boolean bl = false;
                if (Disposer.isDisposed((Disposable)((Disposable)this.this$0.getLibrary()))) {
                    boolean bl2 = false;
                    list2 = CollectionsKt.emptyList();
                } else {
                    RootProvider rootProvider = this.this$0.getLibrary().getRootProvider();
                    Intrinsics.checkNotNullExpressionValue((Object)rootProvider, (String)"library.rootProvider");
                    RootProvider rootProvider2 = rootProvider;
                    Object[] objectArray = rootProvider2.getFiles(OrderRootType.SOURCES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootProvider.getFiles(OrderRootType.SOURCES)");
                    Collection collection = ArraysKt.toList((Object[])objectArray);
                    Object[] objectArray2 = rootProvider2.getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"rootProvider.getFiles(OrderRootType.CLASSES)");
                    list2 = CollectionsKt.plus((Collection)collection, (Object[])objectArray2);
                }
                return (T)list2;
            }
        });
    }

    @NotNull
    public Set<String> getRootUrls() {
        RootProvider rootProvider = this.library.getRootProvider();
        Intrinsics.checkNotNullExpressionValue((Object)rootProvider, (String)"library.rootProvider");
        RootProvider rootProvider2 = rootProvider;
        Object[] objectArray = rootProvider2.getUrls(OrderRootType.SOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootProvider.getUrls(OrderRootType.SOURCES)");
        Object[] objectArray2 = rootProvider2.getUrls(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"rootProvider.getUrls(OrderRootType.CLASSES)");
        return ArraysKt.toSet((Object[])ArraysKt.plus((Object[])objectArray, (Object[])objectArray2));
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    public LibraryIndexableFilesIteratorBase(@NotNull Library library2) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        this.library = library2;
    }
}

