/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots.builders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryBridgeIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilderHandler;
import com.intellij.util.indexing.roots.builders.LibraryIdIteratorBuilder;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler;", "Lcom/intellij/util/indexing/roots/builders/IndexableIteratorBuilderHandler;", "()V", "accepts", "", "builder", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "createLibraryIterator", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "entityStorage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "instantiate", "", "builders", "DependencyChecker", "intellij.platform.lang.impl"})
public final class LibraryIndexableIteratorHandler
implements IndexableIteratorBuilderHandler {
    @Override
    public boolean accepts(@NotNull IndexableEntityProvider.IndexableIteratorBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        return builder2 instanceof LibraryIdIteratorBuilder;
    }

    @NotNull
    public List<IndexableFilesIterator> instantiate(@NotNull Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull Project project, @NotNull WorkspaceEntityStorage entityStorage) {
        Intrinsics.checkNotNullParameter(builders, (String)"builders");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        boolean bl = false;
        Set idsToIndex = new LinkedHashSet();
        Iterable $this$forEach$iv = builders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryIdIteratorBuilder builder2 = (LibraryIdIteratorBuilder)element$iv;
            boolean bl2 = false;
            if (!builder2.getDependencyChecked()) continue;
            idsToIndex.add(builder2.getLibraryId());
        }
        DependencyChecker dependencyChecker = new DependencyChecker(entityStorage, idsToIndex);
        Iterable $this$forEach$iv2 = builders;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            LibraryIdIteratorBuilder builder3 = (LibraryIdIteratorBuilder)element$iv;
            boolean bl3 = false;
            if (builder3.getDependencyChecked()) continue;
            dependencyChecker.checkDependency(builder3.getLibraryId());
        }
        $i$f$forEach2 = false;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv3 = idsToIndex;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            LibraryId id2 = (LibraryId)element$iv;
            boolean bl4 = false;
            result2.addAll(this.createLibraryIterator(id2, entityStorage, project));
        }
        return result2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Collection<IndexableFilesIterator> createLibraryIterator(LibraryId libraryId, WorkspaceEntityStorage entityStorage, Project project) {
        Object object;
        if (libraryId.getTableId() instanceof LibraryTableId.GlobalLibraryTableId) {
            object = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(libraryId.getTableId().getLevel(), project);
            if (object != null) {
                Object object2;
                LibraryTable libraryTable = object;
                boolean bl = false;
                boolean bl2 = false;
                LibraryTable it = libraryTable;
                boolean bl3 = false;
                Library library2 = it.getLibraryByName(libraryId.getName());
                if (library2 != null) {
                    Library library3 = library2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Library it2 = library3;
                    boolean bl6 = false;
                    Library library4 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)library4, (String)"it");
                    object2 = IndexableEntityProviderMethods.INSTANCE.createIterators(library4, libraryId);
                } else {
                    object2 = object = null;
                }
                if (object2 != null) {
                    return object;
                }
            }
            object = CollectionsKt.emptyList();
            return object;
        }
        Object object3 = (LibraryEntity)entityStorage.resolve(libraryId);
        if (object3 != null) {
            Object object4 = object3;
            boolean bl = false;
            boolean bl7 = false;
            Object it = object4;
            boolean bl8 = false;
            object3 = ProjectLibraryTableBridgeImpl.Companion.getLibraryMap(entityStorage).getDataByEntity((WorkspaceEntity)it);
            if (object3 != null) {
                object4 = object3;
                bl = false;
                bl7 = false;
                it = object4;
                boolean bl9 = false;
                object3 = CollectionsKt.listOf((Object)new LibraryBridgeIndexableFilesIteratorImpl((LibraryBridge)it));
                if (object3 != null) {
                    object = (Collection)object3;
                    return object;
                }
            }
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0006R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$DependencyChecker;", "", "entityStorage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "idsToIndex", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryId;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;Ljava/util/Set;)V", "dependencyIterator", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleDependencyItem;", "getEntityStorage", "()Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "idsFromDependencies", "getIdsToIndex", "()Ljava/util/Set;", "moduleIterator", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "checkDependencies", "", "iterator", "libraryId", "checkDependency", "", "intellij.platform.lang.impl"})
    private static final class DependencyChecker {
        private final Set<LibraryId> idsFromDependencies;
        private Iterator<ModuleEntity> moduleIterator;
        private Iterator<? extends ModuleDependencyItem> dependencyIterator;
        @NotNull
        private final WorkspaceEntityStorage entityStorage;
        @NotNull
        private final Set<LibraryId> idsToIndex;

        public final void checkDependency(@NotNull LibraryId libraryId) {
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            if (libraryId.getTableId() instanceof LibraryTableId.ModuleLibraryTableId) {
                this.idsToIndex.add(libraryId);
                return;
            }
            if (this.idsFromDependencies.contains(libraryId)) {
                this.idsToIndex.add(libraryId);
                return;
            }
            Iterator iterator2 = this.moduleIterator;
            if (iterator2 == null) {
                iterator2 = this.entityStorage.entities(ModuleEntity.class).iterator();
            }
            Iterator localModuleIterator = iterator2;
            Iterator<? extends ModuleDependencyItem> localDependencyIterator = this.dependencyIterator;
            if (localDependencyIterator == null || !localDependencyIterator.hasNext()) {
                if (localModuleIterator.hasNext()) {
                    localDependencyIterator = ((ModuleEntity)localModuleIterator.next()).getDependencies().iterator();
                } else {
                    return;
                }
            }
            boolean foundInDependencies = this.checkDependencies(localDependencyIterator, libraryId);
            this.dependencyIterator = localDependencyIterator;
            if (foundInDependencies) {
                return;
            }
            while (localModuleIterator.hasNext()) {
                localDependencyIterator = ((ModuleEntity)localModuleIterator.next()).getDependencies().iterator();
                boolean foundInDependency = this.checkDependencies(localDependencyIterator, libraryId);
                this.dependencyIterator = localDependencyIterator;
                this.moduleIterator = localModuleIterator;
                if (!foundInDependency) continue;
                return;
            }
        }

        private final boolean checkDependencies(Iterator<? extends ModuleDependencyItem> iterator2, LibraryId libraryId) {
            while (iterator2.hasNext()) {
                ModuleDependencyItem next = iterator2.next();
                if (!(next instanceof ModuleDependencyItem.Exportable.LibraryDependency)) continue;
                this.idsFromDependencies.add(((ModuleDependencyItem.Exportable.LibraryDependency)next).getLibrary());
                if (!Intrinsics.areEqual((Object)libraryId, (Object)((ModuleDependencyItem.Exportable.LibraryDependency)next).getLibrary())) continue;
                this.idsToIndex.add(libraryId);
                return true;
            }
            return false;
        }

        @NotNull
        public final WorkspaceEntityStorage getEntityStorage() {
            return this.entityStorage;
        }

        @NotNull
        public final Set<LibraryId> getIdsToIndex() {
            return this.idsToIndex;
        }

        public DependencyChecker(@NotNull WorkspaceEntityStorage entityStorage, @NotNull Set<LibraryId> idsToIndex) {
            Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
            Intrinsics.checkNotNullParameter(idsToIndex, (String)"idsToIndex");
            this.entityStorage = entityStorage;
            this.idsToIndex = idsToIndex;
            boolean bl = false;
            this.idsFromDependencies = new LinkedHashSet();
            this.idsFromDependencies.addAll((Collection<LibraryId>)this.idsToIndex);
        }
    }
}

