/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0004\u0014\u0015\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u00072\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010J\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService;", "Ljava/io/Closeable;", "()V", "contentHashEnumerator", "Lcom/intellij/util/hash/ContentHashEnumerator;", "handles", "", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandle;", "lock", "Ljava/util/concurrent/locks/Lock;", "state", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$State;", "close", "", "createHashEnumeratorHandle", "requestorIndexId", "Lcom/intellij/util/indexing/ID;", "flush", "initialize", "", "Companion", "HashEnumeratorHandle", "HashEnumeratorHandleImpl", "State", "intellij.platform.lang.impl"})
public final class SnapshotHashEnumeratorService
implements Closeable {
    private volatile State state = State.CLOSED;
    private volatile ContentHashEnumerator contentHashEnumerator;
    private final Set<HashEnumeratorHandle> handles = new HashSet();
    private final Lock lock = new ReentrantLock();
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initialize() throws IOException {
        Lock lock2 = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            if (this.state == State.CLOSED) {
                Path hashEnumeratorFile = IndexInfrastructure.getPersistentIndexRoot().resolve("textContentHashes");
                this.state = State.OPEN;
                Object object = IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable(hashEnumeratorFile){
                    final /* synthetic */ Path $hashEnumeratorFile;

                    public final ContentHashEnumerator compute() {
                        return new ContentHashEnumerator(this.$hashEnumeratorFile);
                    }
                    {
                        this.$hashEnumeratorFile = path2;
                    }
                }, (Runnable)new Runnable(hashEnumeratorFile, this){
                    final /* synthetic */ Path $hashEnumeratorFile;
                    final /* synthetic */ SnapshotHashEnumeratorService this$0;
                    {
                        this.$hashEnumeratorFile = path2;
                        this.this$0 = snapshotHashEnumeratorService;
                    }

                    public final void run() {
                        IOUtil.deleteAllFilesStartingWith((Path)this.$hashEnumeratorFile);
                        SnapshotHashEnumeratorService.access$setState$p(this.this$0, State.OPEN_AND_CLEAN);
                    }
                });
                Intrinsics.checkNotNull((Object)object);
                this.contentHashEnumerator = (ContentHashEnumerator)((Object)object);
            }
            LOG.assertTrue(this.state != State.CLOSED);
            boolean bl4 = this.state == State.OPEN;
            return bl4;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Lock lock2 = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            if (this.state == State.OPEN) {
                ContentHashEnumerator contentHashEnumerator = this.contentHashEnumerator;
                Intrinsics.checkNotNull((Object)((Object)contentHashEnumerator));
                contentHashEnumerator.close();
                this.state = State.CLOSED;
                LOG.assertTrue(this.handles.isEmpty(), (Object)("enumerator handles are still held: " + this.handles));
                this.handles.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        Lock lock2 = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            if (this.state == State.OPEN) {
                ContentHashEnumerator contentHashEnumerator = this.contentHashEnumerator;
                Intrinsics.checkNotNull((Object)((Object)contentHashEnumerator));
                contentHashEnumerator.force();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HashEnumeratorHandle createHashEnumeratorHandle(@NotNull ID<?, ?> requestorIndexId) {
        Intrinsics.checkNotNullParameter(requestorIndexId, (String)"requestorIndexId");
        HashEnumeratorHandleImpl handle = new HashEnumeratorHandleImpl(requestorIndexId);
        Lock lock2 = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            bl2 = this.handles.add(handle);
        }
        finally {
            lock2.unlock();
        }
        return handle;
    }

    public SnapshotHashEnumeratorService() {
        FlushingDaemon.everyFiveSeconds(new Runnable(){

            @Override
            public final void run() {
                this.flush();
            }
        });
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SnapshotHashEnumeratorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setContentHashEnumerator$p(SnapshotHashEnumeratorService $this, ContentHashEnumerator contentHashEnumerator) {
        $this.contentHashEnumerator = contentHashEnumerator;
    }

    public static final /* synthetic */ void access$setState$p(SnapshotHashEnumeratorService $this, State state) {
        $this.state = state;
    }

    @JvmStatic
    @NotNull
    public static final SnapshotHashEnumeratorService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$State;", "", "(Ljava/lang/String;I)V", "OPEN", "OPEN_AND_CLEAN", "CLOSED", "intellij.platform.lang.impl"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State OPEN;
        public static final /* enum */ State OPEN_AND_CLEAN;
        public static final /* enum */ State CLOSED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = OPEN = new State();
            stateArray[1] = OPEN_AND_CLEAN = new State();
            stateArray[2] = CLOSED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandle;", "", "enumerateHash", "", "digest", "", "release", "", "intellij.platform.lang.impl"})
    public static interface HashEnumeratorHandle {
        public int enumerateHash(@NotNull byte[] var1) throws IOException;

        public void release();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandleImpl;", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$HashEnumeratorHandle;", "requestorIndexId", "Lcom/intellij/util/indexing/ID;", "(Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService;Lcom/intellij/util/indexing/ID;)V", "enumerateHash", "", "digest", "", "equals", "", "other", "", "hashCode", "release", "", "toString", "", "intellij.platform.lang.impl"})
    private final class HashEnumeratorHandleImpl
    implements HashEnumeratorHandle {
        private final ID<?, ?> requestorIndexId;

        @Override
        public int enumerateHash(@NotNull byte[] digest) {
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            ContentHashEnumerator contentHashEnumerator = SnapshotHashEnumeratorService.this.contentHashEnumerator;
            Intrinsics.checkNotNull((Object)((Object)contentHashEnumerator));
            return contentHashEnumerator.enumerate(digest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Lock lock2 = SnapshotHashEnumeratorService.this.lock;
            boolean bl = false;
            boolean bl2 = false;
            lock2.lock();
            try {
                boolean bl3 = false;
                SnapshotHashEnumeratorService.this.handles.remove(this);
                bl2 = LOG.assertTrue(SnapshotHashEnumeratorService.this.state != State.CLOSED, (Object)"handle is released for closed enumerator");
            }
            finally {
                lock2.unlock();
            }
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof HashEnumeratorHandleImpl && Intrinsics.areEqual(((HashEnumeratorHandleImpl)other).requestorIndexId, this.requestorIndexId);
        }

        public int hashCode() {
            return this.requestorIndexId.hashCode();
        }

        @NotNull
        public String toString() {
            return "handle for " + this.requestorIndexId.getName();
        }

        public HashEnumeratorHandleImpl(ID<?, ?> requestorIndexId) {
            Intrinsics.checkNotNullParameter(requestorIndexId, (String)"requestorIndexId");
            this.requestorIndexId = requestorIndexId;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/util/indexing/snapshot/SnapshotHashEnumeratorService;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SnapshotHashEnumeratorService getInstance() {
            boolean $i$f$service = false;
            Class<SnapshotHashEnumeratorService> serviceClass$iv = SnapshotHashEnumeratorService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (SnapshotHashEnumeratorService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

