/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBTableRow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBTableRowEditor
extends JPanel {
    private final List<RowDocumentListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private MouseEvent myMouseEvent;

    public abstract void prepareEditor(JTable var1, int var2);

    public abstract JBTableRow getValue();

    public abstract JComponent getPreferredFocusedComponent();

    public abstract JComponent[] getFocusableComponents();

    public final void addDocumentListener(RowDocumentListener listener2) {
        this.myListeners.add(listener2);
    }

    public void fireDocumentChanged(@NotNull DocumentEvent e, int column2) {
        if (e == null) {
            JBTableRowEditor.$$$reportNull$$$0(0);
        }
        for (RowDocumentListener listener2 : this.myListeners) {
            listener2.documentChanged(e, column2);
        }
    }

    @Nullable
    public final MouseEvent getMouseEvent() {
        if (this.myMouseEvent != null && this.myMouseEvent.getClickCount() == 0) {
            return null;
        }
        return this.myMouseEvent;
    }

    public final void setMouseEvent(@Nullable MouseEvent e) {
        this.myMouseEvent = e;
    }

    public static JPanel createLabeledPanel(@NlsContexts.Label String labelText, JComponent component2) {
        JPanel panel2 = new JPanel(new BorderLayout(JBUI.scale((int)4), JBUI.scale((int)2)));
        panel2.add((Component)new JBLabel(labelText, UIUtil.ComponentStyle.SMALL), "North");
        panel2.add((Component)component2, "Center");
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/table/JBTableRowEditor", "fireDocumentChanged"));
    }

    public class RowEditorChangeListener
    implements DocumentListener {
        private final int myColumn;

        public RowEditorChangeListener(int column2) {
            this.myColumn = column2;
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                RowEditorChangeListener.$$$reportNull$$$0(0);
            }
            JBTableRowEditor.this.fireDocumentChanged(e, this.myColumn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/table/JBTableRowEditor$RowEditorChangeListener", "documentChanged"));
        }
    }

    public static interface RowDocumentListener {
        public void documentChanged(@NotNull DocumentEvent var1, int var2);
    }
}

