/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.vcs.commit.EditedCommitDetails;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/commit/EditedCommitNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/vcs/commit/EditedCommitDetails;", "editedCommit", "(Lcom/intellij/vcs/commit/EditedCommitDetails;)V", "commit", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getCommit", "()Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getEditedCommit", "()Lcom/intellij/vcs/commit/EditedCommitDetails;", "getTextPresentation", "", "isDifferentCommitter", "", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "expanded", "hasFocus", "intellij.platform.vcs.impl"})
public final class EditedCommitNode
extends ChangesBrowserNode<EditedCommitDetails> {
    @NotNull
    public final EditedCommitDetails getEditedCommit() {
        Object t = this.getUserObject();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getUserObject()");
        return (EditedCommitDetails)t;
    }

    @NotNull
    public final VcsFullCommitDetails getCommit() {
        return this.getEditedCommit().getCommit();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded2, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer2), (String)"renderer");
        if (this.isDifferentCommitter()) {
            renderer2.setIcon(AllIcons.General.Warning);
            renderer2.setToolTipText(VcsBundle.message((String)"amend.commit.different.committer.warning", (Object[])new Object[0]));
        } else {
            renderer2.setIcon(AllIcons.Vcs.CommitNode);
        }
        renderer2.append(this.getCommit().getSubject());
        this.appendCount(renderer2);
    }

    private final boolean isDifferentCommitter() {
        VcsUser vcsUser = this.getEditedCommit().getCurrentUser();
        if (vcsUser == null) {
            return false;
        }
        VcsUser currentUser = vcsUser;
        return !VcsUserUtil.isSamePerson(currentUser, this.getCommit().getCommitter());
    }

    @Override
    @NotNull
    public String getTextPresentation() {
        String string = ((EditedCommitDetails)this.getUserObject()).getCommit().getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserObject().commit.subject");
        return string;
    }

    public EditedCommitNode(@NotNull EditedCommitDetails editedCommit) {
        Intrinsics.checkNotNullParameter((Object)editedCommit, (String)"editedCommit");
        super(editedCommit);
    }
}

